/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * The BigQuery table where the server writes the output.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleCloudHealthcareV1DicomBigQueryDestination extends com.google.api.client.json.GenericJson {

  /**
   * Use `write_disposition` instead. If `write_disposition` is specified, this parameter is
   * ignored. force=false is equivalent to write_disposition=WRITE_EMPTY and force=true is
   * equivalent to write_disposition=WRITE_TRUNCATE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean force;

  /**
   * BigQuery URI to a table, up to 2000 characters long, in the format
   * `bq://projectId.bqDatasetId.tableId`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tableUri;

  /**
   * Determines whether the existing table in the destination is to be overwritten or appended to.
   * If a write_disposition is specified, the `force` parameter is ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String writeDisposition;

  /**
   * Use `write_disposition` instead. If `write_disposition` is specified, this parameter is
   * ignored. force=false is equivalent to write_disposition=WRITE_EMPTY and force=true is
   * equivalent to write_disposition=WRITE_TRUNCATE.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getForce() {
    return force;
  }

  /**
   * Use `write_disposition` instead. If `write_disposition` is specified, this parameter is
   * ignored. force=false is equivalent to write_disposition=WRITE_EMPTY and force=true is
   * equivalent to write_disposition=WRITE_TRUNCATE.
   * @param force force or {@code null} for none
   */
  public GoogleCloudHealthcareV1DicomBigQueryDestination setForce(java.lang.Boolean force) {
    this.force = force;
    return this;
  }

  /**
   * BigQuery URI to a table, up to 2000 characters long, in the format
   * `bq://projectId.bqDatasetId.tableId`
   * @return value or {@code null} for none
   */
  public java.lang.String getTableUri() {
    return tableUri;
  }

  /**
   * BigQuery URI to a table, up to 2000 characters long, in the format
   * `bq://projectId.bqDatasetId.tableId`
   * @param tableUri tableUri or {@code null} for none
   */
  public GoogleCloudHealthcareV1DicomBigQueryDestination setTableUri(java.lang.String tableUri) {
    this.tableUri = tableUri;
    return this;
  }

  /**
   * Determines whether the existing table in the destination is to be overwritten or appended to.
   * If a write_disposition is specified, the `force` parameter is ignored.
   * @return value or {@code null} for none
   */
  public java.lang.String getWriteDisposition() {
    return writeDisposition;
  }

  /**
   * Determines whether the existing table in the destination is to be overwritten or appended to.
   * If a write_disposition is specified, the `force` parameter is ignored.
   * @param writeDisposition writeDisposition or {@code null} for none
   */
  public GoogleCloudHealthcareV1DicomBigQueryDestination setWriteDisposition(java.lang.String writeDisposition) {
    this.writeDisposition = writeDisposition;
    return this;
  }

  @Override
  public GoogleCloudHealthcareV1DicomBigQueryDestination set(String fieldName, Object value) {
    return (GoogleCloudHealthcareV1DicomBigQueryDestination) super.set(fieldName, value);
  }

  @Override
  public GoogleCloudHealthcareV1DicomBigQueryDestination clone() {
    return (GoogleCloudHealthcareV1DicomBigQueryDestination) super.clone();
  }

}
