/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * The Cloud Storage location where the server writes the output and the export configuration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleCloudHealthcareV1DicomGcsDestination extends com.google.api.client.json.GenericJson {

  /**
   * MIME types supported by DICOM spec. Each file is written in the following format:
   * `.../{study_id}/{series_id}/{instance_id}[/{frame_number}].{extension}` The frame_number
   * component exists only for multi-frame instances. Supported MIME types are consistent with
   * supported formats in DICOMweb:
   * https://cloud.google.com/healthcare/docs/dicom#retrieve_transaction. Specifically, the
   * following are supported: - application/dicom; transfer-syntax=1.2.840.10008.1.2.1 (uncompressed
   * DICOM) - application/dicom; transfer-syntax=1.2.840.10008.1.2.4.50 (DICOM with embedded JPEG
   * Baseline) - application/dicom; transfer-syntax=1.2.840.10008.1.2.4.90 (DICOM with embedded JPEG
   * 2000 Lossless Only) - application/dicom; transfer-syntax=1.2.840.10008.1.2.4.91 (DICOM with
   * embedded JPEG 2000) - application/dicom; transfer-syntax=* (DICOM with no transcoding) -
   * application/octet-stream; transfer-syntax=1.2.840.10008.1.2.1 (raw uncompressed PixelData) -
   * application/octet-stream; transfer-syntax=* (raw PixelData in whatever format it was uploaded
   * in) - image/jpeg; transfer-syntax=1.2.840.10008.1.2.4.50 (Consumer JPEG) - image/png The
   * following extensions are used for output files: - application/dicom -> .dcm - image/jpeg ->
   * .jpg - image/png -> .png - application/octet-stream -> no extension If unspecified, the
   * instances are exported in the original DICOM format they were uploaded in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mimeType;

  /**
   * The Cloud Storage destination to export to. URI for a Cloud Storage directory where the server
   * writes the result files, in the format `gs://{bucket-id}/{path/to/destination/dir}`). If there
   * is no trailing slash, the service appends one when composing the object path. The user is
   * responsible for creating the Cloud Storage bucket referenced in `uri_prefix`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String uriPrefix;

  /**
   * MIME types supported by DICOM spec. Each file is written in the following format:
   * `.../{study_id}/{series_id}/{instance_id}[/{frame_number}].{extension}` The frame_number
   * component exists only for multi-frame instances. Supported MIME types are consistent with
   * supported formats in DICOMweb:
   * https://cloud.google.com/healthcare/docs/dicom#retrieve_transaction. Specifically, the
   * following are supported: - application/dicom; transfer-syntax=1.2.840.10008.1.2.1 (uncompressed
   * DICOM) - application/dicom; transfer-syntax=1.2.840.10008.1.2.4.50 (DICOM with embedded JPEG
   * Baseline) - application/dicom; transfer-syntax=1.2.840.10008.1.2.4.90 (DICOM with embedded JPEG
   * 2000 Lossless Only) - application/dicom; transfer-syntax=1.2.840.10008.1.2.4.91 (DICOM with
   * embedded JPEG 2000) - application/dicom; transfer-syntax=* (DICOM with no transcoding) -
   * application/octet-stream; transfer-syntax=1.2.840.10008.1.2.1 (raw uncompressed PixelData) -
   * application/octet-stream; transfer-syntax=* (raw PixelData in whatever format it was uploaded
   * in) - image/jpeg; transfer-syntax=1.2.840.10008.1.2.4.50 (Consumer JPEG) - image/png The
   * following extensions are used for output files: - application/dicom -> .dcm - image/jpeg ->
   * .jpg - image/png -> .png - application/octet-stream -> no extension If unspecified, the
   * instances are exported in the original DICOM format they were uploaded in.
   * @return value or {@code null} for none
   */
  public java.lang.String getMimeType() {
    return mimeType;
  }

  /**
   * MIME types supported by DICOM spec. Each file is written in the following format:
   * `.../{study_id}/{series_id}/{instance_id}[/{frame_number}].{extension}` The frame_number
   * component exists only for multi-frame instances. Supported MIME types are consistent with
   * supported formats in DICOMweb:
   * https://cloud.google.com/healthcare/docs/dicom#retrieve_transaction. Specifically, the
   * following are supported: - application/dicom; transfer-syntax=1.2.840.10008.1.2.1 (uncompressed
   * DICOM) - application/dicom; transfer-syntax=1.2.840.10008.1.2.4.50 (DICOM with embedded JPEG
   * Baseline) - application/dicom; transfer-syntax=1.2.840.10008.1.2.4.90 (DICOM with embedded JPEG
   * 2000 Lossless Only) - application/dicom; transfer-syntax=1.2.840.10008.1.2.4.91 (DICOM with
   * embedded JPEG 2000) - application/dicom; transfer-syntax=* (DICOM with no transcoding) -
   * application/octet-stream; transfer-syntax=1.2.840.10008.1.2.1 (raw uncompressed PixelData) -
   * application/octet-stream; transfer-syntax=* (raw PixelData in whatever format it was uploaded
   * in) - image/jpeg; transfer-syntax=1.2.840.10008.1.2.4.50 (Consumer JPEG) - image/png The
   * following extensions are used for output files: - application/dicom -> .dcm - image/jpeg ->
   * .jpg - image/png -> .png - application/octet-stream -> no extension If unspecified, the
   * instances are exported in the original DICOM format they were uploaded in.
   * @param mimeType mimeType or {@code null} for none
   */
  public GoogleCloudHealthcareV1DicomGcsDestination setMimeType(java.lang.String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  /**
   * The Cloud Storage destination to export to. URI for a Cloud Storage directory where the server
   * writes the result files, in the format `gs://{bucket-id}/{path/to/destination/dir}`). If there
   * is no trailing slash, the service appends one when composing the object path. The user is
   * responsible for creating the Cloud Storage bucket referenced in `uri_prefix`.
   * @return value or {@code null} for none
   */
  public java.lang.String getUriPrefix() {
    return uriPrefix;
  }

  /**
   * The Cloud Storage destination to export to. URI for a Cloud Storage directory where the server
   * writes the result files, in the format `gs://{bucket-id}/{path/to/destination/dir}`). If there
   * is no trailing slash, the service appends one when composing the object path. The user is
   * responsible for creating the Cloud Storage bucket referenced in `uri_prefix`.
   * @param uriPrefix uriPrefix or {@code null} for none
   */
  public GoogleCloudHealthcareV1DicomGcsDestination setUriPrefix(java.lang.String uriPrefix) {
    this.uriPrefix = uriPrefix;
    return this;
  }

  @Override
  public GoogleCloudHealthcareV1DicomGcsDestination set(String fieldName, Object value) {
    return (GoogleCloudHealthcareV1DicomGcsDestination) super.set(fieldName, value);
  }

  @Override
  public GoogleCloudHealthcareV1DicomGcsDestination clone() {
    return (GoogleCloudHealthcareV1DicomGcsDestination) super.clone();
  }

}
