/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Include to use an existing data crypto key wrapped by KMS. The wrapped key must be a 128-, 192-,
 * or 256-bit key. The key must grant the Cloud IAM permission
 * `cloudkms.cryptoKeyVersions.useToDecrypt` to the project's Cloud Healthcare Service Agent service
 * account. For more information, see [Creating a wrapped key] (https://cloud.google.com/dlp/docs
 * /create-wrapped-key).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class KmsWrappedCryptoKey extends com.google.api.client.json.GenericJson {

  /**
   * Required. The resource name of the KMS CryptoKey to use for unwrapping. For example,
   * `projects/{project_id}/locations/{location_id}/keyRings/{keyring}/cryptoKeys/{key}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cryptoKey;

  /**
   * Required. The wrapped data crypto key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String wrappedKey;

  /**
   * Required. The resource name of the KMS CryptoKey to use for unwrapping. For example,
   * `projects/{project_id}/locations/{location_id}/keyRings/{keyring}/cryptoKeys/{key}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getCryptoKey() {
    return cryptoKey;
  }

  /**
   * Required. The resource name of the KMS CryptoKey to use for unwrapping. For example,
   * `projects/{project_id}/locations/{location_id}/keyRings/{keyring}/cryptoKeys/{key}`.
   * @param cryptoKey cryptoKey or {@code null} for none
   */
  public KmsWrappedCryptoKey setCryptoKey(java.lang.String cryptoKey) {
    this.cryptoKey = cryptoKey;
    return this;
  }

  /**
   * Required. The wrapped data crypto key.
   * @see #decodeWrappedKey()
   * @return value or {@code null} for none
   */
  public java.lang.String getWrappedKey() {
    return wrappedKey;
  }

  /**
   * Required. The wrapped data crypto key.
   * @see #getWrappedKey()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeWrappedKey() {
    return com.google.api.client.util.Base64.decodeBase64(wrappedKey);
  }

  /**
   * Required. The wrapped data crypto key.
   * @see #encodeWrappedKey()
   * @param wrappedKey wrappedKey or {@code null} for none
   */
  public KmsWrappedCryptoKey setWrappedKey(java.lang.String wrappedKey) {
    this.wrappedKey = wrappedKey;
    return this;
  }

  /**
   * Required. The wrapped data crypto key.
   * @see #setWrappedKey()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public KmsWrappedCryptoKey encodeWrappedKey(byte[] wrappedKey) {
    this.wrappedKey = com.google.api.client.util.Base64.encodeBase64URLSafeString(wrappedKey);
    return this;
  }

  @Override
  public KmsWrappedCryptoKey set(String fieldName, Object value) {
    return (KmsWrappedCryptoKey) super.set(fieldName, value);
  }

  @Override
  public KmsWrappedCryptoKey clone() {
    return (KmsWrappedCryptoKey) super.clone();
  }

}
