/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Lists the messages in the specified HL7v2 store.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListMessagesResponse extends com.google.api.client.json.GenericJson {

  /**
   * The returned Messages. Won't be more Messages than the value of page_size in the request. See
   * view for populated fields.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Message> hl7V2Messages;

  /**
   * Token to retrieve the next page of results or empty if there are no more results in the list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The returned Messages. Won't be more Messages than the value of page_size in the request. See
   * view for populated fields.
   * @return value or {@code null} for none
   */
  public java.util.List<Message> getHl7V2Messages() {
    return hl7V2Messages;
  }

  /**
   * The returned Messages. Won't be more Messages than the value of page_size in the request. See
   * view for populated fields.
   * @param hl7V2Messages hl7V2Messages or {@code null} for none
   */
  public ListMessagesResponse setHl7V2Messages(java.util.List<Message> hl7V2Messages) {
    this.hl7V2Messages = hl7V2Messages;
    return this;
  }

  /**
   * Token to retrieve the next page of results or empty if there are no more results in the list.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Token to retrieve the next page of results or empty if there are no more results in the list.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListMessagesResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListMessagesResponse set(String fieldName, Object value) {
    return (ListMessagesResponse) super.set(fieldName, value);
  }

  @Override
  public ListMessagesResponse clone() {
    return (ListMessagesResponse) super.clone();
  }

}
