/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Model definition for RollbackFhirResourceFilteringFields.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RollbackFhirResourceFilteringFields extends com.google.api.client.json.GenericJson {

  /**
   * Optional. A filter expression that matches data in the `Resource.meta` element. Supports all
   * filters in [AIP-160](https://google.aip.dev/160) except the "has" (`:`) operator. Supports the
   * following custom functions: * `tag("") = ""` for tag filtering. * `extension_value_ts("") = `
   * for filtering extensions with a timestamp, where `` is a Unix timestamp. Supports the `>`, `<`,
   * `<=`, `>=`, and `!=` comparison operators.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metadataFilter;

  /**
   * Optional. A list of operation IDs to roll back.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.math.BigInteger> operationIds;

  /**
   * Optional. A filter expression that matches data in the `Resource.meta` element. Supports all
   * filters in [AIP-160](https://google.aip.dev/160) except the "has" (`:`) operator. Supports the
   * following custom functions: * `tag("") = ""` for tag filtering. * `extension_value_ts("") = `
   * for filtering extensions with a timestamp, where `` is a Unix timestamp. Supports the `>`, `<`,
   * `<=`, `>=`, and `!=` comparison operators.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetadataFilter() {
    return metadataFilter;
  }

  /**
   * Optional. A filter expression that matches data in the `Resource.meta` element. Supports all
   * filters in [AIP-160](https://google.aip.dev/160) except the "has" (`:`) operator. Supports the
   * following custom functions: * `tag("") = ""` for tag filtering. * `extension_value_ts("") = `
   * for filtering extensions with a timestamp, where `` is a Unix timestamp. Supports the `>`, `<`,
   * `<=`, `>=`, and `!=` comparison operators.
   * @param metadataFilter metadataFilter or {@code null} for none
   */
  public RollbackFhirResourceFilteringFields setMetadataFilter(java.lang.String metadataFilter) {
    this.metadataFilter = metadataFilter;
    return this;
  }

  /**
   * Optional. A list of operation IDs to roll back.
   * @return value or {@code null} for none
   */
  public java.util.List<java.math.BigInteger> getOperationIds() {
    return operationIds;
  }

  /**
   * Optional. A list of operation IDs to roll back.
   * @param operationIds operationIds or {@code null} for none
   */
  public RollbackFhirResourceFilteringFields setOperationIds(java.util.List<java.math.BigInteger> operationIds) {
    this.operationIds = operationIds;
    return this;
  }

  @Override
  public RollbackFhirResourceFilteringFields set(String fieldName, Object value) {
    return (RollbackFhirResourceFilteringFields) super.set(fieldName, value);
  }

  @Override
  public RollbackFhirResourceFilteringFields clone() {
    return (RollbackFhirResourceFilteringFields) super.clone();
  }

}
