/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Model definition for TextConfig.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TextConfig extends com.google.api.client.json.GenericJson {

  /**
   * Transformations to apply to the detected data, overridden by `exclude_info_types`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InfoTypeTransformation> additionalTransformations;

  static {
    // hack to force ProGuard to consider InfoTypeTransformation used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(InfoTypeTransformation.class);
  }

  /**
   * InfoTypes to skip transforming, overriding `additional_transformations`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> excludeInfoTypes;

  /**
   * The transformations to apply to the detected data. Deprecated. Use `additional_transformations`
   * instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InfoTypeTransformation> transformations;

  static {
    // hack to force ProGuard to consider InfoTypeTransformation used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(InfoTypeTransformation.class);
  }

  /**
   * Transformations to apply to the detected data, overridden by `exclude_info_types`.
   * @return value or {@code null} for none
   */
  public java.util.List<InfoTypeTransformation> getAdditionalTransformations() {
    return additionalTransformations;
  }

  /**
   * Transformations to apply to the detected data, overridden by `exclude_info_types`.
   * @param additionalTransformations additionalTransformations or {@code null} for none
   */
  public TextConfig setAdditionalTransformations(java.util.List<InfoTypeTransformation> additionalTransformations) {
    this.additionalTransformations = additionalTransformations;
    return this;
  }

  /**
   * InfoTypes to skip transforming, overriding `additional_transformations`.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getExcludeInfoTypes() {
    return excludeInfoTypes;
  }

  /**
   * InfoTypes to skip transforming, overriding `additional_transformations`.
   * @param excludeInfoTypes excludeInfoTypes or {@code null} for none
   */
  public TextConfig setExcludeInfoTypes(java.util.List<java.lang.String> excludeInfoTypes) {
    this.excludeInfoTypes = excludeInfoTypes;
    return this;
  }

  /**
   * The transformations to apply to the detected data. Deprecated. Use `additional_transformations`
   * instead.
   * @return value or {@code null} for none
   */
  public java.util.List<InfoTypeTransformation> getTransformations() {
    return transformations;
  }

  /**
   * The transformations to apply to the detected data. Deprecated. Use `additional_transformations`
   * instead.
   * @param transformations transformations or {@code null} for none
   */
  public TextConfig setTransformations(java.util.List<InfoTypeTransformation> transformations) {
    this.transformations = transformations;
    return this;
  }

  @Override
  public TextConfig set(String fieldName, Object value) {
    return (TextConfig) super.set(fieldName, value);
  }

  @Override
  public TextConfig clone() {
    return (TextConfig) super.clone();
  }

}
