/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Configuration for FHIR BigQuery time-partitioned tables.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TimePartitioning extends com.google.api.client.json.GenericJson {

  /**
   * Number of milliseconds for which to keep the storage for a partition.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long expirationMs;

  /**
   * Type of partitioning.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Number of milliseconds for which to keep the storage for a partition.
   * @return value or {@code null} for none
   */
  public java.lang.Long getExpirationMs() {
    return expirationMs;
  }

  /**
   * Number of milliseconds for which to keep the storage for a partition.
   * @param expirationMs expirationMs or {@code null} for none
   */
  public TimePartitioning setExpirationMs(java.lang.Long expirationMs) {
    this.expirationMs = expirationMs;
    return this;
  }

  /**
   * Type of partitioning.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of partitioning.
   * @param type type or {@code null} for none
   */
  public TimePartitioning setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public TimePartitioning set(String fieldName, Object value) {
    return (TimePartitioning) super.set(fieldName, value);
  }

  @Override
  public TimePartitioning clone() {
    return (TimePartitioning) super.clone();
  }

}
