/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.healthcare.v1beta1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.healthcare.v1beta1.CloudHealthcareRequest;
import com.google.api.services.healthcare.v1beta1.CloudHealthcareRequestInitializer;
import com.google.api.services.healthcare.v1beta1.model.Annotation;
import com.google.api.services.healthcare.v1beta1.model.AnnotationStore;
import com.google.api.services.healthcare.v1beta1.model.CancelOperationRequest;
import com.google.api.services.healthcare.v1beta1.model.CreateMessageRequest;
import com.google.api.services.healthcare.v1beta1.model.Dataset;
import com.google.api.services.healthcare.v1beta1.model.DeidentifyDatasetRequest;
import com.google.api.services.healthcare.v1beta1.model.DeidentifyDicomStoreRequest;
import com.google.api.services.healthcare.v1beta1.model.DeidentifyFhirStoreRequest;
import com.google.api.services.healthcare.v1beta1.model.DicomStore;
import com.google.api.services.healthcare.v1beta1.model.Empty;
import com.google.api.services.healthcare.v1beta1.model.EvaluateAnnotationStoreRequest;
import com.google.api.services.healthcare.v1beta1.model.ExportAnnotationsRequest;
import com.google.api.services.healthcare.v1beta1.model.ExportDicomDataRequest;
import com.google.api.services.healthcare.v1beta1.model.ExportResourcesRequest;
import com.google.api.services.healthcare.v1beta1.model.FhirStore;
import com.google.api.services.healthcare.v1beta1.model.Hl7V2Store;
import com.google.api.services.healthcare.v1beta1.model.HttpBody;
import com.google.api.services.healthcare.v1beta1.model.ImportAnnotationsRequest;
import com.google.api.services.healthcare.v1beta1.model.ImportDicomDataRequest;
import com.google.api.services.healthcare.v1beta1.model.ImportResourcesRequest;
import com.google.api.services.healthcare.v1beta1.model.IngestMessageRequest;
import com.google.api.services.healthcare.v1beta1.model.IngestMessageResponse;
import com.google.api.services.healthcare.v1beta1.model.ListAnnotationStoresResponse;
import com.google.api.services.healthcare.v1beta1.model.ListAnnotationsResponse;
import com.google.api.services.healthcare.v1beta1.model.ListDatasetsResponse;
import com.google.api.services.healthcare.v1beta1.model.ListDicomStoresResponse;
import com.google.api.services.healthcare.v1beta1.model.ListFhirStoresResponse;
import com.google.api.services.healthcare.v1beta1.model.ListHl7V2StoresResponse;
import com.google.api.services.healthcare.v1beta1.model.ListLocationsResponse;
import com.google.api.services.healthcare.v1beta1.model.ListMessagesResponse;
import com.google.api.services.healthcare.v1beta1.model.ListOperationsResponse;
import com.google.api.services.healthcare.v1beta1.model.Location;
import com.google.api.services.healthcare.v1beta1.model.Message;
import com.google.api.services.healthcare.v1beta1.model.Operation;
import com.google.api.services.healthcare.v1beta1.model.Policy;
import com.google.api.services.healthcare.v1beta1.model.SearchResourcesRequest;
import com.google.api.services.healthcare.v1beta1.model.SetIamPolicyRequest;
import com.google.api.services.healthcare.v1beta1.model.TestIamPermissionsRequest;
import com.google.api.services.healthcare.v1beta1.model.TestIamPermissionsResponse;
import java.io.IOException;
import java.util.regex.Pattern;

public class CloudHealthcare
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://healthcare.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://healthcare.googleapis.com/";

    public CloudHealthcare(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    CloudHealthcare(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.30.10 of the Cloud Healthcare API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://healthcare.googleapis.com/", CloudHealthcare.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(CloudHealthcare.DEFAULT_BATCH_PATH);
        }

        public CloudHealthcare build() {
            return new CloudHealthcare(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setCloudHealthcareRequestInitializer(CloudHealthcareRequestInitializer cloudhealthcareRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)cloudhealthcareRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Locations locations() {
            return new Locations();
        }

        public class Locations {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Datasets datasets() {
                return new Datasets();
            }

            public class Datasets {
                public Create create(String parent, Dataset content) throws IOException {
                    Create result = new Create(parent, content);
                    CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Deidentify deidentify(String sourceDataset, DeidentifyDatasetRequest content) throws IOException {
                    Deidentify result = new Deidentify(sourceDataset, content);
                    CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GetIamPolicy getIamPolicy(String resource) throws IOException {
                    GetIamPolicy result = new GetIamPolicy(resource);
                    CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, Dataset content) throws IOException {
                    Patch result = new Patch(name, content);
                    CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                    SetIamPolicy result = new SetIamPolicy(resource, content);
                    CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                    TestIamPermissions result = new TestIamPermissions(resource, content);
                    CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public AnnotationStores annotationStores() {
                    return new AnnotationStores();
                }

                public DicomStores dicomStores() {
                    return new DicomStores();
                }

                public FhirStores fhirStores() {
                    return new FhirStores();
                }

                public Hl7V2Stores hl7V2Stores() {
                    return new Hl7V2Stores();
                }

                public Operations operations() {
                    return new Operations();
                }

                public class Operations {
                    public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
                        Cancel result = new Cancel(name, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String name) throws IOException {
                        List result = new List(name);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends CloudHealthcareRequest<ListOperationsResponse> {
                        private static final String REST_PATH = "v1beta1/{+name}/operations";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String filter;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String name) {
                            super(CloudHealthcare.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public List setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends CloudHealthcareRequest<Operation> {
                        private static final String REST_PATH = "v1beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(CloudHealthcare.this, "GET", REST_PATH, null, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/operations/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/operations/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/operations/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Cancel
                    extends CloudHealthcareRequest<Empty> {
                        private static final String REST_PATH = "v1beta1/{+name}:cancel";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Cancel(String name, CancelOperationRequest content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/operations/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/operations/[^/]+$");
                            }
                        }

                        public Cancel set$Xgafv(String $Xgafv) {
                            return (Cancel)super.set$Xgafv($Xgafv);
                        }

                        public Cancel setAccessToken(String accessToken) {
                            return (Cancel)super.setAccessToken(accessToken);
                        }

                        public Cancel setAlt(String alt) {
                            return (Cancel)super.setAlt(alt);
                        }

                        public Cancel setCallback(String callback) {
                            return (Cancel)super.setCallback(callback);
                        }

                        public Cancel setFields(String fields) {
                            return (Cancel)super.setFields(fields);
                        }

                        public Cancel setKey(String key) {
                            return (Cancel)super.setKey(key);
                        }

                        public Cancel setOauthToken(String oauthToken) {
                            return (Cancel)super.setOauthToken(oauthToken);
                        }

                        public Cancel setPrettyPrint(Boolean prettyPrint) {
                            return (Cancel)super.setPrettyPrint(prettyPrint);
                        }

                        public Cancel setQuotaUser(String quotaUser) {
                            return (Cancel)super.setQuotaUser(quotaUser);
                        }

                        public Cancel setUploadType(String uploadType) {
                            return (Cancel)super.setUploadType(uploadType);
                        }

                        public Cancel setUploadProtocol(String uploadProtocol) {
                            return (Cancel)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Cancel setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/operations/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Cancel set(String parameterName, Object value) {
                            return (Cancel)super.set(parameterName, value);
                        }
                    }
                }

                public class Hl7V2Stores {
                    public Create create(String parent, Hl7V2Store content) throws IOException {
                        Create result = new Create(parent, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public GetIamPolicy getIamPolicy(String resource) throws IOException {
                        GetIamPolicy result = new GetIamPolicy(resource);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String name, Hl7V2Store content) throws IOException {
                        Patch result = new Patch(name, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                        SetIamPolicy result = new SetIamPolicy(resource, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                        TestIamPermissions result = new TestIamPermissions(resource, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Messages messages() {
                        return new Messages();
                    }

                    public class Messages {
                        public Create create(String parent, CreateMessageRequest content) throws IOException {
                            Create result = new Create(parent, content);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Delete delete(String name) throws IOException {
                            Delete result = new Delete(name);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Get get(String name) throws IOException {
                            Get result = new Get(name);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Ingest ingest(String parent, IngestMessageRequest content) throws IOException {
                            Ingest result = new Ingest(parent, content);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public List list(String parent) throws IOException {
                            List result = new List(parent);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Patch patch(String name, Message content) throws IOException {
                            Patch result = new Patch(name, content);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public class Patch
                        extends CloudHealthcareRequest<Message> {
                            private static final String REST_PATH = "v1beta1/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;
                            @Key
                            private String updateMask;

                            protected Patch(String name, Message content) {
                                super(CloudHealthcare.this, "PATCH", REST_PATH, (Object)content, Message.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+/messages/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+/messages/[^/]+$");
                                }
                            }

                            public Patch set$Xgafv(String $Xgafv) {
                                return (Patch)super.set$Xgafv($Xgafv);
                            }

                            public Patch setAccessToken(String accessToken) {
                                return (Patch)super.setAccessToken(accessToken);
                            }

                            public Patch setAlt(String alt) {
                                return (Patch)super.setAlt(alt);
                            }

                            public Patch setCallback(String callback) {
                                return (Patch)super.setCallback(callback);
                            }

                            public Patch setFields(String fields) {
                                return (Patch)super.setFields(fields);
                            }

                            public Patch setKey(String key) {
                                return (Patch)super.setKey(key);
                            }

                            public Patch setOauthToken(String oauthToken) {
                                return (Patch)super.setOauthToken(oauthToken);
                            }

                            public Patch setPrettyPrint(Boolean prettyPrint) {
                                return (Patch)super.setPrettyPrint(prettyPrint);
                            }

                            public Patch setQuotaUser(String quotaUser) {
                                return (Patch)super.setQuotaUser(quotaUser);
                            }

                            public Patch setUploadType(String uploadType) {
                                return (Patch)super.setUploadType(uploadType);
                            }

                            public Patch setUploadProtocol(String uploadProtocol) {
                                return (Patch)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Patch setName(String name) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+/messages/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            public String getUpdateMask() {
                                return this.updateMask;
                            }

                            public Patch setUpdateMask(String updateMask) {
                                this.updateMask = updateMask;
                                return this;
                            }

                            @Override
                            public Patch set(String parameterName, Object value) {
                                return (Patch)super.set(parameterName, value);
                            }
                        }

                        public class List
                        extends CloudHealthcareRequest<ListMessagesResponse> {
                            private static final String REST_PATH = "v1beta1/{+parent}/messages";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private String filter;
                            @Key
                            private String orderBy;
                            @Key
                            private Integer pageSize;
                            @Key
                            private String pageToken;
                            @Key
                            private String view;

                            protected List(String parent) {
                                super(CloudHealthcare.this, "GET", REST_PATH, null, ListMessagesResponse.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public List set$Xgafv(String $Xgafv) {
                                return (List)super.set$Xgafv($Xgafv);
                            }

                            public List setAccessToken(String accessToken) {
                                return (List)super.setAccessToken(accessToken);
                            }

                            public List setAlt(String alt) {
                                return (List)super.setAlt(alt);
                            }

                            public List setCallback(String callback) {
                                return (List)super.setCallback(callback);
                            }

                            public List setFields(String fields) {
                                return (List)super.setFields(fields);
                            }

                            public List setKey(String key) {
                                return (List)super.setKey(key);
                            }

                            public List setOauthToken(String oauthToken) {
                                return (List)super.setOauthToken(oauthToken);
                            }

                            public List setPrettyPrint(Boolean prettyPrint) {
                                return (List)super.setPrettyPrint(prettyPrint);
                            }

                            public List setQuotaUser(String quotaUser) {
                                return (List)super.setQuotaUser(quotaUser);
                            }

                            public List setUploadType(String uploadType) {
                                return (List)super.setUploadType(uploadType);
                            }

                            public List setUploadProtocol(String uploadProtocol) {
                                return (List)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public List setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public String getFilter() {
                                return this.filter;
                            }

                            public List setFilter(String filter) {
                                this.filter = filter;
                                return this;
                            }

                            public String getOrderBy() {
                                return this.orderBy;
                            }

                            public List setOrderBy(String orderBy) {
                                this.orderBy = orderBy;
                                return this;
                            }

                            public Integer getPageSize() {
                                return this.pageSize;
                            }

                            public List setPageSize(Integer pageSize) {
                                this.pageSize = pageSize;
                                return this;
                            }

                            public String getPageToken() {
                                return this.pageToken;
                            }

                            public List setPageToken(String pageToken) {
                                this.pageToken = pageToken;
                                return this;
                            }

                            public String getView() {
                                return this.view;
                            }

                            public List setView(String view) {
                                this.view = view;
                                return this;
                            }

                            @Override
                            public List set(String parameterName, Object value) {
                                return (List)super.set(parameterName, value);
                            }
                        }

                        public class Ingest
                        extends CloudHealthcareRequest<IngestMessageResponse> {
                            private static final String REST_PATH = "v1beta1/{+parent}/messages:ingest";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;

                            protected Ingest(String parent, IngestMessageRequest content) {
                                super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, IngestMessageResponse.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                                }
                            }

                            public Ingest set$Xgafv(String $Xgafv) {
                                return (Ingest)super.set$Xgafv($Xgafv);
                            }

                            public Ingest setAccessToken(String accessToken) {
                                return (Ingest)super.setAccessToken(accessToken);
                            }

                            public Ingest setAlt(String alt) {
                                return (Ingest)super.setAlt(alt);
                            }

                            public Ingest setCallback(String callback) {
                                return (Ingest)super.setCallback(callback);
                            }

                            public Ingest setFields(String fields) {
                                return (Ingest)super.setFields(fields);
                            }

                            public Ingest setKey(String key) {
                                return (Ingest)super.setKey(key);
                            }

                            public Ingest setOauthToken(String oauthToken) {
                                return (Ingest)super.setOauthToken(oauthToken);
                            }

                            public Ingest setPrettyPrint(Boolean prettyPrint) {
                                return (Ingest)super.setPrettyPrint(prettyPrint);
                            }

                            public Ingest setQuotaUser(String quotaUser) {
                                return (Ingest)super.setQuotaUser(quotaUser);
                            }

                            public Ingest setUploadType(String uploadType) {
                                return (Ingest)super.setUploadType(uploadType);
                            }

                            public Ingest setUploadProtocol(String uploadProtocol) {
                                return (Ingest)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public Ingest setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            @Override
                            public Ingest set(String parameterName, Object value) {
                                return (Ingest)super.set(parameterName, value);
                            }
                        }

                        public class Get
                        extends CloudHealthcareRequest<Message> {
                            private static final String REST_PATH = "v1beta1/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;
                            @Key
                            private String view;

                            protected Get(String name) {
                                super(CloudHealthcare.this, "GET", REST_PATH, null, Message.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+/messages/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+/messages/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public Get set$Xgafv(String $Xgafv) {
                                return (Get)super.set$Xgafv($Xgafv);
                            }

                            public Get setAccessToken(String accessToken) {
                                return (Get)super.setAccessToken(accessToken);
                            }

                            public Get setAlt(String alt) {
                                return (Get)super.setAlt(alt);
                            }

                            public Get setCallback(String callback) {
                                return (Get)super.setCallback(callback);
                            }

                            public Get setFields(String fields) {
                                return (Get)super.setFields(fields);
                            }

                            public Get setKey(String key) {
                                return (Get)super.setKey(key);
                            }

                            public Get setOauthToken(String oauthToken) {
                                return (Get)super.setOauthToken(oauthToken);
                            }

                            public Get setPrettyPrint(Boolean prettyPrint) {
                                return (Get)super.setPrettyPrint(prettyPrint);
                            }

                            public Get setQuotaUser(String quotaUser) {
                                return (Get)super.setQuotaUser(quotaUser);
                            }

                            public Get setUploadType(String uploadType) {
                                return (Get)super.setUploadType(uploadType);
                            }

                            public Get setUploadProtocol(String uploadProtocol) {
                                return (Get)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Get setName(String name) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+/messages/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            public String getView() {
                                return this.view;
                            }

                            public Get setView(String view) {
                                this.view = view;
                                return this;
                            }

                            @Override
                            public Get set(String parameterName, Object value) {
                                return (Get)super.set(parameterName, value);
                            }
                        }

                        public class Delete
                        extends CloudHealthcareRequest<Empty> {
                            private static final String REST_PATH = "v1beta1/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected Delete(String name) {
                                super(CloudHealthcare.this, "DELETE", REST_PATH, null, Empty.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+/messages/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+/messages/[^/]+$");
                                }
                            }

                            public Delete set$Xgafv(String $Xgafv) {
                                return (Delete)super.set$Xgafv($Xgafv);
                            }

                            public Delete setAccessToken(String accessToken) {
                                return (Delete)super.setAccessToken(accessToken);
                            }

                            public Delete setAlt(String alt) {
                                return (Delete)super.setAlt(alt);
                            }

                            public Delete setCallback(String callback) {
                                return (Delete)super.setCallback(callback);
                            }

                            public Delete setFields(String fields) {
                                return (Delete)super.setFields(fields);
                            }

                            public Delete setKey(String key) {
                                return (Delete)super.setKey(key);
                            }

                            public Delete setOauthToken(String oauthToken) {
                                return (Delete)super.setOauthToken(oauthToken);
                            }

                            public Delete setPrettyPrint(Boolean prettyPrint) {
                                return (Delete)super.setPrettyPrint(prettyPrint);
                            }

                            public Delete setQuotaUser(String quotaUser) {
                                return (Delete)super.setQuotaUser(quotaUser);
                            }

                            public Delete setUploadType(String uploadType) {
                                return (Delete)super.setUploadType(uploadType);
                            }

                            public Delete setUploadProtocol(String uploadProtocol) {
                                return (Delete)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Delete setName(String name) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+/messages/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public Delete set(String parameterName, Object value) {
                                return (Delete)super.set(parameterName, value);
                            }
                        }

                        public class Create
                        extends CloudHealthcareRequest<Message> {
                            private static final String REST_PATH = "v1beta1/{+parent}/messages";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;

                            protected Create(String parent, CreateMessageRequest content) {
                                super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Message.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                                }
                            }

                            public Create set$Xgafv(String $Xgafv) {
                                return (Create)super.set$Xgafv($Xgafv);
                            }

                            public Create setAccessToken(String accessToken) {
                                return (Create)super.setAccessToken(accessToken);
                            }

                            public Create setAlt(String alt) {
                                return (Create)super.setAlt(alt);
                            }

                            public Create setCallback(String callback) {
                                return (Create)super.setCallback(callback);
                            }

                            public Create setFields(String fields) {
                                return (Create)super.setFields(fields);
                            }

                            public Create setKey(String key) {
                                return (Create)super.setKey(key);
                            }

                            public Create setOauthToken(String oauthToken) {
                                return (Create)super.setOauthToken(oauthToken);
                            }

                            public Create setPrettyPrint(Boolean prettyPrint) {
                                return (Create)super.setPrettyPrint(prettyPrint);
                            }

                            public Create setQuotaUser(String quotaUser) {
                                return (Create)super.setQuotaUser(quotaUser);
                            }

                            public Create setUploadType(String uploadType) {
                                return (Create)super.setUploadType(uploadType);
                            }

                            public Create setUploadProtocol(String uploadProtocol) {
                                return (Create)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public Create setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            @Override
                            public Create set(String parameterName, Object value) {
                                return (Create)super.set(parameterName, value);
                            }
                        }
                    }

                    public class TestIamPermissions
                    extends CloudHealthcareRequest<TestIamPermissionsResponse> {
                        private static final String REST_PATH = "v1beta1/{+resource}:testIamPermissions";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;

                        protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                            }
                        }

                        public TestIamPermissions set$Xgafv(String $Xgafv) {
                            return (TestIamPermissions)super.set$Xgafv($Xgafv);
                        }

                        public TestIamPermissions setAccessToken(String accessToken) {
                            return (TestIamPermissions)super.setAccessToken(accessToken);
                        }

                        public TestIamPermissions setAlt(String alt) {
                            return (TestIamPermissions)super.setAlt(alt);
                        }

                        public TestIamPermissions setCallback(String callback) {
                            return (TestIamPermissions)super.setCallback(callback);
                        }

                        public TestIamPermissions setFields(String fields) {
                            return (TestIamPermissions)super.setFields(fields);
                        }

                        public TestIamPermissions setKey(String key) {
                            return (TestIamPermissions)super.setKey(key);
                        }

                        public TestIamPermissions setOauthToken(String oauthToken) {
                            return (TestIamPermissions)super.setOauthToken(oauthToken);
                        }

                        public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                            return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                        }

                        public TestIamPermissions setQuotaUser(String quotaUser) {
                            return (TestIamPermissions)super.setQuotaUser(quotaUser);
                        }

                        public TestIamPermissions setUploadType(String uploadType) {
                            return (TestIamPermissions)super.setUploadType(uploadType);
                        }

                        public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                            return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public TestIamPermissions setResource(String resource) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        @Override
                        public TestIamPermissions set(String parameterName, Object value) {
                            return (TestIamPermissions)super.set(parameterName, value);
                        }
                    }

                    public class SetIamPolicy
                    extends CloudHealthcareRequest<Policy> {
                        private static final String REST_PATH = "v1beta1/{+resource}:setIamPolicy";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;

                        protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Policy.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                            }
                        }

                        public SetIamPolicy set$Xgafv(String $Xgafv) {
                            return (SetIamPolicy)super.set$Xgafv($Xgafv);
                        }

                        public SetIamPolicy setAccessToken(String accessToken) {
                            return (SetIamPolicy)super.setAccessToken(accessToken);
                        }

                        public SetIamPolicy setAlt(String alt) {
                            return (SetIamPolicy)super.setAlt(alt);
                        }

                        public SetIamPolicy setCallback(String callback) {
                            return (SetIamPolicy)super.setCallback(callback);
                        }

                        public SetIamPolicy setFields(String fields) {
                            return (SetIamPolicy)super.setFields(fields);
                        }

                        public SetIamPolicy setKey(String key) {
                            return (SetIamPolicy)super.setKey(key);
                        }

                        public SetIamPolicy setOauthToken(String oauthToken) {
                            return (SetIamPolicy)super.setOauthToken(oauthToken);
                        }

                        public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                            return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                        }

                        public SetIamPolicy setQuotaUser(String quotaUser) {
                            return (SetIamPolicy)super.setQuotaUser(quotaUser);
                        }

                        public SetIamPolicy setUploadType(String uploadType) {
                            return (SetIamPolicy)super.setUploadType(uploadType);
                        }

                        public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                            return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public SetIamPolicy setResource(String resource) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        @Override
                        public SetIamPolicy set(String parameterName, Object value) {
                            return (SetIamPolicy)super.set(parameterName, value);
                        }
                    }

                    public class Patch
                    extends CloudHealthcareRequest<Hl7V2Store> {
                        private static final String REST_PATH = "v1beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String updateMask;

                        protected Patch(String name, Hl7V2Store content) {
                            super(CloudHealthcare.this, "PATCH", REST_PATH, (Object)content, Hl7V2Store.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String $Xgafv) {
                            return (Patch)super.set$Xgafv($Xgafv);
                        }

                        public Patch setAccessToken(String accessToken) {
                            return (Patch)super.setAccessToken(accessToken);
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setCallback(String callback) {
                            return (Patch)super.setCallback(callback);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUploadType(String uploadType) {
                            return (Patch)super.setUploadType(uploadType);
                        }

                        public Patch setUploadProtocol(String uploadProtocol) {
                            return (Patch)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String updateMask) {
                            this.updateMask = updateMask;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends CloudHealthcareRequest<ListHl7V2StoresResponse> {
                        private static final String REST_PATH = "v1beta1/{+parent}/hl7V2Stores";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String filter;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(CloudHealthcare.this, "GET", REST_PATH, null, ListHl7V2StoresResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class GetIamPolicy
                    extends CloudHealthcareRequest<Policy> {
                        private static final String REST_PATH = "v1beta1/{+resource}:getIamPolicy";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;
                        @Key(value="options.requestedPolicyVersion")
                        private Integer optionsRequestedPolicyVersion;

                        protected GetIamPolicy(String resource) {
                            super(CloudHealthcare.this, "GET", REST_PATH, null, Policy.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public GetIamPolicy set$Xgafv(String $Xgafv) {
                            return (GetIamPolicy)super.set$Xgafv($Xgafv);
                        }

                        public GetIamPolicy setAccessToken(String accessToken) {
                            return (GetIamPolicy)super.setAccessToken(accessToken);
                        }

                        public GetIamPolicy setAlt(String alt) {
                            return (GetIamPolicy)super.setAlt(alt);
                        }

                        public GetIamPolicy setCallback(String callback) {
                            return (GetIamPolicy)super.setCallback(callback);
                        }

                        public GetIamPolicy setFields(String fields) {
                            return (GetIamPolicy)super.setFields(fields);
                        }

                        public GetIamPolicy setKey(String key) {
                            return (GetIamPolicy)super.setKey(key);
                        }

                        public GetIamPolicy setOauthToken(String oauthToken) {
                            return (GetIamPolicy)super.setOauthToken(oauthToken);
                        }

                        public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                            return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                        }

                        public GetIamPolicy setQuotaUser(String quotaUser) {
                            return (GetIamPolicy)super.setQuotaUser(quotaUser);
                        }

                        public GetIamPolicy setUploadType(String uploadType) {
                            return (GetIamPolicy)super.setUploadType(uploadType);
                        }

                        public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                            return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public GetIamPolicy setResource(String resource) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        public Integer getOptionsRequestedPolicyVersion() {
                            return this.optionsRequestedPolicyVersion;
                        }

                        public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                            this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                            return this;
                        }

                        @Override
                        public GetIamPolicy set(String parameterName, Object value) {
                            return (GetIamPolicy)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends CloudHealthcareRequest<Hl7V2Store> {
                        private static final String REST_PATH = "v1beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(CloudHealthcare.this, "GET", REST_PATH, null, Hl7V2Store.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends CloudHealthcareRequest<Empty> {
                        private static final String REST_PATH = "v1beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String name) {
                            super(CloudHealthcare.this, "DELETE", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/hl7V2Stores/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends CloudHealthcareRequest<Hl7V2Store> {
                        private static final String REST_PATH = "v1beta1/{+parent}/hl7V2Stores";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String hl7V2StoreId;

                        protected Create(String parent, Hl7V2Store content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Hl7V2Store.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getHl7V2StoreId() {
                            return this.hl7V2StoreId;
                        }

                        public Create setHl7V2StoreId(String hl7V2StoreId) {
                            this.hl7V2StoreId = hl7V2StoreId;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                public class FhirStores {
                    public Create create(String parent, FhirStore content) throws IOException {
                        Create result = new Create(parent, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Deidentify deidentify(String sourceStore, DeidentifyFhirStoreRequest content) throws IOException {
                        Deidentify result = new Deidentify(sourceStore, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Export export(String name, ExportResourcesRequest content) throws IOException {
                        Export result = new Export(name, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public GetIamPolicy getIamPolicy(String resource) throws IOException {
                        GetIamPolicy result = new GetIamPolicy(resource);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public CloudHealthcareImport healthcareImport(String name, ImportResourcesRequest content) throws IOException {
                        CloudHealthcareImport result = new CloudHealthcareImport(name, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String name, FhirStore content) throws IOException {
                        Patch result = new Patch(name, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                        SetIamPolicy result = new SetIamPolicy(resource, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                        TestIamPermissions result = new TestIamPermissions(resource, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Fhir fhir() {
                        return new Fhir();
                    }

                    public class Fhir {
                        public ConceptMapSearchTranslate conceptMapSearchTranslate(String parent) throws IOException {
                            ConceptMapSearchTranslate result = new ConceptMapSearchTranslate(parent);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public ConceptMapTranslate conceptMapTranslate(String name) throws IOException {
                            ConceptMapTranslate result = new ConceptMapTranslate(name);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public ObservationLastn observationLastn(String parent) throws IOException {
                            ObservationLastn result = new ObservationLastn(parent);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public PatientEverything patientEverything(String name) throws IOException {
                            PatientEverything result = new PatientEverything(name);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public ResourcePurge resourcePurge(String name) throws IOException {
                            ResourcePurge result = new ResourcePurge(name);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Capabilities capabilities(String name) throws IOException {
                            Capabilities result = new Capabilities(name);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public ConditionalDelete conditionalDelete(String parent, String type) throws IOException {
                            ConditionalDelete result = new ConditionalDelete(parent, type);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public ConditionalPatch conditionalPatch(String parent, String type, HttpBody content) throws IOException {
                            ConditionalPatch result = new ConditionalPatch(parent, type, content);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public ConditionalUpdate conditionalUpdate(String parent, String type, HttpBody content) throws IOException {
                            ConditionalUpdate result = new ConditionalUpdate(parent, type, content);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Create create(String parent, String type, HttpBody content) throws IOException {
                            Create result = new Create(parent, type, content);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Delete delete(String name) throws IOException {
                            Delete result = new Delete(name);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public ExecuteBundle executeBundle(String parent, HttpBody content) throws IOException {
                            ExecuteBundle result = new ExecuteBundle(parent, content);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public History history(String name) throws IOException {
                            History result = new History(name);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Patch patch(String name, HttpBody content) throws IOException {
                            Patch result = new Patch(name, content);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Read read(String name) throws IOException {
                            Read result = new Read(name);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Search search(String parent, SearchResourcesRequest content) throws IOException {
                            Search result = new Search(parent, content);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Update update(String name, HttpBody content) throws IOException {
                            Update result = new Update(name, content);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Vread vread(String name) throws IOException {
                            Vread result = new Vread(name);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public class Vread
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected Vread(String name) {
                                super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+/_history/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+/_history/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public Vread set$Xgafv(String $Xgafv) {
                                return (Vread)super.set$Xgafv($Xgafv);
                            }

                            public Vread setAccessToken(String accessToken) {
                                return (Vread)super.setAccessToken(accessToken);
                            }

                            public Vread setAlt(String alt) {
                                return (Vread)super.setAlt(alt);
                            }

                            public Vread setCallback(String callback) {
                                return (Vread)super.setCallback(callback);
                            }

                            public Vread setFields(String fields) {
                                return (Vread)super.setFields(fields);
                            }

                            public Vread setKey(String key) {
                                return (Vread)super.setKey(key);
                            }

                            public Vread setOauthToken(String oauthToken) {
                                return (Vread)super.setOauthToken(oauthToken);
                            }

                            public Vread setPrettyPrint(Boolean prettyPrint) {
                                return (Vread)super.setPrettyPrint(prettyPrint);
                            }

                            public Vread setQuotaUser(String quotaUser) {
                                return (Vread)super.setQuotaUser(quotaUser);
                            }

                            public Vread setUploadType(String uploadType) {
                                return (Vread)super.setUploadType(uploadType);
                            }

                            public Vread setUploadProtocol(String uploadProtocol) {
                                return (Vread)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Vread setName(String name) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+/_history/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public Vread set(String parameterName, Object value) {
                                return (Vread)super.set(parameterName, value);
                            }
                        }

                        public class Update
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected Update(String name, HttpBody content) {
                                super(CloudHealthcare.this, "PUT", REST_PATH, (Object)content, HttpBody.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                                }
                            }

                            public Update set$Xgafv(String $Xgafv) {
                                return (Update)super.set$Xgafv($Xgafv);
                            }

                            public Update setAccessToken(String accessToken) {
                                return (Update)super.setAccessToken(accessToken);
                            }

                            public Update setAlt(String alt) {
                                return (Update)super.setAlt(alt);
                            }

                            public Update setCallback(String callback) {
                                return (Update)super.setCallback(callback);
                            }

                            public Update setFields(String fields) {
                                return (Update)super.setFields(fields);
                            }

                            public Update setKey(String key) {
                                return (Update)super.setKey(key);
                            }

                            public Update setOauthToken(String oauthToken) {
                                return (Update)super.setOauthToken(oauthToken);
                            }

                            public Update setPrettyPrint(Boolean prettyPrint) {
                                return (Update)super.setPrettyPrint(prettyPrint);
                            }

                            public Update setQuotaUser(String quotaUser) {
                                return (Update)super.setQuotaUser(quotaUser);
                            }

                            public Update setUploadType(String uploadType) {
                                return (Update)super.setUploadType(uploadType);
                            }

                            public Update setUploadProtocol(String uploadProtocol) {
                                return (Update)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Update setName(String name) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public Update set(String parameterName, Object value) {
                                return (Update)super.set(parameterName, value);
                            }
                        }

                        public class Search
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+parent}/fhir/_search";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;

                            protected Search(String parent, SearchResourcesRequest content) {
                                super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, HttpBody.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                }
                            }

                            public Search set$Xgafv(String $Xgafv) {
                                return (Search)super.set$Xgafv($Xgafv);
                            }

                            public Search setAccessToken(String accessToken) {
                                return (Search)super.setAccessToken(accessToken);
                            }

                            public Search setAlt(String alt) {
                                return (Search)super.setAlt(alt);
                            }

                            public Search setCallback(String callback) {
                                return (Search)super.setCallback(callback);
                            }

                            public Search setFields(String fields) {
                                return (Search)super.setFields(fields);
                            }

                            public Search setKey(String key) {
                                return (Search)super.setKey(key);
                            }

                            public Search setOauthToken(String oauthToken) {
                                return (Search)super.setOauthToken(oauthToken);
                            }

                            public Search setPrettyPrint(Boolean prettyPrint) {
                                return (Search)super.setPrettyPrint(prettyPrint);
                            }

                            public Search setQuotaUser(String quotaUser) {
                                return (Search)super.setQuotaUser(quotaUser);
                            }

                            public Search setUploadType(String uploadType) {
                                return (Search)super.setUploadType(uploadType);
                            }

                            public Search setUploadProtocol(String uploadProtocol) {
                                return (Search)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public Search setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            @Override
                            public Search set(String parameterName, Object value) {
                                return (Search)super.set(parameterName, value);
                            }
                        }

                        public class Read
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected Read(String name) {
                                super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public Read set$Xgafv(String $Xgafv) {
                                return (Read)super.set$Xgafv($Xgafv);
                            }

                            public Read setAccessToken(String accessToken) {
                                return (Read)super.setAccessToken(accessToken);
                            }

                            public Read setAlt(String alt) {
                                return (Read)super.setAlt(alt);
                            }

                            public Read setCallback(String callback) {
                                return (Read)super.setCallback(callback);
                            }

                            public Read setFields(String fields) {
                                return (Read)super.setFields(fields);
                            }

                            public Read setKey(String key) {
                                return (Read)super.setKey(key);
                            }

                            public Read setOauthToken(String oauthToken) {
                                return (Read)super.setOauthToken(oauthToken);
                            }

                            public Read setPrettyPrint(Boolean prettyPrint) {
                                return (Read)super.setPrettyPrint(prettyPrint);
                            }

                            public Read setQuotaUser(String quotaUser) {
                                return (Read)super.setQuotaUser(quotaUser);
                            }

                            public Read setUploadType(String uploadType) {
                                return (Read)super.setUploadType(uploadType);
                            }

                            public Read setUploadProtocol(String uploadProtocol) {
                                return (Read)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Read setName(String name) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public Read set(String parameterName, Object value) {
                                return (Read)super.set(parameterName, value);
                            }
                        }

                        public class Patch
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected Patch(String name, HttpBody content) {
                                super(CloudHealthcare.this, "PATCH", REST_PATH, (Object)content, HttpBody.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                                }
                            }

                            public Patch set$Xgafv(String $Xgafv) {
                                return (Patch)super.set$Xgafv($Xgafv);
                            }

                            public Patch setAccessToken(String accessToken) {
                                return (Patch)super.setAccessToken(accessToken);
                            }

                            public Patch setAlt(String alt) {
                                return (Patch)super.setAlt(alt);
                            }

                            public Patch setCallback(String callback) {
                                return (Patch)super.setCallback(callback);
                            }

                            public Patch setFields(String fields) {
                                return (Patch)super.setFields(fields);
                            }

                            public Patch setKey(String key) {
                                return (Patch)super.setKey(key);
                            }

                            public Patch setOauthToken(String oauthToken) {
                                return (Patch)super.setOauthToken(oauthToken);
                            }

                            public Patch setPrettyPrint(Boolean prettyPrint) {
                                return (Patch)super.setPrettyPrint(prettyPrint);
                            }

                            public Patch setQuotaUser(String quotaUser) {
                                return (Patch)super.setQuotaUser(quotaUser);
                            }

                            public Patch setUploadType(String uploadType) {
                                return (Patch)super.setUploadType(uploadType);
                            }

                            public Patch setUploadProtocol(String uploadProtocol) {
                                return (Patch)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Patch setName(String name) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public Patch set(String parameterName, Object value) {
                                return (Patch)super.set(parameterName, value);
                            }
                        }

                        public class History
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+name}/_history";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;
                            @Key(value="_at")
                            private String at;
                            @Key(value="_count")
                            private Integer count;
                            @Key(value="_page_token")
                            private String pageToken;
                            @Key(value="_since")
                            private String since;

                            protected History(String name) {
                                super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public History set$Xgafv(String $Xgafv) {
                                return (History)super.set$Xgafv($Xgafv);
                            }

                            public History setAccessToken(String accessToken) {
                                return (History)super.setAccessToken(accessToken);
                            }

                            public History setAlt(String alt) {
                                return (History)super.setAlt(alt);
                            }

                            public History setCallback(String callback) {
                                return (History)super.setCallback(callback);
                            }

                            public History setFields(String fields) {
                                return (History)super.setFields(fields);
                            }

                            public History setKey(String key) {
                                return (History)super.setKey(key);
                            }

                            public History setOauthToken(String oauthToken) {
                                return (History)super.setOauthToken(oauthToken);
                            }

                            public History setPrettyPrint(Boolean prettyPrint) {
                                return (History)super.setPrettyPrint(prettyPrint);
                            }

                            public History setQuotaUser(String quotaUser) {
                                return (History)super.setQuotaUser(quotaUser);
                            }

                            public History setUploadType(String uploadType) {
                                return (History)super.setUploadType(uploadType);
                            }

                            public History setUploadProtocol(String uploadProtocol) {
                                return (History)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public History setName(String name) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            public String getAt() {
                                return this.at;
                            }

                            public History setAt(String at) {
                                this.at = at;
                                return this;
                            }

                            public Integer getCount() {
                                return this.count;
                            }

                            public History setCount(Integer count) {
                                this.count = count;
                                return this;
                            }

                            public String getPageToken() {
                                return this.pageToken;
                            }

                            public History setPageToken(String pageToken) {
                                this.pageToken = pageToken;
                                return this;
                            }

                            public String getSince() {
                                return this.since;
                            }

                            public History setSince(String since) {
                                this.since = since;
                                return this;
                            }

                            @Override
                            public History set(String parameterName, Object value) {
                                return (History)super.set(parameterName, value);
                            }
                        }

                        public class ExecuteBundle
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+parent}/fhir";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;

                            protected ExecuteBundle(String parent, HttpBody content) {
                                super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, HttpBody.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                }
                            }

                            public ExecuteBundle set$Xgafv(String $Xgafv) {
                                return (ExecuteBundle)super.set$Xgafv($Xgafv);
                            }

                            public ExecuteBundle setAccessToken(String accessToken) {
                                return (ExecuteBundle)super.setAccessToken(accessToken);
                            }

                            public ExecuteBundle setAlt(String alt) {
                                return (ExecuteBundle)super.setAlt(alt);
                            }

                            public ExecuteBundle setCallback(String callback) {
                                return (ExecuteBundle)super.setCallback(callback);
                            }

                            public ExecuteBundle setFields(String fields) {
                                return (ExecuteBundle)super.setFields(fields);
                            }

                            public ExecuteBundle setKey(String key) {
                                return (ExecuteBundle)super.setKey(key);
                            }

                            public ExecuteBundle setOauthToken(String oauthToken) {
                                return (ExecuteBundle)super.setOauthToken(oauthToken);
                            }

                            public ExecuteBundle setPrettyPrint(Boolean prettyPrint) {
                                return (ExecuteBundle)super.setPrettyPrint(prettyPrint);
                            }

                            public ExecuteBundle setQuotaUser(String quotaUser) {
                                return (ExecuteBundle)super.setQuotaUser(quotaUser);
                            }

                            public ExecuteBundle setUploadType(String uploadType) {
                                return (ExecuteBundle)super.setUploadType(uploadType);
                            }

                            public ExecuteBundle setUploadProtocol(String uploadProtocol) {
                                return (ExecuteBundle)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public ExecuteBundle setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            @Override
                            public ExecuteBundle set(String parameterName, Object value) {
                                return (ExecuteBundle)super.set(parameterName, value);
                            }
                        }

                        public class Delete
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected Delete(String name) {
                                super(CloudHealthcare.this, "DELETE", REST_PATH, null, HttpBody.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                                }
                            }

                            public Delete set$Xgafv(String $Xgafv) {
                                return (Delete)super.set$Xgafv($Xgafv);
                            }

                            public Delete setAccessToken(String accessToken) {
                                return (Delete)super.setAccessToken(accessToken);
                            }

                            public Delete setAlt(String alt) {
                                return (Delete)super.setAlt(alt);
                            }

                            public Delete setCallback(String callback) {
                                return (Delete)super.setCallback(callback);
                            }

                            public Delete setFields(String fields) {
                                return (Delete)super.setFields(fields);
                            }

                            public Delete setKey(String key) {
                                return (Delete)super.setKey(key);
                            }

                            public Delete setOauthToken(String oauthToken) {
                                return (Delete)super.setOauthToken(oauthToken);
                            }

                            public Delete setPrettyPrint(Boolean prettyPrint) {
                                return (Delete)super.setPrettyPrint(prettyPrint);
                            }

                            public Delete setQuotaUser(String quotaUser) {
                                return (Delete)super.setQuotaUser(quotaUser);
                            }

                            public Delete setUploadType(String uploadType) {
                                return (Delete)super.setUploadType(uploadType);
                            }

                            public Delete setUploadProtocol(String uploadProtocol) {
                                return (Delete)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Delete setName(String name) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public Delete set(String parameterName, Object value) {
                                return (Delete)super.set(parameterName, value);
                            }
                        }

                        public class Create
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+parent}/fhir/{+type}";
                            private final Pattern PARENT_PATTERN;
                            private final Pattern TYPE_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private String type;

                            protected Create(String parent, String type, HttpBody content) {
                                super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, HttpBody.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                this.TYPE_PATTERN = Pattern.compile("^[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                }
                                this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"Required parameter type must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.TYPE_PATTERN.matcher(type).matches(), (Object)"Parameter type must conform to the pattern ^[^/]+$");
                                }
                            }

                            public Create set$Xgafv(String $Xgafv) {
                                return (Create)super.set$Xgafv($Xgafv);
                            }

                            public Create setAccessToken(String accessToken) {
                                return (Create)super.setAccessToken(accessToken);
                            }

                            public Create setAlt(String alt) {
                                return (Create)super.setAlt(alt);
                            }

                            public Create setCallback(String callback) {
                                return (Create)super.setCallback(callback);
                            }

                            public Create setFields(String fields) {
                                return (Create)super.setFields(fields);
                            }

                            public Create setKey(String key) {
                                return (Create)super.setKey(key);
                            }

                            public Create setOauthToken(String oauthToken) {
                                return (Create)super.setOauthToken(oauthToken);
                            }

                            public Create setPrettyPrint(Boolean prettyPrint) {
                                return (Create)super.setPrettyPrint(prettyPrint);
                            }

                            public Create setQuotaUser(String quotaUser) {
                                return (Create)super.setQuotaUser(quotaUser);
                            }

                            public Create setUploadType(String uploadType) {
                                return (Create)super.setUploadType(uploadType);
                            }

                            public Create setUploadProtocol(String uploadProtocol) {
                                return (Create)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public Create setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public String getType() {
                                return this.type;
                            }

                            public Create setType(String type) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.TYPE_PATTERN.matcher(type).matches(), (Object)"Parameter type must conform to the pattern ^[^/]+$");
                                }
                                this.type = type;
                                return this;
                            }

                            @Override
                            public Create set(String parameterName, Object value) {
                                return (Create)super.set(parameterName, value);
                            }
                        }

                        public class ConditionalUpdate
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+parent}/fhir/{+type}";
                            private final Pattern PARENT_PATTERN;
                            private final Pattern TYPE_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private String type;

                            protected ConditionalUpdate(String parent, String type, HttpBody content) {
                                super(CloudHealthcare.this, "PUT", REST_PATH, (Object)content, HttpBody.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                this.TYPE_PATTERN = Pattern.compile("^[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                }
                                this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"Required parameter type must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.TYPE_PATTERN.matcher(type).matches(), (Object)"Parameter type must conform to the pattern ^[^/]+$");
                                }
                            }

                            public ConditionalUpdate set$Xgafv(String $Xgafv) {
                                return (ConditionalUpdate)super.set$Xgafv($Xgafv);
                            }

                            public ConditionalUpdate setAccessToken(String accessToken) {
                                return (ConditionalUpdate)super.setAccessToken(accessToken);
                            }

                            public ConditionalUpdate setAlt(String alt) {
                                return (ConditionalUpdate)super.setAlt(alt);
                            }

                            public ConditionalUpdate setCallback(String callback) {
                                return (ConditionalUpdate)super.setCallback(callback);
                            }

                            public ConditionalUpdate setFields(String fields) {
                                return (ConditionalUpdate)super.setFields(fields);
                            }

                            public ConditionalUpdate setKey(String key) {
                                return (ConditionalUpdate)super.setKey(key);
                            }

                            public ConditionalUpdate setOauthToken(String oauthToken) {
                                return (ConditionalUpdate)super.setOauthToken(oauthToken);
                            }

                            public ConditionalUpdate setPrettyPrint(Boolean prettyPrint) {
                                return (ConditionalUpdate)super.setPrettyPrint(prettyPrint);
                            }

                            public ConditionalUpdate setQuotaUser(String quotaUser) {
                                return (ConditionalUpdate)super.setQuotaUser(quotaUser);
                            }

                            public ConditionalUpdate setUploadType(String uploadType) {
                                return (ConditionalUpdate)super.setUploadType(uploadType);
                            }

                            public ConditionalUpdate setUploadProtocol(String uploadProtocol) {
                                return (ConditionalUpdate)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public ConditionalUpdate setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public String getType() {
                                return this.type;
                            }

                            public ConditionalUpdate setType(String type) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.TYPE_PATTERN.matcher(type).matches(), (Object)"Parameter type must conform to the pattern ^[^/]+$");
                                }
                                this.type = type;
                                return this;
                            }

                            @Override
                            public ConditionalUpdate set(String parameterName, Object value) {
                                return (ConditionalUpdate)super.set(parameterName, value);
                            }
                        }

                        public class ConditionalPatch
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+parent}/fhir/{+type}";
                            private final Pattern PARENT_PATTERN;
                            private final Pattern TYPE_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private String type;

                            protected ConditionalPatch(String parent, String type, HttpBody content) {
                                super(CloudHealthcare.this, "PATCH", REST_PATH, (Object)content, HttpBody.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                this.TYPE_PATTERN = Pattern.compile("^[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                }
                                this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"Required parameter type must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.TYPE_PATTERN.matcher(type).matches(), (Object)"Parameter type must conform to the pattern ^[^/]+$");
                                }
                            }

                            public ConditionalPatch set$Xgafv(String $Xgafv) {
                                return (ConditionalPatch)super.set$Xgafv($Xgafv);
                            }

                            public ConditionalPatch setAccessToken(String accessToken) {
                                return (ConditionalPatch)super.setAccessToken(accessToken);
                            }

                            public ConditionalPatch setAlt(String alt) {
                                return (ConditionalPatch)super.setAlt(alt);
                            }

                            public ConditionalPatch setCallback(String callback) {
                                return (ConditionalPatch)super.setCallback(callback);
                            }

                            public ConditionalPatch setFields(String fields) {
                                return (ConditionalPatch)super.setFields(fields);
                            }

                            public ConditionalPatch setKey(String key) {
                                return (ConditionalPatch)super.setKey(key);
                            }

                            public ConditionalPatch setOauthToken(String oauthToken) {
                                return (ConditionalPatch)super.setOauthToken(oauthToken);
                            }

                            public ConditionalPatch setPrettyPrint(Boolean prettyPrint) {
                                return (ConditionalPatch)super.setPrettyPrint(prettyPrint);
                            }

                            public ConditionalPatch setQuotaUser(String quotaUser) {
                                return (ConditionalPatch)super.setQuotaUser(quotaUser);
                            }

                            public ConditionalPatch setUploadType(String uploadType) {
                                return (ConditionalPatch)super.setUploadType(uploadType);
                            }

                            public ConditionalPatch setUploadProtocol(String uploadProtocol) {
                                return (ConditionalPatch)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public ConditionalPatch setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public String getType() {
                                return this.type;
                            }

                            public ConditionalPatch setType(String type) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.TYPE_PATTERN.matcher(type).matches(), (Object)"Parameter type must conform to the pattern ^[^/]+$");
                                }
                                this.type = type;
                                return this;
                            }

                            @Override
                            public ConditionalPatch set(String parameterName, Object value) {
                                return (ConditionalPatch)super.set(parameterName, value);
                            }
                        }

                        public class ConditionalDelete
                        extends CloudHealthcareRequest<Empty> {
                            private static final String REST_PATH = "v1beta1/{+parent}/fhir/{+type}";
                            private final Pattern PARENT_PATTERN;
                            private final Pattern TYPE_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private String type;

                            protected ConditionalDelete(String parent, String type) {
                                super(CloudHealthcare.this, "DELETE", REST_PATH, null, Empty.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                this.TYPE_PATTERN = Pattern.compile("^[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                }
                                this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"Required parameter type must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.TYPE_PATTERN.matcher(type).matches(), (Object)"Parameter type must conform to the pattern ^[^/]+$");
                                }
                            }

                            public ConditionalDelete set$Xgafv(String $Xgafv) {
                                return (ConditionalDelete)super.set$Xgafv($Xgafv);
                            }

                            public ConditionalDelete setAccessToken(String accessToken) {
                                return (ConditionalDelete)super.setAccessToken(accessToken);
                            }

                            public ConditionalDelete setAlt(String alt) {
                                return (ConditionalDelete)super.setAlt(alt);
                            }

                            public ConditionalDelete setCallback(String callback) {
                                return (ConditionalDelete)super.setCallback(callback);
                            }

                            public ConditionalDelete setFields(String fields) {
                                return (ConditionalDelete)super.setFields(fields);
                            }

                            public ConditionalDelete setKey(String key) {
                                return (ConditionalDelete)super.setKey(key);
                            }

                            public ConditionalDelete setOauthToken(String oauthToken) {
                                return (ConditionalDelete)super.setOauthToken(oauthToken);
                            }

                            public ConditionalDelete setPrettyPrint(Boolean prettyPrint) {
                                return (ConditionalDelete)super.setPrettyPrint(prettyPrint);
                            }

                            public ConditionalDelete setQuotaUser(String quotaUser) {
                                return (ConditionalDelete)super.setQuotaUser(quotaUser);
                            }

                            public ConditionalDelete setUploadType(String uploadType) {
                                return (ConditionalDelete)super.setUploadType(uploadType);
                            }

                            public ConditionalDelete setUploadProtocol(String uploadProtocol) {
                                return (ConditionalDelete)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public ConditionalDelete setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public String getType() {
                                return this.type;
                            }

                            public ConditionalDelete setType(String type) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.TYPE_PATTERN.matcher(type).matches(), (Object)"Parameter type must conform to the pattern ^[^/]+$");
                                }
                                this.type = type;
                                return this;
                            }

                            @Override
                            public ConditionalDelete set(String parameterName, Object value) {
                                return (ConditionalDelete)super.set(parameterName, value);
                            }
                        }

                        public class Capabilities
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+name}/fhir/metadata";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected Capabilities(String name) {
                                super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public Capabilities set$Xgafv(String $Xgafv) {
                                return (Capabilities)super.set$Xgafv($Xgafv);
                            }

                            public Capabilities setAccessToken(String accessToken) {
                                return (Capabilities)super.setAccessToken(accessToken);
                            }

                            public Capabilities setAlt(String alt) {
                                return (Capabilities)super.setAlt(alt);
                            }

                            public Capabilities setCallback(String callback) {
                                return (Capabilities)super.setCallback(callback);
                            }

                            public Capabilities setFields(String fields) {
                                return (Capabilities)super.setFields(fields);
                            }

                            public Capabilities setKey(String key) {
                                return (Capabilities)super.setKey(key);
                            }

                            public Capabilities setOauthToken(String oauthToken) {
                                return (Capabilities)super.setOauthToken(oauthToken);
                            }

                            public Capabilities setPrettyPrint(Boolean prettyPrint) {
                                return (Capabilities)super.setPrettyPrint(prettyPrint);
                            }

                            public Capabilities setQuotaUser(String quotaUser) {
                                return (Capabilities)super.setQuotaUser(quotaUser);
                            }

                            public Capabilities setUploadType(String uploadType) {
                                return (Capabilities)super.setUploadType(uploadType);
                            }

                            public Capabilities setUploadProtocol(String uploadProtocol) {
                                return (Capabilities)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Capabilities setName(String name) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public Capabilities set(String parameterName, Object value) {
                                return (Capabilities)super.set(parameterName, value);
                            }
                        }

                        public class ResourcePurge
                        extends CloudHealthcareRequest<Empty> {
                            private static final String REST_PATH = "v1beta1/{+name}/$purge";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected ResourcePurge(String name) {
                                super(CloudHealthcare.this, "DELETE", REST_PATH, null, Empty.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                                }
                            }

                            public ResourcePurge set$Xgafv(String $Xgafv) {
                                return (ResourcePurge)super.set$Xgafv($Xgafv);
                            }

                            public ResourcePurge setAccessToken(String accessToken) {
                                return (ResourcePurge)super.setAccessToken(accessToken);
                            }

                            public ResourcePurge setAlt(String alt) {
                                return (ResourcePurge)super.setAlt(alt);
                            }

                            public ResourcePurge setCallback(String callback) {
                                return (ResourcePurge)super.setCallback(callback);
                            }

                            public ResourcePurge setFields(String fields) {
                                return (ResourcePurge)super.setFields(fields);
                            }

                            public ResourcePurge setKey(String key) {
                                return (ResourcePurge)super.setKey(key);
                            }

                            public ResourcePurge setOauthToken(String oauthToken) {
                                return (ResourcePurge)super.setOauthToken(oauthToken);
                            }

                            public ResourcePurge setPrettyPrint(Boolean prettyPrint) {
                                return (ResourcePurge)super.setPrettyPrint(prettyPrint);
                            }

                            public ResourcePurge setQuotaUser(String quotaUser) {
                                return (ResourcePurge)super.setQuotaUser(quotaUser);
                            }

                            public ResourcePurge setUploadType(String uploadType) {
                                return (ResourcePurge)super.setUploadType(uploadType);
                            }

                            public ResourcePurge setUploadProtocol(String uploadProtocol) {
                                return (ResourcePurge)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public ResourcePurge setName(String name) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/[^/]+/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public ResourcePurge set(String parameterName, Object value) {
                                return (ResourcePurge)super.set(parameterName, value);
                            }
                        }

                        public class PatientEverything
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+name}/$everything";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;
                            @Key(value="_count")
                            private Integer count;
                            @Key(value="_page_token")
                            private String pageToken;
                            @Key(value="_since")
                            private String since;
                            @Key(value="_type")
                            private String type;
                            @Key
                            private String end;
                            @Key
                            private String start;

                            protected PatientEverything(String name) {
                                super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/Patient/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/Patient/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public PatientEverything set$Xgafv(String $Xgafv) {
                                return (PatientEverything)super.set$Xgafv($Xgafv);
                            }

                            public PatientEverything setAccessToken(String accessToken) {
                                return (PatientEverything)super.setAccessToken(accessToken);
                            }

                            public PatientEverything setAlt(String alt) {
                                return (PatientEverything)super.setAlt(alt);
                            }

                            public PatientEverything setCallback(String callback) {
                                return (PatientEverything)super.setCallback(callback);
                            }

                            public PatientEverything setFields(String fields) {
                                return (PatientEverything)super.setFields(fields);
                            }

                            public PatientEverything setKey(String key) {
                                return (PatientEverything)super.setKey(key);
                            }

                            public PatientEverything setOauthToken(String oauthToken) {
                                return (PatientEverything)super.setOauthToken(oauthToken);
                            }

                            public PatientEverything setPrettyPrint(Boolean prettyPrint) {
                                return (PatientEverything)super.setPrettyPrint(prettyPrint);
                            }

                            public PatientEverything setQuotaUser(String quotaUser) {
                                return (PatientEverything)super.setQuotaUser(quotaUser);
                            }

                            public PatientEverything setUploadType(String uploadType) {
                                return (PatientEverything)super.setUploadType(uploadType);
                            }

                            public PatientEverything setUploadProtocol(String uploadProtocol) {
                                return (PatientEverything)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public PatientEverything setName(String name) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/Patient/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            public Integer getCount() {
                                return this.count;
                            }

                            public PatientEverything setCount(Integer count) {
                                this.count = count;
                                return this;
                            }

                            public String getPageToken() {
                                return this.pageToken;
                            }

                            public PatientEverything setPageToken(String pageToken) {
                                this.pageToken = pageToken;
                                return this;
                            }

                            public String getSince() {
                                return this.since;
                            }

                            public PatientEverything setSince(String since) {
                                this.since = since;
                                return this;
                            }

                            public String getType() {
                                return this.type;
                            }

                            public PatientEverything setType(String type) {
                                this.type = type;
                                return this;
                            }

                            public String getEnd() {
                                return this.end;
                            }

                            public PatientEverything setEnd(String end) {
                                this.end = end;
                                return this;
                            }

                            public String getStart() {
                                return this.start;
                            }

                            public PatientEverything setStart(String start) {
                                this.start = start;
                                return this;
                            }

                            @Override
                            public PatientEverything set(String parameterName, Object value) {
                                return (PatientEverything)super.set(parameterName, value);
                            }
                        }

                        public class ObservationLastn
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+parent}/fhir/Observation/$lastn";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;

                            protected ObservationLastn(String parent) {
                                super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public ObservationLastn set$Xgafv(String $Xgafv) {
                                return (ObservationLastn)super.set$Xgafv($Xgafv);
                            }

                            public ObservationLastn setAccessToken(String accessToken) {
                                return (ObservationLastn)super.setAccessToken(accessToken);
                            }

                            public ObservationLastn setAlt(String alt) {
                                return (ObservationLastn)super.setAlt(alt);
                            }

                            public ObservationLastn setCallback(String callback) {
                                return (ObservationLastn)super.setCallback(callback);
                            }

                            public ObservationLastn setFields(String fields) {
                                return (ObservationLastn)super.setFields(fields);
                            }

                            public ObservationLastn setKey(String key) {
                                return (ObservationLastn)super.setKey(key);
                            }

                            public ObservationLastn setOauthToken(String oauthToken) {
                                return (ObservationLastn)super.setOauthToken(oauthToken);
                            }

                            public ObservationLastn setPrettyPrint(Boolean prettyPrint) {
                                return (ObservationLastn)super.setPrettyPrint(prettyPrint);
                            }

                            public ObservationLastn setQuotaUser(String quotaUser) {
                                return (ObservationLastn)super.setQuotaUser(quotaUser);
                            }

                            public ObservationLastn setUploadType(String uploadType) {
                                return (ObservationLastn)super.setUploadType(uploadType);
                            }

                            public ObservationLastn setUploadProtocol(String uploadProtocol) {
                                return (ObservationLastn)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public ObservationLastn setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            @Override
                            public ObservationLastn set(String parameterName, Object value) {
                                return (ObservationLastn)super.set(parameterName, value);
                            }
                        }

                        public class ConceptMapTranslate
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+name}/$translate";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;
                            @Key
                            private String code;
                            @Key
                            private String conceptMapVersion;
                            @Key
                            private String system;

                            protected ConceptMapTranslate(String name) {
                                super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/ConceptMap/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/ConceptMap/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public ConceptMapTranslate set$Xgafv(String $Xgafv) {
                                return (ConceptMapTranslate)super.set$Xgafv($Xgafv);
                            }

                            public ConceptMapTranslate setAccessToken(String accessToken) {
                                return (ConceptMapTranslate)super.setAccessToken(accessToken);
                            }

                            public ConceptMapTranslate setAlt(String alt) {
                                return (ConceptMapTranslate)super.setAlt(alt);
                            }

                            public ConceptMapTranslate setCallback(String callback) {
                                return (ConceptMapTranslate)super.setCallback(callback);
                            }

                            public ConceptMapTranslate setFields(String fields) {
                                return (ConceptMapTranslate)super.setFields(fields);
                            }

                            public ConceptMapTranslate setKey(String key) {
                                return (ConceptMapTranslate)super.setKey(key);
                            }

                            public ConceptMapTranslate setOauthToken(String oauthToken) {
                                return (ConceptMapTranslate)super.setOauthToken(oauthToken);
                            }

                            public ConceptMapTranslate setPrettyPrint(Boolean prettyPrint) {
                                return (ConceptMapTranslate)super.setPrettyPrint(prettyPrint);
                            }

                            public ConceptMapTranslate setQuotaUser(String quotaUser) {
                                return (ConceptMapTranslate)super.setQuotaUser(quotaUser);
                            }

                            public ConceptMapTranslate setUploadType(String uploadType) {
                                return (ConceptMapTranslate)super.setUploadType(uploadType);
                            }

                            public ConceptMapTranslate setUploadProtocol(String uploadProtocol) {
                                return (ConceptMapTranslate)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public ConceptMapTranslate setName(String name) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+/fhir/ConceptMap/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            public String getCode() {
                                return this.code;
                            }

                            public ConceptMapTranslate setCode(String code) {
                                this.code = code;
                                return this;
                            }

                            public String getConceptMapVersion() {
                                return this.conceptMapVersion;
                            }

                            public ConceptMapTranslate setConceptMapVersion(String conceptMapVersion) {
                                this.conceptMapVersion = conceptMapVersion;
                                return this;
                            }

                            public String getSystem() {
                                return this.system;
                            }

                            public ConceptMapTranslate setSystem(String system) {
                                this.system = system;
                                return this;
                            }

                            @Override
                            public ConceptMapTranslate set(String parameterName, Object value) {
                                return (ConceptMapTranslate)super.set(parameterName, value);
                            }
                        }

                        public class ConceptMapSearchTranslate
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+parent}/fhir/ConceptMap/$translate";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private String code;
                            @Key
                            private String conceptMapVersion;
                            @Key
                            private String source;
                            @Key
                            private String system;
                            @Key
                            private String target;
                            @Key
                            private String url;

                            protected ConceptMapSearchTranslate(String parent) {
                                super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public ConceptMapSearchTranslate set$Xgafv(String $Xgafv) {
                                return (ConceptMapSearchTranslate)super.set$Xgafv($Xgafv);
                            }

                            public ConceptMapSearchTranslate setAccessToken(String accessToken) {
                                return (ConceptMapSearchTranslate)super.setAccessToken(accessToken);
                            }

                            public ConceptMapSearchTranslate setAlt(String alt) {
                                return (ConceptMapSearchTranslate)super.setAlt(alt);
                            }

                            public ConceptMapSearchTranslate setCallback(String callback) {
                                return (ConceptMapSearchTranslate)super.setCallback(callback);
                            }

                            public ConceptMapSearchTranslate setFields(String fields) {
                                return (ConceptMapSearchTranslate)super.setFields(fields);
                            }

                            public ConceptMapSearchTranslate setKey(String key) {
                                return (ConceptMapSearchTranslate)super.setKey(key);
                            }

                            public ConceptMapSearchTranslate setOauthToken(String oauthToken) {
                                return (ConceptMapSearchTranslate)super.setOauthToken(oauthToken);
                            }

                            public ConceptMapSearchTranslate setPrettyPrint(Boolean prettyPrint) {
                                return (ConceptMapSearchTranslate)super.setPrettyPrint(prettyPrint);
                            }

                            public ConceptMapSearchTranslate setQuotaUser(String quotaUser) {
                                return (ConceptMapSearchTranslate)super.setQuotaUser(quotaUser);
                            }

                            public ConceptMapSearchTranslate setUploadType(String uploadType) {
                                return (ConceptMapSearchTranslate)super.setUploadType(uploadType);
                            }

                            public ConceptMapSearchTranslate setUploadProtocol(String uploadProtocol) {
                                return (ConceptMapSearchTranslate)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public ConceptMapSearchTranslate setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public String getCode() {
                                return this.code;
                            }

                            public ConceptMapSearchTranslate setCode(String code) {
                                this.code = code;
                                return this;
                            }

                            public String getConceptMapVersion() {
                                return this.conceptMapVersion;
                            }

                            public ConceptMapSearchTranslate setConceptMapVersion(String conceptMapVersion) {
                                this.conceptMapVersion = conceptMapVersion;
                                return this;
                            }

                            public String getSource() {
                                return this.source;
                            }

                            public ConceptMapSearchTranslate setSource(String source) {
                                this.source = source;
                                return this;
                            }

                            public String getSystem() {
                                return this.system;
                            }

                            public ConceptMapSearchTranslate setSystem(String system) {
                                this.system = system;
                                return this;
                            }

                            public String getTarget() {
                                return this.target;
                            }

                            public ConceptMapSearchTranslate setTarget(String target) {
                                this.target = target;
                                return this;
                            }

                            public String getUrl() {
                                return this.url;
                            }

                            public ConceptMapSearchTranslate setUrl(String url) {
                                this.url = url;
                                return this;
                            }

                            @Override
                            public ConceptMapSearchTranslate set(String parameterName, Object value) {
                                return (ConceptMapSearchTranslate)super.set(parameterName, value);
                            }
                        }
                    }

                    public class TestIamPermissions
                    extends CloudHealthcareRequest<TestIamPermissionsResponse> {
                        private static final String REST_PATH = "v1beta1/{+resource}:testIamPermissions";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;

                        protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            }
                        }

                        public TestIamPermissions set$Xgafv(String $Xgafv) {
                            return (TestIamPermissions)super.set$Xgafv($Xgafv);
                        }

                        public TestIamPermissions setAccessToken(String accessToken) {
                            return (TestIamPermissions)super.setAccessToken(accessToken);
                        }

                        public TestIamPermissions setAlt(String alt) {
                            return (TestIamPermissions)super.setAlt(alt);
                        }

                        public TestIamPermissions setCallback(String callback) {
                            return (TestIamPermissions)super.setCallback(callback);
                        }

                        public TestIamPermissions setFields(String fields) {
                            return (TestIamPermissions)super.setFields(fields);
                        }

                        public TestIamPermissions setKey(String key) {
                            return (TestIamPermissions)super.setKey(key);
                        }

                        public TestIamPermissions setOauthToken(String oauthToken) {
                            return (TestIamPermissions)super.setOauthToken(oauthToken);
                        }

                        public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                            return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                        }

                        public TestIamPermissions setQuotaUser(String quotaUser) {
                            return (TestIamPermissions)super.setQuotaUser(quotaUser);
                        }

                        public TestIamPermissions setUploadType(String uploadType) {
                            return (TestIamPermissions)super.setUploadType(uploadType);
                        }

                        public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                            return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public TestIamPermissions setResource(String resource) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        @Override
                        public TestIamPermissions set(String parameterName, Object value) {
                            return (TestIamPermissions)super.set(parameterName, value);
                        }
                    }

                    public class SetIamPolicy
                    extends CloudHealthcareRequest<Policy> {
                        private static final String REST_PATH = "v1beta1/{+resource}:setIamPolicy";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;

                        protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Policy.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            }
                        }

                        public SetIamPolicy set$Xgafv(String $Xgafv) {
                            return (SetIamPolicy)super.set$Xgafv($Xgafv);
                        }

                        public SetIamPolicy setAccessToken(String accessToken) {
                            return (SetIamPolicy)super.setAccessToken(accessToken);
                        }

                        public SetIamPolicy setAlt(String alt) {
                            return (SetIamPolicy)super.setAlt(alt);
                        }

                        public SetIamPolicy setCallback(String callback) {
                            return (SetIamPolicy)super.setCallback(callback);
                        }

                        public SetIamPolicy setFields(String fields) {
                            return (SetIamPolicy)super.setFields(fields);
                        }

                        public SetIamPolicy setKey(String key) {
                            return (SetIamPolicy)super.setKey(key);
                        }

                        public SetIamPolicy setOauthToken(String oauthToken) {
                            return (SetIamPolicy)super.setOauthToken(oauthToken);
                        }

                        public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                            return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                        }

                        public SetIamPolicy setQuotaUser(String quotaUser) {
                            return (SetIamPolicy)super.setQuotaUser(quotaUser);
                        }

                        public SetIamPolicy setUploadType(String uploadType) {
                            return (SetIamPolicy)super.setUploadType(uploadType);
                        }

                        public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                            return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public SetIamPolicy setResource(String resource) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        @Override
                        public SetIamPolicy set(String parameterName, Object value) {
                            return (SetIamPolicy)super.set(parameterName, value);
                        }
                    }

                    public class Patch
                    extends CloudHealthcareRequest<FhirStore> {
                        private static final String REST_PATH = "v1beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String updateMask;

                        protected Patch(String name, FhirStore content) {
                            super(CloudHealthcare.this, "PATCH", REST_PATH, (Object)content, FhirStore.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String $Xgafv) {
                            return (Patch)super.set$Xgafv($Xgafv);
                        }

                        public Patch setAccessToken(String accessToken) {
                            return (Patch)super.setAccessToken(accessToken);
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setCallback(String callback) {
                            return (Patch)super.setCallback(callback);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUploadType(String uploadType) {
                            return (Patch)super.setUploadType(uploadType);
                        }

                        public Patch setUploadProtocol(String uploadProtocol) {
                            return (Patch)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String updateMask) {
                            this.updateMask = updateMask;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends CloudHealthcareRequest<ListFhirStoresResponse> {
                        private static final String REST_PATH = "v1beta1/{+parent}/fhirStores";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String filter;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(CloudHealthcare.this, "GET", REST_PATH, null, ListFhirStoresResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class CloudHealthcareImport
                    extends CloudHealthcareRequest<Operation> {
                        private static final String REST_PATH = "v1beta1/{+name}:import";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected CloudHealthcareImport(String name, ImportResourcesRequest content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            }
                        }

                        public CloudHealthcareImport set$Xgafv(String $Xgafv) {
                            return (CloudHealthcareImport)super.set$Xgafv($Xgafv);
                        }

                        public CloudHealthcareImport setAccessToken(String accessToken) {
                            return (CloudHealthcareImport)super.setAccessToken(accessToken);
                        }

                        public CloudHealthcareImport setAlt(String alt) {
                            return (CloudHealthcareImport)super.setAlt(alt);
                        }

                        public CloudHealthcareImport setCallback(String callback) {
                            return (CloudHealthcareImport)super.setCallback(callback);
                        }

                        public CloudHealthcareImport setFields(String fields) {
                            return (CloudHealthcareImport)super.setFields(fields);
                        }

                        public CloudHealthcareImport setKey(String key) {
                            return (CloudHealthcareImport)super.setKey(key);
                        }

                        public CloudHealthcareImport setOauthToken(String oauthToken) {
                            return (CloudHealthcareImport)super.setOauthToken(oauthToken);
                        }

                        public CloudHealthcareImport setPrettyPrint(Boolean prettyPrint) {
                            return (CloudHealthcareImport)super.setPrettyPrint(prettyPrint);
                        }

                        public CloudHealthcareImport setQuotaUser(String quotaUser) {
                            return (CloudHealthcareImport)super.setQuotaUser(quotaUser);
                        }

                        public CloudHealthcareImport setUploadType(String uploadType) {
                            return (CloudHealthcareImport)super.setUploadType(uploadType);
                        }

                        public CloudHealthcareImport setUploadProtocol(String uploadProtocol) {
                            return (CloudHealthcareImport)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public CloudHealthcareImport setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public CloudHealthcareImport set(String parameterName, Object value) {
                            return (CloudHealthcareImport)super.set(parameterName, value);
                        }
                    }

                    public class GetIamPolicy
                    extends CloudHealthcareRequest<Policy> {
                        private static final String REST_PATH = "v1beta1/{+resource}:getIamPolicy";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;
                        @Key(value="options.requestedPolicyVersion")
                        private Integer optionsRequestedPolicyVersion;

                        protected GetIamPolicy(String resource) {
                            super(CloudHealthcare.this, "GET", REST_PATH, null, Policy.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public GetIamPolicy set$Xgafv(String $Xgafv) {
                            return (GetIamPolicy)super.set$Xgafv($Xgafv);
                        }

                        public GetIamPolicy setAccessToken(String accessToken) {
                            return (GetIamPolicy)super.setAccessToken(accessToken);
                        }

                        public GetIamPolicy setAlt(String alt) {
                            return (GetIamPolicy)super.setAlt(alt);
                        }

                        public GetIamPolicy setCallback(String callback) {
                            return (GetIamPolicy)super.setCallback(callback);
                        }

                        public GetIamPolicy setFields(String fields) {
                            return (GetIamPolicy)super.setFields(fields);
                        }

                        public GetIamPolicy setKey(String key) {
                            return (GetIamPolicy)super.setKey(key);
                        }

                        public GetIamPolicy setOauthToken(String oauthToken) {
                            return (GetIamPolicy)super.setOauthToken(oauthToken);
                        }

                        public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                            return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                        }

                        public GetIamPolicy setQuotaUser(String quotaUser) {
                            return (GetIamPolicy)super.setQuotaUser(quotaUser);
                        }

                        public GetIamPolicy setUploadType(String uploadType) {
                            return (GetIamPolicy)super.setUploadType(uploadType);
                        }

                        public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                            return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public GetIamPolicy setResource(String resource) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        public Integer getOptionsRequestedPolicyVersion() {
                            return this.optionsRequestedPolicyVersion;
                        }

                        public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                            this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                            return this;
                        }

                        @Override
                        public GetIamPolicy set(String parameterName, Object value) {
                            return (GetIamPolicy)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends CloudHealthcareRequest<FhirStore> {
                        private static final String REST_PATH = "v1beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(CloudHealthcare.this, "GET", REST_PATH, null, FhirStore.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Export
                    extends CloudHealthcareRequest<Operation> {
                        private static final String REST_PATH = "v1beta1/{+name}:export";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Export(String name, ExportResourcesRequest content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            }
                        }

                        public Export set$Xgafv(String $Xgafv) {
                            return (Export)super.set$Xgafv($Xgafv);
                        }

                        public Export setAccessToken(String accessToken) {
                            return (Export)super.setAccessToken(accessToken);
                        }

                        public Export setAlt(String alt) {
                            return (Export)super.setAlt(alt);
                        }

                        public Export setCallback(String callback) {
                            return (Export)super.setCallback(callback);
                        }

                        public Export setFields(String fields) {
                            return (Export)super.setFields(fields);
                        }

                        public Export setKey(String key) {
                            return (Export)super.setKey(key);
                        }

                        public Export setOauthToken(String oauthToken) {
                            return (Export)super.setOauthToken(oauthToken);
                        }

                        public Export setPrettyPrint(Boolean prettyPrint) {
                            return (Export)super.setPrettyPrint(prettyPrint);
                        }

                        public Export setQuotaUser(String quotaUser) {
                            return (Export)super.setQuotaUser(quotaUser);
                        }

                        public Export setUploadType(String uploadType) {
                            return (Export)super.setUploadType(uploadType);
                        }

                        public Export setUploadProtocol(String uploadProtocol) {
                            return (Export)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Export setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Export set(String parameterName, Object value) {
                            return (Export)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends CloudHealthcareRequest<Empty> {
                        private static final String REST_PATH = "v1beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String name) {
                            super(CloudHealthcare.this, "DELETE", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Deidentify
                    extends CloudHealthcareRequest<Operation> {
                        private static final String REST_PATH = "v1beta1/{+sourceStore}:deidentify";
                        private final Pattern SOURCE_STORE_PATTERN;
                        @Key
                        private String sourceStore;

                        protected Deidentify(String sourceStore, DeidentifyFhirStoreRequest content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.SOURCE_STORE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            this.sourceStore = (String)Preconditions.checkNotNull((Object)sourceStore, (Object)"Required parameter sourceStore must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SOURCE_STORE_PATTERN.matcher(sourceStore).matches(), (Object)"Parameter sourceStore must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            }
                        }

                        public Deidentify set$Xgafv(String $Xgafv) {
                            return (Deidentify)super.set$Xgafv($Xgafv);
                        }

                        public Deidentify setAccessToken(String accessToken) {
                            return (Deidentify)super.setAccessToken(accessToken);
                        }

                        public Deidentify setAlt(String alt) {
                            return (Deidentify)super.setAlt(alt);
                        }

                        public Deidentify setCallback(String callback) {
                            return (Deidentify)super.setCallback(callback);
                        }

                        public Deidentify setFields(String fields) {
                            return (Deidentify)super.setFields(fields);
                        }

                        public Deidentify setKey(String key) {
                            return (Deidentify)super.setKey(key);
                        }

                        public Deidentify setOauthToken(String oauthToken) {
                            return (Deidentify)super.setOauthToken(oauthToken);
                        }

                        public Deidentify setPrettyPrint(Boolean prettyPrint) {
                            return (Deidentify)super.setPrettyPrint(prettyPrint);
                        }

                        public Deidentify setQuotaUser(String quotaUser) {
                            return (Deidentify)super.setQuotaUser(quotaUser);
                        }

                        public Deidentify setUploadType(String uploadType) {
                            return (Deidentify)super.setUploadType(uploadType);
                        }

                        public Deidentify setUploadProtocol(String uploadProtocol) {
                            return (Deidentify)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getSourceStore() {
                            return this.sourceStore;
                        }

                        public Deidentify setSourceStore(String sourceStore) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SOURCE_STORE_PATTERN.matcher(sourceStore).matches(), (Object)"Parameter sourceStore must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/fhirStores/[^/]+$");
                            }
                            this.sourceStore = sourceStore;
                            return this;
                        }

                        @Override
                        public Deidentify set(String parameterName, Object value) {
                            return (Deidentify)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends CloudHealthcareRequest<FhirStore> {
                        private static final String REST_PATH = "v1beta1/{+parent}/fhirStores";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String fhirStoreId;

                        protected Create(String parent, FhirStore content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, FhirStore.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getFhirStoreId() {
                            return this.fhirStoreId;
                        }

                        public Create setFhirStoreId(String fhirStoreId) {
                            this.fhirStoreId = fhirStoreId;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                public class DicomStores {
                    public Create create(String parent, DicomStore content) throws IOException {
                        Create result = new Create(parent, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Deidentify deidentify(String sourceStore, DeidentifyDicomStoreRequest content) throws IOException {
                        Deidentify result = new Deidentify(sourceStore, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Export export(String name, ExportDicomDataRequest content) throws IOException {
                        Export result = new Export(name, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public GetIamPolicy getIamPolicy(String resource) throws IOException {
                        GetIamPolicy result = new GetIamPolicy(resource);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public CloudHealthcareImport healthcareImport(String name, ImportDicomDataRequest content) throws IOException {
                        CloudHealthcareImport result = new CloudHealthcareImport(name, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String name, DicomStore content) throws IOException {
                        Patch result = new Patch(name, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public SearchForInstances searchForInstances(String parent, String dicomWebPath) throws IOException {
                        SearchForInstances result = new SearchForInstances(parent, dicomWebPath);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public SearchForSeries searchForSeries(String parent, String dicomWebPath) throws IOException {
                        SearchForSeries result = new SearchForSeries(parent, dicomWebPath);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public SearchForStudies searchForStudies(String parent, String dicomWebPath) throws IOException {
                        SearchForStudies result = new SearchForStudies(parent, dicomWebPath);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                        SetIamPolicy result = new SetIamPolicy(resource, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public StoreInstances storeInstances(String parent, String dicomWebPath, HttpBody content) throws IOException {
                        StoreInstances result = new StoreInstances(parent, dicomWebPath, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                        TestIamPermissions result = new TestIamPermissions(resource, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Studies studies() {
                        return new Studies();
                    }

                    public class Studies {
                        public Delete delete(String parent, String dicomWebPath) throws IOException {
                            Delete result = new Delete(parent, dicomWebPath);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public RetrieveMetadata retrieveMetadata(String parent, String dicomWebPath) throws IOException {
                            RetrieveMetadata result = new RetrieveMetadata(parent, dicomWebPath);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public RetrieveStudy retrieveStudy(String parent, String dicomWebPath) throws IOException {
                            RetrieveStudy result = new RetrieveStudy(parent, dicomWebPath);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public SearchForInstances searchForInstances(String parent, String dicomWebPath) throws IOException {
                            SearchForInstances result = new SearchForInstances(parent, dicomWebPath);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public SearchForSeries searchForSeries(String parent, String dicomWebPath) throws IOException {
                            SearchForSeries result = new SearchForSeries(parent, dicomWebPath);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public StoreInstances storeInstances(String parent, String dicomWebPath, HttpBody content) throws IOException {
                            StoreInstances result = new StoreInstances(parent, dicomWebPath, content);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Series series() {
                            return new Series();
                        }

                        public class Series {
                            public Delete delete(String parent, String dicomWebPath) throws IOException {
                                Delete result = new Delete(parent, dicomWebPath);
                                CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                                return result;
                            }

                            public RetrieveMetadata retrieveMetadata(String parent, String dicomWebPath) throws IOException {
                                RetrieveMetadata result = new RetrieveMetadata(parent, dicomWebPath);
                                CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                                return result;
                            }

                            public RetrieveSeries retrieveSeries(String parent, String dicomWebPath) throws IOException {
                                RetrieveSeries result = new RetrieveSeries(parent, dicomWebPath);
                                CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                                return result;
                            }

                            public SearchForInstances searchForInstances(String parent, String dicomWebPath) throws IOException {
                                SearchForInstances result = new SearchForInstances(parent, dicomWebPath);
                                CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                                return result;
                            }

                            public Instances instances() {
                                return new Instances();
                            }

                            public class Instances {
                                public Delete delete(String parent, String dicomWebPath) throws IOException {
                                    Delete result = new Delete(parent, dicomWebPath);
                                    CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                                    return result;
                                }

                                public RetrieveInstance retrieveInstance(String parent, String dicomWebPath) throws IOException {
                                    RetrieveInstance result = new RetrieveInstance(parent, dicomWebPath);
                                    CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                                    return result;
                                }

                                public RetrieveMetadata retrieveMetadata(String parent, String dicomWebPath) throws IOException {
                                    RetrieveMetadata result = new RetrieveMetadata(parent, dicomWebPath);
                                    CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                                    return result;
                                }

                                public RetrieveRendered retrieveRendered(String parent, String dicomWebPath) throws IOException {
                                    RetrieveRendered result = new RetrieveRendered(parent, dicomWebPath);
                                    CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                                    return result;
                                }

                                public Frames frames() {
                                    return new Frames();
                                }

                                public class Frames {
                                    public RetrieveFrames retrieveFrames(String parent, String dicomWebPath) throws IOException {
                                        RetrieveFrames result = new RetrieveFrames(parent, dicomWebPath);
                                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                                        return result;
                                    }

                                    public RetrieveRendered retrieveRendered(String parent, String dicomWebPath) throws IOException {
                                        RetrieveRendered result = new RetrieveRendered(parent, dicomWebPath);
                                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                                        return result;
                                    }

                                    public class RetrieveRendered
                                    extends CloudHealthcareRequest<HttpBody> {
                                        private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                                        private final Pattern PARENT_PATTERN;
                                        private final Pattern DICOM_WEB_PATH_PATTERN;
                                        @Key
                                        private String parent;
                                        @Key
                                        private String dicomWebPath;

                                        protected RetrieveRendered(String parent, String dicomWebPath) {
                                            super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                            this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^studies/[^/]+/series/[^/]+/instances/[^/]+/frames/[^/]+/rendered$");
                                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                            }
                                            this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                                Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+/instances/[^/]+/frames/[^/]+/rendered$");
                                            }
                                        }

                                        public HttpResponse executeUsingHead() throws IOException {
                                            return super.executeUsingHead();
                                        }

                                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                            return super.buildHttpRequestUsingHead();
                                        }

                                        public RetrieveRendered set$Xgafv(String $Xgafv) {
                                            return (RetrieveRendered)super.set$Xgafv($Xgafv);
                                        }

                                        public RetrieveRendered setAccessToken(String accessToken) {
                                            return (RetrieveRendered)super.setAccessToken(accessToken);
                                        }

                                        public RetrieveRendered setAlt(String alt) {
                                            return (RetrieveRendered)super.setAlt(alt);
                                        }

                                        public RetrieveRendered setCallback(String callback) {
                                            return (RetrieveRendered)super.setCallback(callback);
                                        }

                                        public RetrieveRendered setFields(String fields) {
                                            return (RetrieveRendered)super.setFields(fields);
                                        }

                                        public RetrieveRendered setKey(String key) {
                                            return (RetrieveRendered)super.setKey(key);
                                        }

                                        public RetrieveRendered setOauthToken(String oauthToken) {
                                            return (RetrieveRendered)super.setOauthToken(oauthToken);
                                        }

                                        public RetrieveRendered setPrettyPrint(Boolean prettyPrint) {
                                            return (RetrieveRendered)super.setPrettyPrint(prettyPrint);
                                        }

                                        public RetrieveRendered setQuotaUser(String quotaUser) {
                                            return (RetrieveRendered)super.setQuotaUser(quotaUser);
                                        }

                                        public RetrieveRendered setUploadType(String uploadType) {
                                            return (RetrieveRendered)super.setUploadType(uploadType);
                                        }

                                        public RetrieveRendered setUploadProtocol(String uploadProtocol) {
                                            return (RetrieveRendered)super.setUploadProtocol(uploadProtocol);
                                        }

                                        public String getParent() {
                                            return this.parent;
                                        }

                                        public RetrieveRendered setParent(String parent) {
                                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                            }
                                            this.parent = parent;
                                            return this;
                                        }

                                        public String getDicomWebPath() {
                                            return this.dicomWebPath;
                                        }

                                        public RetrieveRendered setDicomWebPath(String dicomWebPath) {
                                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                                Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+/instances/[^/]+/frames/[^/]+/rendered$");
                                            }
                                            this.dicomWebPath = dicomWebPath;
                                            return this;
                                        }

                                        @Override
                                        public RetrieveRendered set(String parameterName, Object value) {
                                            return (RetrieveRendered)super.set(parameterName, value);
                                        }
                                    }

                                    public class RetrieveFrames
                                    extends CloudHealthcareRequest<HttpBody> {
                                        private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                                        private final Pattern PARENT_PATTERN;
                                        private final Pattern DICOM_WEB_PATH_PATTERN;
                                        @Key
                                        private String parent;
                                        @Key
                                        private String dicomWebPath;

                                        protected RetrieveFrames(String parent, String dicomWebPath) {
                                            super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                            this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^studies/[^/]+/series/[^/]+/instances/[^/]+/frames/[^/]+$");
                                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                            }
                                            this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                                Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+/instances/[^/]+/frames/[^/]+$");
                                            }
                                        }

                                        public HttpResponse executeUsingHead() throws IOException {
                                            return super.executeUsingHead();
                                        }

                                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                            return super.buildHttpRequestUsingHead();
                                        }

                                        public RetrieveFrames set$Xgafv(String $Xgafv) {
                                            return (RetrieveFrames)super.set$Xgafv($Xgafv);
                                        }

                                        public RetrieveFrames setAccessToken(String accessToken) {
                                            return (RetrieveFrames)super.setAccessToken(accessToken);
                                        }

                                        public RetrieveFrames setAlt(String alt) {
                                            return (RetrieveFrames)super.setAlt(alt);
                                        }

                                        public RetrieveFrames setCallback(String callback) {
                                            return (RetrieveFrames)super.setCallback(callback);
                                        }

                                        public RetrieveFrames setFields(String fields) {
                                            return (RetrieveFrames)super.setFields(fields);
                                        }

                                        public RetrieveFrames setKey(String key) {
                                            return (RetrieveFrames)super.setKey(key);
                                        }

                                        public RetrieveFrames setOauthToken(String oauthToken) {
                                            return (RetrieveFrames)super.setOauthToken(oauthToken);
                                        }

                                        public RetrieveFrames setPrettyPrint(Boolean prettyPrint) {
                                            return (RetrieveFrames)super.setPrettyPrint(prettyPrint);
                                        }

                                        public RetrieveFrames setQuotaUser(String quotaUser) {
                                            return (RetrieveFrames)super.setQuotaUser(quotaUser);
                                        }

                                        public RetrieveFrames setUploadType(String uploadType) {
                                            return (RetrieveFrames)super.setUploadType(uploadType);
                                        }

                                        public RetrieveFrames setUploadProtocol(String uploadProtocol) {
                                            return (RetrieveFrames)super.setUploadProtocol(uploadProtocol);
                                        }

                                        public String getParent() {
                                            return this.parent;
                                        }

                                        public RetrieveFrames setParent(String parent) {
                                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                            }
                                            this.parent = parent;
                                            return this;
                                        }

                                        public String getDicomWebPath() {
                                            return this.dicomWebPath;
                                        }

                                        public RetrieveFrames setDicomWebPath(String dicomWebPath) {
                                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                                Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+/instances/[^/]+/frames/[^/]+$");
                                            }
                                            this.dicomWebPath = dicomWebPath;
                                            return this;
                                        }

                                        @Override
                                        public RetrieveFrames set(String parameterName, Object value) {
                                            return (RetrieveFrames)super.set(parameterName, value);
                                        }
                                    }
                                }

                                public class RetrieveRendered
                                extends CloudHealthcareRequest<HttpBody> {
                                    private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                                    private final Pattern PARENT_PATTERN;
                                    private final Pattern DICOM_WEB_PATH_PATTERN;
                                    @Key
                                    private String parent;
                                    @Key
                                    private String dicomWebPath;

                                    protected RetrieveRendered(String parent, String dicomWebPath) {
                                        super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                        this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^studies/[^/]+/series/[^/]+/instances/[^/]+/rendered$");
                                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                        }
                                        this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                            Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+/instances/[^/]+/rendered$");
                                        }
                                    }

                                    public HttpResponse executeUsingHead() throws IOException {
                                        return super.executeUsingHead();
                                    }

                                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                        return super.buildHttpRequestUsingHead();
                                    }

                                    public RetrieveRendered set$Xgafv(String $Xgafv) {
                                        return (RetrieveRendered)super.set$Xgafv($Xgafv);
                                    }

                                    public RetrieveRendered setAccessToken(String accessToken) {
                                        return (RetrieveRendered)super.setAccessToken(accessToken);
                                    }

                                    public RetrieveRendered setAlt(String alt) {
                                        return (RetrieveRendered)super.setAlt(alt);
                                    }

                                    public RetrieveRendered setCallback(String callback) {
                                        return (RetrieveRendered)super.setCallback(callback);
                                    }

                                    public RetrieveRendered setFields(String fields) {
                                        return (RetrieveRendered)super.setFields(fields);
                                    }

                                    public RetrieveRendered setKey(String key) {
                                        return (RetrieveRendered)super.setKey(key);
                                    }

                                    public RetrieveRendered setOauthToken(String oauthToken) {
                                        return (RetrieveRendered)super.setOauthToken(oauthToken);
                                    }

                                    public RetrieveRendered setPrettyPrint(Boolean prettyPrint) {
                                        return (RetrieveRendered)super.setPrettyPrint(prettyPrint);
                                    }

                                    public RetrieveRendered setQuotaUser(String quotaUser) {
                                        return (RetrieveRendered)super.setQuotaUser(quotaUser);
                                    }

                                    public RetrieveRendered setUploadType(String uploadType) {
                                        return (RetrieveRendered)super.setUploadType(uploadType);
                                    }

                                    public RetrieveRendered setUploadProtocol(String uploadProtocol) {
                                        return (RetrieveRendered)super.setUploadProtocol(uploadProtocol);
                                    }

                                    public String getParent() {
                                        return this.parent;
                                    }

                                    public RetrieveRendered setParent(String parent) {
                                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                        }
                                        this.parent = parent;
                                        return this;
                                    }

                                    public String getDicomWebPath() {
                                        return this.dicomWebPath;
                                    }

                                    public RetrieveRendered setDicomWebPath(String dicomWebPath) {
                                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                            Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+/instances/[^/]+/rendered$");
                                        }
                                        this.dicomWebPath = dicomWebPath;
                                        return this;
                                    }

                                    @Override
                                    public RetrieveRendered set(String parameterName, Object value) {
                                        return (RetrieveRendered)super.set(parameterName, value);
                                    }
                                }

                                public class RetrieveMetadata
                                extends CloudHealthcareRequest<HttpBody> {
                                    private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                                    private final Pattern PARENT_PATTERN;
                                    private final Pattern DICOM_WEB_PATH_PATTERN;
                                    @Key
                                    private String parent;
                                    @Key
                                    private String dicomWebPath;

                                    protected RetrieveMetadata(String parent, String dicomWebPath) {
                                        super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                        this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^studies/[^/]+/series/[^/]+/instances/[^/]+/metadata$");
                                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                        }
                                        this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                            Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+/instances/[^/]+/metadata$");
                                        }
                                    }

                                    public HttpResponse executeUsingHead() throws IOException {
                                        return super.executeUsingHead();
                                    }

                                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                        return super.buildHttpRequestUsingHead();
                                    }

                                    public RetrieveMetadata set$Xgafv(String $Xgafv) {
                                        return (RetrieveMetadata)super.set$Xgafv($Xgafv);
                                    }

                                    public RetrieveMetadata setAccessToken(String accessToken) {
                                        return (RetrieveMetadata)super.setAccessToken(accessToken);
                                    }

                                    public RetrieveMetadata setAlt(String alt) {
                                        return (RetrieveMetadata)super.setAlt(alt);
                                    }

                                    public RetrieveMetadata setCallback(String callback) {
                                        return (RetrieveMetadata)super.setCallback(callback);
                                    }

                                    public RetrieveMetadata setFields(String fields) {
                                        return (RetrieveMetadata)super.setFields(fields);
                                    }

                                    public RetrieveMetadata setKey(String key) {
                                        return (RetrieveMetadata)super.setKey(key);
                                    }

                                    public RetrieveMetadata setOauthToken(String oauthToken) {
                                        return (RetrieveMetadata)super.setOauthToken(oauthToken);
                                    }

                                    public RetrieveMetadata setPrettyPrint(Boolean prettyPrint) {
                                        return (RetrieveMetadata)super.setPrettyPrint(prettyPrint);
                                    }

                                    public RetrieveMetadata setQuotaUser(String quotaUser) {
                                        return (RetrieveMetadata)super.setQuotaUser(quotaUser);
                                    }

                                    public RetrieveMetadata setUploadType(String uploadType) {
                                        return (RetrieveMetadata)super.setUploadType(uploadType);
                                    }

                                    public RetrieveMetadata setUploadProtocol(String uploadProtocol) {
                                        return (RetrieveMetadata)super.setUploadProtocol(uploadProtocol);
                                    }

                                    public String getParent() {
                                        return this.parent;
                                    }

                                    public RetrieveMetadata setParent(String parent) {
                                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                        }
                                        this.parent = parent;
                                        return this;
                                    }

                                    public String getDicomWebPath() {
                                        return this.dicomWebPath;
                                    }

                                    public RetrieveMetadata setDicomWebPath(String dicomWebPath) {
                                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                            Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+/instances/[^/]+/metadata$");
                                        }
                                        this.dicomWebPath = dicomWebPath;
                                        return this;
                                    }

                                    @Override
                                    public RetrieveMetadata set(String parameterName, Object value) {
                                        return (RetrieveMetadata)super.set(parameterName, value);
                                    }
                                }

                                public class RetrieveInstance
                                extends CloudHealthcareRequest<HttpBody> {
                                    private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                                    private final Pattern PARENT_PATTERN;
                                    private final Pattern DICOM_WEB_PATH_PATTERN;
                                    @Key
                                    private String parent;
                                    @Key
                                    private String dicomWebPath;

                                    protected RetrieveInstance(String parent, String dicomWebPath) {
                                        super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                        this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^studies/[^/]+/series/[^/]+/instances/[^/]+$");
                                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                        }
                                        this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                            Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+/instances/[^/]+$");
                                        }
                                    }

                                    public HttpResponse executeUsingHead() throws IOException {
                                        return super.executeUsingHead();
                                    }

                                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                        return super.buildHttpRequestUsingHead();
                                    }

                                    public RetrieveInstance set$Xgafv(String $Xgafv) {
                                        return (RetrieveInstance)super.set$Xgafv($Xgafv);
                                    }

                                    public RetrieveInstance setAccessToken(String accessToken) {
                                        return (RetrieveInstance)super.setAccessToken(accessToken);
                                    }

                                    public RetrieveInstance setAlt(String alt) {
                                        return (RetrieveInstance)super.setAlt(alt);
                                    }

                                    public RetrieveInstance setCallback(String callback) {
                                        return (RetrieveInstance)super.setCallback(callback);
                                    }

                                    public RetrieveInstance setFields(String fields) {
                                        return (RetrieveInstance)super.setFields(fields);
                                    }

                                    public RetrieveInstance setKey(String key) {
                                        return (RetrieveInstance)super.setKey(key);
                                    }

                                    public RetrieveInstance setOauthToken(String oauthToken) {
                                        return (RetrieveInstance)super.setOauthToken(oauthToken);
                                    }

                                    public RetrieveInstance setPrettyPrint(Boolean prettyPrint) {
                                        return (RetrieveInstance)super.setPrettyPrint(prettyPrint);
                                    }

                                    public RetrieveInstance setQuotaUser(String quotaUser) {
                                        return (RetrieveInstance)super.setQuotaUser(quotaUser);
                                    }

                                    public RetrieveInstance setUploadType(String uploadType) {
                                        return (RetrieveInstance)super.setUploadType(uploadType);
                                    }

                                    public RetrieveInstance setUploadProtocol(String uploadProtocol) {
                                        return (RetrieveInstance)super.setUploadProtocol(uploadProtocol);
                                    }

                                    public String getParent() {
                                        return this.parent;
                                    }

                                    public RetrieveInstance setParent(String parent) {
                                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                        }
                                        this.parent = parent;
                                        return this;
                                    }

                                    public String getDicomWebPath() {
                                        return this.dicomWebPath;
                                    }

                                    public RetrieveInstance setDicomWebPath(String dicomWebPath) {
                                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                            Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+/instances/[^/]+$");
                                        }
                                        this.dicomWebPath = dicomWebPath;
                                        return this;
                                    }

                                    @Override
                                    public RetrieveInstance set(String parameterName, Object value) {
                                        return (RetrieveInstance)super.set(parameterName, value);
                                    }
                                }

                                public class Delete
                                extends CloudHealthcareRequest<Empty> {
                                    private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                                    private final Pattern PARENT_PATTERN;
                                    private final Pattern DICOM_WEB_PATH_PATTERN;
                                    @Key
                                    private String parent;
                                    @Key
                                    private String dicomWebPath;

                                    protected Delete(String parent, String dicomWebPath) {
                                        super(CloudHealthcare.this, "DELETE", REST_PATH, null, Empty.class);
                                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                        this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^studies/[^/]+/series/[^/]+/instances/[^/]+$");
                                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                        }
                                        this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                            Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+/instances/[^/]+$");
                                        }
                                    }

                                    public Delete set$Xgafv(String $Xgafv) {
                                        return (Delete)super.set$Xgafv($Xgafv);
                                    }

                                    public Delete setAccessToken(String accessToken) {
                                        return (Delete)super.setAccessToken(accessToken);
                                    }

                                    public Delete setAlt(String alt) {
                                        return (Delete)super.setAlt(alt);
                                    }

                                    public Delete setCallback(String callback) {
                                        return (Delete)super.setCallback(callback);
                                    }

                                    public Delete setFields(String fields) {
                                        return (Delete)super.setFields(fields);
                                    }

                                    public Delete setKey(String key) {
                                        return (Delete)super.setKey(key);
                                    }

                                    public Delete setOauthToken(String oauthToken) {
                                        return (Delete)super.setOauthToken(oauthToken);
                                    }

                                    public Delete setPrettyPrint(Boolean prettyPrint) {
                                        return (Delete)super.setPrettyPrint(prettyPrint);
                                    }

                                    public Delete setQuotaUser(String quotaUser) {
                                        return (Delete)super.setQuotaUser(quotaUser);
                                    }

                                    public Delete setUploadType(String uploadType) {
                                        return (Delete)super.setUploadType(uploadType);
                                    }

                                    public Delete setUploadProtocol(String uploadProtocol) {
                                        return (Delete)super.setUploadProtocol(uploadProtocol);
                                    }

                                    public String getParent() {
                                        return this.parent;
                                    }

                                    public Delete setParent(String parent) {
                                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                        }
                                        this.parent = parent;
                                        return this;
                                    }

                                    public String getDicomWebPath() {
                                        return this.dicomWebPath;
                                    }

                                    public Delete setDicomWebPath(String dicomWebPath) {
                                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                            Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+/instances/[^/]+$");
                                        }
                                        this.dicomWebPath = dicomWebPath;
                                        return this;
                                    }

                                    @Override
                                    public Delete set(String parameterName, Object value) {
                                        return (Delete)super.set(parameterName, value);
                                    }
                                }
                            }

                            public class SearchForInstances
                            extends CloudHealthcareRequest<HttpBody> {
                                private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                                private final Pattern PARENT_PATTERN;
                                private final Pattern DICOM_WEB_PATH_PATTERN;
                                @Key
                                private String parent;
                                @Key
                                private String dicomWebPath;

                                protected SearchForInstances(String parent, String dicomWebPath) {
                                    super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                    this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^studies/[^/]+/series/[^/]+/instances$");
                                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                    }
                                    this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+/instances$");
                                    }
                                }

                                public HttpResponse executeUsingHead() throws IOException {
                                    return super.executeUsingHead();
                                }

                                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                    return super.buildHttpRequestUsingHead();
                                }

                                public SearchForInstances set$Xgafv(String $Xgafv) {
                                    return (SearchForInstances)super.set$Xgafv($Xgafv);
                                }

                                public SearchForInstances setAccessToken(String accessToken) {
                                    return (SearchForInstances)super.setAccessToken(accessToken);
                                }

                                public SearchForInstances setAlt(String alt) {
                                    return (SearchForInstances)super.setAlt(alt);
                                }

                                public SearchForInstances setCallback(String callback) {
                                    return (SearchForInstances)super.setCallback(callback);
                                }

                                public SearchForInstances setFields(String fields) {
                                    return (SearchForInstances)super.setFields(fields);
                                }

                                public SearchForInstances setKey(String key) {
                                    return (SearchForInstances)super.setKey(key);
                                }

                                public SearchForInstances setOauthToken(String oauthToken) {
                                    return (SearchForInstances)super.setOauthToken(oauthToken);
                                }

                                public SearchForInstances setPrettyPrint(Boolean prettyPrint) {
                                    return (SearchForInstances)super.setPrettyPrint(prettyPrint);
                                }

                                public SearchForInstances setQuotaUser(String quotaUser) {
                                    return (SearchForInstances)super.setQuotaUser(quotaUser);
                                }

                                public SearchForInstances setUploadType(String uploadType) {
                                    return (SearchForInstances)super.setUploadType(uploadType);
                                }

                                public SearchForInstances setUploadProtocol(String uploadProtocol) {
                                    return (SearchForInstances)super.setUploadProtocol(uploadProtocol);
                                }

                                public String getParent() {
                                    return this.parent;
                                }

                                public SearchForInstances setParent(String parent) {
                                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                    }
                                    this.parent = parent;
                                    return this;
                                }

                                public String getDicomWebPath() {
                                    return this.dicomWebPath;
                                }

                                public SearchForInstances setDicomWebPath(String dicomWebPath) {
                                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+/instances$");
                                    }
                                    this.dicomWebPath = dicomWebPath;
                                    return this;
                                }

                                @Override
                                public SearchForInstances set(String parameterName, Object value) {
                                    return (SearchForInstances)super.set(parameterName, value);
                                }
                            }

                            public class RetrieveSeries
                            extends CloudHealthcareRequest<HttpBody> {
                                private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                                private final Pattern PARENT_PATTERN;
                                private final Pattern DICOM_WEB_PATH_PATTERN;
                                @Key
                                private String parent;
                                @Key
                                private String dicomWebPath;

                                protected RetrieveSeries(String parent, String dicomWebPath) {
                                    super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                    this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^studies/[^/]+/series/[^/]+$");
                                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                    }
                                    this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+$");
                                    }
                                }

                                public HttpResponse executeUsingHead() throws IOException {
                                    return super.executeUsingHead();
                                }

                                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                    return super.buildHttpRequestUsingHead();
                                }

                                public RetrieveSeries set$Xgafv(String $Xgafv) {
                                    return (RetrieveSeries)super.set$Xgafv($Xgafv);
                                }

                                public RetrieveSeries setAccessToken(String accessToken) {
                                    return (RetrieveSeries)super.setAccessToken(accessToken);
                                }

                                public RetrieveSeries setAlt(String alt) {
                                    return (RetrieveSeries)super.setAlt(alt);
                                }

                                public RetrieveSeries setCallback(String callback) {
                                    return (RetrieveSeries)super.setCallback(callback);
                                }

                                public RetrieveSeries setFields(String fields) {
                                    return (RetrieveSeries)super.setFields(fields);
                                }

                                public RetrieveSeries setKey(String key) {
                                    return (RetrieveSeries)super.setKey(key);
                                }

                                public RetrieveSeries setOauthToken(String oauthToken) {
                                    return (RetrieveSeries)super.setOauthToken(oauthToken);
                                }

                                public RetrieveSeries setPrettyPrint(Boolean prettyPrint) {
                                    return (RetrieveSeries)super.setPrettyPrint(prettyPrint);
                                }

                                public RetrieveSeries setQuotaUser(String quotaUser) {
                                    return (RetrieveSeries)super.setQuotaUser(quotaUser);
                                }

                                public RetrieveSeries setUploadType(String uploadType) {
                                    return (RetrieveSeries)super.setUploadType(uploadType);
                                }

                                public RetrieveSeries setUploadProtocol(String uploadProtocol) {
                                    return (RetrieveSeries)super.setUploadProtocol(uploadProtocol);
                                }

                                public String getParent() {
                                    return this.parent;
                                }

                                public RetrieveSeries setParent(String parent) {
                                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                    }
                                    this.parent = parent;
                                    return this;
                                }

                                public String getDicomWebPath() {
                                    return this.dicomWebPath;
                                }

                                public RetrieveSeries setDicomWebPath(String dicomWebPath) {
                                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+$");
                                    }
                                    this.dicomWebPath = dicomWebPath;
                                    return this;
                                }

                                @Override
                                public RetrieveSeries set(String parameterName, Object value) {
                                    return (RetrieveSeries)super.set(parameterName, value);
                                }
                            }

                            public class RetrieveMetadata
                            extends CloudHealthcareRequest<HttpBody> {
                                private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                                private final Pattern PARENT_PATTERN;
                                private final Pattern DICOM_WEB_PATH_PATTERN;
                                @Key
                                private String parent;
                                @Key
                                private String dicomWebPath;

                                protected RetrieveMetadata(String parent, String dicomWebPath) {
                                    super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                    this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^studies/[^/]+/series/[^/]+/metadata$");
                                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                    }
                                    this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+/metadata$");
                                    }
                                }

                                public HttpResponse executeUsingHead() throws IOException {
                                    return super.executeUsingHead();
                                }

                                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                    return super.buildHttpRequestUsingHead();
                                }

                                public RetrieveMetadata set$Xgafv(String $Xgafv) {
                                    return (RetrieveMetadata)super.set$Xgafv($Xgafv);
                                }

                                public RetrieveMetadata setAccessToken(String accessToken) {
                                    return (RetrieveMetadata)super.setAccessToken(accessToken);
                                }

                                public RetrieveMetadata setAlt(String alt) {
                                    return (RetrieveMetadata)super.setAlt(alt);
                                }

                                public RetrieveMetadata setCallback(String callback) {
                                    return (RetrieveMetadata)super.setCallback(callback);
                                }

                                public RetrieveMetadata setFields(String fields) {
                                    return (RetrieveMetadata)super.setFields(fields);
                                }

                                public RetrieveMetadata setKey(String key) {
                                    return (RetrieveMetadata)super.setKey(key);
                                }

                                public RetrieveMetadata setOauthToken(String oauthToken) {
                                    return (RetrieveMetadata)super.setOauthToken(oauthToken);
                                }

                                public RetrieveMetadata setPrettyPrint(Boolean prettyPrint) {
                                    return (RetrieveMetadata)super.setPrettyPrint(prettyPrint);
                                }

                                public RetrieveMetadata setQuotaUser(String quotaUser) {
                                    return (RetrieveMetadata)super.setQuotaUser(quotaUser);
                                }

                                public RetrieveMetadata setUploadType(String uploadType) {
                                    return (RetrieveMetadata)super.setUploadType(uploadType);
                                }

                                public RetrieveMetadata setUploadProtocol(String uploadProtocol) {
                                    return (RetrieveMetadata)super.setUploadProtocol(uploadProtocol);
                                }

                                public String getParent() {
                                    return this.parent;
                                }

                                public RetrieveMetadata setParent(String parent) {
                                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                    }
                                    this.parent = parent;
                                    return this;
                                }

                                public String getDicomWebPath() {
                                    return this.dicomWebPath;
                                }

                                public RetrieveMetadata setDicomWebPath(String dicomWebPath) {
                                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+/metadata$");
                                    }
                                    this.dicomWebPath = dicomWebPath;
                                    return this;
                                }

                                @Override
                                public RetrieveMetadata set(String parameterName, Object value) {
                                    return (RetrieveMetadata)super.set(parameterName, value);
                                }
                            }

                            public class Delete
                            extends CloudHealthcareRequest<Empty> {
                                private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                                private final Pattern PARENT_PATTERN;
                                private final Pattern DICOM_WEB_PATH_PATTERN;
                                @Key
                                private String parent;
                                @Key
                                private String dicomWebPath;

                                protected Delete(String parent, String dicomWebPath) {
                                    super(CloudHealthcare.this, "DELETE", REST_PATH, null, Empty.class);
                                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                    this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^studies/[^/]+/series/[^/]+$");
                                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                    }
                                    this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+$");
                                    }
                                }

                                public Delete set$Xgafv(String $Xgafv) {
                                    return (Delete)super.set$Xgafv($Xgafv);
                                }

                                public Delete setAccessToken(String accessToken) {
                                    return (Delete)super.setAccessToken(accessToken);
                                }

                                public Delete setAlt(String alt) {
                                    return (Delete)super.setAlt(alt);
                                }

                                public Delete setCallback(String callback) {
                                    return (Delete)super.setCallback(callback);
                                }

                                public Delete setFields(String fields) {
                                    return (Delete)super.setFields(fields);
                                }

                                public Delete setKey(String key) {
                                    return (Delete)super.setKey(key);
                                }

                                public Delete setOauthToken(String oauthToken) {
                                    return (Delete)super.setOauthToken(oauthToken);
                                }

                                public Delete setPrettyPrint(Boolean prettyPrint) {
                                    return (Delete)super.setPrettyPrint(prettyPrint);
                                }

                                public Delete setQuotaUser(String quotaUser) {
                                    return (Delete)super.setQuotaUser(quotaUser);
                                }

                                public Delete setUploadType(String uploadType) {
                                    return (Delete)super.setUploadType(uploadType);
                                }

                                public Delete setUploadProtocol(String uploadProtocol) {
                                    return (Delete)super.setUploadProtocol(uploadProtocol);
                                }

                                public String getParent() {
                                    return this.parent;
                                }

                                public Delete setParent(String parent) {
                                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                    }
                                    this.parent = parent;
                                    return this;
                                }

                                public String getDicomWebPath() {
                                    return this.dicomWebPath;
                                }

                                public Delete setDicomWebPath(String dicomWebPath) {
                                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                        Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series/[^/]+$");
                                    }
                                    this.dicomWebPath = dicomWebPath;
                                    return this;
                                }

                                @Override
                                public Delete set(String parameterName, Object value) {
                                    return (Delete)super.set(parameterName, value);
                                }
                            }
                        }

                        public class StoreInstances
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                            private final Pattern PARENT_PATTERN;
                            private final Pattern DICOM_WEB_PATH_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private String dicomWebPath;

                            protected StoreInstances(String parent, String dicomWebPath, HttpBody content) {
                                super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, HttpBody.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^studies/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                }
                                this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+$");
                                }
                            }

                            public StoreInstances set$Xgafv(String $Xgafv) {
                                return (StoreInstances)super.set$Xgafv($Xgafv);
                            }

                            public StoreInstances setAccessToken(String accessToken) {
                                return (StoreInstances)super.setAccessToken(accessToken);
                            }

                            public StoreInstances setAlt(String alt) {
                                return (StoreInstances)super.setAlt(alt);
                            }

                            public StoreInstances setCallback(String callback) {
                                return (StoreInstances)super.setCallback(callback);
                            }

                            public StoreInstances setFields(String fields) {
                                return (StoreInstances)super.setFields(fields);
                            }

                            public StoreInstances setKey(String key) {
                                return (StoreInstances)super.setKey(key);
                            }

                            public StoreInstances setOauthToken(String oauthToken) {
                                return (StoreInstances)super.setOauthToken(oauthToken);
                            }

                            public StoreInstances setPrettyPrint(Boolean prettyPrint) {
                                return (StoreInstances)super.setPrettyPrint(prettyPrint);
                            }

                            public StoreInstances setQuotaUser(String quotaUser) {
                                return (StoreInstances)super.setQuotaUser(quotaUser);
                            }

                            public StoreInstances setUploadType(String uploadType) {
                                return (StoreInstances)super.setUploadType(uploadType);
                            }

                            public StoreInstances setUploadProtocol(String uploadProtocol) {
                                return (StoreInstances)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public StoreInstances setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public String getDicomWebPath() {
                                return this.dicomWebPath;
                            }

                            public StoreInstances setDicomWebPath(String dicomWebPath) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+$");
                                }
                                this.dicomWebPath = dicomWebPath;
                                return this;
                            }

                            @Override
                            public StoreInstances set(String parameterName, Object value) {
                                return (StoreInstances)super.set(parameterName, value);
                            }
                        }

                        public class SearchForSeries
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                            private final Pattern PARENT_PATTERN;
                            private final Pattern DICOM_WEB_PATH_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private String dicomWebPath;

                            protected SearchForSeries(String parent, String dicomWebPath) {
                                super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^studies/[^/]+/series$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                }
                                this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public SearchForSeries set$Xgafv(String $Xgafv) {
                                return (SearchForSeries)super.set$Xgafv($Xgafv);
                            }

                            public SearchForSeries setAccessToken(String accessToken) {
                                return (SearchForSeries)super.setAccessToken(accessToken);
                            }

                            public SearchForSeries setAlt(String alt) {
                                return (SearchForSeries)super.setAlt(alt);
                            }

                            public SearchForSeries setCallback(String callback) {
                                return (SearchForSeries)super.setCallback(callback);
                            }

                            public SearchForSeries setFields(String fields) {
                                return (SearchForSeries)super.setFields(fields);
                            }

                            public SearchForSeries setKey(String key) {
                                return (SearchForSeries)super.setKey(key);
                            }

                            public SearchForSeries setOauthToken(String oauthToken) {
                                return (SearchForSeries)super.setOauthToken(oauthToken);
                            }

                            public SearchForSeries setPrettyPrint(Boolean prettyPrint) {
                                return (SearchForSeries)super.setPrettyPrint(prettyPrint);
                            }

                            public SearchForSeries setQuotaUser(String quotaUser) {
                                return (SearchForSeries)super.setQuotaUser(quotaUser);
                            }

                            public SearchForSeries setUploadType(String uploadType) {
                                return (SearchForSeries)super.setUploadType(uploadType);
                            }

                            public SearchForSeries setUploadProtocol(String uploadProtocol) {
                                return (SearchForSeries)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public SearchForSeries setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public String getDicomWebPath() {
                                return this.dicomWebPath;
                            }

                            public SearchForSeries setDicomWebPath(String dicomWebPath) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/series$");
                                }
                                this.dicomWebPath = dicomWebPath;
                                return this;
                            }

                            @Override
                            public SearchForSeries set(String parameterName, Object value) {
                                return (SearchForSeries)super.set(parameterName, value);
                            }
                        }

                        public class SearchForInstances
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                            private final Pattern PARENT_PATTERN;
                            private final Pattern DICOM_WEB_PATH_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private String dicomWebPath;

                            protected SearchForInstances(String parent, String dicomWebPath) {
                                super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^studies/[^/]+/instances$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                }
                                this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/instances$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public SearchForInstances set$Xgafv(String $Xgafv) {
                                return (SearchForInstances)super.set$Xgafv($Xgafv);
                            }

                            public SearchForInstances setAccessToken(String accessToken) {
                                return (SearchForInstances)super.setAccessToken(accessToken);
                            }

                            public SearchForInstances setAlt(String alt) {
                                return (SearchForInstances)super.setAlt(alt);
                            }

                            public SearchForInstances setCallback(String callback) {
                                return (SearchForInstances)super.setCallback(callback);
                            }

                            public SearchForInstances setFields(String fields) {
                                return (SearchForInstances)super.setFields(fields);
                            }

                            public SearchForInstances setKey(String key) {
                                return (SearchForInstances)super.setKey(key);
                            }

                            public SearchForInstances setOauthToken(String oauthToken) {
                                return (SearchForInstances)super.setOauthToken(oauthToken);
                            }

                            public SearchForInstances setPrettyPrint(Boolean prettyPrint) {
                                return (SearchForInstances)super.setPrettyPrint(prettyPrint);
                            }

                            public SearchForInstances setQuotaUser(String quotaUser) {
                                return (SearchForInstances)super.setQuotaUser(quotaUser);
                            }

                            public SearchForInstances setUploadType(String uploadType) {
                                return (SearchForInstances)super.setUploadType(uploadType);
                            }

                            public SearchForInstances setUploadProtocol(String uploadProtocol) {
                                return (SearchForInstances)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public SearchForInstances setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public String getDicomWebPath() {
                                return this.dicomWebPath;
                            }

                            public SearchForInstances setDicomWebPath(String dicomWebPath) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/instances$");
                                }
                                this.dicomWebPath = dicomWebPath;
                                return this;
                            }

                            @Override
                            public SearchForInstances set(String parameterName, Object value) {
                                return (SearchForInstances)super.set(parameterName, value);
                            }
                        }

                        public class RetrieveStudy
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                            private final Pattern PARENT_PATTERN;
                            private final Pattern DICOM_WEB_PATH_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private String dicomWebPath;

                            protected RetrieveStudy(String parent, String dicomWebPath) {
                                super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^studies/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                }
                                this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public RetrieveStudy set$Xgafv(String $Xgafv) {
                                return (RetrieveStudy)super.set$Xgafv($Xgafv);
                            }

                            public RetrieveStudy setAccessToken(String accessToken) {
                                return (RetrieveStudy)super.setAccessToken(accessToken);
                            }

                            public RetrieveStudy setAlt(String alt) {
                                return (RetrieveStudy)super.setAlt(alt);
                            }

                            public RetrieveStudy setCallback(String callback) {
                                return (RetrieveStudy)super.setCallback(callback);
                            }

                            public RetrieveStudy setFields(String fields) {
                                return (RetrieveStudy)super.setFields(fields);
                            }

                            public RetrieveStudy setKey(String key) {
                                return (RetrieveStudy)super.setKey(key);
                            }

                            public RetrieveStudy setOauthToken(String oauthToken) {
                                return (RetrieveStudy)super.setOauthToken(oauthToken);
                            }

                            public RetrieveStudy setPrettyPrint(Boolean prettyPrint) {
                                return (RetrieveStudy)super.setPrettyPrint(prettyPrint);
                            }

                            public RetrieveStudy setQuotaUser(String quotaUser) {
                                return (RetrieveStudy)super.setQuotaUser(quotaUser);
                            }

                            public RetrieveStudy setUploadType(String uploadType) {
                                return (RetrieveStudy)super.setUploadType(uploadType);
                            }

                            public RetrieveStudy setUploadProtocol(String uploadProtocol) {
                                return (RetrieveStudy)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public RetrieveStudy setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public String getDicomWebPath() {
                                return this.dicomWebPath;
                            }

                            public RetrieveStudy setDicomWebPath(String dicomWebPath) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+$");
                                }
                                this.dicomWebPath = dicomWebPath;
                                return this;
                            }

                            @Override
                            public RetrieveStudy set(String parameterName, Object value) {
                                return (RetrieveStudy)super.set(parameterName, value);
                            }
                        }

                        public class RetrieveMetadata
                        extends CloudHealthcareRequest<HttpBody> {
                            private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                            private final Pattern PARENT_PATTERN;
                            private final Pattern DICOM_WEB_PATH_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private String dicomWebPath;

                            protected RetrieveMetadata(String parent, String dicomWebPath) {
                                super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^studies/[^/]+/metadata$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                }
                                this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/metadata$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public RetrieveMetadata set$Xgafv(String $Xgafv) {
                                return (RetrieveMetadata)super.set$Xgafv($Xgafv);
                            }

                            public RetrieveMetadata setAccessToken(String accessToken) {
                                return (RetrieveMetadata)super.setAccessToken(accessToken);
                            }

                            public RetrieveMetadata setAlt(String alt) {
                                return (RetrieveMetadata)super.setAlt(alt);
                            }

                            public RetrieveMetadata setCallback(String callback) {
                                return (RetrieveMetadata)super.setCallback(callback);
                            }

                            public RetrieveMetadata setFields(String fields) {
                                return (RetrieveMetadata)super.setFields(fields);
                            }

                            public RetrieveMetadata setKey(String key) {
                                return (RetrieveMetadata)super.setKey(key);
                            }

                            public RetrieveMetadata setOauthToken(String oauthToken) {
                                return (RetrieveMetadata)super.setOauthToken(oauthToken);
                            }

                            public RetrieveMetadata setPrettyPrint(Boolean prettyPrint) {
                                return (RetrieveMetadata)super.setPrettyPrint(prettyPrint);
                            }

                            public RetrieveMetadata setQuotaUser(String quotaUser) {
                                return (RetrieveMetadata)super.setQuotaUser(quotaUser);
                            }

                            public RetrieveMetadata setUploadType(String uploadType) {
                                return (RetrieveMetadata)super.setUploadType(uploadType);
                            }

                            public RetrieveMetadata setUploadProtocol(String uploadProtocol) {
                                return (RetrieveMetadata)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public RetrieveMetadata setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public String getDicomWebPath() {
                                return this.dicomWebPath;
                            }

                            public RetrieveMetadata setDicomWebPath(String dicomWebPath) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+/metadata$");
                                }
                                this.dicomWebPath = dicomWebPath;
                                return this;
                            }

                            @Override
                            public RetrieveMetadata set(String parameterName, Object value) {
                                return (RetrieveMetadata)super.set(parameterName, value);
                            }
                        }

                        public class Delete
                        extends CloudHealthcareRequest<Empty> {
                            private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                            private final Pattern PARENT_PATTERN;
                            private final Pattern DICOM_WEB_PATH_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private String dicomWebPath;

                            protected Delete(String parent, String dicomWebPath) {
                                super(CloudHealthcare.this, "DELETE", REST_PATH, null, Empty.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^studies/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                }
                                this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+$");
                                }
                            }

                            public Delete set$Xgafv(String $Xgafv) {
                                return (Delete)super.set$Xgafv($Xgafv);
                            }

                            public Delete setAccessToken(String accessToken) {
                                return (Delete)super.setAccessToken(accessToken);
                            }

                            public Delete setAlt(String alt) {
                                return (Delete)super.setAlt(alt);
                            }

                            public Delete setCallback(String callback) {
                                return (Delete)super.setCallback(callback);
                            }

                            public Delete setFields(String fields) {
                                return (Delete)super.setFields(fields);
                            }

                            public Delete setKey(String key) {
                                return (Delete)super.setKey(key);
                            }

                            public Delete setOauthToken(String oauthToken) {
                                return (Delete)super.setOauthToken(oauthToken);
                            }

                            public Delete setPrettyPrint(Boolean prettyPrint) {
                                return (Delete)super.setPrettyPrint(prettyPrint);
                            }

                            public Delete setQuotaUser(String quotaUser) {
                                return (Delete)super.setQuotaUser(quotaUser);
                            }

                            public Delete setUploadType(String uploadType) {
                                return (Delete)super.setUploadType(uploadType);
                            }

                            public Delete setUploadProtocol(String uploadProtocol) {
                                return (Delete)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public Delete setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public String getDicomWebPath() {
                                return this.dicomWebPath;
                            }

                            public Delete setDicomWebPath(String dicomWebPath) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies/[^/]+$");
                                }
                                this.dicomWebPath = dicomWebPath;
                                return this;
                            }

                            @Override
                            public Delete set(String parameterName, Object value) {
                                return (Delete)super.set(parameterName, value);
                            }
                        }
                    }

                    public class TestIamPermissions
                    extends CloudHealthcareRequest<TestIamPermissionsResponse> {
                        private static final String REST_PATH = "v1beta1/{+resource}:testIamPermissions";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;

                        protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                        }

                        public TestIamPermissions set$Xgafv(String $Xgafv) {
                            return (TestIamPermissions)super.set$Xgafv($Xgafv);
                        }

                        public TestIamPermissions setAccessToken(String accessToken) {
                            return (TestIamPermissions)super.setAccessToken(accessToken);
                        }

                        public TestIamPermissions setAlt(String alt) {
                            return (TestIamPermissions)super.setAlt(alt);
                        }

                        public TestIamPermissions setCallback(String callback) {
                            return (TestIamPermissions)super.setCallback(callback);
                        }

                        public TestIamPermissions setFields(String fields) {
                            return (TestIamPermissions)super.setFields(fields);
                        }

                        public TestIamPermissions setKey(String key) {
                            return (TestIamPermissions)super.setKey(key);
                        }

                        public TestIamPermissions setOauthToken(String oauthToken) {
                            return (TestIamPermissions)super.setOauthToken(oauthToken);
                        }

                        public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                            return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                        }

                        public TestIamPermissions setQuotaUser(String quotaUser) {
                            return (TestIamPermissions)super.setQuotaUser(quotaUser);
                        }

                        public TestIamPermissions setUploadType(String uploadType) {
                            return (TestIamPermissions)super.setUploadType(uploadType);
                        }

                        public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                            return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public TestIamPermissions setResource(String resource) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        @Override
                        public TestIamPermissions set(String parameterName, Object value) {
                            return (TestIamPermissions)super.set(parameterName, value);
                        }
                    }

                    public class StoreInstances
                    extends CloudHealthcareRequest<HttpBody> {
                        private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                        private final Pattern PARENT_PATTERN;
                        private final Pattern DICOM_WEB_PATH_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String dicomWebPath;

                        protected StoreInstances(String parent, String dicomWebPath, HttpBody content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, HttpBody.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^studies$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                            this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies$");
                            }
                        }

                        public StoreInstances set$Xgafv(String $Xgafv) {
                            return (StoreInstances)super.set$Xgafv($Xgafv);
                        }

                        public StoreInstances setAccessToken(String accessToken) {
                            return (StoreInstances)super.setAccessToken(accessToken);
                        }

                        public StoreInstances setAlt(String alt) {
                            return (StoreInstances)super.setAlt(alt);
                        }

                        public StoreInstances setCallback(String callback) {
                            return (StoreInstances)super.setCallback(callback);
                        }

                        public StoreInstances setFields(String fields) {
                            return (StoreInstances)super.setFields(fields);
                        }

                        public StoreInstances setKey(String key) {
                            return (StoreInstances)super.setKey(key);
                        }

                        public StoreInstances setOauthToken(String oauthToken) {
                            return (StoreInstances)super.setOauthToken(oauthToken);
                        }

                        public StoreInstances setPrettyPrint(Boolean prettyPrint) {
                            return (StoreInstances)super.setPrettyPrint(prettyPrint);
                        }

                        public StoreInstances setQuotaUser(String quotaUser) {
                            return (StoreInstances)super.setQuotaUser(quotaUser);
                        }

                        public StoreInstances setUploadType(String uploadType) {
                            return (StoreInstances)super.setUploadType(uploadType);
                        }

                        public StoreInstances setUploadProtocol(String uploadProtocol) {
                            return (StoreInstances)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public StoreInstances setParent(String parent) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getDicomWebPath() {
                            return this.dicomWebPath;
                        }

                        public StoreInstances setDicomWebPath(String dicomWebPath) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies$");
                            }
                            this.dicomWebPath = dicomWebPath;
                            return this;
                        }

                        @Override
                        public StoreInstances set(String parameterName, Object value) {
                            return (StoreInstances)super.set(parameterName, value);
                        }
                    }

                    public class SetIamPolicy
                    extends CloudHealthcareRequest<Policy> {
                        private static final String REST_PATH = "v1beta1/{+resource}:setIamPolicy";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;

                        protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Policy.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                        }

                        public SetIamPolicy set$Xgafv(String $Xgafv) {
                            return (SetIamPolicy)super.set$Xgafv($Xgafv);
                        }

                        public SetIamPolicy setAccessToken(String accessToken) {
                            return (SetIamPolicy)super.setAccessToken(accessToken);
                        }

                        public SetIamPolicy setAlt(String alt) {
                            return (SetIamPolicy)super.setAlt(alt);
                        }

                        public SetIamPolicy setCallback(String callback) {
                            return (SetIamPolicy)super.setCallback(callback);
                        }

                        public SetIamPolicy setFields(String fields) {
                            return (SetIamPolicy)super.setFields(fields);
                        }

                        public SetIamPolicy setKey(String key) {
                            return (SetIamPolicy)super.setKey(key);
                        }

                        public SetIamPolicy setOauthToken(String oauthToken) {
                            return (SetIamPolicy)super.setOauthToken(oauthToken);
                        }

                        public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                            return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                        }

                        public SetIamPolicy setQuotaUser(String quotaUser) {
                            return (SetIamPolicy)super.setQuotaUser(quotaUser);
                        }

                        public SetIamPolicy setUploadType(String uploadType) {
                            return (SetIamPolicy)super.setUploadType(uploadType);
                        }

                        public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                            return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public SetIamPolicy setResource(String resource) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        @Override
                        public SetIamPolicy set(String parameterName, Object value) {
                            return (SetIamPolicy)super.set(parameterName, value);
                        }
                    }

                    public class SearchForStudies
                    extends CloudHealthcareRequest<HttpBody> {
                        private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                        private final Pattern PARENT_PATTERN;
                        private final Pattern DICOM_WEB_PATH_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String dicomWebPath;

                        protected SearchForStudies(String parent, String dicomWebPath) {
                            super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^studies$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                            this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public SearchForStudies set$Xgafv(String $Xgafv) {
                            return (SearchForStudies)super.set$Xgafv($Xgafv);
                        }

                        public SearchForStudies setAccessToken(String accessToken) {
                            return (SearchForStudies)super.setAccessToken(accessToken);
                        }

                        public SearchForStudies setAlt(String alt) {
                            return (SearchForStudies)super.setAlt(alt);
                        }

                        public SearchForStudies setCallback(String callback) {
                            return (SearchForStudies)super.setCallback(callback);
                        }

                        public SearchForStudies setFields(String fields) {
                            return (SearchForStudies)super.setFields(fields);
                        }

                        public SearchForStudies setKey(String key) {
                            return (SearchForStudies)super.setKey(key);
                        }

                        public SearchForStudies setOauthToken(String oauthToken) {
                            return (SearchForStudies)super.setOauthToken(oauthToken);
                        }

                        public SearchForStudies setPrettyPrint(Boolean prettyPrint) {
                            return (SearchForStudies)super.setPrettyPrint(prettyPrint);
                        }

                        public SearchForStudies setQuotaUser(String quotaUser) {
                            return (SearchForStudies)super.setQuotaUser(quotaUser);
                        }

                        public SearchForStudies setUploadType(String uploadType) {
                            return (SearchForStudies)super.setUploadType(uploadType);
                        }

                        public SearchForStudies setUploadProtocol(String uploadProtocol) {
                            return (SearchForStudies)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public SearchForStudies setParent(String parent) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getDicomWebPath() {
                            return this.dicomWebPath;
                        }

                        public SearchForStudies setDicomWebPath(String dicomWebPath) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^studies$");
                            }
                            this.dicomWebPath = dicomWebPath;
                            return this;
                        }

                        @Override
                        public SearchForStudies set(String parameterName, Object value) {
                            return (SearchForStudies)super.set(parameterName, value);
                        }
                    }

                    public class SearchForSeries
                    extends CloudHealthcareRequest<HttpBody> {
                        private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                        private final Pattern PARENT_PATTERN;
                        private final Pattern DICOM_WEB_PATH_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String dicomWebPath;

                        protected SearchForSeries(String parent, String dicomWebPath) {
                            super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^series$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                            this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^series$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public SearchForSeries set$Xgafv(String $Xgafv) {
                            return (SearchForSeries)super.set$Xgafv($Xgafv);
                        }

                        public SearchForSeries setAccessToken(String accessToken) {
                            return (SearchForSeries)super.setAccessToken(accessToken);
                        }

                        public SearchForSeries setAlt(String alt) {
                            return (SearchForSeries)super.setAlt(alt);
                        }

                        public SearchForSeries setCallback(String callback) {
                            return (SearchForSeries)super.setCallback(callback);
                        }

                        public SearchForSeries setFields(String fields) {
                            return (SearchForSeries)super.setFields(fields);
                        }

                        public SearchForSeries setKey(String key) {
                            return (SearchForSeries)super.setKey(key);
                        }

                        public SearchForSeries setOauthToken(String oauthToken) {
                            return (SearchForSeries)super.setOauthToken(oauthToken);
                        }

                        public SearchForSeries setPrettyPrint(Boolean prettyPrint) {
                            return (SearchForSeries)super.setPrettyPrint(prettyPrint);
                        }

                        public SearchForSeries setQuotaUser(String quotaUser) {
                            return (SearchForSeries)super.setQuotaUser(quotaUser);
                        }

                        public SearchForSeries setUploadType(String uploadType) {
                            return (SearchForSeries)super.setUploadType(uploadType);
                        }

                        public SearchForSeries setUploadProtocol(String uploadProtocol) {
                            return (SearchForSeries)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public SearchForSeries setParent(String parent) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getDicomWebPath() {
                            return this.dicomWebPath;
                        }

                        public SearchForSeries setDicomWebPath(String dicomWebPath) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^series$");
                            }
                            this.dicomWebPath = dicomWebPath;
                            return this;
                        }

                        @Override
                        public SearchForSeries set(String parameterName, Object value) {
                            return (SearchForSeries)super.set(parameterName, value);
                        }
                    }

                    public class SearchForInstances
                    extends CloudHealthcareRequest<HttpBody> {
                        private static final String REST_PATH = "v1beta1/{+parent}/dicomWeb/{+dicomWebPath}";
                        private final Pattern PARENT_PATTERN;
                        private final Pattern DICOM_WEB_PATH_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String dicomWebPath;

                        protected SearchForInstances(String parent, String dicomWebPath) {
                            super(CloudHealthcare.this, "GET", REST_PATH, null, HttpBody.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            this.DICOM_WEB_PATH_PATTERN = Pattern.compile("^instances$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                            this.dicomWebPath = (String)Preconditions.checkNotNull((Object)dicomWebPath, (Object)"Required parameter dicomWebPath must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^instances$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public SearchForInstances set$Xgafv(String $Xgafv) {
                            return (SearchForInstances)super.set$Xgafv($Xgafv);
                        }

                        public SearchForInstances setAccessToken(String accessToken) {
                            return (SearchForInstances)super.setAccessToken(accessToken);
                        }

                        public SearchForInstances setAlt(String alt) {
                            return (SearchForInstances)super.setAlt(alt);
                        }

                        public SearchForInstances setCallback(String callback) {
                            return (SearchForInstances)super.setCallback(callback);
                        }

                        public SearchForInstances setFields(String fields) {
                            return (SearchForInstances)super.setFields(fields);
                        }

                        public SearchForInstances setKey(String key) {
                            return (SearchForInstances)super.setKey(key);
                        }

                        public SearchForInstances setOauthToken(String oauthToken) {
                            return (SearchForInstances)super.setOauthToken(oauthToken);
                        }

                        public SearchForInstances setPrettyPrint(Boolean prettyPrint) {
                            return (SearchForInstances)super.setPrettyPrint(prettyPrint);
                        }

                        public SearchForInstances setQuotaUser(String quotaUser) {
                            return (SearchForInstances)super.setQuotaUser(quotaUser);
                        }

                        public SearchForInstances setUploadType(String uploadType) {
                            return (SearchForInstances)super.setUploadType(uploadType);
                        }

                        public SearchForInstances setUploadProtocol(String uploadProtocol) {
                            return (SearchForInstances)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public SearchForInstances setParent(String parent) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getDicomWebPath() {
                            return this.dicomWebPath;
                        }

                        public SearchForInstances setDicomWebPath(String dicomWebPath) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.DICOM_WEB_PATH_PATTERN.matcher(dicomWebPath).matches(), (Object)"Parameter dicomWebPath must conform to the pattern ^instances$");
                            }
                            this.dicomWebPath = dicomWebPath;
                            return this;
                        }

                        @Override
                        public SearchForInstances set(String parameterName, Object value) {
                            return (SearchForInstances)super.set(parameterName, value);
                        }
                    }

                    public class Patch
                    extends CloudHealthcareRequest<DicomStore> {
                        private static final String REST_PATH = "v1beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String updateMask;

                        protected Patch(String name, DicomStore content) {
                            super(CloudHealthcare.this, "PATCH", REST_PATH, (Object)content, DicomStore.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String $Xgafv) {
                            return (Patch)super.set$Xgafv($Xgafv);
                        }

                        public Patch setAccessToken(String accessToken) {
                            return (Patch)super.setAccessToken(accessToken);
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setCallback(String callback) {
                            return (Patch)super.setCallback(callback);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUploadType(String uploadType) {
                            return (Patch)super.setUploadType(uploadType);
                        }

                        public Patch setUploadProtocol(String uploadProtocol) {
                            return (Patch)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String updateMask) {
                            this.updateMask = updateMask;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends CloudHealthcareRequest<ListDicomStoresResponse> {
                        private static final String REST_PATH = "v1beta1/{+parent}/dicomStores";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String filter;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(CloudHealthcare.this, "GET", REST_PATH, null, ListDicomStoresResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class CloudHealthcareImport
                    extends CloudHealthcareRequest<Operation> {
                        private static final String REST_PATH = "v1beta1/{+name}:import";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected CloudHealthcareImport(String name, ImportDicomDataRequest content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                        }

                        public CloudHealthcareImport set$Xgafv(String $Xgafv) {
                            return (CloudHealthcareImport)super.set$Xgafv($Xgafv);
                        }

                        public CloudHealthcareImport setAccessToken(String accessToken) {
                            return (CloudHealthcareImport)super.setAccessToken(accessToken);
                        }

                        public CloudHealthcareImport setAlt(String alt) {
                            return (CloudHealthcareImport)super.setAlt(alt);
                        }

                        public CloudHealthcareImport setCallback(String callback) {
                            return (CloudHealthcareImport)super.setCallback(callback);
                        }

                        public CloudHealthcareImport setFields(String fields) {
                            return (CloudHealthcareImport)super.setFields(fields);
                        }

                        public CloudHealthcareImport setKey(String key) {
                            return (CloudHealthcareImport)super.setKey(key);
                        }

                        public CloudHealthcareImport setOauthToken(String oauthToken) {
                            return (CloudHealthcareImport)super.setOauthToken(oauthToken);
                        }

                        public CloudHealthcareImport setPrettyPrint(Boolean prettyPrint) {
                            return (CloudHealthcareImport)super.setPrettyPrint(prettyPrint);
                        }

                        public CloudHealthcareImport setQuotaUser(String quotaUser) {
                            return (CloudHealthcareImport)super.setQuotaUser(quotaUser);
                        }

                        public CloudHealthcareImport setUploadType(String uploadType) {
                            return (CloudHealthcareImport)super.setUploadType(uploadType);
                        }

                        public CloudHealthcareImport setUploadProtocol(String uploadProtocol) {
                            return (CloudHealthcareImport)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public CloudHealthcareImport setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public CloudHealthcareImport set(String parameterName, Object value) {
                            return (CloudHealthcareImport)super.set(parameterName, value);
                        }
                    }

                    public class GetIamPolicy
                    extends CloudHealthcareRequest<Policy> {
                        private static final String REST_PATH = "v1beta1/{+resource}:getIamPolicy";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;
                        @Key(value="options.requestedPolicyVersion")
                        private Integer optionsRequestedPolicyVersion;

                        protected GetIamPolicy(String resource) {
                            super(CloudHealthcare.this, "GET", REST_PATH, null, Policy.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public GetIamPolicy set$Xgafv(String $Xgafv) {
                            return (GetIamPolicy)super.set$Xgafv($Xgafv);
                        }

                        public GetIamPolicy setAccessToken(String accessToken) {
                            return (GetIamPolicy)super.setAccessToken(accessToken);
                        }

                        public GetIamPolicy setAlt(String alt) {
                            return (GetIamPolicy)super.setAlt(alt);
                        }

                        public GetIamPolicy setCallback(String callback) {
                            return (GetIamPolicy)super.setCallback(callback);
                        }

                        public GetIamPolicy setFields(String fields) {
                            return (GetIamPolicy)super.setFields(fields);
                        }

                        public GetIamPolicy setKey(String key) {
                            return (GetIamPolicy)super.setKey(key);
                        }

                        public GetIamPolicy setOauthToken(String oauthToken) {
                            return (GetIamPolicy)super.setOauthToken(oauthToken);
                        }

                        public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                            return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                        }

                        public GetIamPolicy setQuotaUser(String quotaUser) {
                            return (GetIamPolicy)super.setQuotaUser(quotaUser);
                        }

                        public GetIamPolicy setUploadType(String uploadType) {
                            return (GetIamPolicy)super.setUploadType(uploadType);
                        }

                        public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                            return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public GetIamPolicy setResource(String resource) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        public Integer getOptionsRequestedPolicyVersion() {
                            return this.optionsRequestedPolicyVersion;
                        }

                        public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                            this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                            return this;
                        }

                        @Override
                        public GetIamPolicy set(String parameterName, Object value) {
                            return (GetIamPolicy)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends CloudHealthcareRequest<DicomStore> {
                        private static final String REST_PATH = "v1beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(CloudHealthcare.this, "GET", REST_PATH, null, DicomStore.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Export
                    extends CloudHealthcareRequest<Operation> {
                        private static final String REST_PATH = "v1beta1/{+name}:export";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Export(String name, ExportDicomDataRequest content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                        }

                        public Export set$Xgafv(String $Xgafv) {
                            return (Export)super.set$Xgafv($Xgafv);
                        }

                        public Export setAccessToken(String accessToken) {
                            return (Export)super.setAccessToken(accessToken);
                        }

                        public Export setAlt(String alt) {
                            return (Export)super.setAlt(alt);
                        }

                        public Export setCallback(String callback) {
                            return (Export)super.setCallback(callback);
                        }

                        public Export setFields(String fields) {
                            return (Export)super.setFields(fields);
                        }

                        public Export setKey(String key) {
                            return (Export)super.setKey(key);
                        }

                        public Export setOauthToken(String oauthToken) {
                            return (Export)super.setOauthToken(oauthToken);
                        }

                        public Export setPrettyPrint(Boolean prettyPrint) {
                            return (Export)super.setPrettyPrint(prettyPrint);
                        }

                        public Export setQuotaUser(String quotaUser) {
                            return (Export)super.setQuotaUser(quotaUser);
                        }

                        public Export setUploadType(String uploadType) {
                            return (Export)super.setUploadType(uploadType);
                        }

                        public Export setUploadProtocol(String uploadProtocol) {
                            return (Export)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Export setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Export set(String parameterName, Object value) {
                            return (Export)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends CloudHealthcareRequest<Empty> {
                        private static final String REST_PATH = "v1beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String name) {
                            super(CloudHealthcare.this, "DELETE", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Deidentify
                    extends CloudHealthcareRequest<Operation> {
                        private static final String REST_PATH = "v1beta1/{+sourceStore}:deidentify";
                        private final Pattern SOURCE_STORE_PATTERN;
                        @Key
                        private String sourceStore;

                        protected Deidentify(String sourceStore, DeidentifyDicomStoreRequest content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.SOURCE_STORE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            this.sourceStore = (String)Preconditions.checkNotNull((Object)sourceStore, (Object)"Required parameter sourceStore must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SOURCE_STORE_PATTERN.matcher(sourceStore).matches(), (Object)"Parameter sourceStore must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                        }

                        public Deidentify set$Xgafv(String $Xgafv) {
                            return (Deidentify)super.set$Xgafv($Xgafv);
                        }

                        public Deidentify setAccessToken(String accessToken) {
                            return (Deidentify)super.setAccessToken(accessToken);
                        }

                        public Deidentify setAlt(String alt) {
                            return (Deidentify)super.setAlt(alt);
                        }

                        public Deidentify setCallback(String callback) {
                            return (Deidentify)super.setCallback(callback);
                        }

                        public Deidentify setFields(String fields) {
                            return (Deidentify)super.setFields(fields);
                        }

                        public Deidentify setKey(String key) {
                            return (Deidentify)super.setKey(key);
                        }

                        public Deidentify setOauthToken(String oauthToken) {
                            return (Deidentify)super.setOauthToken(oauthToken);
                        }

                        public Deidentify setPrettyPrint(Boolean prettyPrint) {
                            return (Deidentify)super.setPrettyPrint(prettyPrint);
                        }

                        public Deidentify setQuotaUser(String quotaUser) {
                            return (Deidentify)super.setQuotaUser(quotaUser);
                        }

                        public Deidentify setUploadType(String uploadType) {
                            return (Deidentify)super.setUploadType(uploadType);
                        }

                        public Deidentify setUploadProtocol(String uploadProtocol) {
                            return (Deidentify)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getSourceStore() {
                            return this.sourceStore;
                        }

                        public Deidentify setSourceStore(String sourceStore) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.SOURCE_STORE_PATTERN.matcher(sourceStore).matches(), (Object)"Parameter sourceStore must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/dicomStores/[^/]+$");
                            }
                            this.sourceStore = sourceStore;
                            return this;
                        }

                        @Override
                        public Deidentify set(String parameterName, Object value) {
                            return (Deidentify)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends CloudHealthcareRequest<DicomStore> {
                        private static final String REST_PATH = "v1beta1/{+parent}/dicomStores";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String dicomStoreId;

                        protected Create(String parent, DicomStore content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, DicomStore.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getDicomStoreId() {
                            return this.dicomStoreId;
                        }

                        public Create setDicomStoreId(String dicomStoreId) {
                            this.dicomStoreId = dicomStoreId;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                public class AnnotationStores {
                    public Create create(String parent, AnnotationStore content) throws IOException {
                        Create result = new Create(parent, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Evaluate evaluate(String evalStore, EvaluateAnnotationStoreRequest content) throws IOException {
                        Evaluate result = new Evaluate(evalStore, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Export export(String annotationStore, ExportAnnotationsRequest content) throws IOException {
                        Export result = new Export(annotationStore, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public GetIamPolicy getIamPolicy(String resource) throws IOException {
                        GetIamPolicy result = new GetIamPolicy(resource);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public CloudHealthcareImport healthcareImport(String annotationStore, ImportAnnotationsRequest content) throws IOException {
                        CloudHealthcareImport result = new CloudHealthcareImport(annotationStore, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String name, AnnotationStore content) throws IOException {
                        Patch result = new Patch(name, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                        SetIamPolicy result = new SetIamPolicy(resource, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                        TestIamPermissions result = new TestIamPermissions(resource, content);
                        CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Annotations annotations() {
                        return new Annotations();
                    }

                    public class Annotations {
                        public Create create(String parent, Annotation content) throws IOException {
                            Create result = new Create(parent, content);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Delete delete(String name) throws IOException {
                            Delete result = new Delete(name);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Get get(String name) throws IOException {
                            Get result = new Get(name);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public List list(String parent) throws IOException {
                            List result = new List(parent);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Patch patch(String name, Annotation content) throws IOException {
                            Patch result = new Patch(name, content);
                            CloudHealthcare.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public class Patch
                        extends CloudHealthcareRequest<Annotation> {
                            private static final String REST_PATH = "v1beta1/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;
                            @Key
                            private String updateMask;

                            protected Patch(String name, Annotation content) {
                                super(CloudHealthcare.this, "PATCH", REST_PATH, (Object)content, Annotation.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+/annotations/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+/annotations/[^/]+$");
                                }
                            }

                            public Patch set$Xgafv(String $Xgafv) {
                                return (Patch)super.set$Xgafv($Xgafv);
                            }

                            public Patch setAccessToken(String accessToken) {
                                return (Patch)super.setAccessToken(accessToken);
                            }

                            public Patch setAlt(String alt) {
                                return (Patch)super.setAlt(alt);
                            }

                            public Patch setCallback(String callback) {
                                return (Patch)super.setCallback(callback);
                            }

                            public Patch setFields(String fields) {
                                return (Patch)super.setFields(fields);
                            }

                            public Patch setKey(String key) {
                                return (Patch)super.setKey(key);
                            }

                            public Patch setOauthToken(String oauthToken) {
                                return (Patch)super.setOauthToken(oauthToken);
                            }

                            public Patch setPrettyPrint(Boolean prettyPrint) {
                                return (Patch)super.setPrettyPrint(prettyPrint);
                            }

                            public Patch setQuotaUser(String quotaUser) {
                                return (Patch)super.setQuotaUser(quotaUser);
                            }

                            public Patch setUploadType(String uploadType) {
                                return (Patch)super.setUploadType(uploadType);
                            }

                            public Patch setUploadProtocol(String uploadProtocol) {
                                return (Patch)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Patch setName(String name) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+/annotations/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            public String getUpdateMask() {
                                return this.updateMask;
                            }

                            public Patch setUpdateMask(String updateMask) {
                                this.updateMask = updateMask;
                                return this;
                            }

                            @Override
                            public Patch set(String parameterName, Object value) {
                                return (Patch)super.set(parameterName, value);
                            }
                        }

                        public class List
                        extends CloudHealthcareRequest<ListAnnotationsResponse> {
                            private static final String REST_PATH = "v1beta1/{+parent}/annotations";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private String filter;
                            @Key
                            private Integer pageSize;
                            @Key
                            private String pageToken;
                            @Key
                            private String view;

                            protected List(String parent) {
                                super(CloudHealthcare.this, "GET", REST_PATH, null, ListAnnotationsResponse.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public List set$Xgafv(String $Xgafv) {
                                return (List)super.set$Xgafv($Xgafv);
                            }

                            public List setAccessToken(String accessToken) {
                                return (List)super.setAccessToken(accessToken);
                            }

                            public List setAlt(String alt) {
                                return (List)super.setAlt(alt);
                            }

                            public List setCallback(String callback) {
                                return (List)super.setCallback(callback);
                            }

                            public List setFields(String fields) {
                                return (List)super.setFields(fields);
                            }

                            public List setKey(String key) {
                                return (List)super.setKey(key);
                            }

                            public List setOauthToken(String oauthToken) {
                                return (List)super.setOauthToken(oauthToken);
                            }

                            public List setPrettyPrint(Boolean prettyPrint) {
                                return (List)super.setPrettyPrint(prettyPrint);
                            }

                            public List setQuotaUser(String quotaUser) {
                                return (List)super.setQuotaUser(quotaUser);
                            }

                            public List setUploadType(String uploadType) {
                                return (List)super.setUploadType(uploadType);
                            }

                            public List setUploadProtocol(String uploadProtocol) {
                                return (List)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public List setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public String getFilter() {
                                return this.filter;
                            }

                            public List setFilter(String filter) {
                                this.filter = filter;
                                return this;
                            }

                            public Integer getPageSize() {
                                return this.pageSize;
                            }

                            public List setPageSize(Integer pageSize) {
                                this.pageSize = pageSize;
                                return this;
                            }

                            public String getPageToken() {
                                return this.pageToken;
                            }

                            public List setPageToken(String pageToken) {
                                this.pageToken = pageToken;
                                return this;
                            }

                            public String getView() {
                                return this.view;
                            }

                            public List setView(String view) {
                                this.view = view;
                                return this;
                            }

                            @Override
                            public List set(String parameterName, Object value) {
                                return (List)super.set(parameterName, value);
                            }
                        }

                        public class Get
                        extends CloudHealthcareRequest<Annotation> {
                            private static final String REST_PATH = "v1beta1/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected Get(String name) {
                                super(CloudHealthcare.this, "GET", REST_PATH, null, Annotation.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+/annotations/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+/annotations/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public Get set$Xgafv(String $Xgafv) {
                                return (Get)super.set$Xgafv($Xgafv);
                            }

                            public Get setAccessToken(String accessToken) {
                                return (Get)super.setAccessToken(accessToken);
                            }

                            public Get setAlt(String alt) {
                                return (Get)super.setAlt(alt);
                            }

                            public Get setCallback(String callback) {
                                return (Get)super.setCallback(callback);
                            }

                            public Get setFields(String fields) {
                                return (Get)super.setFields(fields);
                            }

                            public Get setKey(String key) {
                                return (Get)super.setKey(key);
                            }

                            public Get setOauthToken(String oauthToken) {
                                return (Get)super.setOauthToken(oauthToken);
                            }

                            public Get setPrettyPrint(Boolean prettyPrint) {
                                return (Get)super.setPrettyPrint(prettyPrint);
                            }

                            public Get setQuotaUser(String quotaUser) {
                                return (Get)super.setQuotaUser(quotaUser);
                            }

                            public Get setUploadType(String uploadType) {
                                return (Get)super.setUploadType(uploadType);
                            }

                            public Get setUploadProtocol(String uploadProtocol) {
                                return (Get)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Get setName(String name) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+/annotations/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public Get set(String parameterName, Object value) {
                                return (Get)super.set(parameterName, value);
                            }
                        }

                        public class Delete
                        extends CloudHealthcareRequest<Empty> {
                            private static final String REST_PATH = "v1beta1/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected Delete(String name) {
                                super(CloudHealthcare.this, "DELETE", REST_PATH, null, Empty.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+/annotations/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+/annotations/[^/]+$");
                                }
                            }

                            public Delete set$Xgafv(String $Xgafv) {
                                return (Delete)super.set$Xgafv($Xgafv);
                            }

                            public Delete setAccessToken(String accessToken) {
                                return (Delete)super.setAccessToken(accessToken);
                            }

                            public Delete setAlt(String alt) {
                                return (Delete)super.setAlt(alt);
                            }

                            public Delete setCallback(String callback) {
                                return (Delete)super.setCallback(callback);
                            }

                            public Delete setFields(String fields) {
                                return (Delete)super.setFields(fields);
                            }

                            public Delete setKey(String key) {
                                return (Delete)super.setKey(key);
                            }

                            public Delete setOauthToken(String oauthToken) {
                                return (Delete)super.setOauthToken(oauthToken);
                            }

                            public Delete setPrettyPrint(Boolean prettyPrint) {
                                return (Delete)super.setPrettyPrint(prettyPrint);
                            }

                            public Delete setQuotaUser(String quotaUser) {
                                return (Delete)super.setQuotaUser(quotaUser);
                            }

                            public Delete setUploadType(String uploadType) {
                                return (Delete)super.setUploadType(uploadType);
                            }

                            public Delete setUploadProtocol(String uploadProtocol) {
                                return (Delete)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Delete setName(String name) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+/annotations/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public Delete set(String parameterName, Object value) {
                                return (Delete)super.set(parameterName, value);
                            }
                        }

                        public class Create
                        extends CloudHealthcareRequest<Annotation> {
                            private static final String REST_PATH = "v1beta1/{+parent}/annotations";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;

                            protected Create(String parent, Annotation content) {
                                super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Annotation.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                                }
                            }

                            public Create set$Xgafv(String $Xgafv) {
                                return (Create)super.set$Xgafv($Xgafv);
                            }

                            public Create setAccessToken(String accessToken) {
                                return (Create)super.setAccessToken(accessToken);
                            }

                            public Create setAlt(String alt) {
                                return (Create)super.setAlt(alt);
                            }

                            public Create setCallback(String callback) {
                                return (Create)super.setCallback(callback);
                            }

                            public Create setFields(String fields) {
                                return (Create)super.setFields(fields);
                            }

                            public Create setKey(String key) {
                                return (Create)super.setKey(key);
                            }

                            public Create setOauthToken(String oauthToken) {
                                return (Create)super.setOauthToken(oauthToken);
                            }

                            public Create setPrettyPrint(Boolean prettyPrint) {
                                return (Create)super.setPrettyPrint(prettyPrint);
                            }

                            public Create setQuotaUser(String quotaUser) {
                                return (Create)super.setQuotaUser(quotaUser);
                            }

                            public Create setUploadType(String uploadType) {
                                return (Create)super.setUploadType(uploadType);
                            }

                            public Create setUploadProtocol(String uploadProtocol) {
                                return (Create)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public Create setParent(String parent) {
                                if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            @Override
                            public Create set(String parameterName, Object value) {
                                return (Create)super.set(parameterName, value);
                            }
                        }
                    }

                    public class TestIamPermissions
                    extends CloudHealthcareRequest<TestIamPermissionsResponse> {
                        private static final String REST_PATH = "v1beta1/{+resource}:testIamPermissions";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;

                        protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            }
                        }

                        public TestIamPermissions set$Xgafv(String $Xgafv) {
                            return (TestIamPermissions)super.set$Xgafv($Xgafv);
                        }

                        public TestIamPermissions setAccessToken(String accessToken) {
                            return (TestIamPermissions)super.setAccessToken(accessToken);
                        }

                        public TestIamPermissions setAlt(String alt) {
                            return (TestIamPermissions)super.setAlt(alt);
                        }

                        public TestIamPermissions setCallback(String callback) {
                            return (TestIamPermissions)super.setCallback(callback);
                        }

                        public TestIamPermissions setFields(String fields) {
                            return (TestIamPermissions)super.setFields(fields);
                        }

                        public TestIamPermissions setKey(String key) {
                            return (TestIamPermissions)super.setKey(key);
                        }

                        public TestIamPermissions setOauthToken(String oauthToken) {
                            return (TestIamPermissions)super.setOauthToken(oauthToken);
                        }

                        public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                            return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                        }

                        public TestIamPermissions setQuotaUser(String quotaUser) {
                            return (TestIamPermissions)super.setQuotaUser(quotaUser);
                        }

                        public TestIamPermissions setUploadType(String uploadType) {
                            return (TestIamPermissions)super.setUploadType(uploadType);
                        }

                        public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                            return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public TestIamPermissions setResource(String resource) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        @Override
                        public TestIamPermissions set(String parameterName, Object value) {
                            return (TestIamPermissions)super.set(parameterName, value);
                        }
                    }

                    public class SetIamPolicy
                    extends CloudHealthcareRequest<Policy> {
                        private static final String REST_PATH = "v1beta1/{+resource}:setIamPolicy";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;

                        protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Policy.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            }
                        }

                        public SetIamPolicy set$Xgafv(String $Xgafv) {
                            return (SetIamPolicy)super.set$Xgafv($Xgafv);
                        }

                        public SetIamPolicy setAccessToken(String accessToken) {
                            return (SetIamPolicy)super.setAccessToken(accessToken);
                        }

                        public SetIamPolicy setAlt(String alt) {
                            return (SetIamPolicy)super.setAlt(alt);
                        }

                        public SetIamPolicy setCallback(String callback) {
                            return (SetIamPolicy)super.setCallback(callback);
                        }

                        public SetIamPolicy setFields(String fields) {
                            return (SetIamPolicy)super.setFields(fields);
                        }

                        public SetIamPolicy setKey(String key) {
                            return (SetIamPolicy)super.setKey(key);
                        }

                        public SetIamPolicy setOauthToken(String oauthToken) {
                            return (SetIamPolicy)super.setOauthToken(oauthToken);
                        }

                        public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                            return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                        }

                        public SetIamPolicy setQuotaUser(String quotaUser) {
                            return (SetIamPolicy)super.setQuotaUser(quotaUser);
                        }

                        public SetIamPolicy setUploadType(String uploadType) {
                            return (SetIamPolicy)super.setUploadType(uploadType);
                        }

                        public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                            return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public SetIamPolicy setResource(String resource) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        @Override
                        public SetIamPolicy set(String parameterName, Object value) {
                            return (SetIamPolicy)super.set(parameterName, value);
                        }
                    }

                    public class Patch
                    extends CloudHealthcareRequest<AnnotationStore> {
                        private static final String REST_PATH = "v1beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String updateMask;

                        protected Patch(String name, AnnotationStore content) {
                            super(CloudHealthcare.this, "PATCH", REST_PATH, (Object)content, AnnotationStore.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String $Xgafv) {
                            return (Patch)super.set$Xgafv($Xgafv);
                        }

                        public Patch setAccessToken(String accessToken) {
                            return (Patch)super.setAccessToken(accessToken);
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setCallback(String callback) {
                            return (Patch)super.setCallback(callback);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUploadType(String uploadType) {
                            return (Patch)super.setUploadType(uploadType);
                        }

                        public Patch setUploadProtocol(String uploadProtocol) {
                            return (Patch)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String updateMask) {
                            this.updateMask = updateMask;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends CloudHealthcareRequest<ListAnnotationStoresResponse> {
                        private static final String REST_PATH = "v1beta1/{+parent}/annotationStores";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String filter;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(CloudHealthcare.this, "GET", REST_PATH, null, ListAnnotationStoresResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class CloudHealthcareImport
                    extends CloudHealthcareRequest<Operation> {
                        private static final String REST_PATH = "v1beta1/{+annotationStore}:import";
                        private final Pattern ANNOTATION_STORE_PATTERN;
                        @Key
                        private String annotationStore;

                        protected CloudHealthcareImport(String annotationStore, ImportAnnotationsRequest content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.ANNOTATION_STORE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            this.annotationStore = (String)Preconditions.checkNotNull((Object)annotationStore, (Object)"Required parameter annotationStore must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.ANNOTATION_STORE_PATTERN.matcher(annotationStore).matches(), (Object)"Parameter annotationStore must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            }
                        }

                        public CloudHealthcareImport set$Xgafv(String $Xgafv) {
                            return (CloudHealthcareImport)super.set$Xgafv($Xgafv);
                        }

                        public CloudHealthcareImport setAccessToken(String accessToken) {
                            return (CloudHealthcareImport)super.setAccessToken(accessToken);
                        }

                        public CloudHealthcareImport setAlt(String alt) {
                            return (CloudHealthcareImport)super.setAlt(alt);
                        }

                        public CloudHealthcareImport setCallback(String callback) {
                            return (CloudHealthcareImport)super.setCallback(callback);
                        }

                        public CloudHealthcareImport setFields(String fields) {
                            return (CloudHealthcareImport)super.setFields(fields);
                        }

                        public CloudHealthcareImport setKey(String key) {
                            return (CloudHealthcareImport)super.setKey(key);
                        }

                        public CloudHealthcareImport setOauthToken(String oauthToken) {
                            return (CloudHealthcareImport)super.setOauthToken(oauthToken);
                        }

                        public CloudHealthcareImport setPrettyPrint(Boolean prettyPrint) {
                            return (CloudHealthcareImport)super.setPrettyPrint(prettyPrint);
                        }

                        public CloudHealthcareImport setQuotaUser(String quotaUser) {
                            return (CloudHealthcareImport)super.setQuotaUser(quotaUser);
                        }

                        public CloudHealthcareImport setUploadType(String uploadType) {
                            return (CloudHealthcareImport)super.setUploadType(uploadType);
                        }

                        public CloudHealthcareImport setUploadProtocol(String uploadProtocol) {
                            return (CloudHealthcareImport)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getAnnotationStore() {
                            return this.annotationStore;
                        }

                        public CloudHealthcareImport setAnnotationStore(String annotationStore) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.ANNOTATION_STORE_PATTERN.matcher(annotationStore).matches(), (Object)"Parameter annotationStore must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            }
                            this.annotationStore = annotationStore;
                            return this;
                        }

                        @Override
                        public CloudHealthcareImport set(String parameterName, Object value) {
                            return (CloudHealthcareImport)super.set(parameterName, value);
                        }
                    }

                    public class GetIamPolicy
                    extends CloudHealthcareRequest<Policy> {
                        private static final String REST_PATH = "v1beta1/{+resource}:getIamPolicy";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;
                        @Key(value="options.requestedPolicyVersion")
                        private Integer optionsRequestedPolicyVersion;

                        protected GetIamPolicy(String resource) {
                            super(CloudHealthcare.this, "GET", REST_PATH, null, Policy.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public GetIamPolicy set$Xgafv(String $Xgafv) {
                            return (GetIamPolicy)super.set$Xgafv($Xgafv);
                        }

                        public GetIamPolicy setAccessToken(String accessToken) {
                            return (GetIamPolicy)super.setAccessToken(accessToken);
                        }

                        public GetIamPolicy setAlt(String alt) {
                            return (GetIamPolicy)super.setAlt(alt);
                        }

                        public GetIamPolicy setCallback(String callback) {
                            return (GetIamPolicy)super.setCallback(callback);
                        }

                        public GetIamPolicy setFields(String fields) {
                            return (GetIamPolicy)super.setFields(fields);
                        }

                        public GetIamPolicy setKey(String key) {
                            return (GetIamPolicy)super.setKey(key);
                        }

                        public GetIamPolicy setOauthToken(String oauthToken) {
                            return (GetIamPolicy)super.setOauthToken(oauthToken);
                        }

                        public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                            return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                        }

                        public GetIamPolicy setQuotaUser(String quotaUser) {
                            return (GetIamPolicy)super.setQuotaUser(quotaUser);
                        }

                        public GetIamPolicy setUploadType(String uploadType) {
                            return (GetIamPolicy)super.setUploadType(uploadType);
                        }

                        public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                            return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public GetIamPolicy setResource(String resource) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        public Integer getOptionsRequestedPolicyVersion() {
                            return this.optionsRequestedPolicyVersion;
                        }

                        public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                            this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                            return this;
                        }

                        @Override
                        public GetIamPolicy set(String parameterName, Object value) {
                            return (GetIamPolicy)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends CloudHealthcareRequest<AnnotationStore> {
                        private static final String REST_PATH = "v1beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(CloudHealthcare.this, "GET", REST_PATH, null, AnnotationStore.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Export
                    extends CloudHealthcareRequest<Operation> {
                        private static final String REST_PATH = "v1beta1/{+annotationStore}:export";
                        private final Pattern ANNOTATION_STORE_PATTERN;
                        @Key
                        private String annotationStore;

                        protected Export(String annotationStore, ExportAnnotationsRequest content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.ANNOTATION_STORE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            this.annotationStore = (String)Preconditions.checkNotNull((Object)annotationStore, (Object)"Required parameter annotationStore must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.ANNOTATION_STORE_PATTERN.matcher(annotationStore).matches(), (Object)"Parameter annotationStore must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            }
                        }

                        public Export set$Xgafv(String $Xgafv) {
                            return (Export)super.set$Xgafv($Xgafv);
                        }

                        public Export setAccessToken(String accessToken) {
                            return (Export)super.setAccessToken(accessToken);
                        }

                        public Export setAlt(String alt) {
                            return (Export)super.setAlt(alt);
                        }

                        public Export setCallback(String callback) {
                            return (Export)super.setCallback(callback);
                        }

                        public Export setFields(String fields) {
                            return (Export)super.setFields(fields);
                        }

                        public Export setKey(String key) {
                            return (Export)super.setKey(key);
                        }

                        public Export setOauthToken(String oauthToken) {
                            return (Export)super.setOauthToken(oauthToken);
                        }

                        public Export setPrettyPrint(Boolean prettyPrint) {
                            return (Export)super.setPrettyPrint(prettyPrint);
                        }

                        public Export setQuotaUser(String quotaUser) {
                            return (Export)super.setQuotaUser(quotaUser);
                        }

                        public Export setUploadType(String uploadType) {
                            return (Export)super.setUploadType(uploadType);
                        }

                        public Export setUploadProtocol(String uploadProtocol) {
                            return (Export)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getAnnotationStore() {
                            return this.annotationStore;
                        }

                        public Export setAnnotationStore(String annotationStore) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.ANNOTATION_STORE_PATTERN.matcher(annotationStore).matches(), (Object)"Parameter annotationStore must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            }
                            this.annotationStore = annotationStore;
                            return this;
                        }

                        @Override
                        public Export set(String parameterName, Object value) {
                            return (Export)super.set(parameterName, value);
                        }
                    }

                    public class Evaluate
                    extends CloudHealthcareRequest<Operation> {
                        private static final String REST_PATH = "v1beta1/{+evalStore}:evaluate";
                        private final Pattern EVAL_STORE_PATTERN;
                        @Key
                        private String evalStore;

                        protected Evaluate(String evalStore, EvaluateAnnotationStoreRequest content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.EVAL_STORE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            this.evalStore = (String)Preconditions.checkNotNull((Object)evalStore, (Object)"Required parameter evalStore must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.EVAL_STORE_PATTERN.matcher(evalStore).matches(), (Object)"Parameter evalStore must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            }
                        }

                        public Evaluate set$Xgafv(String $Xgafv) {
                            return (Evaluate)super.set$Xgafv($Xgafv);
                        }

                        public Evaluate setAccessToken(String accessToken) {
                            return (Evaluate)super.setAccessToken(accessToken);
                        }

                        public Evaluate setAlt(String alt) {
                            return (Evaluate)super.setAlt(alt);
                        }

                        public Evaluate setCallback(String callback) {
                            return (Evaluate)super.setCallback(callback);
                        }

                        public Evaluate setFields(String fields) {
                            return (Evaluate)super.setFields(fields);
                        }

                        public Evaluate setKey(String key) {
                            return (Evaluate)super.setKey(key);
                        }

                        public Evaluate setOauthToken(String oauthToken) {
                            return (Evaluate)super.setOauthToken(oauthToken);
                        }

                        public Evaluate setPrettyPrint(Boolean prettyPrint) {
                            return (Evaluate)super.setPrettyPrint(prettyPrint);
                        }

                        public Evaluate setQuotaUser(String quotaUser) {
                            return (Evaluate)super.setQuotaUser(quotaUser);
                        }

                        public Evaluate setUploadType(String uploadType) {
                            return (Evaluate)super.setUploadType(uploadType);
                        }

                        public Evaluate setUploadProtocol(String uploadProtocol) {
                            return (Evaluate)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getEvalStore() {
                            return this.evalStore;
                        }

                        public Evaluate setEvalStore(String evalStore) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.EVAL_STORE_PATTERN.matcher(evalStore).matches(), (Object)"Parameter evalStore must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            }
                            this.evalStore = evalStore;
                            return this;
                        }

                        @Override
                        public Evaluate set(String parameterName, Object value) {
                            return (Evaluate)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends CloudHealthcareRequest<Empty> {
                        private static final String REST_PATH = "v1beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String name) {
                            super(CloudHealthcare.this, "DELETE", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+/annotationStores/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends CloudHealthcareRequest<AnnotationStore> {
                        private static final String REST_PATH = "v1beta1/{+parent}/annotationStores";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String annotationStoreId;

                        protected Create(String parent, AnnotationStore content) {
                            super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, AnnotationStore.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getAnnotationStoreId() {
                            return this.annotationStoreId;
                        }

                        public Create setAnnotationStoreId(String annotationStoreId) {
                            this.annotationStoreId = annotationStoreId;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                public class TestIamPermissions
                extends CloudHealthcareRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v1beta1/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                        super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String $Xgafv) {
                        return (TestIamPermissions)super.set$Xgafv($Xgafv);
                    }

                    public TestIamPermissions setAccessToken(String accessToken) {
                        return (TestIamPermissions)super.setAccessToken(accessToken);
                    }

                    public TestIamPermissions setAlt(String alt) {
                        return (TestIamPermissions)super.setAlt(alt);
                    }

                    public TestIamPermissions setCallback(String callback) {
                        return (TestIamPermissions)super.setCallback(callback);
                    }

                    public TestIamPermissions setFields(String fields) {
                        return (TestIamPermissions)super.setFields(fields);
                    }

                    public TestIamPermissions setKey(String key) {
                        return (TestIamPermissions)super.setKey(key);
                    }

                    public TestIamPermissions setOauthToken(String oauthToken) {
                        return (TestIamPermissions)super.setOauthToken(oauthToken);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                        return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                    }

                    public TestIamPermissions setQuotaUser(String quotaUser) {
                        return (TestIamPermissions)super.setQuotaUser(quotaUser);
                    }

                    public TestIamPermissions setUploadType(String uploadType) {
                        return (TestIamPermissions)super.setUploadType(uploadType);
                    }

                    public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                        return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String resource) {
                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String parameterName, Object value) {
                        return (TestIamPermissions)super.set(parameterName, value);
                    }
                }

                public class SetIamPolicy
                extends CloudHealthcareRequest<Policy> {
                    private static final String REST_PATH = "v1beta1/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                        super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String $Xgafv) {
                        return (SetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public SetIamPolicy setAccessToken(String accessToken) {
                        return (SetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public SetIamPolicy setAlt(String alt) {
                        return (SetIamPolicy)super.setAlt(alt);
                    }

                    public SetIamPolicy setCallback(String callback) {
                        return (SetIamPolicy)super.setCallback(callback);
                    }

                    public SetIamPolicy setFields(String fields) {
                        return (SetIamPolicy)super.setFields(fields);
                    }

                    public SetIamPolicy setKey(String key) {
                        return (SetIamPolicy)super.setKey(key);
                    }

                    public SetIamPolicy setOauthToken(String oauthToken) {
                        return (SetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public SetIamPolicy setQuotaUser(String quotaUser) {
                        return (SetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public SetIamPolicy setUploadType(String uploadType) {
                        return (SetIamPolicy)super.setUploadType(uploadType);
                    }

                    public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String resource) {
                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String parameterName, Object value) {
                        return (SetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends CloudHealthcareRequest<Dataset> {
                    private static final String REST_PATH = "v1beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, Dataset content) {
                        super(CloudHealthcare.this, "PATCH", REST_PATH, (Object)content, Dataset.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends CloudHealthcareRequest<ListDatasetsResponse> {
                    private static final String REST_PATH = "v1beta1/{+parent}/datasets";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(CloudHealthcare.this, "GET", REST_PATH, null, ListDatasetsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class GetIamPolicy
                extends CloudHealthcareRequest<Policy> {
                    private static final String REST_PATH = "v1beta1/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;
                    @Key(value="options.requestedPolicyVersion")
                    private Integer optionsRequestedPolicyVersion;

                    protected GetIamPolicy(String resource) {
                        super(CloudHealthcare.this, "GET", REST_PATH, null, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetIamPolicy set$Xgafv(String $Xgafv) {
                        return (GetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public GetIamPolicy setAccessToken(String accessToken) {
                        return (GetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public GetIamPolicy setAlt(String alt) {
                        return (GetIamPolicy)super.setAlt(alt);
                    }

                    public GetIamPolicy setCallback(String callback) {
                        return (GetIamPolicy)super.setCallback(callback);
                    }

                    public GetIamPolicy setFields(String fields) {
                        return (GetIamPolicy)super.setFields(fields);
                    }

                    public GetIamPolicy setKey(String key) {
                        return (GetIamPolicy)super.setKey(key);
                    }

                    public GetIamPolicy setOauthToken(String oauthToken) {
                        return (GetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public GetIamPolicy setQuotaUser(String quotaUser) {
                        return (GetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public GetIamPolicy setUploadType(String uploadType) {
                        return (GetIamPolicy)super.setUploadType(uploadType);
                    }

                    public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String resource) {
                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    public Integer getOptionsRequestedPolicyVersion() {
                        return this.optionsRequestedPolicyVersion;
                    }

                    public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                        this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String parameterName, Object value) {
                        return (GetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudHealthcareRequest<Dataset> {
                    private static final String REST_PATH = "v1beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(CloudHealthcare.this, "GET", REST_PATH, null, Dataset.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends CloudHealthcareRequest<Empty> {
                    private static final String REST_PATH = "v1beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(CloudHealthcare.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Deidentify
                extends CloudHealthcareRequest<Operation> {
                    private static final String REST_PATH = "v1beta1/{+sourceDataset}:deidentify";
                    private final Pattern SOURCE_DATASET_PATTERN;
                    @Key
                    private String sourceDataset;

                    protected Deidentify(String sourceDataset, DeidentifyDatasetRequest content) {
                        super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.SOURCE_DATASET_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        this.sourceDataset = (String)Preconditions.checkNotNull((Object)sourceDataset, (Object)"Required parameter sourceDataset must be specified.");
                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.SOURCE_DATASET_PATTERN.matcher(sourceDataset).matches(), (Object)"Parameter sourceDataset must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                    }

                    public Deidentify set$Xgafv(String $Xgafv) {
                        return (Deidentify)super.set$Xgafv($Xgafv);
                    }

                    public Deidentify setAccessToken(String accessToken) {
                        return (Deidentify)super.setAccessToken(accessToken);
                    }

                    public Deidentify setAlt(String alt) {
                        return (Deidentify)super.setAlt(alt);
                    }

                    public Deidentify setCallback(String callback) {
                        return (Deidentify)super.setCallback(callback);
                    }

                    public Deidentify setFields(String fields) {
                        return (Deidentify)super.setFields(fields);
                    }

                    public Deidentify setKey(String key) {
                        return (Deidentify)super.setKey(key);
                    }

                    public Deidentify setOauthToken(String oauthToken) {
                        return (Deidentify)super.setOauthToken(oauthToken);
                    }

                    public Deidentify setPrettyPrint(Boolean prettyPrint) {
                        return (Deidentify)super.setPrettyPrint(prettyPrint);
                    }

                    public Deidentify setQuotaUser(String quotaUser) {
                        return (Deidentify)super.setQuotaUser(quotaUser);
                    }

                    public Deidentify setUploadType(String uploadType) {
                        return (Deidentify)super.setUploadType(uploadType);
                    }

                    public Deidentify setUploadProtocol(String uploadProtocol) {
                        return (Deidentify)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getSourceDataset() {
                        return this.sourceDataset;
                    }

                    public Deidentify setSourceDataset(String sourceDataset) {
                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.SOURCE_DATASET_PATTERN.matcher(sourceDataset).matches(), (Object)"Parameter sourceDataset must conform to the pattern ^projects/[^/]+/locations/[^/]+/datasets/[^/]+$");
                        }
                        this.sourceDataset = sourceDataset;
                        return this;
                    }

                    @Override
                    public Deidentify set(String parameterName, Object value) {
                        return (Deidentify)super.set(parameterName, value);
                    }
                }

                public class Create
                extends CloudHealthcareRequest<Operation> {
                    private static final String REST_PATH = "v1beta1/{+parent}/datasets";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String datasetId;

                    protected Create(String parent, Dataset content) {
                        super(CloudHealthcare.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getDatasetId() {
                        return this.datasetId;
                    }

                    public Create setDatasetId(String datasetId) {
                        this.datasetId = datasetId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class List
            extends CloudHealthcareRequest<ListLocationsResponse> {
                private static final String REST_PATH = "v1beta1/{+name}/locations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(CloudHealthcare.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends CloudHealthcareRequest<Location> {
                private static final String REST_PATH = "v1beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(CloudHealthcare.this, "GET", REST_PATH, null, Location.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!CloudHealthcare.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }
    }
}

