/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.homegraph.v1.model;

/**
 * Identifiers used to describe the device.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the HomeGraph API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeviceNames extends com.google.api.client.json.GenericJson {

  /**
   * List of names provided by the manufacturer rather than the user, such as serial numbers, SKUs,
   * etc.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> defaultNames;

  /**
   * Primary name of the device, generally provided by the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Additional names provided by the user for the device.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> nicknames;

  /**
   * List of names provided by the manufacturer rather than the user, such as serial numbers, SKUs,
   * etc.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDefaultNames() {
    return defaultNames;
  }

  /**
   * List of names provided by the manufacturer rather than the user, such as serial numbers, SKUs,
   * etc.
   * @param defaultNames defaultNames or {@code null} for none
   */
  public DeviceNames setDefaultNames(java.util.List<java.lang.String> defaultNames) {
    this.defaultNames = defaultNames;
    return this;
  }

  /**
   * Primary name of the device, generally provided by the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Primary name of the device, generally provided by the user.
   * @param name name or {@code null} for none
   */
  public DeviceNames setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Additional names provided by the user for the device.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getNicknames() {
    return nicknames;
  }

  /**
   * Additional names provided by the user for the device.
   * @param nicknames nicknames or {@code null} for none
   */
  public DeviceNames setNicknames(java.util.List<java.lang.String> nicknames) {
    this.nicknames = nicknames;
    return this;
  }

  @Override
  public DeviceNames set(String fieldName, Object value) {
    return (DeviceNames) super.set(fieldName, value);
  }

  @Override
  public DeviceNames clone() {
    return (DeviceNames) super.clone();
  }

}
