/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.homegraph.v1.model;

/**
 * Request type for the [`Query`](#google.home.graph.v1.HomeGraphApiService.Query) call.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the HomeGraph API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class QueryRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. Third-party user ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String agentUserId;

  /**
   * Required. Inputs containing third-party device IDs for which to get the device states.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<QueryRequestInput> inputs;

  /**
   * Request ID used for debugging.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestId;

  /**
   * Required. Third-party user ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getAgentUserId() {
    return agentUserId;
  }

  /**
   * Required. Third-party user ID.
   * @param agentUserId agentUserId or {@code null} for none
   */
  public QueryRequest setAgentUserId(java.lang.String agentUserId) {
    this.agentUserId = agentUserId;
    return this;
  }

  /**
   * Required. Inputs containing third-party device IDs for which to get the device states.
   * @return value or {@code null} for none
   */
  public java.util.List<QueryRequestInput> getInputs() {
    return inputs;
  }

  /**
   * Required. Inputs containing third-party device IDs for which to get the device states.
   * @param inputs inputs or {@code null} for none
   */
  public QueryRequest setInputs(java.util.List<QueryRequestInput> inputs) {
    this.inputs = inputs;
    return this;
  }

  /**
   * Request ID used for debugging.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestId() {
    return requestId;
  }

  /**
   * Request ID used for debugging.
   * @param requestId requestId or {@code null} for none
   */
  public QueryRequest setRequestId(java.lang.String requestId) {
    this.requestId = requestId;
    return this;
  }

  @Override
  public QueryRequest set(String fieldName, Object value) {
    return (QueryRequest) super.set(fieldName, value);
  }

  @Override
  public QueryRequest clone() {
    return (QueryRequest) super.clone();
  }

}
