/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.homegraph.v1.model;

/**
 * The states and notifications specific to a device.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the HomeGraph API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReportStateAndNotificationDevice extends com.google.api.client.json.GenericJson {

  /**
   * Notifications metadata for devices. See the **Device NOTIFICATIONS** section of the individual
   * trait [reference guides](https://developers.google.com/assistant/smarthome/traits).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.Object> notifications;

  /**
   * States of devices to update. See the **Device STATES** section of the individual trait
   * [reference guides](https://developers.google.com/assistant/smarthome/traits).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.Object> states;

  /**
   * Notifications metadata for devices. See the **Device NOTIFICATIONS** section of the individual
   * trait [reference guides](https://developers.google.com/assistant/smarthome/traits).
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Object> getNotifications() {
    return notifications;
  }

  /**
   * Notifications metadata for devices. See the **Device NOTIFICATIONS** section of the individual
   * trait [reference guides](https://developers.google.com/assistant/smarthome/traits).
   * @param notifications notifications or {@code null} for none
   */
  public ReportStateAndNotificationDevice setNotifications(java.util.Map<String, java.lang.Object> notifications) {
    this.notifications = notifications;
    return this;
  }

  /**
   * States of devices to update. See the **Device STATES** section of the individual trait
   * [reference guides](https://developers.google.com/assistant/smarthome/traits).
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Object> getStates() {
    return states;
  }

  /**
   * States of devices to update. See the **Device STATES** section of the individual trait
   * [reference guides](https://developers.google.com/assistant/smarthome/traits).
   * @param states states or {@code null} for none
   */
  public ReportStateAndNotificationDevice setStates(java.util.Map<String, java.lang.Object> states) {
    this.states = states;
    return this;
  }

  @Override
  public ReportStateAndNotificationDevice set(String fieldName, Object value) {
    return (ReportStateAndNotificationDevice) super.set(fieldName, value);
  }

  @Override
  public ReportStateAndNotificationDevice clone() {
    return (ReportStateAndNotificationDevice) super.clone();
  }

}
