/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.homegraph.v1.model;

/**
 * Request type for the
 * [`RequestSyncDevices`](#google.home.graph.v1.HomeGraphApiService.RequestSyncDevices) call.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the HomeGraph API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RequestSyncDevicesRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. Third-party user ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String agentUserId;

  /**
   * Optional. If set, the request will be added to a queue and a response will be returned
   * immediately. This enables concurrent requests for the given `agent_user_id`, but the caller
   * will not receive any error responses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean async;

  /**
   * Required. Third-party user ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getAgentUserId() {
    return agentUserId;
  }

  /**
   * Required. Third-party user ID.
   * @param agentUserId agentUserId or {@code null} for none
   */
  public RequestSyncDevicesRequest setAgentUserId(java.lang.String agentUserId) {
    this.agentUserId = agentUserId;
    return this;
  }

  /**
   * Optional. If set, the request will be added to a queue and a response will be returned
   * immediately. This enables concurrent requests for the given `agent_user_id`, but the caller
   * will not receive any error responses.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAsync() {
    return async;
  }

  /**
   * Optional. If set, the request will be added to a queue and a response will be returned
   * immediately. This enables concurrent requests for the given `agent_user_id`, but the caller
   * will not receive any error responses.
   * @param async async or {@code null} for none
   */
  public RequestSyncDevicesRequest setAsync(java.lang.Boolean async) {
    this.async = async;
    return this;
  }

  @Override
  public RequestSyncDevicesRequest set(String fieldName, Object value) {
    return (RequestSyncDevicesRequest) super.set(fieldName, value);
  }

  @Override
  public RequestSyncDevicesRequest clone() {
    return (RequestSyncDevicesRequest) super.clone();
  }

}
