/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.homegraph.v1.model;

/**
 * Response type for the [`Sync`](#google.home.graph.v1.HomeGraphApiService.Sync) call. This should
 * follow the same format as the Google smart home `action.devices.SYNC`
 * [response](https://developers.google.com/assistant/smarthome/reference/intent/sync). # Example
 * ```json { "requestId": "ff36a3cc-ec34-11e6-b1a0-64510650abcf", "payload": { "agentUserId":
 * "1836.15267389", "devices": [{ "id": "123", "type": "action.devices.types.OUTLET", "traits": [
 * "action.devices.traits.OnOff" ], "name": { "defaultNames": ["My Outlet 1234"], "name": "Night
 * light", "nicknames": ["wall plug"] }, "willReportState": false, "deviceInfo": { "manufacturer":
 * "lights-out-inc", "model": "hs1234", "hwVersion": "3.2", "swVersion": "11.4" }, "customData": {
 * "fooValue": 74, "barValue": true, "bazValue": "foo" } }] } } ```
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the HomeGraph API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SyncResponse extends com.google.api.client.json.GenericJson {

  /**
   * Devices associated with the third-party user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SyncResponsePayload payload;

  /**
   * Request ID used for debugging. Copied from the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestId;

  /**
   * Devices associated with the third-party user.
   * @return value or {@code null} for none
   */
  public SyncResponsePayload getPayload() {
    return payload;
  }

  /**
   * Devices associated with the third-party user.
   * @param payload payload or {@code null} for none
   */
  public SyncResponse setPayload(SyncResponsePayload payload) {
    this.payload = payload;
    return this;
  }

  /**
   * Request ID used for debugging. Copied from the request.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestId() {
    return requestId;
  }

  /**
   * Request ID used for debugging. Copied from the request.
   * @param requestId requestId or {@code null} for none
   */
  public SyncResponse setRequestId(java.lang.String requestId) {
    this.requestId = requestId;
    return this;
  }

  @Override
  public SyncResponse set(String fieldName, Object value) {
    return (SyncResponse) super.set(fieldName, value);
  }

  @Override
  public SyncResponse clone() {
    return (SyncResponse) super.clone();
  }

}
