/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.homegraph.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.homegraph.v1.HomeGraphServiceRequest;
import com.google.api.services.homegraph.v1.HomeGraphServiceRequestInitializer;
import com.google.api.services.homegraph.v1.model.Empty;
import com.google.api.services.homegraph.v1.model.QueryRequest;
import com.google.api.services.homegraph.v1.model.QueryResponse;
import com.google.api.services.homegraph.v1.model.ReportStateAndNotificationRequest;
import com.google.api.services.homegraph.v1.model.ReportStateAndNotificationResponse;
import com.google.api.services.homegraph.v1.model.RequestSyncDevicesRequest;
import com.google.api.services.homegraph.v1.model.RequestSyncDevicesResponse;
import com.google.api.services.homegraph.v1.model.SyncRequest;
import com.google.api.services.homegraph.v1.model.SyncResponse;
import java.io.IOException;
import java.util.regex.Pattern;

public class HomeGraphService
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://homegraph.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://homegraph.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://homegraph.googleapis.com/";

    public HomeGraphService(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    HomeGraphService(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public AgentUsers agentUsers() {
        return new AgentUsers();
    }

    public Devices devices() {
        return new Devices();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the HomeGraph API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return HomeGraphService.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://homegraph.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), HomeGraphService.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(HomeGraphService.DEFAULT_BATCH_PATH);
        }

        public HomeGraphService build() {
            return new HomeGraphService(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setHomeGraphServiceRequestInitializer(HomeGraphServiceRequestInitializer homegraphserviceRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)homegraphserviceRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Devices {
        public Query query(QueryRequest content) throws IOException {
            Query result = new Query(content);
            HomeGraphService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ReportStateAndNotification reportStateAndNotification(ReportStateAndNotificationRequest content) throws IOException {
            ReportStateAndNotification result = new ReportStateAndNotification(content);
            HomeGraphService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public RequestSync requestSync(RequestSyncDevicesRequest content) throws IOException {
            RequestSync result = new RequestSync(content);
            HomeGraphService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Sync sync(SyncRequest content) throws IOException {
            Sync result = new Sync(content);
            HomeGraphService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Sync
        extends HomeGraphServiceRequest<SyncResponse> {
            private static final String REST_PATH = "v1/devices:sync";

            protected Sync(SyncRequest content) {
                super(HomeGraphService.this, "POST", REST_PATH, (Object)content, SyncResponse.class);
            }

            public Sync set$Xgafv(String $Xgafv) {
                return (Sync)super.set$Xgafv($Xgafv);
            }

            public Sync setAccessToken(String accessToken) {
                return (Sync)super.setAccessToken(accessToken);
            }

            public Sync setAlt(String alt) {
                return (Sync)super.setAlt(alt);
            }

            public Sync setCallback(String callback) {
                return (Sync)super.setCallback(callback);
            }

            public Sync setFields(String fields) {
                return (Sync)super.setFields(fields);
            }

            public Sync setKey(String key) {
                return (Sync)super.setKey(key);
            }

            public Sync setOauthToken(String oauthToken) {
                return (Sync)super.setOauthToken(oauthToken);
            }

            public Sync setPrettyPrint(Boolean prettyPrint) {
                return (Sync)super.setPrettyPrint(prettyPrint);
            }

            public Sync setQuotaUser(String quotaUser) {
                return (Sync)super.setQuotaUser(quotaUser);
            }

            public Sync setUploadType(String uploadType) {
                return (Sync)super.setUploadType(uploadType);
            }

            public Sync setUploadProtocol(String uploadProtocol) {
                return (Sync)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Sync set(String parameterName, Object value) {
                return (Sync)super.set(parameterName, value);
            }
        }

        public class RequestSync
        extends HomeGraphServiceRequest<RequestSyncDevicesResponse> {
            private static final String REST_PATH = "v1/devices:requestSync";

            protected RequestSync(RequestSyncDevicesRequest content) {
                super(HomeGraphService.this, "POST", REST_PATH, (Object)content, RequestSyncDevicesResponse.class);
            }

            public RequestSync set$Xgafv(String $Xgafv) {
                return (RequestSync)super.set$Xgafv($Xgafv);
            }

            public RequestSync setAccessToken(String accessToken) {
                return (RequestSync)super.setAccessToken(accessToken);
            }

            public RequestSync setAlt(String alt) {
                return (RequestSync)super.setAlt(alt);
            }

            public RequestSync setCallback(String callback) {
                return (RequestSync)super.setCallback(callback);
            }

            public RequestSync setFields(String fields) {
                return (RequestSync)super.setFields(fields);
            }

            public RequestSync setKey(String key) {
                return (RequestSync)super.setKey(key);
            }

            public RequestSync setOauthToken(String oauthToken) {
                return (RequestSync)super.setOauthToken(oauthToken);
            }

            public RequestSync setPrettyPrint(Boolean prettyPrint) {
                return (RequestSync)super.setPrettyPrint(prettyPrint);
            }

            public RequestSync setQuotaUser(String quotaUser) {
                return (RequestSync)super.setQuotaUser(quotaUser);
            }

            public RequestSync setUploadType(String uploadType) {
                return (RequestSync)super.setUploadType(uploadType);
            }

            public RequestSync setUploadProtocol(String uploadProtocol) {
                return (RequestSync)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public RequestSync set(String parameterName, Object value) {
                return (RequestSync)super.set(parameterName, value);
            }
        }

        public class ReportStateAndNotification
        extends HomeGraphServiceRequest<ReportStateAndNotificationResponse> {
            private static final String REST_PATH = "v1/devices:reportStateAndNotification";

            protected ReportStateAndNotification(ReportStateAndNotificationRequest content) {
                super(HomeGraphService.this, "POST", REST_PATH, (Object)content, ReportStateAndNotificationResponse.class);
            }

            public ReportStateAndNotification set$Xgafv(String $Xgafv) {
                return (ReportStateAndNotification)super.set$Xgafv($Xgafv);
            }

            public ReportStateAndNotification setAccessToken(String accessToken) {
                return (ReportStateAndNotification)super.setAccessToken(accessToken);
            }

            public ReportStateAndNotification setAlt(String alt) {
                return (ReportStateAndNotification)super.setAlt(alt);
            }

            public ReportStateAndNotification setCallback(String callback) {
                return (ReportStateAndNotification)super.setCallback(callback);
            }

            public ReportStateAndNotification setFields(String fields) {
                return (ReportStateAndNotification)super.setFields(fields);
            }

            public ReportStateAndNotification setKey(String key) {
                return (ReportStateAndNotification)super.setKey(key);
            }

            public ReportStateAndNotification setOauthToken(String oauthToken) {
                return (ReportStateAndNotification)super.setOauthToken(oauthToken);
            }

            public ReportStateAndNotification setPrettyPrint(Boolean prettyPrint) {
                return (ReportStateAndNotification)super.setPrettyPrint(prettyPrint);
            }

            public ReportStateAndNotification setQuotaUser(String quotaUser) {
                return (ReportStateAndNotification)super.setQuotaUser(quotaUser);
            }

            public ReportStateAndNotification setUploadType(String uploadType) {
                return (ReportStateAndNotification)super.setUploadType(uploadType);
            }

            public ReportStateAndNotification setUploadProtocol(String uploadProtocol) {
                return (ReportStateAndNotification)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public ReportStateAndNotification set(String parameterName, Object value) {
                return (ReportStateAndNotification)super.set(parameterName, value);
            }
        }

        public class Query
        extends HomeGraphServiceRequest<QueryResponse> {
            private static final String REST_PATH = "v1/devices:query";

            protected Query(QueryRequest content) {
                super(HomeGraphService.this, "POST", REST_PATH, (Object)content, QueryResponse.class);
            }

            public Query set$Xgafv(String $Xgafv) {
                return (Query)super.set$Xgafv($Xgafv);
            }

            public Query setAccessToken(String accessToken) {
                return (Query)super.setAccessToken(accessToken);
            }

            public Query setAlt(String alt) {
                return (Query)super.setAlt(alt);
            }

            public Query setCallback(String callback) {
                return (Query)super.setCallback(callback);
            }

            public Query setFields(String fields) {
                return (Query)super.setFields(fields);
            }

            public Query setKey(String key) {
                return (Query)super.setKey(key);
            }

            public Query setOauthToken(String oauthToken) {
                return (Query)super.setOauthToken(oauthToken);
            }

            public Query setPrettyPrint(Boolean prettyPrint) {
                return (Query)super.setPrettyPrint(prettyPrint);
            }

            public Query setQuotaUser(String quotaUser) {
                return (Query)super.setQuotaUser(quotaUser);
            }

            public Query setUploadType(String uploadType) {
                return (Query)super.setUploadType(uploadType);
            }

            public Query setUploadProtocol(String uploadProtocol) {
                return (Query)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Query set(String parameterName, Object value) {
                return (Query)super.set(parameterName, value);
            }
        }
    }

    public class AgentUsers {
        public Delete delete(String agentUserId) throws IOException {
            Delete result = new Delete(agentUserId);
            HomeGraphService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Delete
        extends HomeGraphServiceRequest<Empty> {
            private static final String REST_PATH = "v1/{+agentUserId}";
            private final Pattern AGENT_USER_ID_PATTERN;
            @Key
            private String agentUserId;
            @Key
            private String requestId;

            protected Delete(String agentUserId) {
                super(HomeGraphService.this, "DELETE", REST_PATH, null, Empty.class);
                this.AGENT_USER_ID_PATTERN = Pattern.compile("^agentUsers/.*$");
                this.agentUserId = (String)Preconditions.checkNotNull((Object)agentUserId, (Object)"Required parameter agentUserId must be specified.");
                if (!HomeGraphService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.AGENT_USER_ID_PATTERN.matcher(agentUserId).matches(), (Object)"Parameter agentUserId must conform to the pattern ^agentUsers/.*$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getAgentUserId() {
                return this.agentUserId;
            }

            public Delete setAgentUserId(String agentUserId) {
                if (!HomeGraphService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.AGENT_USER_ID_PATTERN.matcher(agentUserId).matches(), (Object)"Parameter agentUserId must conform to the pattern ^agentUsers/.*$");
                }
                this.agentUserId = agentUserId;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }
}

