/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1;

/**
 * Service definition for Iam (v1).
 *
 * <p>
 * Manages identity and access control for Google Cloud Platform resources, including the creation of service accounts, which you can use to authenticate to Google and make API calls. 
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/iam/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link IamRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Iam extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.30.10 of the Identity and Access Management (IAM) API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://iam.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Iam(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Iam(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the IamPolicies collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Iam iam = new Iam(...);}
   *   {@code Iam.IamPolicies.List request = iam.iamPolicies().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public IamPolicies iamPolicies() {
    return new IamPolicies();
  }

  /**
   * The "iamPolicies" collection of methods.
   */
  public class IamPolicies {

    /**
     * Lints, or validates, an IAM policy. Currently checks the google.iam.v1.Binding.condition field,
     * which contains a condition expression for a role binding. Successful calls to this method always
     * return an HTTP `200 OK` status code, even if the linter detects an issue in the IAM policy.
     *
     * Create a request for the method "iamPolicies.lintPolicy".
     *
     * This request holds the parameters needed by the iam server.  After setting any optional
     * parameters, call the {@link LintPolicy#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.iam.v1.model.LintPolicyRequest}
     * @return the request
     */
    public LintPolicy lintPolicy(com.google.api.services.iam.v1.model.LintPolicyRequest content) throws java.io.IOException {
      LintPolicy result = new LintPolicy(content);
      initialize(result);
      return result;
    }

    public class LintPolicy extends IamRequest<com.google.api.services.iam.v1.model.LintPolicyResponse> {

      private static final String REST_PATH = "v1/iamPolicies:lintPolicy";

      /**
       * Lints, or validates, an IAM policy. Currently checks the google.iam.v1.Binding.condition field,
       * which contains a condition expression for a role binding. Successful calls to this method
       * always return an HTTP `200 OK` status code, even if the linter detects an issue in the IAM
       * policy.
       *
       * Create a request for the method "iamPolicies.lintPolicy".
       *
       * This request holds the parameters needed by the the iam server.  After setting any optional
       * parameters, call the {@link LintPolicy#execute()} method to invoke the remote operation. <p>
       * {@link
       * LintPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.iam.v1.model.LintPolicyRequest}
       * @since 1.13
       */
      protected LintPolicy(com.google.api.services.iam.v1.model.LintPolicyRequest content) {
        super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.LintPolicyResponse.class);
      }

      @Override
      public LintPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (LintPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public LintPolicy setAccessToken(java.lang.String accessToken) {
        return (LintPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public LintPolicy setAlt(java.lang.String alt) {
        return (LintPolicy) super.setAlt(alt);
      }

      @Override
      public LintPolicy setCallback(java.lang.String callback) {
        return (LintPolicy) super.setCallback(callback);
      }

      @Override
      public LintPolicy setFields(java.lang.String fields) {
        return (LintPolicy) super.setFields(fields);
      }

      @Override
      public LintPolicy setKey(java.lang.String key) {
        return (LintPolicy) super.setKey(key);
      }

      @Override
      public LintPolicy setOauthToken(java.lang.String oauthToken) {
        return (LintPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public LintPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (LintPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public LintPolicy setQuotaUser(java.lang.String quotaUser) {
        return (LintPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public LintPolicy setUploadType(java.lang.String uploadType) {
        return (LintPolicy) super.setUploadType(uploadType);
      }

      @Override
      public LintPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (LintPolicy) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public LintPolicy set(String parameterName, Object value) {
        return (LintPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of services that allow you to opt into audit logs that are not generated by
     * default. To learn more about audit logs, see the [Logging
     * documentation](https://cloud.google.com/logging/docs/audit).
     *
     * Create a request for the method "iamPolicies.queryAuditableServices".
     *
     * This request holds the parameters needed by the iam server.  After setting any optional
     * parameters, call the {@link QueryAuditableServices#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.iam.v1.model.QueryAuditableServicesRequest}
     * @return the request
     */
    public QueryAuditableServices queryAuditableServices(com.google.api.services.iam.v1.model.QueryAuditableServicesRequest content) throws java.io.IOException {
      QueryAuditableServices result = new QueryAuditableServices(content);
      initialize(result);
      return result;
    }

    public class QueryAuditableServices extends IamRequest<com.google.api.services.iam.v1.model.QueryAuditableServicesResponse> {

      private static final String REST_PATH = "v1/iamPolicies:queryAuditableServices";

      /**
       * Returns a list of services that allow you to opt into audit logs that are not generated by
       * default. To learn more about audit logs, see the [Logging
       * documentation](https://cloud.google.com/logging/docs/audit).
       *
       * Create a request for the method "iamPolicies.queryAuditableServices".
       *
       * This request holds the parameters needed by the the iam server.  After setting any optional
       * parameters, call the {@link QueryAuditableServices#execute()} method to invoke the remote
       * operation. <p> {@link QueryAuditableServices#initialize(com.google.api.client.googleapis.servic
       * es.AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.iam.v1.model.QueryAuditableServicesRequest}
       * @since 1.13
       */
      protected QueryAuditableServices(com.google.api.services.iam.v1.model.QueryAuditableServicesRequest content) {
        super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.QueryAuditableServicesResponse.class);
      }

      @Override
      public QueryAuditableServices set$Xgafv(java.lang.String $Xgafv) {
        return (QueryAuditableServices) super.set$Xgafv($Xgafv);
      }

      @Override
      public QueryAuditableServices setAccessToken(java.lang.String accessToken) {
        return (QueryAuditableServices) super.setAccessToken(accessToken);
      }

      @Override
      public QueryAuditableServices setAlt(java.lang.String alt) {
        return (QueryAuditableServices) super.setAlt(alt);
      }

      @Override
      public QueryAuditableServices setCallback(java.lang.String callback) {
        return (QueryAuditableServices) super.setCallback(callback);
      }

      @Override
      public QueryAuditableServices setFields(java.lang.String fields) {
        return (QueryAuditableServices) super.setFields(fields);
      }

      @Override
      public QueryAuditableServices setKey(java.lang.String key) {
        return (QueryAuditableServices) super.setKey(key);
      }

      @Override
      public QueryAuditableServices setOauthToken(java.lang.String oauthToken) {
        return (QueryAuditableServices) super.setOauthToken(oauthToken);
      }

      @Override
      public QueryAuditableServices setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (QueryAuditableServices) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public QueryAuditableServices setQuotaUser(java.lang.String quotaUser) {
        return (QueryAuditableServices) super.setQuotaUser(quotaUser);
      }

      @Override
      public QueryAuditableServices setUploadType(java.lang.String uploadType) {
        return (QueryAuditableServices) super.setUploadType(uploadType);
      }

      @Override
      public QueryAuditableServices setUploadProtocol(java.lang.String uploadProtocol) {
        return (QueryAuditableServices) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public QueryAuditableServices set(String parameterName, Object value) {
        return (QueryAuditableServices) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Organizations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Iam iam = new Iam(...);}
   *   {@code Iam.Organizations.List request = iam.organizations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Organizations organizations() {
    return new Organizations();
  }

  /**
   * The "organizations" collection of methods.
   */
  public class Organizations {

    /**
     * An accessor for creating requests from the Roles collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Iam iam = new Iam(...);}
     *   {@code Iam.Roles.List request = iam.roles().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Roles roles() {
      return new Roles();
    }

    /**
     * The "roles" collection of methods.
     */
    public class Roles {

      /**
       * Creates a new custom Role.
       *
       * Create a request for the method "roles.create".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent The `parent` parameter's value depends on the target resource for the request, namely
       *        [`projects`](/iam/reference/rest/v1/projects.roles) or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
       *        `parent` value format is described below: *
       *        [`projects.roles.create()`](/iam/reference/rest/v1/projects.roles/create):
       *        `projects/{PROJECT_ID}`. This method creates project-level [custom roles](/iam/docs
       *        /understanding-custom-roles). Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
       *        [`organizations.roles.create()`](/iam/reference/rest/v1/organizations.roles/create):
       *        `organizations/{ORGANIZATION_ID}`. This method creates organization-level [custom
       *        roles](/iam/docs/understanding-custom-roles). Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*)
       *        values are invalid; you must specify a complete project ID or organization ID.
       * @param content the {@link com.google.api.services.iam.v1.model.CreateRoleRequest}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.iam.v1.model.CreateRoleRequest content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends IamRequest<com.google.api.services.iam.v1.model.Role> {

        private static final String REST_PATH = "v1/{+parent}/roles";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^organizations/[^/]+$");

        /**
         * Creates a new custom Role.
         *
         * Create a request for the method "roles.create".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent The `parent` parameter's value depends on the target resource for the request, namely
       *        [`projects`](/iam/reference/rest/v1/projects.roles) or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
       *        `parent` value format is described below: *
       *        [`projects.roles.create()`](/iam/reference/rest/v1/projects.roles/create):
       *        `projects/{PROJECT_ID}`. This method creates project-level [custom roles](/iam/docs
       *        /understanding-custom-roles). Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
       *        [`organizations.roles.create()`](/iam/reference/rest/v1/organizations.roles/create):
       *        `organizations/{ORGANIZATION_ID}`. This method creates organization-level [custom
       *        roles](/iam/docs/understanding-custom-roles). Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*)
       *        values are invalid; you must specify a complete project ID or organization ID.
         * @param content the {@link com.google.api.services.iam.v1.model.CreateRoleRequest}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.iam.v1.model.CreateRoleRequest content) {
          super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.Role.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^organizations/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The `parent` parameter's value depends on the target resource for the request, namely
         * [`projects`](/iam/reference/rest/v1/projects.roles) or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `parent` value format is described below: *
         * [`projects.roles.create()`](/iam/reference/rest/v1/projects.roles/create):
         * `projects/{PROJECT_ID}`. This method creates project-level [custom roles](/iam/docs
         * /understanding-custom-roles). Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
         * [`organizations.roles.create()`](/iam/reference/rest/v1/organizations.roles/create):
         * `organizations/{ORGANIZATION_ID}`. This method creates organization-level [custom
         * roles](/iam/docs/understanding-custom-roles). Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*)
         * values are invalid; you must specify a complete project ID or organization ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** The `parent` parameter's value depends on the target resource for the request, namely
       [`projects`](/iam/reference/rest/v1/projects.roles) or
       [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `parent` value
       format is described below: *
       [`projects.roles.create()`](/iam/reference/rest/v1/projects.roles/create): `projects/{PROJECT_ID}`.
       This method creates project-level [custom roles](/iam/docs/understanding-custom-roles). Example
       request URL: `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
       [`organizations.roles.create()`](/iam/reference/rest/v1/organizations.roles/create):
       `organizations/{ORGANIZATION_ID}`. This method creates organization-level [custom roles](/iam/docs
       /understanding-custom-roles). Example request URL:
       `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*) values are
       invalid; you must specify a complete project ID or organization ID.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * The `parent` parameter's value depends on the target resource for the request, namely
         * [`projects`](/iam/reference/rest/v1/projects.roles) or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `parent` value format is described below: *
         * [`projects.roles.create()`](/iam/reference/rest/v1/projects.roles/create):
         * `projects/{PROJECT_ID}`. This method creates project-level [custom roles](/iam/docs
         * /understanding-custom-roles). Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
         * [`organizations.roles.create()`](/iam/reference/rest/v1/organizations.roles/create):
         * `organizations/{ORGANIZATION_ID}`. This method creates organization-level [custom
         * roles](/iam/docs/understanding-custom-roles). Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*)
         * values are invalid; you must specify a complete project ID or organization ID.
         */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^organizations/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a custom Role. When you delete a custom role, the following changes occur immediately: *
       * You cannot bind a member to the custom role in an IAM Policy. * Existing bindings to the custom
       * role are not changed, but they have no effect. * By default, the response from ListRoles does not
       * include the custom role. You have 7 days to undelete the custom role. After 7 days, the following
       * changes occur: * The custom role is permanently deleted and cannot be recovered. * If an IAM
       * policy contains a binding to the custom role, the binding is permanently removed.
       *
       * Create a request for the method "roles.delete".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name The `name` parameter's value depends on the target resource for the request, namely
       *        [`projects`](/iam/reference/rest/v1/projects.roles) or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
       *        value format is described below: *
       *        [`projects.roles.delete()`](/iam/reference/rest/v1/projects.roles/delete):
       *        `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
       *        Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       *        [`organizations.roles.delete()`](/iam/reference/rest/v1/organizations.roles/delete):
       *        `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the organization
       *        level. Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
       *        Note: Wildcard (*) values are invalid; you must specify a complete project ID or
       *        organization ID.
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends IamRequest<com.google.api.services.iam.v1.model.Role> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^organizations/[^/]+/roles/[^/]+$");

        /**
         * Deletes a custom Role. When you delete a custom role, the following changes occur immediately:
         * * You cannot bind a member to the custom role in an IAM Policy. * Existing bindings to the
         * custom role are not changed, but they have no effect. * By default, the response from ListRoles
         * does not include the custom role. You have 7 days to undelete the custom role. After 7 days,
         * the following changes occur: * The custom role is permanently deleted and cannot be recovered.
         * * If an IAM policy contains a binding to the custom role, the binding is permanently removed.
         *
         * Create a request for the method "roles.delete".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The `name` parameter's value depends on the target resource for the request, namely
       *        [`projects`](/iam/reference/rest/v1/projects.roles) or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
       *        value format is described below: *
       *        [`projects.roles.delete()`](/iam/reference/rest/v1/projects.roles/delete):
       *        `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
       *        Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       *        [`organizations.roles.delete()`](/iam/reference/rest/v1/organizations.roles/delete):
       *        `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the organization
       *        level. Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
       *        Note: Wildcard (*) values are invalid; you must specify a complete project ID or
       *        organization ID.
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(Iam.this, "DELETE", REST_PATH, null, com.google.api.services.iam.v1.model.Role.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^organizations/[^/]+/roles/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The `name` parameter's value depends on the target resource for the request, namely
         * [`projects`](/iam/reference/rest/v1/projects.roles) or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `name` value format is described below: *
         * [`projects.roles.delete()`](/iam/reference/rest/v1/projects.roles/delete):
         * `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only [custom
         * roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
         * Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
         * [`organizations.roles.delete()`](/iam/reference/rest/v1/organizations.roles/delete):
         * `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only
         * [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
         * organization level. Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
         * Note: Wildcard (*) values are invalid; you must specify a complete project ID or
         * organization ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The `name` parameter's value depends on the target resource for the request, namely
       [`projects`](/iam/reference/rest/v1/projects.roles) or
       [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name` value
       format is described below: *
       [`projects.roles.delete()`](/iam/reference/rest/v1/projects.roles/delete):
       `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only [custom roles](/iam/docs
       /understanding-custom-roles) that have been created at the project level. Example request URL:
       `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       [`organizations.roles.delete()`](/iam/reference/rest/v1/organizations.roles/delete):
       `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only [custom
       roles](/iam/docs/understanding-custom-roles) that have been created at the organization level.
       Example request URL:
       `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}` Note:
       Wildcard (*) values are invalid; you must specify a complete project ID or organization ID.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The `name` parameter's value depends on the target resource for the request, namely
         * [`projects`](/iam/reference/rest/v1/projects.roles) or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `name` value format is described below: *
         * [`projects.roles.delete()`](/iam/reference/rest/v1/projects.roles/delete):
         * `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only [custom
         * roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
         * Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
         * [`organizations.roles.delete()`](/iam/reference/rest/v1/organizations.roles/delete):
         * `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only
         * [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
         * organization level. Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
         * Note: Wildcard (*) values are invalid; you must specify a complete project ID or
         * organization ID.
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^organizations/[^/]+/roles/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /** Used to perform a consistent read-modify-write. */
        @com.google.api.client.util.Key
        private java.lang.String etag;

        /** Used to perform a consistent read-modify-write.
         */
        public java.lang.String getEtag() {
          return etag;
        }

        /** Used to perform a consistent read-modify-write. */
        public Delete setEtag(java.lang.String etag) {
          this.etag = etag;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets the definition of a Role.
       *
       * Create a request for the method "roles.get".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name The `name` parameter's value depends on the target resource for the request, namely
       *        [`roles`](/iam/reference/rest/v1/roles),
       *        [`projects`](/iam/reference/rest/v1/projects.roles), or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
       *        value format is described below: * [`roles.get()`](/iam/reference/rest/v1/roles/get):
       *        `roles/{ROLE_NAME}`. This method returns results from all [predefined roles](/iam/docs
       *        /understanding-roles#predefined_roles) in Cloud IAM. Example request URL:
       *        `https://iam.googleapis.com/v1/roles/{ROLE_NAME}` *
       *        [`projects.roles.get()`](/iam/reference/rest/v1/projects.roles/get):
       *        `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
       *        Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       *        [`organizations.roles.get()`](/iam/reference/rest/v1/organizations.roles/get):
       *        `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the organization
       *        level. Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
       *        Note: Wildcard (*) values are invalid; you must specify a complete project ID or
       *        organization ID.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends IamRequest<com.google.api.services.iam.v1.model.Role> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^organizations/[^/]+/roles/[^/]+$");

        /**
         * Gets the definition of a Role.
         *
         * Create a request for the method "roles.get".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The `name` parameter's value depends on the target resource for the request, namely
       *        [`roles`](/iam/reference/rest/v1/roles),
       *        [`projects`](/iam/reference/rest/v1/projects.roles), or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
       *        value format is described below: * [`roles.get()`](/iam/reference/rest/v1/roles/get):
       *        `roles/{ROLE_NAME}`. This method returns results from all [predefined roles](/iam/docs
       *        /understanding-roles#predefined_roles) in Cloud IAM. Example request URL:
       *        `https://iam.googleapis.com/v1/roles/{ROLE_NAME}` *
       *        [`projects.roles.get()`](/iam/reference/rest/v1/projects.roles/get):
       *        `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
       *        Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       *        [`organizations.roles.get()`](/iam/reference/rest/v1/organizations.roles/get):
       *        `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the organization
       *        level. Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
       *        Note: Wildcard (*) values are invalid; you must specify a complete project ID or
       *        organization ID.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Iam.this, "GET", REST_PATH, null, com.google.api.services.iam.v1.model.Role.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^organizations/[^/]+/roles/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The `name` parameter's value depends on the target resource for the request, namely
         * [`roles`](/iam/reference/rest/v1/roles),
         * [`projects`](/iam/reference/rest/v1/projects.roles), or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `name` value format is described below: *
         * [`roles.get()`](/iam/reference/rest/v1/roles/get): `roles/{ROLE_NAME}`. This method
         * returns results from all [predefined roles](/iam/docs/understanding-
         * roles#predefined_roles) in Cloud IAM. Example request URL:
         * `https://iam.googleapis.com/v1/roles/{ROLE_NAME}` *
         * [`projects.roles.get()`](/iam/reference/rest/v1/projects.roles/get):
         * `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
         * roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
         * Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
         * [`organizations.roles.get()`](/iam/reference/rest/v1/organizations.roles/get):
         * `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only
         * [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
         * organization level. Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
         * Note: Wildcard (*) values are invalid; you must specify a complete project ID or
         * organization ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The `name` parameter's value depends on the target resource for the request, namely
       [`roles`](/iam/reference/rest/v1/roles), [`projects`](/iam/reference/rest/v1/projects.roles), or
       [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name` value
       format is described below: * [`roles.get()`](/iam/reference/rest/v1/roles/get):
       `roles/{ROLE_NAME}`. This method returns results from all [predefined roles](/iam/docs
       /understanding-roles#predefined_roles) in Cloud IAM. Example request URL:
       `https://iam.googleapis.com/v1/roles/{ROLE_NAME}` *
       [`projects.roles.get()`](/iam/reference/rest/v1/projects.roles/get):
       `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom roles](/iam/docs
       /understanding-custom-roles) that have been created at the project level. Example request URL:
       `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       [`organizations.roles.get()`](/iam/reference/rest/v1/organizations.roles/get):
       `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
       roles](/iam/docs/understanding-custom-roles) that have been created at the organization level.
       Example request URL:
       `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}` Note:
       Wildcard (*) values are invalid; you must specify a complete project ID or organization ID.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The `name` parameter's value depends on the target resource for the request, namely
         * [`roles`](/iam/reference/rest/v1/roles),
         * [`projects`](/iam/reference/rest/v1/projects.roles), or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `name` value format is described below: *
         * [`roles.get()`](/iam/reference/rest/v1/roles/get): `roles/{ROLE_NAME}`. This method
         * returns results from all [predefined roles](/iam/docs/understanding-
         * roles#predefined_roles) in Cloud IAM. Example request URL:
         * `https://iam.googleapis.com/v1/roles/{ROLE_NAME}` *
         * [`projects.roles.get()`](/iam/reference/rest/v1/projects.roles/get):
         * `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
         * roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
         * Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
         * [`organizations.roles.get()`](/iam/reference/rest/v1/organizations.roles/get):
         * `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only
         * [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
         * organization level. Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
         * Note: Wildcard (*) values are invalid; you must specify a complete project ID or
         * organization ID.
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^organizations/[^/]+/roles/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists every predefined Role that IAM supports, or every custom role that is defined for an
       * organization or project.
       *
       * Create a request for the method "roles.list".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param parent The `parent` parameter's value depends on the target resource for the request, namely
       *        [`roles`](/iam/reference/rest/v1/roles),
       *        [`projects`](/iam/reference/rest/v1/projects.roles), or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
       *        `parent` value format is described below: *
       *        [`roles.list()`](/iam/reference/rest/v1/roles/list): An empty string. This method doesn't
       *        require a resource; it simply returns all [predefined roles](/iam/docs/understanding-
       *        roles#predefined_roles) in Cloud IAM. Example request URL:
       *        `https://iam.googleapis.com/v1/roles` *
       *        [`projects.roles.list()`](/iam/reference/rest/v1/projects.roles/list):
       *        `projects/{PROJECT_ID}`. This method lists all project-level [custom roles](/iam/docs
       *        /understanding-custom-roles). Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
       *        [`organizations.roles.list()`](/iam/reference/rest/v1/organizations.roles/list):
       *        `organizations/{ORGANIZATION_ID}`. This method lists all organization-level [custom
       *        roles](/iam/docs/understanding-custom-roles). Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*)
       *        values are invalid; you must specify a complete project ID or organization ID.
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends IamRequest<com.google.api.services.iam.v1.model.ListRolesResponse> {

        private static final String REST_PATH = "v1/{+parent}/roles";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^organizations/[^/]+$");

        /**
         * Lists every predefined Role that IAM supports, or every custom role that is defined for an
         * organization or project.
         *
         * Create a request for the method "roles.list".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent The `parent` parameter's value depends on the target resource for the request, namely
       *        [`roles`](/iam/reference/rest/v1/roles),
       *        [`projects`](/iam/reference/rest/v1/projects.roles), or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
       *        `parent` value format is described below: *
       *        [`roles.list()`](/iam/reference/rest/v1/roles/list): An empty string. This method doesn't
       *        require a resource; it simply returns all [predefined roles](/iam/docs/understanding-
       *        roles#predefined_roles) in Cloud IAM. Example request URL:
       *        `https://iam.googleapis.com/v1/roles` *
       *        [`projects.roles.list()`](/iam/reference/rest/v1/projects.roles/list):
       *        `projects/{PROJECT_ID}`. This method lists all project-level [custom roles](/iam/docs
       *        /understanding-custom-roles). Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
       *        [`organizations.roles.list()`](/iam/reference/rest/v1/organizations.roles/list):
       *        `organizations/{ORGANIZATION_ID}`. This method lists all organization-level [custom
       *        roles](/iam/docs/understanding-custom-roles). Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*)
       *        values are invalid; you must specify a complete project ID or organization ID.
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(Iam.this, "GET", REST_PATH, null, com.google.api.services.iam.v1.model.ListRolesResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^organizations/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The `parent` parameter's value depends on the target resource for the request, namely
         * [`roles`](/iam/reference/rest/v1/roles),
         * [`projects`](/iam/reference/rest/v1/projects.roles), or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `parent` value format is described below: *
         * [`roles.list()`](/iam/reference/rest/v1/roles/list): An empty string. This method doesn't
         * require a resource; it simply returns all [predefined roles](/iam/docs/understanding-
         * roles#predefined_roles) in Cloud IAM. Example request URL:
         * `https://iam.googleapis.com/v1/roles` *
         * [`projects.roles.list()`](/iam/reference/rest/v1/projects.roles/list):
         * `projects/{PROJECT_ID}`. This method lists all project-level [custom roles](/iam/docs
         * /understanding-custom-roles). Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
         * [`organizations.roles.list()`](/iam/reference/rest/v1/organizations.roles/list):
         * `organizations/{ORGANIZATION_ID}`. This method lists all organization-level [custom
         * roles](/iam/docs/understanding-custom-roles). Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*)
         * values are invalid; you must specify a complete project ID or organization ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** The `parent` parameter's value depends on the target resource for the request, namely
       [`roles`](/iam/reference/rest/v1/roles), [`projects`](/iam/reference/rest/v1/projects.roles), or
       [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `parent` value
       format is described below: * [`roles.list()`](/iam/reference/rest/v1/roles/list): An empty string.
       This method doesn't require a resource; it simply returns all [predefined roles](/iam/docs
       /understanding-roles#predefined_roles) in Cloud IAM. Example request URL:
       `https://iam.googleapis.com/v1/roles` *
       [`projects.roles.list()`](/iam/reference/rest/v1/projects.roles/list): `projects/{PROJECT_ID}`.
       This method lists all project-level [custom roles](/iam/docs/understanding-custom-roles). Example
       request URL: `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
       [`organizations.roles.list()`](/iam/reference/rest/v1/organizations.roles/list):
       `organizations/{ORGANIZATION_ID}`. This method lists all organization-level [custom
       roles](/iam/docs/understanding-custom-roles). Example request URL:
       `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*) values are
       invalid; you must specify a complete project ID or organization ID.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * The `parent` parameter's value depends on the target resource for the request, namely
         * [`roles`](/iam/reference/rest/v1/roles),
         * [`projects`](/iam/reference/rest/v1/projects.roles), or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `parent` value format is described below: *
         * [`roles.list()`](/iam/reference/rest/v1/roles/list): An empty string. This method doesn't
         * require a resource; it simply returns all [predefined roles](/iam/docs/understanding-
         * roles#predefined_roles) in Cloud IAM. Example request URL:
         * `https://iam.googleapis.com/v1/roles` *
         * [`projects.roles.list()`](/iam/reference/rest/v1/projects.roles/list):
         * `projects/{PROJECT_ID}`. This method lists all project-level [custom roles](/iam/docs
         * /understanding-custom-roles). Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
         * [`organizations.roles.list()`](/iam/reference/rest/v1/organizations.roles/list):
         * `organizations/{ORGANIZATION_ID}`. This method lists all organization-level [custom
         * roles](/iam/docs/understanding-custom-roles). Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*)
         * values are invalid; you must specify a complete project ID or organization ID.
         */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^organizations/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * Optional limit on the number of roles to include in the response. The default is 300, and
         * the maximum is 1,000.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** Optional limit on the number of roles to include in the response. The default is 300, and the
       maximum is 1,000.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * Optional limit on the number of roles to include in the response. The default is 300, and
         * the maximum is 1,000.
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /** Optional pagination token returned in an earlier ListRolesResponse. */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** Optional pagination token returned in an earlier ListRolesResponse.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /** Optional pagination token returned in an earlier ListRolesResponse. */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /** Include Roles that have been deleted. */
        @com.google.api.client.util.Key
        private java.lang.Boolean showDeleted;

        /** Include Roles that have been deleted.
         */
        public java.lang.Boolean getShowDeleted() {
          return showDeleted;
        }

        /** Include Roles that have been deleted. */
        public List setShowDeleted(java.lang.Boolean showDeleted) {
          this.showDeleted = showDeleted;
          return this;
        }

        /**
         * Optional view for the returned Role objects. When `FULL` is specified, the
         * `includedPermissions` field is returned, which includes a list of all permissions in the
         * role. The default value is `BASIC`, which does not return the `includedPermissions`
         * field.
         */
        @com.google.api.client.util.Key
        private java.lang.String view;

        /** Optional view for the returned Role objects. When `FULL` is specified, the `includedPermissions`
       field is returned, which includes a list of all permissions in the role. The default value is
       `BASIC`, which does not return the `includedPermissions` field.
         */
        public java.lang.String getView() {
          return view;
        }

        /**
         * Optional view for the returned Role objects. When `FULL` is specified, the
         * `includedPermissions` field is returned, which includes a list of all permissions in the
         * role. The default value is `BASIC`, which does not return the `includedPermissions`
         * field.
         */
        public List setView(java.lang.String view) {
          this.view = view;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates the definition of a custom Role.
       *
       * Create a request for the method "roles.patch".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name The `name` parameter's value depends on the target resource for the request, namely
       *        [`projects`](/iam/reference/rest/v1/projects.roles) or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
       *        value format is described below: *
       *        [`projects.roles.patch()`](/iam/reference/rest/v1/projects.roles/patch):
       *        `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
       *        Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       *        [`organizations.roles.patch()`](/iam/reference/rest/v1/organizations.roles/patch):
       *        `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the organization
       *        level. Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
       *        Note: Wildcard (*) values are invalid; you must specify a complete project ID or
       *        organization ID.
       * @param content the {@link com.google.api.services.iam.v1.model.Role}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.iam.v1.model.Role content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends IamRequest<com.google.api.services.iam.v1.model.Role> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^organizations/[^/]+/roles/[^/]+$");

        /**
         * Updates the definition of a custom Role.
         *
         * Create a request for the method "roles.patch".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The `name` parameter's value depends on the target resource for the request, namely
       *        [`projects`](/iam/reference/rest/v1/projects.roles) or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
       *        value format is described below: *
       *        [`projects.roles.patch()`](/iam/reference/rest/v1/projects.roles/patch):
       *        `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
       *        Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       *        [`organizations.roles.patch()`](/iam/reference/rest/v1/organizations.roles/patch):
       *        `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the organization
       *        level. Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
       *        Note: Wildcard (*) values are invalid; you must specify a complete project ID or
       *        organization ID.
         * @param content the {@link com.google.api.services.iam.v1.model.Role}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.iam.v1.model.Role content) {
          super(Iam.this, "PATCH", REST_PATH, content, com.google.api.services.iam.v1.model.Role.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^organizations/[^/]+/roles/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The `name` parameter's value depends on the target resource for the request, namely
         * [`projects`](/iam/reference/rest/v1/projects.roles) or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `name` value format is described below: *
         * [`projects.roles.patch()`](/iam/reference/rest/v1/projects.roles/patch):
         * `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only [custom
         * roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
         * Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
         * [`organizations.roles.patch()`](/iam/reference/rest/v1/organizations.roles/patch):
         * `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only
         * [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
         * organization level. Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
         * Note: Wildcard (*) values are invalid; you must specify a complete project ID or
         * organization ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The `name` parameter's value depends on the target resource for the request, namely
       [`projects`](/iam/reference/rest/v1/projects.roles) or
       [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name` value
       format is described below: *
       [`projects.roles.patch()`](/iam/reference/rest/v1/projects.roles/patch):
       `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only [custom roles](/iam/docs
       /understanding-custom-roles) that have been created at the project level. Example request URL:
       `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       [`organizations.roles.patch()`](/iam/reference/rest/v1/organizations.roles/patch):
       `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only [custom
       roles](/iam/docs/understanding-custom-roles) that have been created at the organization level.
       Example request URL:
       `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}` Note:
       Wildcard (*) values are invalid; you must specify a complete project ID or organization ID.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The `name` parameter's value depends on the target resource for the request, namely
         * [`projects`](/iam/reference/rest/v1/projects.roles) or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `name` value format is described below: *
         * [`projects.roles.patch()`](/iam/reference/rest/v1/projects.roles/patch):
         * `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only [custom
         * roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
         * Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
         * [`organizations.roles.patch()`](/iam/reference/rest/v1/organizations.roles/patch):
         * `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only
         * [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
         * organization level. Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
         * Note: Wildcard (*) values are invalid; you must specify a complete project ID or
         * organization ID.
         */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^organizations/[^/]+/roles/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /** A mask describing which fields in the Role have changed. */
        @com.google.api.client.util.Key
        private String updateMask;

        /** A mask describing which fields in the Role have changed.
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /** A mask describing which fields in the Role have changed. */
        public Patch setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Undeletes a custom Role.
       *
       * Create a request for the method "roles.undelete".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Undelete#execute()} method to invoke the remote operation.
       *
       * @param name The `name` parameter's value depends on the target resource for the request, namely
       *        [`projects`](/iam/reference/rest/v1/projects.roles) or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
       *        value format is described below: *
       *        [`projects.roles.undelete()`](/iam/reference/rest/v1/projects.roles/undelete):
       *        `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
       *        Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       *        [`organizations.roles.undelete()`](/iam/reference/rest/v1/organizations.roles/undelete):
       *        `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only
       *        [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
       *        organization level. Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
       *        Note: Wildcard (*) values are invalid; you must specify a complete project ID or
       *        organization ID.
       * @param content the {@link com.google.api.services.iam.v1.model.UndeleteRoleRequest}
       * @return the request
       */
      public Undelete undelete(java.lang.String name, com.google.api.services.iam.v1.model.UndeleteRoleRequest content) throws java.io.IOException {
        Undelete result = new Undelete(name, content);
        initialize(result);
        return result;
      }

      public class Undelete extends IamRequest<com.google.api.services.iam.v1.model.Role> {

        private static final String REST_PATH = "v1/{+name}:undelete";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^organizations/[^/]+/roles/[^/]+$");

        /**
         * Undeletes a custom Role.
         *
         * Create a request for the method "roles.undelete".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Undelete#execute()} method to invoke the remote operation. <p>
         * {@link
         * Undelete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The `name` parameter's value depends on the target resource for the request, namely
       *        [`projects`](/iam/reference/rest/v1/projects.roles) or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
       *        value format is described below: *
       *        [`projects.roles.undelete()`](/iam/reference/rest/v1/projects.roles/undelete):
       *        `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
       *        Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       *        [`organizations.roles.undelete()`](/iam/reference/rest/v1/organizations.roles/undelete):
       *        `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only
       *        [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
       *        organization level. Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
       *        Note: Wildcard (*) values are invalid; you must specify a complete project ID or
       *        organization ID.
         * @param content the {@link com.google.api.services.iam.v1.model.UndeleteRoleRequest}
         * @since 1.13
         */
        protected Undelete(java.lang.String name, com.google.api.services.iam.v1.model.UndeleteRoleRequest content) {
          super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.Role.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^organizations/[^/]+/roles/[^/]+$");
          }
        }

        @Override
        public Undelete set$Xgafv(java.lang.String $Xgafv) {
          return (Undelete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Undelete setAccessToken(java.lang.String accessToken) {
          return (Undelete) super.setAccessToken(accessToken);
        }

        @Override
        public Undelete setAlt(java.lang.String alt) {
          return (Undelete) super.setAlt(alt);
        }

        @Override
        public Undelete setCallback(java.lang.String callback) {
          return (Undelete) super.setCallback(callback);
        }

        @Override
        public Undelete setFields(java.lang.String fields) {
          return (Undelete) super.setFields(fields);
        }

        @Override
        public Undelete setKey(java.lang.String key) {
          return (Undelete) super.setKey(key);
        }

        @Override
        public Undelete setOauthToken(java.lang.String oauthToken) {
          return (Undelete) super.setOauthToken(oauthToken);
        }

        @Override
        public Undelete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Undelete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Undelete setQuotaUser(java.lang.String quotaUser) {
          return (Undelete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Undelete setUploadType(java.lang.String uploadType) {
          return (Undelete) super.setUploadType(uploadType);
        }

        @Override
        public Undelete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Undelete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The `name` parameter's value depends on the target resource for the request, namely
         * [`projects`](/iam/reference/rest/v1/projects.roles) or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `name` value format is described below: *
         * [`projects.roles.undelete()`](/iam/reference/rest/v1/projects.roles/undelete):
         * `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only [custom
         * roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
         * Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
         * [`organizations.roles.undelete()`](/iam/reference/rest/v1/organizations.roles/undelete):
         * `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only
         * [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
         * organization level. Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
         * Note: Wildcard (*) values are invalid; you must specify a complete project ID or
         * organization ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The `name` parameter's value depends on the target resource for the request, namely
       [`projects`](/iam/reference/rest/v1/projects.roles) or
       [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name` value
       format is described below: *
       [`projects.roles.undelete()`](/iam/reference/rest/v1/projects.roles/undelete):
       `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only [custom roles](/iam/docs
       /understanding-custom-roles) that have been created at the project level. Example request URL:
       `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       [`organizations.roles.undelete()`](/iam/reference/rest/v1/organizations.roles/undelete):
       `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only [custom
       roles](/iam/docs/understanding-custom-roles) that have been created at the organization level.
       Example request URL:
       `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}` Note:
       Wildcard (*) values are invalid; you must specify a complete project ID or organization ID.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The `name` parameter's value depends on the target resource for the request, namely
         * [`projects`](/iam/reference/rest/v1/projects.roles) or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `name` value format is described below: *
         * [`projects.roles.undelete()`](/iam/reference/rest/v1/projects.roles/undelete):
         * `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only [custom
         * roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
         * Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
         * [`organizations.roles.undelete()`](/iam/reference/rest/v1/organizations.roles/undelete):
         * `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only
         * [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
         * organization level. Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
         * Note: Wildcard (*) values are invalid; you must specify a complete project ID or
         * organization ID.
         */
        public Undelete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^organizations/[^/]+/roles/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Undelete set(String parameterName, Object value) {
          return (Undelete) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * An accessor for creating requests from the Permissions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Iam iam = new Iam(...);}
   *   {@code Iam.Permissions.List request = iam.permissions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Permissions permissions() {
    return new Permissions();
  }

  /**
   * The "permissions" collection of methods.
   */
  public class Permissions {

    /**
     * Lists every permission that you can test on a resource. A permission is testable if you can check
     * whether a member has that permission on the resource.
     *
     * Create a request for the method "permissions.queryTestablePermissions".
     *
     * This request holds the parameters needed by the iam server.  After setting any optional
     * parameters, call the {@link QueryTestablePermissions#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.iam.v1.model.QueryTestablePermissionsRequest}
     * @return the request
     */
    public QueryTestablePermissions queryTestablePermissions(com.google.api.services.iam.v1.model.QueryTestablePermissionsRequest content) throws java.io.IOException {
      QueryTestablePermissions result = new QueryTestablePermissions(content);
      initialize(result);
      return result;
    }

    public class QueryTestablePermissions extends IamRequest<com.google.api.services.iam.v1.model.QueryTestablePermissionsResponse> {

      private static final String REST_PATH = "v1/permissions:queryTestablePermissions";

      /**
       * Lists every permission that you can test on a resource. A permission is testable if you can
       * check whether a member has that permission on the resource.
       *
       * Create a request for the method "permissions.queryTestablePermissions".
       *
       * This request holds the parameters needed by the the iam server.  After setting any optional
       * parameters, call the {@link QueryTestablePermissions#execute()} method to invoke the remote
       * operation. <p> {@link QueryTestablePermissions#initialize(com.google.api.client.googleapis.serv
       * ices.AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.iam.v1.model.QueryTestablePermissionsRequest}
       * @since 1.13
       */
      protected QueryTestablePermissions(com.google.api.services.iam.v1.model.QueryTestablePermissionsRequest content) {
        super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.QueryTestablePermissionsResponse.class);
      }

      @Override
      public QueryTestablePermissions set$Xgafv(java.lang.String $Xgafv) {
        return (QueryTestablePermissions) super.set$Xgafv($Xgafv);
      }

      @Override
      public QueryTestablePermissions setAccessToken(java.lang.String accessToken) {
        return (QueryTestablePermissions) super.setAccessToken(accessToken);
      }

      @Override
      public QueryTestablePermissions setAlt(java.lang.String alt) {
        return (QueryTestablePermissions) super.setAlt(alt);
      }

      @Override
      public QueryTestablePermissions setCallback(java.lang.String callback) {
        return (QueryTestablePermissions) super.setCallback(callback);
      }

      @Override
      public QueryTestablePermissions setFields(java.lang.String fields) {
        return (QueryTestablePermissions) super.setFields(fields);
      }

      @Override
      public QueryTestablePermissions setKey(java.lang.String key) {
        return (QueryTestablePermissions) super.setKey(key);
      }

      @Override
      public QueryTestablePermissions setOauthToken(java.lang.String oauthToken) {
        return (QueryTestablePermissions) super.setOauthToken(oauthToken);
      }

      @Override
      public QueryTestablePermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (QueryTestablePermissions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public QueryTestablePermissions setQuotaUser(java.lang.String quotaUser) {
        return (QueryTestablePermissions) super.setQuotaUser(quotaUser);
      }

      @Override
      public QueryTestablePermissions setUploadType(java.lang.String uploadType) {
        return (QueryTestablePermissions) super.setUploadType(uploadType);
      }

      @Override
      public QueryTestablePermissions setUploadProtocol(java.lang.String uploadProtocol) {
        return (QueryTestablePermissions) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public QueryTestablePermissions set(String parameterName, Object value) {
        return (QueryTestablePermissions) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Iam iam = new Iam(...);}
   *   {@code Iam.Projects.List request = iam.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * An accessor for creating requests from the Locations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Iam iam = new Iam(...);}
     *   {@code Iam.Locations.List request = iam.locations().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Locations locations() {
      return new Locations();
    }

    /**
     * The "locations" collection of methods.
     */
    public class Locations {

      /**
       * An accessor for creating requests from the WorkloadIdentityPools collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Iam iam = new Iam(...);}
       *   {@code Iam.WorkloadIdentityPools.List request = iam.workloadIdentityPools().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public WorkloadIdentityPools workloadIdentityPools() {
        return new WorkloadIdentityPools();
      }

      /**
       * The "workloadIdentityPools" collection of methods.
       */
      public class WorkloadIdentityPools {

        /**
         * An accessor for creating requests from the Operations collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code Iam iam = new Iam(...);}
         *   {@code Iam.Operations.List request = iam.operations().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public Operations operations() {
          return new Operations();
        }

        /**
         * The "operations" collection of methods.
         */
        public class Operations {

          /**
           * Gets the latest state of a long-running operation. Clients can use this method to poll the
           * operation result at intervals as recommended by the API service.
           *
           * Create a request for the method "operations.get".
           *
           * This request holds the parameters needed by the iam server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation.
           *
           * @param name The name of the operation resource.
           * @return the request
           */
          public Get get(java.lang.String name) throws java.io.IOException {
            Get result = new Get(name);
            initialize(result);
            return result;
          }

          public class Get extends IamRequest<com.google.api.services.iam.v1.model.Operation> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/operations/[^/]+$");

            /**
             * Gets the latest state of a long-running operation. Clients can use this method to poll the
             * operation result at intervals as recommended by the API service.
             *
             * Create a request for the method "operations.get".
             *
             * This request holds the parameters needed by the the iam server.  After setting any optional
             * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
             * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
             * called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name The name of the operation resource.
             * @since 1.13
             */
            protected Get(java.lang.String name) {
              super(Iam.this, "GET", REST_PATH, null, com.google.api.services.iam.v1.model.Operation.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/operations/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public Get set$Xgafv(java.lang.String $Xgafv) {
              return (Get) super.set$Xgafv($Xgafv);
            }

            @Override
            public Get setAccessToken(java.lang.String accessToken) {
              return (Get) super.setAccessToken(accessToken);
            }

            @Override
            public Get setAlt(java.lang.String alt) {
              return (Get) super.setAlt(alt);
            }

            @Override
            public Get setCallback(java.lang.String callback) {
              return (Get) super.setCallback(callback);
            }

            @Override
            public Get setFields(java.lang.String fields) {
              return (Get) super.setFields(fields);
            }

            @Override
            public Get setKey(java.lang.String key) {
              return (Get) super.setKey(key);
            }

            @Override
            public Get setOauthToken(java.lang.String oauthToken) {
              return (Get) super.setOauthToken(oauthToken);
            }

            @Override
            public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Get) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Get setQuotaUser(java.lang.String quotaUser) {
              return (Get) super.setQuotaUser(quotaUser);
            }

            @Override
            public Get setUploadType(java.lang.String uploadType) {
              return (Get) super.setUploadType(uploadType);
            }

            @Override
            public Get setUploadProtocol(java.lang.String uploadProtocol) {
              return (Get) super.setUploadProtocol(uploadProtocol);
            }

            /** The name of the operation resource. */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The name of the operation resource.
             */
            public java.lang.String getName() {
              return name;
            }

            /** The name of the operation resource. */
            public Get setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/operations/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
              return (Get) super.set(parameterName, value);
            }
          }

        }
        /**
         * An accessor for creating requests from the Providers collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code Iam iam = new Iam(...);}
         *   {@code Iam.Providers.List request = iam.providers().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public Providers providers() {
          return new Providers();
        }

        /**
         * The "providers" collection of methods.
         */
        public class Providers {

          /**
           * An accessor for creating requests from the Operations collection.
           *
           * <p>The typical use is:</p>
           * <pre>
           *   {@code Iam iam = new Iam(...);}
           *   {@code Iam.Operations.List request = iam.operations().list(parameters ...)}
           * </pre>
           *
           * @return the resource collection
           */
          public Operations operations() {
            return new Operations();
          }

          /**
           * The "operations" collection of methods.
           */
          public class Operations {

            /**
             * Gets the latest state of a long-running operation. Clients can use this method to poll the
             * operation result at intervals as recommended by the API service.
             *
             * Create a request for the method "operations.get".
             *
             * This request holds the parameters needed by the iam server.  After setting any optional
             * parameters, call the {@link Get#execute()} method to invoke the remote operation.
             *
             * @param name The name of the operation resource.
             * @return the request
             */
            public Get get(java.lang.String name) throws java.io.IOException {
              Get result = new Get(name);
              initialize(result);
              return result;
            }

            public class Get extends IamRequest<com.google.api.services.iam.v1.model.Operation> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/providers/[^/]+/operations/[^/]+$");

              /**
               * Gets the latest state of a long-running operation. Clients can use this method to poll the
               * operation result at intervals as recommended by the API service.
               *
               * Create a request for the method "operations.get".
               *
               * This request holds the parameters needed by the the iam server.  After setting any optional
               * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
               * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
               * called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name The name of the operation resource.
               * @since 1.13
               */
              protected Get(java.lang.String name) {
                super(Iam.this, "GET", REST_PATH, null, com.google.api.services.iam.v1.model.Operation.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/providers/[^/]+/operations/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public Get set$Xgafv(java.lang.String $Xgafv) {
                return (Get) super.set$Xgafv($Xgafv);
              }

              @Override
              public Get setAccessToken(java.lang.String accessToken) {
                return (Get) super.setAccessToken(accessToken);
              }

              @Override
              public Get setAlt(java.lang.String alt) {
                return (Get) super.setAlt(alt);
              }

              @Override
              public Get setCallback(java.lang.String callback) {
                return (Get) super.setCallback(callback);
              }

              @Override
              public Get setFields(java.lang.String fields) {
                return (Get) super.setFields(fields);
              }

              @Override
              public Get setKey(java.lang.String key) {
                return (Get) super.setKey(key);
              }

              @Override
              public Get setOauthToken(java.lang.String oauthToken) {
                return (Get) super.setOauthToken(oauthToken);
              }

              @Override
              public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Get) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Get setQuotaUser(java.lang.String quotaUser) {
                return (Get) super.setQuotaUser(quotaUser);
              }

              @Override
              public Get setUploadType(java.lang.String uploadType) {
                return (Get) super.setUploadType(uploadType);
              }

              @Override
              public Get setUploadProtocol(java.lang.String uploadProtocol) {
                return (Get) super.setUploadProtocol(uploadProtocol);
              }

              /** The name of the operation resource. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** The name of the operation resource.
               */
              public java.lang.String getName() {
                return name;
              }

              /** The name of the operation resource. */
              public Get setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/providers/[^/]+/operations/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Get set(String parameterName, Object value) {
                return (Get) super.set(parameterName, value);
              }
            }

          }
        }
      }
    }
    /**
     * An accessor for creating requests from the Roles collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Iam iam = new Iam(...);}
     *   {@code Iam.Roles.List request = iam.roles().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Roles roles() {
      return new Roles();
    }

    /**
     * The "roles" collection of methods.
     */
    public class Roles {

      /**
       * Creates a new custom Role.
       *
       * Create a request for the method "roles.create".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent The `parent` parameter's value depends on the target resource for the request, namely
       *        [`projects`](/iam/reference/rest/v1/projects.roles) or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
       *        `parent` value format is described below: *
       *        [`projects.roles.create()`](/iam/reference/rest/v1/projects.roles/create):
       *        `projects/{PROJECT_ID}`. This method creates project-level [custom roles](/iam/docs
       *        /understanding-custom-roles). Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
       *        [`organizations.roles.create()`](/iam/reference/rest/v1/organizations.roles/create):
       *        `organizations/{ORGANIZATION_ID}`. This method creates organization-level [custom
       *        roles](/iam/docs/understanding-custom-roles). Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*)
       *        values are invalid; you must specify a complete project ID or organization ID.
       * @param content the {@link com.google.api.services.iam.v1.model.CreateRoleRequest}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.iam.v1.model.CreateRoleRequest content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends IamRequest<com.google.api.services.iam.v1.model.Role> {

        private static final String REST_PATH = "v1/{+parent}/roles";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Creates a new custom Role.
         *
         * Create a request for the method "roles.create".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent The `parent` parameter's value depends on the target resource for the request, namely
       *        [`projects`](/iam/reference/rest/v1/projects.roles) or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
       *        `parent` value format is described below: *
       *        [`projects.roles.create()`](/iam/reference/rest/v1/projects.roles/create):
       *        `projects/{PROJECT_ID}`. This method creates project-level [custom roles](/iam/docs
       *        /understanding-custom-roles). Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
       *        [`organizations.roles.create()`](/iam/reference/rest/v1/organizations.roles/create):
       *        `organizations/{ORGANIZATION_ID}`. This method creates organization-level [custom
       *        roles](/iam/docs/understanding-custom-roles). Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*)
       *        values are invalid; you must specify a complete project ID or organization ID.
         * @param content the {@link com.google.api.services.iam.v1.model.CreateRoleRequest}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.iam.v1.model.CreateRoleRequest content) {
          super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.Role.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The `parent` parameter's value depends on the target resource for the request, namely
         * [`projects`](/iam/reference/rest/v1/projects.roles) or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `parent` value format is described below: *
         * [`projects.roles.create()`](/iam/reference/rest/v1/projects.roles/create):
         * `projects/{PROJECT_ID}`. This method creates project-level [custom roles](/iam/docs
         * /understanding-custom-roles). Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
         * [`organizations.roles.create()`](/iam/reference/rest/v1/organizations.roles/create):
         * `organizations/{ORGANIZATION_ID}`. This method creates organization-level [custom
         * roles](/iam/docs/understanding-custom-roles). Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*)
         * values are invalid; you must specify a complete project ID or organization ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** The `parent` parameter's value depends on the target resource for the request, namely
       [`projects`](/iam/reference/rest/v1/projects.roles) or
       [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `parent` value
       format is described below: *
       [`projects.roles.create()`](/iam/reference/rest/v1/projects.roles/create): `projects/{PROJECT_ID}`.
       This method creates project-level [custom roles](/iam/docs/understanding-custom-roles). Example
       request URL: `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
       [`organizations.roles.create()`](/iam/reference/rest/v1/organizations.roles/create):
       `organizations/{ORGANIZATION_ID}`. This method creates organization-level [custom roles](/iam/docs
       /understanding-custom-roles). Example request URL:
       `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*) values are
       invalid; you must specify a complete project ID or organization ID.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * The `parent` parameter's value depends on the target resource for the request, namely
         * [`projects`](/iam/reference/rest/v1/projects.roles) or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `parent` value format is described below: *
         * [`projects.roles.create()`](/iam/reference/rest/v1/projects.roles/create):
         * `projects/{PROJECT_ID}`. This method creates project-level [custom roles](/iam/docs
         * /understanding-custom-roles). Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
         * [`organizations.roles.create()`](/iam/reference/rest/v1/organizations.roles/create):
         * `organizations/{ORGANIZATION_ID}`. This method creates organization-level [custom
         * roles](/iam/docs/understanding-custom-roles). Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*)
         * values are invalid; you must specify a complete project ID or organization ID.
         */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a custom Role. When you delete a custom role, the following changes occur immediately: *
       * You cannot bind a member to the custom role in an IAM Policy. * Existing bindings to the custom
       * role are not changed, but they have no effect. * By default, the response from ListRoles does not
       * include the custom role. You have 7 days to undelete the custom role. After 7 days, the following
       * changes occur: * The custom role is permanently deleted and cannot be recovered. * If an IAM
       * policy contains a binding to the custom role, the binding is permanently removed.
       *
       * Create a request for the method "roles.delete".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name The `name` parameter's value depends on the target resource for the request, namely
       *        [`projects`](/iam/reference/rest/v1/projects.roles) or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
       *        value format is described below: *
       *        [`projects.roles.delete()`](/iam/reference/rest/v1/projects.roles/delete):
       *        `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
       *        Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       *        [`organizations.roles.delete()`](/iam/reference/rest/v1/organizations.roles/delete):
       *        `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the organization
       *        level. Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
       *        Note: Wildcard (*) values are invalid; you must specify a complete project ID or
       *        organization ID.
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends IamRequest<com.google.api.services.iam.v1.model.Role> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/roles/[^/]+$");

        /**
         * Deletes a custom Role. When you delete a custom role, the following changes occur immediately:
         * * You cannot bind a member to the custom role in an IAM Policy. * Existing bindings to the
         * custom role are not changed, but they have no effect. * By default, the response from ListRoles
         * does not include the custom role. You have 7 days to undelete the custom role. After 7 days,
         * the following changes occur: * The custom role is permanently deleted and cannot be recovered.
         * * If an IAM policy contains a binding to the custom role, the binding is permanently removed.
         *
         * Create a request for the method "roles.delete".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The `name` parameter's value depends on the target resource for the request, namely
       *        [`projects`](/iam/reference/rest/v1/projects.roles) or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
       *        value format is described below: *
       *        [`projects.roles.delete()`](/iam/reference/rest/v1/projects.roles/delete):
       *        `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
       *        Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       *        [`organizations.roles.delete()`](/iam/reference/rest/v1/organizations.roles/delete):
       *        `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the organization
       *        level. Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
       *        Note: Wildcard (*) values are invalid; you must specify a complete project ID or
       *        organization ID.
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(Iam.this, "DELETE", REST_PATH, null, com.google.api.services.iam.v1.model.Role.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/roles/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The `name` parameter's value depends on the target resource for the request, namely
         * [`projects`](/iam/reference/rest/v1/projects.roles) or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `name` value format is described below: *
         * [`projects.roles.delete()`](/iam/reference/rest/v1/projects.roles/delete):
         * `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only [custom
         * roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
         * Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
         * [`organizations.roles.delete()`](/iam/reference/rest/v1/organizations.roles/delete):
         * `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only
         * [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
         * organization level. Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
         * Note: Wildcard (*) values are invalid; you must specify a complete project ID or
         * organization ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The `name` parameter's value depends on the target resource for the request, namely
       [`projects`](/iam/reference/rest/v1/projects.roles) or
       [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name` value
       format is described below: *
       [`projects.roles.delete()`](/iam/reference/rest/v1/projects.roles/delete):
       `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only [custom roles](/iam/docs
       /understanding-custom-roles) that have been created at the project level. Example request URL:
       `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       [`organizations.roles.delete()`](/iam/reference/rest/v1/organizations.roles/delete):
       `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only [custom
       roles](/iam/docs/understanding-custom-roles) that have been created at the organization level.
       Example request URL:
       `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}` Note:
       Wildcard (*) values are invalid; you must specify a complete project ID or organization ID.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The `name` parameter's value depends on the target resource for the request, namely
         * [`projects`](/iam/reference/rest/v1/projects.roles) or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `name` value format is described below: *
         * [`projects.roles.delete()`](/iam/reference/rest/v1/projects.roles/delete):
         * `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only [custom
         * roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
         * Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
         * [`organizations.roles.delete()`](/iam/reference/rest/v1/organizations.roles/delete):
         * `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only
         * [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
         * organization level. Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
         * Note: Wildcard (*) values are invalid; you must specify a complete project ID or
         * organization ID.
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/roles/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /** Used to perform a consistent read-modify-write. */
        @com.google.api.client.util.Key
        private java.lang.String etag;

        /** Used to perform a consistent read-modify-write.
         */
        public java.lang.String getEtag() {
          return etag;
        }

        /** Used to perform a consistent read-modify-write. */
        public Delete setEtag(java.lang.String etag) {
          this.etag = etag;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets the definition of a Role.
       *
       * Create a request for the method "roles.get".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name The `name` parameter's value depends on the target resource for the request, namely
       *        [`roles`](/iam/reference/rest/v1/roles),
       *        [`projects`](/iam/reference/rest/v1/projects.roles), or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
       *        value format is described below: * [`roles.get()`](/iam/reference/rest/v1/roles/get):
       *        `roles/{ROLE_NAME}`. This method returns results from all [predefined roles](/iam/docs
       *        /understanding-roles#predefined_roles) in Cloud IAM. Example request URL:
       *        `https://iam.googleapis.com/v1/roles/{ROLE_NAME}` *
       *        [`projects.roles.get()`](/iam/reference/rest/v1/projects.roles/get):
       *        `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
       *        Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       *        [`organizations.roles.get()`](/iam/reference/rest/v1/organizations.roles/get):
       *        `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the organization
       *        level. Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
       *        Note: Wildcard (*) values are invalid; you must specify a complete project ID or
       *        organization ID.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends IamRequest<com.google.api.services.iam.v1.model.Role> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/roles/[^/]+$");

        /**
         * Gets the definition of a Role.
         *
         * Create a request for the method "roles.get".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The `name` parameter's value depends on the target resource for the request, namely
       *        [`roles`](/iam/reference/rest/v1/roles),
       *        [`projects`](/iam/reference/rest/v1/projects.roles), or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
       *        value format is described below: * [`roles.get()`](/iam/reference/rest/v1/roles/get):
       *        `roles/{ROLE_NAME}`. This method returns results from all [predefined roles](/iam/docs
       *        /understanding-roles#predefined_roles) in Cloud IAM. Example request URL:
       *        `https://iam.googleapis.com/v1/roles/{ROLE_NAME}` *
       *        [`projects.roles.get()`](/iam/reference/rest/v1/projects.roles/get):
       *        `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
       *        Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       *        [`organizations.roles.get()`](/iam/reference/rest/v1/organizations.roles/get):
       *        `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the organization
       *        level. Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
       *        Note: Wildcard (*) values are invalid; you must specify a complete project ID or
       *        organization ID.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Iam.this, "GET", REST_PATH, null, com.google.api.services.iam.v1.model.Role.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/roles/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The `name` parameter's value depends on the target resource for the request, namely
         * [`roles`](/iam/reference/rest/v1/roles),
         * [`projects`](/iam/reference/rest/v1/projects.roles), or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `name` value format is described below: *
         * [`roles.get()`](/iam/reference/rest/v1/roles/get): `roles/{ROLE_NAME}`. This method
         * returns results from all [predefined roles](/iam/docs/understanding-
         * roles#predefined_roles) in Cloud IAM. Example request URL:
         * `https://iam.googleapis.com/v1/roles/{ROLE_NAME}` *
         * [`projects.roles.get()`](/iam/reference/rest/v1/projects.roles/get):
         * `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
         * roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
         * Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
         * [`organizations.roles.get()`](/iam/reference/rest/v1/organizations.roles/get):
         * `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only
         * [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
         * organization level. Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
         * Note: Wildcard (*) values are invalid; you must specify a complete project ID or
         * organization ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The `name` parameter's value depends on the target resource for the request, namely
       [`roles`](/iam/reference/rest/v1/roles), [`projects`](/iam/reference/rest/v1/projects.roles), or
       [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name` value
       format is described below: * [`roles.get()`](/iam/reference/rest/v1/roles/get):
       `roles/{ROLE_NAME}`. This method returns results from all [predefined roles](/iam/docs
       /understanding-roles#predefined_roles) in Cloud IAM. Example request URL:
       `https://iam.googleapis.com/v1/roles/{ROLE_NAME}` *
       [`projects.roles.get()`](/iam/reference/rest/v1/projects.roles/get):
       `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom roles](/iam/docs
       /understanding-custom-roles) that have been created at the project level. Example request URL:
       `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       [`organizations.roles.get()`](/iam/reference/rest/v1/organizations.roles/get):
       `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
       roles](/iam/docs/understanding-custom-roles) that have been created at the organization level.
       Example request URL:
       `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}` Note:
       Wildcard (*) values are invalid; you must specify a complete project ID or organization ID.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The `name` parameter's value depends on the target resource for the request, namely
         * [`roles`](/iam/reference/rest/v1/roles),
         * [`projects`](/iam/reference/rest/v1/projects.roles), or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `name` value format is described below: *
         * [`roles.get()`](/iam/reference/rest/v1/roles/get): `roles/{ROLE_NAME}`. This method
         * returns results from all [predefined roles](/iam/docs/understanding-
         * roles#predefined_roles) in Cloud IAM. Example request URL:
         * `https://iam.googleapis.com/v1/roles/{ROLE_NAME}` *
         * [`projects.roles.get()`](/iam/reference/rest/v1/projects.roles/get):
         * `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
         * roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
         * Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
         * [`organizations.roles.get()`](/iam/reference/rest/v1/organizations.roles/get):
         * `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only
         * [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
         * organization level. Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
         * Note: Wildcard (*) values are invalid; you must specify a complete project ID or
         * organization ID.
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/roles/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists every predefined Role that IAM supports, or every custom role that is defined for an
       * organization or project.
       *
       * Create a request for the method "roles.list".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param parent The `parent` parameter's value depends on the target resource for the request, namely
       *        [`roles`](/iam/reference/rest/v1/roles),
       *        [`projects`](/iam/reference/rest/v1/projects.roles), or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
       *        `parent` value format is described below: *
       *        [`roles.list()`](/iam/reference/rest/v1/roles/list): An empty string. This method doesn't
       *        require a resource; it simply returns all [predefined roles](/iam/docs/understanding-
       *        roles#predefined_roles) in Cloud IAM. Example request URL:
       *        `https://iam.googleapis.com/v1/roles` *
       *        [`projects.roles.list()`](/iam/reference/rest/v1/projects.roles/list):
       *        `projects/{PROJECT_ID}`. This method lists all project-level [custom roles](/iam/docs
       *        /understanding-custom-roles). Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
       *        [`organizations.roles.list()`](/iam/reference/rest/v1/organizations.roles/list):
       *        `organizations/{ORGANIZATION_ID}`. This method lists all organization-level [custom
       *        roles](/iam/docs/understanding-custom-roles). Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*)
       *        values are invalid; you must specify a complete project ID or organization ID.
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends IamRequest<com.google.api.services.iam.v1.model.ListRolesResponse> {

        private static final String REST_PATH = "v1/{+parent}/roles";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists every predefined Role that IAM supports, or every custom role that is defined for an
         * organization or project.
         *
         * Create a request for the method "roles.list".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent The `parent` parameter's value depends on the target resource for the request, namely
       *        [`roles`](/iam/reference/rest/v1/roles),
       *        [`projects`](/iam/reference/rest/v1/projects.roles), or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
       *        `parent` value format is described below: *
       *        [`roles.list()`](/iam/reference/rest/v1/roles/list): An empty string. This method doesn't
       *        require a resource; it simply returns all [predefined roles](/iam/docs/understanding-
       *        roles#predefined_roles) in Cloud IAM. Example request URL:
       *        `https://iam.googleapis.com/v1/roles` *
       *        [`projects.roles.list()`](/iam/reference/rest/v1/projects.roles/list):
       *        `projects/{PROJECT_ID}`. This method lists all project-level [custom roles](/iam/docs
       *        /understanding-custom-roles). Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
       *        [`organizations.roles.list()`](/iam/reference/rest/v1/organizations.roles/list):
       *        `organizations/{ORGANIZATION_ID}`. This method lists all organization-level [custom
       *        roles](/iam/docs/understanding-custom-roles). Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*)
       *        values are invalid; you must specify a complete project ID or organization ID.
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(Iam.this, "GET", REST_PATH, null, com.google.api.services.iam.v1.model.ListRolesResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The `parent` parameter's value depends on the target resource for the request, namely
         * [`roles`](/iam/reference/rest/v1/roles),
         * [`projects`](/iam/reference/rest/v1/projects.roles), or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `parent` value format is described below: *
         * [`roles.list()`](/iam/reference/rest/v1/roles/list): An empty string. This method doesn't
         * require a resource; it simply returns all [predefined roles](/iam/docs/understanding-
         * roles#predefined_roles) in Cloud IAM. Example request URL:
         * `https://iam.googleapis.com/v1/roles` *
         * [`projects.roles.list()`](/iam/reference/rest/v1/projects.roles/list):
         * `projects/{PROJECT_ID}`. This method lists all project-level [custom roles](/iam/docs
         * /understanding-custom-roles). Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
         * [`organizations.roles.list()`](/iam/reference/rest/v1/organizations.roles/list):
         * `organizations/{ORGANIZATION_ID}`. This method lists all organization-level [custom
         * roles](/iam/docs/understanding-custom-roles). Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*)
         * values are invalid; you must specify a complete project ID or organization ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** The `parent` parameter's value depends on the target resource for the request, namely
       [`roles`](/iam/reference/rest/v1/roles), [`projects`](/iam/reference/rest/v1/projects.roles), or
       [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `parent` value
       format is described below: * [`roles.list()`](/iam/reference/rest/v1/roles/list): An empty string.
       This method doesn't require a resource; it simply returns all [predefined roles](/iam/docs
       /understanding-roles#predefined_roles) in Cloud IAM. Example request URL:
       `https://iam.googleapis.com/v1/roles` *
       [`projects.roles.list()`](/iam/reference/rest/v1/projects.roles/list): `projects/{PROJECT_ID}`.
       This method lists all project-level [custom roles](/iam/docs/understanding-custom-roles). Example
       request URL: `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
       [`organizations.roles.list()`](/iam/reference/rest/v1/organizations.roles/list):
       `organizations/{ORGANIZATION_ID}`. This method lists all organization-level [custom
       roles](/iam/docs/understanding-custom-roles). Example request URL:
       `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*) values are
       invalid; you must specify a complete project ID or organization ID.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * The `parent` parameter's value depends on the target resource for the request, namely
         * [`roles`](/iam/reference/rest/v1/roles),
         * [`projects`](/iam/reference/rest/v1/projects.roles), or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `parent` value format is described below: *
         * [`roles.list()`](/iam/reference/rest/v1/roles/list): An empty string. This method doesn't
         * require a resource; it simply returns all [predefined roles](/iam/docs/understanding-
         * roles#predefined_roles) in Cloud IAM. Example request URL:
         * `https://iam.googleapis.com/v1/roles` *
         * [`projects.roles.list()`](/iam/reference/rest/v1/projects.roles/list):
         * `projects/{PROJECT_ID}`. This method lists all project-level [custom roles](/iam/docs
         * /understanding-custom-roles). Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
         * [`organizations.roles.list()`](/iam/reference/rest/v1/organizations.roles/list):
         * `organizations/{ORGANIZATION_ID}`. This method lists all organization-level [custom
         * roles](/iam/docs/understanding-custom-roles). Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*)
         * values are invalid; you must specify a complete project ID or organization ID.
         */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * Optional limit on the number of roles to include in the response. The default is 300, and
         * the maximum is 1,000.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** Optional limit on the number of roles to include in the response. The default is 300, and the
       maximum is 1,000.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * Optional limit on the number of roles to include in the response. The default is 300, and
         * the maximum is 1,000.
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /** Optional pagination token returned in an earlier ListRolesResponse. */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** Optional pagination token returned in an earlier ListRolesResponse.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /** Optional pagination token returned in an earlier ListRolesResponse. */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /** Include Roles that have been deleted. */
        @com.google.api.client.util.Key
        private java.lang.Boolean showDeleted;

        /** Include Roles that have been deleted.
         */
        public java.lang.Boolean getShowDeleted() {
          return showDeleted;
        }

        /** Include Roles that have been deleted. */
        public List setShowDeleted(java.lang.Boolean showDeleted) {
          this.showDeleted = showDeleted;
          return this;
        }

        /**
         * Optional view for the returned Role objects. When `FULL` is specified, the
         * `includedPermissions` field is returned, which includes a list of all permissions in the
         * role. The default value is `BASIC`, which does not return the `includedPermissions`
         * field.
         */
        @com.google.api.client.util.Key
        private java.lang.String view;

        /** Optional view for the returned Role objects. When `FULL` is specified, the `includedPermissions`
       field is returned, which includes a list of all permissions in the role. The default value is
       `BASIC`, which does not return the `includedPermissions` field.
         */
        public java.lang.String getView() {
          return view;
        }

        /**
         * Optional view for the returned Role objects. When `FULL` is specified, the
         * `includedPermissions` field is returned, which includes a list of all permissions in the
         * role. The default value is `BASIC`, which does not return the `includedPermissions`
         * field.
         */
        public List setView(java.lang.String view) {
          this.view = view;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates the definition of a custom Role.
       *
       * Create a request for the method "roles.patch".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name The `name` parameter's value depends on the target resource for the request, namely
       *        [`projects`](/iam/reference/rest/v1/projects.roles) or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
       *        value format is described below: *
       *        [`projects.roles.patch()`](/iam/reference/rest/v1/projects.roles/patch):
       *        `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
       *        Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       *        [`organizations.roles.patch()`](/iam/reference/rest/v1/organizations.roles/patch):
       *        `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the organization
       *        level. Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
       *        Note: Wildcard (*) values are invalid; you must specify a complete project ID or
       *        organization ID.
       * @param content the {@link com.google.api.services.iam.v1.model.Role}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.iam.v1.model.Role content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends IamRequest<com.google.api.services.iam.v1.model.Role> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/roles/[^/]+$");

        /**
         * Updates the definition of a custom Role.
         *
         * Create a request for the method "roles.patch".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The `name` parameter's value depends on the target resource for the request, namely
       *        [`projects`](/iam/reference/rest/v1/projects.roles) or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
       *        value format is described below: *
       *        [`projects.roles.patch()`](/iam/reference/rest/v1/projects.roles/patch):
       *        `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
       *        Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       *        [`organizations.roles.patch()`](/iam/reference/rest/v1/organizations.roles/patch):
       *        `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the organization
       *        level. Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
       *        Note: Wildcard (*) values are invalid; you must specify a complete project ID or
       *        organization ID.
         * @param content the {@link com.google.api.services.iam.v1.model.Role}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.iam.v1.model.Role content) {
          super(Iam.this, "PATCH", REST_PATH, content, com.google.api.services.iam.v1.model.Role.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/roles/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The `name` parameter's value depends on the target resource for the request, namely
         * [`projects`](/iam/reference/rest/v1/projects.roles) or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `name` value format is described below: *
         * [`projects.roles.patch()`](/iam/reference/rest/v1/projects.roles/patch):
         * `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only [custom
         * roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
         * Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
         * [`organizations.roles.patch()`](/iam/reference/rest/v1/organizations.roles/patch):
         * `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only
         * [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
         * organization level. Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
         * Note: Wildcard (*) values are invalid; you must specify a complete project ID or
         * organization ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The `name` parameter's value depends on the target resource for the request, namely
       [`projects`](/iam/reference/rest/v1/projects.roles) or
       [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name` value
       format is described below: *
       [`projects.roles.patch()`](/iam/reference/rest/v1/projects.roles/patch):
       `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only [custom roles](/iam/docs
       /understanding-custom-roles) that have been created at the project level. Example request URL:
       `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       [`organizations.roles.patch()`](/iam/reference/rest/v1/organizations.roles/patch):
       `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only [custom
       roles](/iam/docs/understanding-custom-roles) that have been created at the organization level.
       Example request URL:
       `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}` Note:
       Wildcard (*) values are invalid; you must specify a complete project ID or organization ID.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The `name` parameter's value depends on the target resource for the request, namely
         * [`projects`](/iam/reference/rest/v1/projects.roles) or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `name` value format is described below: *
         * [`projects.roles.patch()`](/iam/reference/rest/v1/projects.roles/patch):
         * `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only [custom
         * roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
         * Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
         * [`organizations.roles.patch()`](/iam/reference/rest/v1/organizations.roles/patch):
         * `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only
         * [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
         * organization level. Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
         * Note: Wildcard (*) values are invalid; you must specify a complete project ID or
         * organization ID.
         */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/roles/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /** A mask describing which fields in the Role have changed. */
        @com.google.api.client.util.Key
        private String updateMask;

        /** A mask describing which fields in the Role have changed.
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /** A mask describing which fields in the Role have changed. */
        public Patch setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Undeletes a custom Role.
       *
       * Create a request for the method "roles.undelete".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Undelete#execute()} method to invoke the remote operation.
       *
       * @param name The `name` parameter's value depends on the target resource for the request, namely
       *        [`projects`](/iam/reference/rest/v1/projects.roles) or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
       *        value format is described below: *
       *        [`projects.roles.undelete()`](/iam/reference/rest/v1/projects.roles/undelete):
       *        `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
       *        Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       *        [`organizations.roles.undelete()`](/iam/reference/rest/v1/organizations.roles/undelete):
       *        `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only
       *        [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
       *        organization level. Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
       *        Note: Wildcard (*) values are invalid; you must specify a complete project ID or
       *        organization ID.
       * @param content the {@link com.google.api.services.iam.v1.model.UndeleteRoleRequest}
       * @return the request
       */
      public Undelete undelete(java.lang.String name, com.google.api.services.iam.v1.model.UndeleteRoleRequest content) throws java.io.IOException {
        Undelete result = new Undelete(name, content);
        initialize(result);
        return result;
      }

      public class Undelete extends IamRequest<com.google.api.services.iam.v1.model.Role> {

        private static final String REST_PATH = "v1/{+name}:undelete";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/roles/[^/]+$");

        /**
         * Undeletes a custom Role.
         *
         * Create a request for the method "roles.undelete".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Undelete#execute()} method to invoke the remote operation. <p>
         * {@link
         * Undelete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The `name` parameter's value depends on the target resource for the request, namely
       *        [`projects`](/iam/reference/rest/v1/projects.roles) or
       *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
       *        value format is described below: *
       *        [`projects.roles.undelete()`](/iam/reference/rest/v1/projects.roles/undelete):
       *        `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only [custom
       *        roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
       *        Example request URL:
       *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       *        [`organizations.roles.undelete()`](/iam/reference/rest/v1/organizations.roles/undelete):
       *        `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only
       *        [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
       *        organization level. Example request URL:
       *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
       *        Note: Wildcard (*) values are invalid; you must specify a complete project ID or
       *        organization ID.
         * @param content the {@link com.google.api.services.iam.v1.model.UndeleteRoleRequest}
         * @since 1.13
         */
        protected Undelete(java.lang.String name, com.google.api.services.iam.v1.model.UndeleteRoleRequest content) {
          super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.Role.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/roles/[^/]+$");
          }
        }

        @Override
        public Undelete set$Xgafv(java.lang.String $Xgafv) {
          return (Undelete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Undelete setAccessToken(java.lang.String accessToken) {
          return (Undelete) super.setAccessToken(accessToken);
        }

        @Override
        public Undelete setAlt(java.lang.String alt) {
          return (Undelete) super.setAlt(alt);
        }

        @Override
        public Undelete setCallback(java.lang.String callback) {
          return (Undelete) super.setCallback(callback);
        }

        @Override
        public Undelete setFields(java.lang.String fields) {
          return (Undelete) super.setFields(fields);
        }

        @Override
        public Undelete setKey(java.lang.String key) {
          return (Undelete) super.setKey(key);
        }

        @Override
        public Undelete setOauthToken(java.lang.String oauthToken) {
          return (Undelete) super.setOauthToken(oauthToken);
        }

        @Override
        public Undelete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Undelete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Undelete setQuotaUser(java.lang.String quotaUser) {
          return (Undelete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Undelete setUploadType(java.lang.String uploadType) {
          return (Undelete) super.setUploadType(uploadType);
        }

        @Override
        public Undelete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Undelete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The `name` parameter's value depends on the target resource for the request, namely
         * [`projects`](/iam/reference/rest/v1/projects.roles) or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `name` value format is described below: *
         * [`projects.roles.undelete()`](/iam/reference/rest/v1/projects.roles/undelete):
         * `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only [custom
         * roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
         * Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
         * [`organizations.roles.undelete()`](/iam/reference/rest/v1/organizations.roles/undelete):
         * `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only
         * [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
         * organization level. Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
         * Note: Wildcard (*) values are invalid; you must specify a complete project ID or
         * organization ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The `name` parameter's value depends on the target resource for the request, namely
       [`projects`](/iam/reference/rest/v1/projects.roles) or
       [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name` value
       format is described below: *
       [`projects.roles.undelete()`](/iam/reference/rest/v1/projects.roles/undelete):
       `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only [custom roles](/iam/docs
       /understanding-custom-roles) that have been created at the project level. Example request URL:
       `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       [`organizations.roles.undelete()`](/iam/reference/rest/v1/organizations.roles/undelete):
       `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only [custom
       roles](/iam/docs/understanding-custom-roles) that have been created at the organization level.
       Example request URL:
       `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}` Note:
       Wildcard (*) values are invalid; you must specify a complete project ID or organization ID.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The `name` parameter's value depends on the target resource for the request, namely
         * [`projects`](/iam/reference/rest/v1/projects.roles) or
         * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
         * `name` value format is described below: *
         * [`projects.roles.undelete()`](/iam/reference/rest/v1/projects.roles/undelete):
         * `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only [custom
         * roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
         * Example request URL:
         * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
         * [`organizations.roles.undelete()`](/iam/reference/rest/v1/organizations.roles/undelete):
         * `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes only
         * [custom roles](/iam/docs/understanding-custom-roles) that have been created at the
         * organization level. Example request URL:
         * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
         * Note: Wildcard (*) values are invalid; you must specify a complete project ID or
         * organization ID.
         */
        public Undelete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/roles/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Undelete set(String parameterName, Object value) {
          return (Undelete) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the ServiceAccounts collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Iam iam = new Iam(...);}
     *   {@code Iam.ServiceAccounts.List request = iam.serviceAccounts().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public ServiceAccounts serviceAccounts() {
      return new ServiceAccounts();
    }

    /**
     * The "serviceAccounts" collection of methods.
     */
    public class ServiceAccounts {

      /**
       * Creates a ServiceAccount.
       *
       * Create a request for the method "serviceAccounts.create".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name of the project associated with the service accounts, such as `projects
       *        /my-project-123`.
       * @param content the {@link com.google.api.services.iam.v1.model.CreateServiceAccountRequest}
       * @return the request
       */
      public Create create(java.lang.String name, com.google.api.services.iam.v1.model.CreateServiceAccountRequest content) throws java.io.IOException {
        Create result = new Create(name, content);
        initialize(result);
        return result;
      }

      public class Create extends IamRequest<com.google.api.services.iam.v1.model.ServiceAccount> {

        private static final String REST_PATH = "v1/{+name}/serviceAccounts";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Creates a ServiceAccount.
         *
         * Create a request for the method "serviceAccounts.create".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name of the project associated with the service accounts, such as `projects
       *        /my-project-123`.
         * @param content the {@link com.google.api.services.iam.v1.model.CreateServiceAccountRequest}
         * @since 1.13
         */
        protected Create(java.lang.String name, com.google.api.services.iam.v1.model.CreateServiceAccountRequest content) {
          super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.ServiceAccount.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The resource name of the project associated with the service accounts, such as
         * `projects/my-project-123`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name of the project associated with the service accounts, such as `projects
       /my-project-123`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The resource name of the project associated with the service accounts, such as
         * `projects/my-project-123`.
         */
        public Create setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a ServiceAccount. **Warning:** After you delete a service account, you might not be able
       * to undelete it. If you know that you need to re-enable the service account in the future, use
       * DisableServiceAccount instead. If you delete a service account, IAM permanently removes the
       * service account 30 days later. Google Cloud cannot recover the service account after it is
       * permanently removed, even if you file a support request. To help avoid unplanned outages, we
       * recommend that you disable the service account before you delete it. Use DisableServiceAccount to
       * disable the service account, then wait at least 24 hours and watch for unintended consequences.
       * If there are no unintended consequences, you can delete the service account.
       *
       * Create a request for the method "serviceAccounts.delete".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name of the service account in the following format:
       *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
       *        `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
       *        `email` address or the `unique_id` of the service account.
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends IamRequest<com.google.api.services.iam.v1.model.Empty> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");

        /**
         * Deletes a ServiceAccount. **Warning:** After you delete a service account, you might not be
         * able to undelete it. If you know that you need to re-enable the service account in the future,
         * use DisableServiceAccount instead. If you delete a service account, IAM permanently removes the
         * service account 30 days later. Google Cloud cannot recover the service account after it is
         * permanently removed, even if you file a support request. To help avoid unplanned outages, we
         * recommend that you disable the service account before you delete it. Use DisableServiceAccount
         * to disable the service account, then wait at least 24 hours and watch for unintended
         * consequences. If there are no unintended consequences, you can delete the service account.
         *
         * Create a request for the method "serviceAccounts.delete".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name of the service account in the following format:
       *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
       *        `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
       *        `email` address or the `unique_id` of the service account.
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(Iam.this, "DELETE", REST_PATH, null, com.google.api.services.iam.v1.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The resource name of the service account in the following format:
         * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
         * `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         * `email` address or the `unique_id` of the service account.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name of the service account in the following format:
       `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the `PROJECT_ID`
       will infer the project from the account. The `ACCOUNT` value can be the `email` address or the
       `unique_id` of the service account.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The resource name of the service account in the following format:
         * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
         * `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         * `email` address or the `unique_id` of the service account.
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Disables a ServiceAccount immediately. If an application uses the service account to
       * authenticate, that application can no longer call Google APIs or access Google Cloud resources.
       * Existing access tokens for the service account are rejected, and requests for new access tokens
       * will fail. To re-enable the service account, use EnableServiceAccount. After you re-enable the
       * service account, its existing access tokens will be accepted, and you can request new access
       * tokens. To help avoid unplanned outages, we recommend that you disable the service account before
       * you delete it. Use this method to disable the service account, then wait at least 24 hours and
       * watch for unintended consequences. If there are no unintended consequences, you can delete the
       * service account with DeleteServiceAccount.
       *
       * Create a request for the method "serviceAccounts.disable".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Disable#execute()} method to invoke the remote operation.
       *
       * @param name The resource name of the service account in the following format:
       *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
       *        `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
       *        `email` address or the `unique_id` of the service account.
       * @param content the {@link com.google.api.services.iam.v1.model.DisableServiceAccountRequest}
       * @return the request
       */
      public Disable disable(java.lang.String name, com.google.api.services.iam.v1.model.DisableServiceAccountRequest content) throws java.io.IOException {
        Disable result = new Disable(name, content);
        initialize(result);
        return result;
      }

      public class Disable extends IamRequest<com.google.api.services.iam.v1.model.Empty> {

        private static final String REST_PATH = "v1/{+name}:disable";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");

        /**
         * Disables a ServiceAccount immediately. If an application uses the service account to
         * authenticate, that application can no longer call Google APIs or access Google Cloud resources.
         * Existing access tokens for the service account are rejected, and requests for new access tokens
         * will fail. To re-enable the service account, use EnableServiceAccount. After you re-enable the
         * service account, its existing access tokens will be accepted, and you can request new access
         * tokens. To help avoid unplanned outages, we recommend that you disable the service account
         * before you delete it. Use this method to disable the service account, then wait at least 24
         * hours and watch for unintended consequences. If there are no unintended consequences, you can
         * delete the service account with DeleteServiceAccount.
         *
         * Create a request for the method "serviceAccounts.disable".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Disable#execute()} method to invoke the remote operation. <p>
         * {@link
         * Disable#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource name of the service account in the following format:
       *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
       *        `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
       *        `email` address or the `unique_id` of the service account.
         * @param content the {@link com.google.api.services.iam.v1.model.DisableServiceAccountRequest}
         * @since 1.13
         */
        protected Disable(java.lang.String name, com.google.api.services.iam.v1.model.DisableServiceAccountRequest content) {
          super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
        }

        @Override
        public Disable set$Xgafv(java.lang.String $Xgafv) {
          return (Disable) super.set$Xgafv($Xgafv);
        }

        @Override
        public Disable setAccessToken(java.lang.String accessToken) {
          return (Disable) super.setAccessToken(accessToken);
        }

        @Override
        public Disable setAlt(java.lang.String alt) {
          return (Disable) super.setAlt(alt);
        }

        @Override
        public Disable setCallback(java.lang.String callback) {
          return (Disable) super.setCallback(callback);
        }

        @Override
        public Disable setFields(java.lang.String fields) {
          return (Disable) super.setFields(fields);
        }

        @Override
        public Disable setKey(java.lang.String key) {
          return (Disable) super.setKey(key);
        }

        @Override
        public Disable setOauthToken(java.lang.String oauthToken) {
          return (Disable) super.setOauthToken(oauthToken);
        }

        @Override
        public Disable setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Disable) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Disable setQuotaUser(java.lang.String quotaUser) {
          return (Disable) super.setQuotaUser(quotaUser);
        }

        @Override
        public Disable setUploadType(java.lang.String uploadType) {
          return (Disable) super.setUploadType(uploadType);
        }

        @Override
        public Disable setUploadProtocol(java.lang.String uploadProtocol) {
          return (Disable) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The resource name of the service account in the following format:
         * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
         * `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         * `email` address or the `unique_id` of the service account.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource name of the service account in the following format:
       `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the `PROJECT_ID`
       will infer the project from the account. The `ACCOUNT` value can be the `email` address or the
       `unique_id` of the service account.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The resource name of the service account in the following format:
         * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
         * `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         * `email` address or the `unique_id` of the service account.
         */
        public Disable setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Disable set(String parameterName, Object value) {
          return (Disable) super.set(parameterName, value);
        }
      }
      /**
       * Enables a ServiceAccount that was disabled by DisableServiceAccount. If the service account is
       * already enabled, then this method has no effect. If the service account was disabled by other
       * means—for example, if Google disabled the service account because it was compromised—you cannot
       * use this method to enable the service account.
       *
       * Create a request for the method "serviceAccounts.enable".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Enable#execute()} method to invoke the remote operation.
       *
       * @param name The resource name of the service account in the following format:
       *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
       *        `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
       *        `email` address or the `unique_id` of the service account.
       * @param content the {@link com.google.api.services.iam.v1.model.EnableServiceAccountRequest}
       * @return the request
       */
      public Enable enable(java.lang.String name, com.google.api.services.iam.v1.model.EnableServiceAccountRequest content) throws java.io.IOException {
        Enable result = new Enable(name, content);
        initialize(result);
        return result;
      }

      public class Enable extends IamRequest<com.google.api.services.iam.v1.model.Empty> {

        private static final String REST_PATH = "v1/{+name}:enable";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");

        /**
         * Enables a ServiceAccount that was disabled by DisableServiceAccount. If the service account is
         * already enabled, then this method has no effect. If the service account was disabled by other
         * means—for example, if Google disabled the service account because it was compromised—you cannot
         * use this method to enable the service account.
         *
         * Create a request for the method "serviceAccounts.enable".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Enable#execute()} method to invoke the remote operation. <p> {@link
         * Enable#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource name of the service account in the following format:
       *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
       *        `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
       *        `email` address or the `unique_id` of the service account.
         * @param content the {@link com.google.api.services.iam.v1.model.EnableServiceAccountRequest}
         * @since 1.13
         */
        protected Enable(java.lang.String name, com.google.api.services.iam.v1.model.EnableServiceAccountRequest content) {
          super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
        }

        @Override
        public Enable set$Xgafv(java.lang.String $Xgafv) {
          return (Enable) super.set$Xgafv($Xgafv);
        }

        @Override
        public Enable setAccessToken(java.lang.String accessToken) {
          return (Enable) super.setAccessToken(accessToken);
        }

        @Override
        public Enable setAlt(java.lang.String alt) {
          return (Enable) super.setAlt(alt);
        }

        @Override
        public Enable setCallback(java.lang.String callback) {
          return (Enable) super.setCallback(callback);
        }

        @Override
        public Enable setFields(java.lang.String fields) {
          return (Enable) super.setFields(fields);
        }

        @Override
        public Enable setKey(java.lang.String key) {
          return (Enable) super.setKey(key);
        }

        @Override
        public Enable setOauthToken(java.lang.String oauthToken) {
          return (Enable) super.setOauthToken(oauthToken);
        }

        @Override
        public Enable setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Enable) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Enable setQuotaUser(java.lang.String quotaUser) {
          return (Enable) super.setQuotaUser(quotaUser);
        }

        @Override
        public Enable setUploadType(java.lang.String uploadType) {
          return (Enable) super.setUploadType(uploadType);
        }

        @Override
        public Enable setUploadProtocol(java.lang.String uploadProtocol) {
          return (Enable) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The resource name of the service account in the following format:
         * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
         * `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         * `email` address or the `unique_id` of the service account.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource name of the service account in the following format:
       `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the `PROJECT_ID`
       will infer the project from the account. The `ACCOUNT` value can be the `email` address or the
       `unique_id` of the service account.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The resource name of the service account in the following format:
         * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
         * `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         * `email` address or the `unique_id` of the service account.
         */
        public Enable setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Enable set(String parameterName, Object value) {
          return (Enable) super.set(parameterName, value);
        }
      }
      /**
       * Gets a ServiceAccount.
       *
       * Create a request for the method "serviceAccounts.get".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name of the service account in the following format:
       *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
       *        `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
       *        `email` address or the `unique_id` of the service account.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends IamRequest<com.google.api.services.iam.v1.model.ServiceAccount> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");

        /**
         * Gets a ServiceAccount.
         *
         * Create a request for the method "serviceAccounts.get".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name of the service account in the following format:
       *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
       *        `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
       *        `email` address or the `unique_id` of the service account.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Iam.this, "GET", REST_PATH, null, com.google.api.services.iam.v1.model.ServiceAccount.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The resource name of the service account in the following format:
         * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
         * `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         * `email` address or the `unique_id` of the service account.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name of the service account in the following format:
       `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the `PROJECT_ID`
       will infer the project from the account. The `ACCOUNT` value can be the `email` address or the
       `unique_id` of the service account.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The resource name of the service account in the following format:
         * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
         * `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         * `email` address or the `unique_id` of the service account.
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Gets the IAM policy that is attached to a ServiceAccount. This IAM policy specifies which members
       * have access to the service account. This method does not tell you whether the service account has
       * been granted any roles on other resources. To check whether a service account has role grants on
       * a resource, use the `getIamPolicy` method for that resource. For example, to view the role grants
       * for a project, call the Resource Manager API's [`projects.getIamPolicy`](https://cloud.google.com
       * /resource-manager/reference/rest/v1/projects/getIamPolicy) method.
       *
       * Create a request for the method "serviceAccounts.getIamPolicy".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
       *        the appropriate value for this field.
       * @return the request
       */
      public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
        GetIamPolicy result = new GetIamPolicy(resource);
        initialize(result);
        return result;
      }

      public class GetIamPolicy extends IamRequest<com.google.api.services.iam.v1.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");

        /**
         * Gets the IAM policy that is attached to a ServiceAccount. This IAM policy specifies which
         * members have access to the service account. This method does not tell you whether the service
         * account has been granted any roles on other resources. To check whether a service account has
         * role grants on a resource, use the `getIamPolicy` method for that resource. For example, to
         * view the role grants for a project, call the Resource Manager API's
         * [`projects.getIamPolicy`](https://cloud.google.com/resource-
         * manager/reference/rest/v1/projects/getIamPolicy) method.
         *
         * Create a request for the method "serviceAccounts.getIamPolicy".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation. <p>
         * {@link
         * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
       *        the appropriate value for this field.
         * @since 1.13
         */
        protected GetIamPolicy(java.lang.String resource) {
          super(Iam.this, "POST", REST_PATH, null, com.google.api.services.iam.v1.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
        }

        @Override
        public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (GetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (GetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public GetIamPolicy setAlt(java.lang.String alt) {
          return (GetIamPolicy) super.setAlt(alt);
        }

        @Override
        public GetIamPolicy setCallback(java.lang.String callback) {
          return (GetIamPolicy) super.setCallback(callback);
        }

        @Override
        public GetIamPolicy setFields(java.lang.String fields) {
          return (GetIamPolicy) super.setFields(fields);
        }

        @Override
        public GetIamPolicy setKey(java.lang.String key) {
          return (GetIamPolicy) super.setKey(key);
        }

        @Override
        public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (GetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (GetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetIamPolicy setUploadType(java.lang.String uploadType) {
          return (GetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
       the appropriate value for this field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        public GetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        /**
         * Optional. The policy format version to be returned. Valid values are 0, 1, and 3.
         * Requests specifying an invalid value will be rejected. Requests for policies with any
         * conditional bindings must specify version 3. Policies without any conditional bindings
         * may specify any valid value or leave the field unset. To learn which resources support
         * conditions in their IAM policies, see the [IAM
         * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        @com.google.api.client.util.Key("options.requestedPolicyVersion")
        private java.lang.Integer optionsRequestedPolicyVersion;

        /** Optional. The policy format version to be returned. Valid values are 0, 1, and 3. Requests
       specifying an invalid value will be rejected. Requests for policies with any conditional bindings
       must specify version 3. Policies without any conditional bindings may specify any valid value or
       leave the field unset. To learn which resources support conditions in their IAM policies, see the
       [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        public java.lang.Integer getOptionsRequestedPolicyVersion() {
          return optionsRequestedPolicyVersion;
        }

        /**
         * Optional. The policy format version to be returned. Valid values are 0, 1, and 3.
         * Requests specifying an invalid value will be rejected. Requests for policies with any
         * conditional bindings must specify version 3. Policies without any conditional bindings
         * may specify any valid value or leave the field unset. To learn which resources support
         * conditions in their IAM policies, see the [IAM
         * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
          this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
          return this;
        }

        @Override
        public GetIamPolicy set(String parameterName, Object value) {
          return (GetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Lists every ServiceAccount that belongs to a specific project.
       *
       * Create a request for the method "serviceAccounts.list".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name of the project associated with the service accounts, such as `projects
       *        /my-project-123`.
       * @return the request
       */
      public List list(java.lang.String name) throws java.io.IOException {
        List result = new List(name);
        initialize(result);
        return result;
      }

      public class List extends IamRequest<com.google.api.services.iam.v1.model.ListServiceAccountsResponse> {

        private static final String REST_PATH = "v1/{+name}/serviceAccounts";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists every ServiceAccount that belongs to a specific project.
         *
         * Create a request for the method "serviceAccounts.list".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name of the project associated with the service accounts, such as `projects
       *        /my-project-123`.
         * @since 1.13
         */
        protected List(java.lang.String name) {
          super(Iam.this, "GET", REST_PATH, null, com.google.api.services.iam.v1.model.ListServiceAccountsResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The resource name of the project associated with the service accounts, such as
         * `projects/my-project-123`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name of the project associated with the service accounts, such as `projects
       /my-project-123`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The resource name of the project associated with the service accounts, such as
         * `projects/my-project-123`.
         */
        public List setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * Optional limit on the number of service accounts to include in the response. Further
         * accounts can subsequently be obtained by including the
         * ListServiceAccountsResponse.next_page_token in a subsequent request. The default is 20,
         * and the maximum is 100.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** Optional limit on the number of service accounts to include in the response. Further accounts can
       subsequently be obtained by including the ListServiceAccountsResponse.next_page_token in a
       subsequent request. The default is 20, and the maximum is 100.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * Optional limit on the number of service accounts to include in the response. Further
         * accounts can subsequently be obtained by including the
         * ListServiceAccountsResponse.next_page_token in a subsequent request. The default is 20,
         * and the maximum is 100.
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * Optional pagination token returned in an earlier
         * ListServiceAccountsResponse.next_page_token.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** Optional pagination token returned in an earlier ListServiceAccountsResponse.next_page_token.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * Optional pagination token returned in an earlier
         * ListServiceAccountsResponse.next_page_token.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Patches a ServiceAccount.
       *
       * Create a request for the method "serviceAccounts.patch".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name The resource name of the service account. Use one of the following formats: *
       *        `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}` *
       *        `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}` As an alternative, you can use the `-`
       *        wildcard character instead of the project ID: *
       *        `projects/-/serviceAccounts/{EMAIL_ADDRESS}` * `projects/-/serviceAccounts/{UNIQUE_ID}`
       *        When possible, avoid using the `-` wildcard character, because it can cause response
       *        messages to contain misleading error codes. For example, if you try to get the service
       *        account `projects/-/serviceAccounts/fake@example.com`, which does not exist, the response
       *        contains an HTTP `403 Forbidden` error instead of a `404 Not Found` error.
       * @param content the {@link com.google.api.services.iam.v1.model.PatchServiceAccountRequest}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.iam.v1.model.PatchServiceAccountRequest content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends IamRequest<com.google.api.services.iam.v1.model.ServiceAccount> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");

        /**
         * Patches a ServiceAccount.
         *
         * Create a request for the method "serviceAccounts.patch".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource name of the service account. Use one of the following formats: *
       *        `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}` *
       *        `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}` As an alternative, you can use the `-`
       *        wildcard character instead of the project ID: *
       *        `projects/-/serviceAccounts/{EMAIL_ADDRESS}` * `projects/-/serviceAccounts/{UNIQUE_ID}`
       *        When possible, avoid using the `-` wildcard character, because it can cause response
       *        messages to contain misleading error codes. For example, if you try to get the service
       *        account `projects/-/serviceAccounts/fake@example.com`, which does not exist, the response
       *        contains an HTTP `403 Forbidden` error instead of a `404 Not Found` error.
         * @param content the {@link com.google.api.services.iam.v1.model.PatchServiceAccountRequest}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.iam.v1.model.PatchServiceAccountRequest content) {
          super(Iam.this, "PATCH", REST_PATH, content, com.google.api.services.iam.v1.model.ServiceAccount.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The resource name of the service account. Use one of the following formats: *
         * `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}` *
         * `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}` As an alternative, you can use the
         * `-` wildcard character instead of the project ID: *
         * `projects/-/serviceAccounts/{EMAIL_ADDRESS}` * `projects/-/serviceAccounts/{UNIQUE_ID}`
         * When possible, avoid using the `-` wildcard character, because it can cause response
         * messages to contain misleading error codes. For example, if you try to get the service
         * account `projects/-/serviceAccounts/fake@example.com`, which does not exist, the response
         * contains an HTTP `403 Forbidden` error instead of a `404 Not Found` error.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource name of the service account. Use one of the following formats: *
       `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}` *
       `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}` As an alternative, you can use the `-` wildcard
       character instead of the project ID: * `projects/-/serviceAccounts/{EMAIL_ADDRESS}` *
       `projects/-/serviceAccounts/{UNIQUE_ID}` When possible, avoid using the `-` wildcard character,
       because it can cause response messages to contain misleading error codes. For example, if you try
       to get the service account `projects/-/serviceAccounts/fake@example.com`, which does not exist, the
       response contains an HTTP `403 Forbidden` error instead of a `404 Not Found` error.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The resource name of the service account. Use one of the following formats: *
         * `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}` *
         * `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}` As an alternative, you can use the
         * `-` wildcard character instead of the project ID: *
         * `projects/-/serviceAccounts/{EMAIL_ADDRESS}` * `projects/-/serviceAccounts/{UNIQUE_ID}`
         * When possible, avoid using the `-` wildcard character, because it can cause response
         * messages to contain misleading error codes. For example, if you try to get the service
         * account `projects/-/serviceAccounts/fake@example.com`, which does not exist, the response
         * contains an HTTP `403 Forbidden` error instead of a `404 Not Found` error.
         */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Sets the IAM policy that is attached to a ServiceAccount. Use this method to grant or revoke
       * access to the service account. For example, you could grant a member the ability to impersonate
       * the service account. This method does not enable the service account to access other resources.
       * To grant roles to a service account on a resource, follow these steps: 1. Call the resource's
       * `getIamPolicy` method to get its current IAM policy. 2. Edit the policy so that it binds the
       * service account to an IAM role for the resource. 3. Call the resource's `setIamPolicy` method to
       * update its IAM policy. For detailed instructions, see [Granting roles to a service account for
       * specific resources](https://cloud.google.com/iam/help/service-accounts/granting-access-to-
       * service-accounts).
       *
       * Create a request for the method "serviceAccounts.setIamPolicy".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
       *        the appropriate value for this field.
       * @param content the {@link com.google.api.services.iam.v1.model.SetIamPolicyRequest}
       * @return the request
       */
      public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.iam.v1.model.SetIamPolicyRequest content) throws java.io.IOException {
        SetIamPolicy result = new SetIamPolicy(resource, content);
        initialize(result);
        return result;
      }

      public class SetIamPolicy extends IamRequest<com.google.api.services.iam.v1.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");

        /**
         * Sets the IAM policy that is attached to a ServiceAccount. Use this method to grant or revoke
         * access to the service account. For example, you could grant a member the ability to impersonate
         * the service account. This method does not enable the service account to access other resources.
         * To grant roles to a service account on a resource, follow these steps: 1. Call the resource's
         * `getIamPolicy` method to get its current IAM policy. 2. Edit the policy so that it binds the
         * service account to an IAM role for the resource. 3. Call the resource's `setIamPolicy` method
         * to update its IAM policy. For detailed instructions, see [Granting roles to a service account
         * for specific resources](https://cloud.google.com/iam/help/service-accounts/granting-access-to-
         * service-accounts).
         *
         * Create a request for the method "serviceAccounts.setIamPolicy".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation. <p>
         * {@link
         * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
       *        the appropriate value for this field.
         * @param content the {@link com.google.api.services.iam.v1.model.SetIamPolicyRequest}
         * @since 1.13
         */
        protected SetIamPolicy(java.lang.String resource, com.google.api.services.iam.v1.model.SetIamPolicyRequest content) {
          super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
        }

        @Override
        public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (SetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public SetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (SetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public SetIamPolicy setAlt(java.lang.String alt) {
          return (SetIamPolicy) super.setAlt(alt);
        }

        @Override
        public SetIamPolicy setCallback(java.lang.String callback) {
          return (SetIamPolicy) super.setCallback(callback);
        }

        @Override
        public SetIamPolicy setFields(java.lang.String fields) {
          return (SetIamPolicy) super.setFields(fields);
        }

        @Override
        public SetIamPolicy setKey(java.lang.String key) {
          return (SetIamPolicy) super.setKey(key);
        }

        @Override
        public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (SetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (SetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public SetIamPolicy setUploadType(java.lang.String uploadType) {
          return (SetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. See the operation
         * documentation for the appropriate value for this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
       the appropriate value for this field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. See the operation
         * documentation for the appropriate value for this field.
         */
        public SetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public SetIamPolicy set(String parameterName, Object value) {
          return (SetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * **Note:** This method is deprecated and will stop working on July 1, 2021. Use the
       * [`signBlob`](https://cloud.google.com/iam/help/rest-
       * credentials/v1/projects.serviceAccounts/signBlob) method in the IAM Service Account Credentials
       * API instead. If you currently use this method, see the [migration
       * guide](https://cloud.google.com/iam/help/credentials/migrate-api) for instructions. Signs a blob
       * using the system-managed private key for a ServiceAccount.
       *
       * Create a request for the method "serviceAccounts.signBlob".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link SignBlob#execute()} method to invoke the remote operation.
       *
       * @param name Required. Deprecated. [Migrate to Service Account Credentials
       *        API](https://cloud.google.com/iam/help/credentials/migrate-api). The resource name of the
       *        service account in the following format:
       *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
       *        `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
       *        `email` address or the `unique_id` of the service account.
       * @param content the {@link com.google.api.services.iam.v1.model.SignBlobRequest}
       * @return the request
       */
      public SignBlob signBlob(java.lang.String name, com.google.api.services.iam.v1.model.SignBlobRequest content) throws java.io.IOException {
        SignBlob result = new SignBlob(name, content);
        initialize(result);
        return result;
      }

      public class SignBlob extends IamRequest<com.google.api.services.iam.v1.model.SignBlobResponse> {

        private static final String REST_PATH = "v1/{+name}:signBlob";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");

        /**
         * **Note:** This method is deprecated and will stop working on July 1, 2021. Use the
         * [`signBlob`](https://cloud.google.com/iam/help/rest-
         * credentials/v1/projects.serviceAccounts/signBlob) method in the IAM Service Account Credentials
         * API instead. If you currently use this method, see the [migration
         * guide](https://cloud.google.com/iam/help/credentials/migrate-api) for instructions. Signs a
         * blob using the system-managed private key for a ServiceAccount.
         *
         * Create a request for the method "serviceAccounts.signBlob".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link SignBlob#execute()} method to invoke the remote operation. <p>
         * {@link
         * SignBlob#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. Deprecated. [Migrate to Service Account Credentials
       *        API](https://cloud.google.com/iam/help/credentials/migrate-api). The resource name of the
       *        service account in the following format:
       *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
       *        `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
       *        `email` address or the `unique_id` of the service account.
         * @param content the {@link com.google.api.services.iam.v1.model.SignBlobRequest}
         * @since 1.13
         */
        protected SignBlob(java.lang.String name, com.google.api.services.iam.v1.model.SignBlobRequest content) {
          super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.SignBlobResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
        }

        @Override
        public SignBlob set$Xgafv(java.lang.String $Xgafv) {
          return (SignBlob) super.set$Xgafv($Xgafv);
        }

        @Override
        public SignBlob setAccessToken(java.lang.String accessToken) {
          return (SignBlob) super.setAccessToken(accessToken);
        }

        @Override
        public SignBlob setAlt(java.lang.String alt) {
          return (SignBlob) super.setAlt(alt);
        }

        @Override
        public SignBlob setCallback(java.lang.String callback) {
          return (SignBlob) super.setCallback(callback);
        }

        @Override
        public SignBlob setFields(java.lang.String fields) {
          return (SignBlob) super.setFields(fields);
        }

        @Override
        public SignBlob setKey(java.lang.String key) {
          return (SignBlob) super.setKey(key);
        }

        @Override
        public SignBlob setOauthToken(java.lang.String oauthToken) {
          return (SignBlob) super.setOauthToken(oauthToken);
        }

        @Override
        public SignBlob setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (SignBlob) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public SignBlob setQuotaUser(java.lang.String quotaUser) {
          return (SignBlob) super.setQuotaUser(quotaUser);
        }

        @Override
        public SignBlob setUploadType(java.lang.String uploadType) {
          return (SignBlob) super.setUploadType(uploadType);
        }

        @Override
        public SignBlob setUploadProtocol(java.lang.String uploadProtocol) {
          return (SignBlob) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Deprecated. [Migrate to Service Account Credentials
         * API](https://cloud.google.com/iam/help/credentials/migrate-api). The resource name of the
         * service account in the following format:
         * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
         * `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         * `email` address or the `unique_id` of the service account.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Deprecated. [Migrate to Service Account Credentials
       API](https://cloud.google.com/iam/help/credentials/migrate-api). The resource name of the service
       account in the following format: `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a
       wildcard for the `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be
       the `email` address or the `unique_id` of the service account.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Deprecated. [Migrate to Service Account Credentials
         * API](https://cloud.google.com/iam/help/credentials/migrate-api). The resource name of the
         * service account in the following format:
         * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
         * `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         * `email` address or the `unique_id` of the service account.
         */
        public SignBlob setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public SignBlob set(String parameterName, Object value) {
          return (SignBlob) super.set(parameterName, value);
        }
      }
      /**
       * **Note:** This method is deprecated and will stop working on July 1, 2021. Use the
       * [`signJwt`](https://cloud.google.com/iam/help/rest-
       * credentials/v1/projects.serviceAccounts/signJwt) method in the IAM Service Account Credentials
       * API instead. If you currently use this method, see the [migration
       * guide](https://cloud.google.com/iam/help/credentials/migrate-api) for instructions. Signs a JSON
       * Web Token (JWT) using the system-managed private key for a ServiceAccount.
       *
       * Create a request for the method "serviceAccounts.signJwt".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link SignJwt#execute()} method to invoke the remote operation.
       *
       * @param name Required. Deprecated. [Migrate to Service Account Credentials
       *        API](https://cloud.google.com/iam/help/credentials/migrate-api). The resource name of the
       *        service account in the following format:
       *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
       *        `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
       *        `email` address or the `unique_id` of the service account.
       * @param content the {@link com.google.api.services.iam.v1.model.SignJwtRequest}
       * @return the request
       */
      public SignJwt signJwt(java.lang.String name, com.google.api.services.iam.v1.model.SignJwtRequest content) throws java.io.IOException {
        SignJwt result = new SignJwt(name, content);
        initialize(result);
        return result;
      }

      public class SignJwt extends IamRequest<com.google.api.services.iam.v1.model.SignJwtResponse> {

        private static final String REST_PATH = "v1/{+name}:signJwt";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");

        /**
         * **Note:** This method is deprecated and will stop working on July 1, 2021. Use the
         * [`signJwt`](https://cloud.google.com/iam/help/rest-
         * credentials/v1/projects.serviceAccounts/signJwt) method in the IAM Service Account Credentials
         * API instead. If you currently use this method, see the [migration
         * guide](https://cloud.google.com/iam/help/credentials/migrate-api) for instructions. Signs a
         * JSON Web Token (JWT) using the system-managed private key for a ServiceAccount.
         *
         * Create a request for the method "serviceAccounts.signJwt".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link SignJwt#execute()} method to invoke the remote operation. <p>
         * {@link
         * SignJwt#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. Deprecated. [Migrate to Service Account Credentials
       *        API](https://cloud.google.com/iam/help/credentials/migrate-api). The resource name of the
       *        service account in the following format:
       *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
       *        `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
       *        `email` address or the `unique_id` of the service account.
         * @param content the {@link com.google.api.services.iam.v1.model.SignJwtRequest}
         * @since 1.13
         */
        protected SignJwt(java.lang.String name, com.google.api.services.iam.v1.model.SignJwtRequest content) {
          super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.SignJwtResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
        }

        @Override
        public SignJwt set$Xgafv(java.lang.String $Xgafv) {
          return (SignJwt) super.set$Xgafv($Xgafv);
        }

        @Override
        public SignJwt setAccessToken(java.lang.String accessToken) {
          return (SignJwt) super.setAccessToken(accessToken);
        }

        @Override
        public SignJwt setAlt(java.lang.String alt) {
          return (SignJwt) super.setAlt(alt);
        }

        @Override
        public SignJwt setCallback(java.lang.String callback) {
          return (SignJwt) super.setCallback(callback);
        }

        @Override
        public SignJwt setFields(java.lang.String fields) {
          return (SignJwt) super.setFields(fields);
        }

        @Override
        public SignJwt setKey(java.lang.String key) {
          return (SignJwt) super.setKey(key);
        }

        @Override
        public SignJwt setOauthToken(java.lang.String oauthToken) {
          return (SignJwt) super.setOauthToken(oauthToken);
        }

        @Override
        public SignJwt setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (SignJwt) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public SignJwt setQuotaUser(java.lang.String quotaUser) {
          return (SignJwt) super.setQuotaUser(quotaUser);
        }

        @Override
        public SignJwt setUploadType(java.lang.String uploadType) {
          return (SignJwt) super.setUploadType(uploadType);
        }

        @Override
        public SignJwt setUploadProtocol(java.lang.String uploadProtocol) {
          return (SignJwt) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Deprecated. [Migrate to Service Account Credentials
         * API](https://cloud.google.com/iam/help/credentials/migrate-api). The resource name of the
         * service account in the following format:
         * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
         * `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         * `email` address or the `unique_id` of the service account.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Deprecated. [Migrate to Service Account Credentials
       API](https://cloud.google.com/iam/help/credentials/migrate-api). The resource name of the service
       account in the following format: `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a
       wildcard for the `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be
       the `email` address or the `unique_id` of the service account.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Deprecated. [Migrate to Service Account Credentials
         * API](https://cloud.google.com/iam/help/credentials/migrate-api). The resource name of the
         * service account in the following format:
         * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
         * `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         * `email` address or the `unique_id` of the service account.
         */
        public SignJwt setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public SignJwt set(String parameterName, Object value) {
          return (SignJwt) super.set(parameterName, value);
        }
      }
      /**
       * Tests whether the caller has the specified permissions on a ServiceAccount.
       *
       * Create a request for the method "serviceAccounts.testIamPermissions".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
       *        documentation for the appropriate value for this field.
       * @param content the {@link com.google.api.services.iam.v1.model.TestIamPermissionsRequest}
       * @return the request
       */
      public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.iam.v1.model.TestIamPermissionsRequest content) throws java.io.IOException {
        TestIamPermissions result = new TestIamPermissions(resource, content);
        initialize(result);
        return result;
      }

      public class TestIamPermissions extends IamRequest<com.google.api.services.iam.v1.model.TestIamPermissionsResponse> {

        private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");

        /**
         * Tests whether the caller has the specified permissions on a ServiceAccount.
         *
         * Create a request for the method "serviceAccounts.testIamPermissions".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
         * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
         * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
       *        documentation for the appropriate value for this field.
         * @param content the {@link com.google.api.services.iam.v1.model.TestIamPermissionsRequest}
         * @since 1.13
         */
        protected TestIamPermissions(java.lang.String resource, com.google.api.services.iam.v1.model.TestIamPermissionsRequest content) {
          super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.TestIamPermissionsResponse.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
        }

        @Override
        public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
          return (TestIamPermissions) super.set$Xgafv($Xgafv);
        }

        @Override
        public TestIamPermissions setAccessToken(java.lang.String accessToken) {
          return (TestIamPermissions) super.setAccessToken(accessToken);
        }

        @Override
        public TestIamPermissions setAlt(java.lang.String alt) {
          return (TestIamPermissions) super.setAlt(alt);
        }

        @Override
        public TestIamPermissions setCallback(java.lang.String callback) {
          return (TestIamPermissions) super.setCallback(callback);
        }

        @Override
        public TestIamPermissions setFields(java.lang.String fields) {
          return (TestIamPermissions) super.setFields(fields);
        }

        @Override
        public TestIamPermissions setKey(java.lang.String key) {
          return (TestIamPermissions) super.setKey(key);
        }

        @Override
        public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
          return (TestIamPermissions) super.setOauthToken(oauthToken);
        }

        @Override
        public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
          return (TestIamPermissions) super.setQuotaUser(quotaUser);
        }

        @Override
        public TestIamPermissions setUploadType(java.lang.String uploadType) {
          return (TestIamPermissions) super.setUploadType(uploadType);
        }

        @Override
        public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
          return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy detail is being requested. See the operation
       documentation for the appropriate value for this field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        public TestIamPermissions setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public TestIamPermissions set(String parameterName, Object value) {
          return (TestIamPermissions) super.set(parameterName, value);
        }
      }
      /**
       * Restores a deleted ServiceAccount. **Important:** It is not always possible to restore a deleted
       * service account. Use this method only as a last resort. After you delete a service account, IAM
       * permanently removes the service account 30 days later. There is no way to restore a deleted
       * service account that has been permanently removed.
       *
       * Create a request for the method "serviceAccounts.undelete".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Undelete#execute()} method to invoke the remote operation.
       *
       * @param name The resource name of the service account in the following format:
       *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_UNIQUE_ID}`. Using `-` as a wildcard for
       *        the `PROJECT_ID` will infer the project from the account.
       * @param content the {@link com.google.api.services.iam.v1.model.UndeleteServiceAccountRequest}
       * @return the request
       */
      public Undelete undelete(java.lang.String name, com.google.api.services.iam.v1.model.UndeleteServiceAccountRequest content) throws java.io.IOException {
        Undelete result = new Undelete(name, content);
        initialize(result);
        return result;
      }

      public class Undelete extends IamRequest<com.google.api.services.iam.v1.model.UndeleteServiceAccountResponse> {

        private static final String REST_PATH = "v1/{+name}:undelete";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");

        /**
         * Restores a deleted ServiceAccount. **Important:** It is not always possible to restore a
         * deleted service account. Use this method only as a last resort. After you delete a service
         * account, IAM permanently removes the service account 30 days later. There is no way to restore
         * a deleted service account that has been permanently removed.
         *
         * Create a request for the method "serviceAccounts.undelete".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Undelete#execute()} method to invoke the remote operation. <p>
         * {@link
         * Undelete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource name of the service account in the following format:
       *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_UNIQUE_ID}`. Using `-` as a wildcard for
       *        the `PROJECT_ID` will infer the project from the account.
         * @param content the {@link com.google.api.services.iam.v1.model.UndeleteServiceAccountRequest}
         * @since 1.13
         */
        protected Undelete(java.lang.String name, com.google.api.services.iam.v1.model.UndeleteServiceAccountRequest content) {
          super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.UndeleteServiceAccountResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
        }

        @Override
        public Undelete set$Xgafv(java.lang.String $Xgafv) {
          return (Undelete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Undelete setAccessToken(java.lang.String accessToken) {
          return (Undelete) super.setAccessToken(accessToken);
        }

        @Override
        public Undelete setAlt(java.lang.String alt) {
          return (Undelete) super.setAlt(alt);
        }

        @Override
        public Undelete setCallback(java.lang.String callback) {
          return (Undelete) super.setCallback(callback);
        }

        @Override
        public Undelete setFields(java.lang.String fields) {
          return (Undelete) super.setFields(fields);
        }

        @Override
        public Undelete setKey(java.lang.String key) {
          return (Undelete) super.setKey(key);
        }

        @Override
        public Undelete setOauthToken(java.lang.String oauthToken) {
          return (Undelete) super.setOauthToken(oauthToken);
        }

        @Override
        public Undelete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Undelete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Undelete setQuotaUser(java.lang.String quotaUser) {
          return (Undelete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Undelete setUploadType(java.lang.String uploadType) {
          return (Undelete) super.setUploadType(uploadType);
        }

        @Override
        public Undelete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Undelete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The resource name of the service account in the following format:
         * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_UNIQUE_ID}`. Using `-` as a wildcard for
         * the `PROJECT_ID` will infer the project from the account.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource name of the service account in the following format:
       `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_UNIQUE_ID}`. Using `-` as a wildcard for the
       `PROJECT_ID` will infer the project from the account.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The resource name of the service account in the following format:
         * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_UNIQUE_ID}`. Using `-` as a wildcard for
         * the `PROJECT_ID` will infer the project from the account.
         */
        public Undelete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Undelete set(String parameterName, Object value) {
          return (Undelete) super.set(parameterName, value);
        }
      }
      /**
       * **Note:** We are in the process of deprecating this method. Use PatchServiceAccount instead.
       * Updates a ServiceAccount. You can update only the `display_name` and `description` fields.
       *
       * Create a request for the method "serviceAccounts.update".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param name The resource name of the service account. Use one of the following formats: *
       *        `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}` *
       *        `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}` As an alternative, you can use the `-`
       *        wildcard character instead of the project ID: *
       *        `projects/-/serviceAccounts/{EMAIL_ADDRESS}` * `projects/-/serviceAccounts/{UNIQUE_ID}`
       *        When possible, avoid using the `-` wildcard character, because it can cause response
       *        messages to contain misleading error codes. For example, if you try to get the service
       *        account `projects/-/serviceAccounts/fake@example.com`, which does not exist, the response
       *        contains an HTTP `403 Forbidden` error instead of a `404 Not Found` error.
       * @param content the {@link com.google.api.services.iam.v1.model.ServiceAccount}
       * @return the request
       */
      public Update update(java.lang.String name, com.google.api.services.iam.v1.model.ServiceAccount content) throws java.io.IOException {
        Update result = new Update(name, content);
        initialize(result);
        return result;
      }

      public class Update extends IamRequest<com.google.api.services.iam.v1.model.ServiceAccount> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");

        /**
         * **Note:** We are in the process of deprecating this method. Use PatchServiceAccount instead.
         * Updates a ServiceAccount. You can update only the `display_name` and `description` fields.
         *
         * Create a request for the method "serviceAccounts.update".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource name of the service account. Use one of the following formats: *
       *        `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}` *
       *        `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}` As an alternative, you can use the `-`
       *        wildcard character instead of the project ID: *
       *        `projects/-/serviceAccounts/{EMAIL_ADDRESS}` * `projects/-/serviceAccounts/{UNIQUE_ID}`
       *        When possible, avoid using the `-` wildcard character, because it can cause response
       *        messages to contain misleading error codes. For example, if you try to get the service
       *        account `projects/-/serviceAccounts/fake@example.com`, which does not exist, the response
       *        contains an HTTP `403 Forbidden` error instead of a `404 Not Found` error.
         * @param content the {@link com.google.api.services.iam.v1.model.ServiceAccount}
         * @since 1.13
         */
        protected Update(java.lang.String name, com.google.api.services.iam.v1.model.ServiceAccount content) {
          super(Iam.this, "PUT", REST_PATH, content, com.google.api.services.iam.v1.model.ServiceAccount.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The resource name of the service account. Use one of the following formats: *
         * `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}` *
         * `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}` As an alternative, you can use the
         * `-` wildcard character instead of the project ID: *
         * `projects/-/serviceAccounts/{EMAIL_ADDRESS}` * `projects/-/serviceAccounts/{UNIQUE_ID}`
         * When possible, avoid using the `-` wildcard character, because it can cause response
         * messages to contain misleading error codes. For example, if you try to get the service
         * account `projects/-/serviceAccounts/fake@example.com`, which does not exist, the response
         * contains an HTTP `403 Forbidden` error instead of a `404 Not Found` error.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource name of the service account. Use one of the following formats: *
       `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}` *
       `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}` As an alternative, you can use the `-` wildcard
       character instead of the project ID: * `projects/-/serviceAccounts/{EMAIL_ADDRESS}` *
       `projects/-/serviceAccounts/{UNIQUE_ID}` When possible, avoid using the `-` wildcard character,
       because it can cause response messages to contain misleading error codes. For example, if you try
       to get the service account `projects/-/serviceAccounts/fake@example.com`, which does not exist, the
       response contains an HTTP `403 Forbidden` error instead of a `404 Not Found` error.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The resource name of the service account. Use one of the following formats: *
         * `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}` *
         * `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}` As an alternative, you can use the
         * `-` wildcard character instead of the project ID: *
         * `projects/-/serviceAccounts/{EMAIL_ADDRESS}` * `projects/-/serviceAccounts/{UNIQUE_ID}`
         * When possible, avoid using the `-` wildcard character, because it can cause response
         * messages to contain misleading error codes. For example, if you try to get the service
         * account `projects/-/serviceAccounts/fake@example.com`, which does not exist, the response
         * contains an HTTP `403 Forbidden` error instead of a `404 Not Found` error.
         */
        public Update setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/serviceAccounts/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the Keys collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Iam iam = new Iam(...);}
       *   {@code Iam.Keys.List request = iam.keys().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Keys keys() {
        return new Keys();
      }

      /**
       * The "keys" collection of methods.
       */
      public class Keys {

        /**
         * Creates a ServiceAccountKey.
         *
         * Create a request for the method "keys.create".
         *
         * This request holds the parameters needed by the iam server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param name Required. The resource name of the service account in the following format:
         *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
         *        `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         *        `email` address or the `unique_id` of the service account.
         * @param content the {@link com.google.api.services.iam.v1.model.CreateServiceAccountKeyRequest}
         * @return the request
         */
        public Create create(java.lang.String name, com.google.api.services.iam.v1.model.CreateServiceAccountKeyRequest content) throws java.io.IOException {
          Create result = new Create(name, content);
          initialize(result);
          return result;
        }

        public class Create extends IamRequest<com.google.api.services.iam.v1.model.ServiceAccountKey> {

          private static final String REST_PATH = "v1/{+name}/keys";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");

          /**
           * Creates a ServiceAccountKey.
           *
           * Create a request for the method "keys.create".
           *
           * This request holds the parameters needed by the the iam server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. The resource name of the service account in the following format:
         *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
         *        `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         *        `email` address or the `unique_id` of the service account.
           * @param content the {@link com.google.api.services.iam.v1.model.CreateServiceAccountKeyRequest}
           * @since 1.13
           */
          protected Create(java.lang.String name, com.google.api.services.iam.v1.model.CreateServiceAccountKeyRequest content) {
            super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.ServiceAccountKey.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/serviceAccounts/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The resource name of the service account in the following format:
           * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
           * `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
           * `email` address or the `unique_id` of the service account.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. The resource name of the service account in the following format:
         `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the `PROJECT_ID`
         will infer the project from the account. The `ACCOUNT` value can be the `email` address or the
         `unique_id` of the service account.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. The resource name of the service account in the following format:
           * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
           * `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
           * `email` address or the `unique_id` of the service account.
           */
          public Create setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/serviceAccounts/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes a ServiceAccountKey. Deleting a service account key does not revoke short-lived
         * credentials that have been issued based on the service account key.
         *
         * Create a request for the method "keys.delete".
         *
         * This request holds the parameters needed by the iam server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name Required. The resource name of the service account key in the following format:
         *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`. Using `-` as a wildcard for
         *        the `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         *        `email` address or the `unique_id` of the service account.
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends IamRequest<com.google.api.services.iam.v1.model.Empty> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");

          /**
           * Deletes a ServiceAccountKey. Deleting a service account key does not revoke short-lived
           * credentials that have been issued based on the service account key.
           *
           * Create a request for the method "keys.delete".
           *
           * This request holds the parameters needed by the the iam server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. The resource name of the service account key in the following format:
         *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`. Using `-` as a wildcard for
         *        the `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         *        `email` address or the `unique_id` of the service account.
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(Iam.this, "DELETE", REST_PATH, null, com.google.api.services.iam.v1.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The resource name of the service account key in the following format:
           * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`. Using `-` as a wildcard
           * for the `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can
           * be the `email` address or the `unique_id` of the service account.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. The resource name of the service account key in the following format:
         `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`. Using `-` as a wildcard for the
         `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the `email`
         address or the `unique_id` of the service account.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. The resource name of the service account key in the following format:
           * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`. Using `-` as a wildcard
           * for the `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can
           * be the `email` address or the `unique_id` of the service account.
           */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets a ServiceAccountKey.
         *
         * Create a request for the method "keys.get".
         *
         * This request holds the parameters needed by the iam server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Required. The resource name of the service account key in the following format:
         *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`. Using `-` as a wildcard for
         *        the `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         *        `email` address or the `unique_id` of the service account.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends IamRequest<com.google.api.services.iam.v1.model.ServiceAccountKey> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");

          /**
           * Gets a ServiceAccountKey.
           *
           * Create a request for the method "keys.get".
           *
           * This request holds the parameters needed by the the iam server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
           * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. The resource name of the service account key in the following format:
         *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`. Using `-` as a wildcard for
         *        the `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         *        `email` address or the `unique_id` of the service account.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(Iam.this, "GET", REST_PATH, null, com.google.api.services.iam.v1.model.ServiceAccountKey.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The resource name of the service account key in the following format:
           * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`. Using `-` as a wildcard
           * for the `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can
           * be the `email` address or the `unique_id` of the service account.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. The resource name of the service account key in the following format:
         `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`. Using `-` as a wildcard for the
         `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the `email`
         address or the `unique_id` of the service account.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. The resource name of the service account key in the following format:
           * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`. Using `-` as a wildcard
           * for the `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can
           * be the `email` address or the `unique_id` of the service account.
           */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /**
           * The output format of the public key requested. X509_PEM is the default output format.
           */
          @com.google.api.client.util.Key
          private java.lang.String publicKeyType;

          /** The output format of the public key requested. X509_PEM is the default output format.
           */
          public java.lang.String getPublicKeyType() {
            return publicKeyType;
          }

          /**
           * The output format of the public key requested. X509_PEM is the default output format.
           */
          public Get setPublicKeyType(java.lang.String publicKeyType) {
            this.publicKeyType = publicKeyType;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists every ServiceAccountKey for a service account.
         *
         * Create a request for the method "keys.list".
         *
         * This request holds the parameters needed by the iam server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param name Required. The resource name of the service account in the following format:
         *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
         *        `PROJECT_ID`, will infer the project from the account. The `ACCOUNT` value can be the
         *        `email` address or the `unique_id` of the service account.
         * @return the request
         */
        public List list(java.lang.String name) throws java.io.IOException {
          List result = new List(name);
          initialize(result);
          return result;
        }

        public class List extends IamRequest<com.google.api.services.iam.v1.model.ListServiceAccountKeysResponse> {

          private static final String REST_PATH = "v1/{+name}/keys";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");

          /**
           * Lists every ServiceAccountKey for a service account.
           *
           * Create a request for the method "keys.list".
           *
           * This request holds the parameters needed by the the iam server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
           * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. The resource name of the service account in the following format:
         *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
         *        `PROJECT_ID`, will infer the project from the account. The `ACCOUNT` value can be the
         *        `email` address or the `unique_id` of the service account.
           * @since 1.13
           */
          protected List(java.lang.String name) {
            super(Iam.this, "GET", REST_PATH, null, com.google.api.services.iam.v1.model.ListServiceAccountKeysResponse.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/serviceAccounts/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The resource name of the service account in the following format:
           * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
           * `PROJECT_ID`, will infer the project from the account. The `ACCOUNT` value can be the
           * `email` address or the `unique_id` of the service account.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. The resource name of the service account in the following format:
         `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the `PROJECT_ID`,
         will infer the project from the account. The `ACCOUNT` value can be the `email` address or the
         `unique_id` of the service account.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. The resource name of the service account in the following format:
           * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
           * `PROJECT_ID`, will infer the project from the account. The `ACCOUNT` value can be the
           * `email` address or the `unique_id` of the service account.
           */
          public List setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/serviceAccounts/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /**
           * Filters the types of keys the user wants to include in the list response. Duplicate key
           * types are not allowed. If no key type is provided, all keys are returned.
           */
          @com.google.api.client.util.Key
          private java.util.List<java.lang.String> keyTypes;

          /** Filters the types of keys the user wants to include in the list response. Duplicate key types are
         not allowed. If no key type is provided, all keys are returned.
           */
          public java.util.List<java.lang.String> getKeyTypes() {
            return keyTypes;
          }

          /**
           * Filters the types of keys the user wants to include in the list response. Duplicate key
           * types are not allowed. If no key type is provided, all keys are returned.
           */
          public List setKeyTypes(java.util.List<java.lang.String> keyTypes) {
            this.keyTypes = keyTypes;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Creates a ServiceAccountKey, using a public key that you provide.
         *
         * Create a request for the method "keys.upload".
         *
         * This request holds the parameters needed by the iam server.  After setting any optional
         * parameters, call the {@link Upload#execute()} method to invoke the remote operation.
         *
         * @param name The resource name of the service account in the following format:
         *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
         *        `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         *        `email` address or the `unique_id` of the service account.
         * @param content the {@link com.google.api.services.iam.v1.model.UploadServiceAccountKeyRequest}
         * @return the request
         */
        public Upload upload(java.lang.String name, com.google.api.services.iam.v1.model.UploadServiceAccountKeyRequest content) throws java.io.IOException {
          Upload result = new Upload(name, content);
          initialize(result);
          return result;
        }

        public class Upload extends IamRequest<com.google.api.services.iam.v1.model.ServiceAccountKey> {

          private static final String REST_PATH = "v1/{+name}/keys:upload";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");

          /**
           * Creates a ServiceAccountKey, using a public key that you provide.
           *
           * Create a request for the method "keys.upload".
           *
           * This request holds the parameters needed by the the iam server.  After setting any optional
           * parameters, call the {@link Upload#execute()} method to invoke the remote operation. <p> {@link
           * Upload#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The resource name of the service account in the following format:
         *        `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
         *        `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
         *        `email` address or the `unique_id` of the service account.
           * @param content the {@link com.google.api.services.iam.v1.model.UploadServiceAccountKeyRequest}
           * @since 1.13
           */
          protected Upload(java.lang.String name, com.google.api.services.iam.v1.model.UploadServiceAccountKeyRequest content) {
            super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.ServiceAccountKey.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/serviceAccounts/[^/]+$");
            }
          }

          @Override
          public Upload set$Xgafv(java.lang.String $Xgafv) {
            return (Upload) super.set$Xgafv($Xgafv);
          }

          @Override
          public Upload setAccessToken(java.lang.String accessToken) {
            return (Upload) super.setAccessToken(accessToken);
          }

          @Override
          public Upload setAlt(java.lang.String alt) {
            return (Upload) super.setAlt(alt);
          }

          @Override
          public Upload setCallback(java.lang.String callback) {
            return (Upload) super.setCallback(callback);
          }

          @Override
          public Upload setFields(java.lang.String fields) {
            return (Upload) super.setFields(fields);
          }

          @Override
          public Upload setKey(java.lang.String key) {
            return (Upload) super.setKey(key);
          }

          @Override
          public Upload setOauthToken(java.lang.String oauthToken) {
            return (Upload) super.setOauthToken(oauthToken);
          }

          @Override
          public Upload setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Upload) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Upload setQuotaUser(java.lang.String quotaUser) {
            return (Upload) super.setQuotaUser(quotaUser);
          }

          @Override
          public Upload setUploadType(java.lang.String uploadType) {
            return (Upload) super.setUploadType(uploadType);
          }

          @Override
          public Upload setUploadProtocol(java.lang.String uploadProtocol) {
            return (Upload) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The resource name of the service account in the following format:
           * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
           * `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
           * `email` address or the `unique_id` of the service account.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The resource name of the service account in the following format:
         `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the `PROJECT_ID`
         will infer the project from the account. The `ACCOUNT` value can be the `email` address or the
         `unique_id` of the service account.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The resource name of the service account in the following format:
           * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard for the
           * `PROJECT_ID` will infer the project from the account. The `ACCOUNT` value can be the
           * `email` address or the `unique_id` of the service account.
           */
          public Upload setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/serviceAccounts/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Upload set(String parameterName, Object value) {
            return (Upload) super.set(parameterName, value);
          }
        }

      }
    }
  }

  /**
   * An accessor for creating requests from the Roles collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Iam iam = new Iam(...);}
   *   {@code Iam.Roles.List request = iam.roles().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Roles roles() {
    return new Roles();
  }

  /**
   * The "roles" collection of methods.
   */
  public class Roles {

    /**
     * Gets the definition of a Role.
     *
     * Create a request for the method "roles.get".
     *
     * This request holds the parameters needed by the iam server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param name The `name` parameter's value depends on the target resource for the request, namely
     *        [`roles`](/iam/reference/rest/v1/roles),
     *        [`projects`](/iam/reference/rest/v1/projects.roles), or
     *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
     *        value format is described below: * [`roles.get()`](/iam/reference/rest/v1/roles/get):
     *        `roles/{ROLE_NAME}`. This method returns results from all [predefined roles](/iam/docs
     *        /understanding-roles#predefined_roles) in Cloud IAM. Example request URL:
     *        `https://iam.googleapis.com/v1/roles/{ROLE_NAME}` *
     *        [`projects.roles.get()`](/iam/reference/rest/v1/projects.roles/get):
     *        `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
     *        roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
     *        Example request URL:
     *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
     *        [`organizations.roles.get()`](/iam/reference/rest/v1/organizations.roles/get):
     *        `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
     *        roles](/iam/docs/understanding-custom-roles) that have been created at the organization
     *        level. Example request URL:
     *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
     *        Note: Wildcard (*) values are invalid; you must specify a complete project ID or
     *        organization ID.
     * @return the request
     */
    public Get get(java.lang.String name) throws java.io.IOException {
      Get result = new Get(name);
      initialize(result);
      return result;
    }

    public class Get extends IamRequest<com.google.api.services.iam.v1.model.Role> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^roles/[^/]+$");

      /**
       * Gets the definition of a Role.
       *
       * Create a request for the method "roles.get".
       *
       * This request holds the parameters needed by the the iam server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The `name` parameter's value depends on the target resource for the request, namely
     *        [`roles`](/iam/reference/rest/v1/roles),
     *        [`projects`](/iam/reference/rest/v1/projects.roles), or
     *        [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
     *        value format is described below: * [`roles.get()`](/iam/reference/rest/v1/roles/get):
     *        `roles/{ROLE_NAME}`. This method returns results from all [predefined roles](/iam/docs
     *        /understanding-roles#predefined_roles) in Cloud IAM. Example request URL:
     *        `https://iam.googleapis.com/v1/roles/{ROLE_NAME}` *
     *        [`projects.roles.get()`](/iam/reference/rest/v1/projects.roles/get):
     *        `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
     *        roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
     *        Example request URL:
     *        `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
     *        [`organizations.roles.get()`](/iam/reference/rest/v1/organizations.roles/get):
     *        `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
     *        roles](/iam/docs/understanding-custom-roles) that have been created at the organization
     *        level. Example request URL:
     *        `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
     *        Note: Wildcard (*) values are invalid; you must specify a complete project ID or
     *        organization ID.
       * @since 1.13
       */
      protected Get(java.lang.String name) {
        super(Iam.this, "GET", REST_PATH, null, com.google.api.services.iam.v1.model.Role.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^roles/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The `name` parameter's value depends on the target resource for the request, namely
       * [`roles`](/iam/reference/rest/v1/roles),
       * [`projects`](/iam/reference/rest/v1/projects.roles), or
       * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
       * value format is described below: * [`roles.get()`](/iam/reference/rest/v1/roles/get):
       * `roles/{ROLE_NAME}`. This method returns results from all [predefined roles](/iam/docs
       * /understanding-roles#predefined_roles) in Cloud IAM. Example request URL:
       * `https://iam.googleapis.com/v1/roles/{ROLE_NAME}` *
       * [`projects.roles.get()`](/iam/reference/rest/v1/projects.roles/get):
       * `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
       * roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
       * Example request URL:
       * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       * [`organizations.roles.get()`](/iam/reference/rest/v1/organizations.roles/get):
       * `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
       * roles](/iam/docs/understanding-custom-roles) that have been created at the organization
       * level. Example request URL:
       * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
       * Note: Wildcard (*) values are invalid; you must specify a complete project ID or
       * organization ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The `name` parameter's value depends on the target resource for the request, namely
     [`roles`](/iam/reference/rest/v1/roles), [`projects`](/iam/reference/rest/v1/projects.roles), or
     [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name` value
     format is described below: * [`roles.get()`](/iam/reference/rest/v1/roles/get):
     `roles/{ROLE_NAME}`. This method returns results from all [predefined roles](/iam/docs
     /understanding-roles#predefined_roles) in Cloud IAM. Example request URL:
     `https://iam.googleapis.com/v1/roles/{ROLE_NAME}` *
     [`projects.roles.get()`](/iam/reference/rest/v1/projects.roles/get):
     `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom roles](/iam/docs
     /understanding-custom-roles) that have been created at the project level. Example request URL:
     `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
     [`organizations.roles.get()`](/iam/reference/rest/v1/organizations.roles/get):
     `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
     roles](/iam/docs/understanding-custom-roles) that have been created at the organization level.
     Example request URL:
     `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}` Note:
     Wildcard (*) values are invalid; you must specify a complete project ID or organization ID.
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * The `name` parameter's value depends on the target resource for the request, namely
       * [`roles`](/iam/reference/rest/v1/roles),
       * [`projects`](/iam/reference/rest/v1/projects.roles), or
       * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `name`
       * value format is described below: * [`roles.get()`](/iam/reference/rest/v1/roles/get):
       * `roles/{ROLE_NAME}`. This method returns results from all [predefined roles](/iam/docs
       * /understanding-roles#predefined_roles) in Cloud IAM. Example request URL:
       * `https://iam.googleapis.com/v1/roles/{ROLE_NAME}` *
       * [`projects.roles.get()`](/iam/reference/rest/v1/projects.roles/get):
       * `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
       * roles](/iam/docs/understanding-custom-roles) that have been created at the project level.
       * Example request URL:
       * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}` *
       * [`organizations.roles.get()`](/iam/reference/rest/v1/organizations.roles/get):
       * `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only [custom
       * roles](/iam/docs/understanding-custom-roles) that have been created at the organization
       * level. Example request URL:
       * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
       * Note: Wildcard (*) values are invalid; you must specify a complete project ID or
       * organization ID.
       */
      public Get setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^roles/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists every predefined Role that IAM supports, or every custom role that is defined for an
     * organization or project.
     *
     * Create a request for the method "roles.list".
     *
     * This request holds the parameters needed by the iam server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends IamRequest<com.google.api.services.iam.v1.model.ListRolesResponse> {

      private static final String REST_PATH = "v1/roles";

      /**
       * Lists every predefined Role that IAM supports, or every custom role that is defined for an
       * organization or project.
       *
       * Create a request for the method "roles.list".
       *
       * This request holds the parameters needed by the the iam server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Iam.this, "GET", REST_PATH, null, com.google.api.services.iam.v1.model.ListRolesResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Optional limit on the number of roles to include in the response. The default is 300, and
       * the maximum is 1,000.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** Optional limit on the number of roles to include in the response. The default is 300, and the
     maximum is 1,000.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * Optional limit on the number of roles to include in the response. The default is 300, and
       * the maximum is 1,000.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /** Optional pagination token returned in an earlier ListRolesResponse. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional pagination token returned in an earlier ListRolesResponse.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Optional pagination token returned in an earlier ListRolesResponse. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The `parent` parameter's value depends on the target resource for the request, namely
       * [`roles`](/iam/reference/rest/v1/roles),
       * [`projects`](/iam/reference/rest/v1/projects.roles), or
       * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
       * `parent` value format is described below: *
       * [`roles.list()`](/iam/reference/rest/v1/roles/list): An empty string. This method doesn't
       * require a resource; it simply returns all [predefined roles](/iam/docs/understanding-
       * roles#predefined_roles) in Cloud IAM. Example request URL:
       * `https://iam.googleapis.com/v1/roles` *
       * [`projects.roles.list()`](/iam/reference/rest/v1/projects.roles/list):
       * `projects/{PROJECT_ID}`. This method lists all project-level [custom roles](/iam/docs
       * /understanding-custom-roles). Example request URL:
       * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
       * [`organizations.roles.list()`](/iam/reference/rest/v1/organizations.roles/list):
       * `organizations/{ORGANIZATION_ID}`. This method lists all organization-level [custom
       * roles](/iam/docs/understanding-custom-roles). Example request URL:
       * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*)
       * values are invalid; you must specify a complete project ID or organization ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String parent;

      /** The `parent` parameter's value depends on the target resource for the request, namely
     [`roles`](/iam/reference/rest/v1/roles), [`projects`](/iam/reference/rest/v1/projects.roles), or
     [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's `parent` value
     format is described below: * [`roles.list()`](/iam/reference/rest/v1/roles/list): An empty string.
     This method doesn't require a resource; it simply returns all [predefined roles](/iam/docs
     /understanding-roles#predefined_roles) in Cloud IAM. Example request URL:
     `https://iam.googleapis.com/v1/roles` *
     [`projects.roles.list()`](/iam/reference/rest/v1/projects.roles/list): `projects/{PROJECT_ID}`.
     This method lists all project-level [custom roles](/iam/docs/understanding-custom-roles). Example
     request URL: `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
     [`organizations.roles.list()`](/iam/reference/rest/v1/organizations.roles/list):
     `organizations/{ORGANIZATION_ID}`. This method lists all organization-level [custom
     roles](/iam/docs/understanding-custom-roles). Example request URL:
     `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*) values are
     invalid; you must specify a complete project ID or organization ID.
       */
      public java.lang.String getParent() {
        return parent;
      }

      /**
       * The `parent` parameter's value depends on the target resource for the request, namely
       * [`roles`](/iam/reference/rest/v1/roles),
       * [`projects`](/iam/reference/rest/v1/projects.roles), or
       * [`organizations`](/iam/reference/rest/v1/organizations.roles). Each resource type's
       * `parent` value format is described below: *
       * [`roles.list()`](/iam/reference/rest/v1/roles/list): An empty string. This method doesn't
       * require a resource; it simply returns all [predefined roles](/iam/docs/understanding-
       * roles#predefined_roles) in Cloud IAM. Example request URL:
       * `https://iam.googleapis.com/v1/roles` *
       * [`projects.roles.list()`](/iam/reference/rest/v1/projects.roles/list):
       * `projects/{PROJECT_ID}`. This method lists all project-level [custom roles](/iam/docs
       * /understanding-custom-roles). Example request URL:
       * `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles` *
       * [`organizations.roles.list()`](/iam/reference/rest/v1/organizations.roles/list):
       * `organizations/{ORGANIZATION_ID}`. This method lists all organization-level [custom
       * roles](/iam/docs/understanding-custom-roles). Example request URL:
       * `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles` Note: Wildcard (*)
       * values are invalid; you must specify a complete project ID or organization ID.
       */
      public List setParent(java.lang.String parent) {
        this.parent = parent;
        return this;
      }

      /** Include Roles that have been deleted. */
      @com.google.api.client.util.Key
      private java.lang.Boolean showDeleted;

      /** Include Roles that have been deleted.
       */
      public java.lang.Boolean getShowDeleted() {
        return showDeleted;
      }

      /** Include Roles that have been deleted. */
      public List setShowDeleted(java.lang.Boolean showDeleted) {
        this.showDeleted = showDeleted;
        return this;
      }

      /**
       * Optional view for the returned Role objects. When `FULL` is specified, the
       * `includedPermissions` field is returned, which includes a list of all permissions in the
       * role. The default value is `BASIC`, which does not return the `includedPermissions` field.
       */
      @com.google.api.client.util.Key
      private java.lang.String view;

      /** Optional view for the returned Role objects. When `FULL` is specified, the `includedPermissions`
     field is returned, which includes a list of all permissions in the role. The default value is
     `BASIC`, which does not return the `includedPermissions` field.
       */
      public java.lang.String getView() {
        return view;
      }

      /**
       * Optional view for the returned Role objects. When `FULL` is specified, the
       * `includedPermissions` field is returned, which includes a list of all permissions in the
       * role. The default value is `BASIC`, which does not return the `includedPermissions` field.
       */
      public List setView(java.lang.String view) {
        this.view = view;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Lists roles that can be granted on a Google Cloud resource. A role is grantable if the IAM policy
     * for the resource can contain bindings to the role.
     *
     * Create a request for the method "roles.queryGrantableRoles".
     *
     * This request holds the parameters needed by the iam server.  After setting any optional
     * parameters, call the {@link QueryGrantableRoles#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.iam.v1.model.QueryGrantableRolesRequest}
     * @return the request
     */
    public QueryGrantableRoles queryGrantableRoles(com.google.api.services.iam.v1.model.QueryGrantableRolesRequest content) throws java.io.IOException {
      QueryGrantableRoles result = new QueryGrantableRoles(content);
      initialize(result);
      return result;
    }

    public class QueryGrantableRoles extends IamRequest<com.google.api.services.iam.v1.model.QueryGrantableRolesResponse> {

      private static final String REST_PATH = "v1/roles:queryGrantableRoles";

      /**
       * Lists roles that can be granted on a Google Cloud resource. A role is grantable if the IAM
       * policy for the resource can contain bindings to the role.
       *
       * Create a request for the method "roles.queryGrantableRoles".
       *
       * This request holds the parameters needed by the the iam server.  After setting any optional
       * parameters, call the {@link QueryGrantableRoles#execute()} method to invoke the remote
       * operation. <p> {@link QueryGrantableRoles#initialize(com.google.api.client.googleapis.services.
       * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.iam.v1.model.QueryGrantableRolesRequest}
       * @since 1.13
       */
      protected QueryGrantableRoles(com.google.api.services.iam.v1.model.QueryGrantableRolesRequest content) {
        super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.QueryGrantableRolesResponse.class);
      }

      @Override
      public QueryGrantableRoles set$Xgafv(java.lang.String $Xgafv) {
        return (QueryGrantableRoles) super.set$Xgafv($Xgafv);
      }

      @Override
      public QueryGrantableRoles setAccessToken(java.lang.String accessToken) {
        return (QueryGrantableRoles) super.setAccessToken(accessToken);
      }

      @Override
      public QueryGrantableRoles setAlt(java.lang.String alt) {
        return (QueryGrantableRoles) super.setAlt(alt);
      }

      @Override
      public QueryGrantableRoles setCallback(java.lang.String callback) {
        return (QueryGrantableRoles) super.setCallback(callback);
      }

      @Override
      public QueryGrantableRoles setFields(java.lang.String fields) {
        return (QueryGrantableRoles) super.setFields(fields);
      }

      @Override
      public QueryGrantableRoles setKey(java.lang.String key) {
        return (QueryGrantableRoles) super.setKey(key);
      }

      @Override
      public QueryGrantableRoles setOauthToken(java.lang.String oauthToken) {
        return (QueryGrantableRoles) super.setOauthToken(oauthToken);
      }

      @Override
      public QueryGrantableRoles setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (QueryGrantableRoles) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public QueryGrantableRoles setQuotaUser(java.lang.String quotaUser) {
        return (QueryGrantableRoles) super.setQuotaUser(quotaUser);
      }

      @Override
      public QueryGrantableRoles setUploadType(java.lang.String uploadType) {
        return (QueryGrantableRoles) super.setUploadType(uploadType);
      }

      @Override
      public QueryGrantableRoles setUploadProtocol(java.lang.String uploadProtocol) {
        return (QueryGrantableRoles) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public QueryGrantableRoles set(String parameterName, Object value) {
        return (QueryGrantableRoles) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Iam}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Iam}. */
    @Override
    public Iam build() {
      return new Iam(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link IamRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setIamRequestInitializer(
        IamRequestInitializer iamRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(iamRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
