/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1.model;

/**
 * The service account create request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreateServiceAccountRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. The account id that is used to generate the service account email address and a
   * stable unique id. It is unique within a project, must be 6-30 characters long, and match the
   * regular expression `[a-z]([-a-z0-9]*[a-z0-9])` to comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountId;

  /**
   * The ServiceAccount resource to create. Currently, only the following values are user
   * assignable: `display_name` and `description`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ServiceAccount serviceAccount;

  /**
   * Required. The account id that is used to generate the service account email address and a
   * stable unique id. It is unique within a project, must be 6-30 characters long, and match the
   * regular expression `[a-z]([-a-z0-9]*[a-z0-9])` to comply with RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountId() {
    return accountId;
  }

  /**
   * Required. The account id that is used to generate the service account email address and a
   * stable unique id. It is unique within a project, must be 6-30 characters long, and match the
   * regular expression `[a-z]([-a-z0-9]*[a-z0-9])` to comply with RFC1035.
   * @param accountId accountId or {@code null} for none
   */
  public CreateServiceAccountRequest setAccountId(java.lang.String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * The ServiceAccount resource to create. Currently, only the following values are user
   * assignable: `display_name` and `description`.
   * @return value or {@code null} for none
   */
  public ServiceAccount getServiceAccount() {
    return serviceAccount;
  }

  /**
   * The ServiceAccount resource to create. Currently, only the following values are user
   * assignable: `display_name` and `description`.
   * @param serviceAccount serviceAccount or {@code null} for none
   */
  public CreateServiceAccountRequest setServiceAccount(ServiceAccount serviceAccount) {
    this.serviceAccount = serviceAccount;
    return this;
  }

  @Override
  public CreateServiceAccountRequest set(String fieldName, Object value) {
    return (CreateServiceAccountRequest) super.set(fieldName, value);
  }

  @Override
  public CreateServiceAccountRequest clone() {
    return (CreateServiceAccountRequest) super.clone();
  }

}
