/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1.model;

/**
 * Represents an OpenId Connect 1.0 identity provider.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Oidc extends com.google.api.client.json.GenericJson {

  /**
   * Acceptable values for the `aud` field (audience) in the OIDC token. Token exchange requests are
   * rejected if the token audience does not match one of the configured values. Each audience may
   * be at most 256 characters. A maximum of 10 audiences may be configured. If this list is empty,
   * the OIDC token audience must be equal to the full canonical resource name of the
   * WorkloadIdentityPoolProvider, with or without the HTTPS prefix. For example: ```
   * //iam.googleapis.com/projects//locations//workloadIdentityPools//providers/
   * https://iam.googleapis.com/projects//locations//workloadIdentityPools//providers/ ```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> allowedAudiences;

  /**
   * Required. The OIDC issuer URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String issuerUri;

  /**
   * Acceptable values for the `aud` field (audience) in the OIDC token. Token exchange requests are
   * rejected if the token audience does not match one of the configured values. Each audience may
   * be at most 256 characters. A maximum of 10 audiences may be configured. If this list is empty,
   * the OIDC token audience must be equal to the full canonical resource name of the
   * WorkloadIdentityPoolProvider, with or without the HTTPS prefix. For example: ```
   * //iam.googleapis.com/projects//locations//workloadIdentityPools//providers/
   * https://iam.googleapis.com/projects//locations//workloadIdentityPools//providers/ ```
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAllowedAudiences() {
    return allowedAudiences;
  }

  /**
   * Acceptable values for the `aud` field (audience) in the OIDC token. Token exchange requests are
   * rejected if the token audience does not match one of the configured values. Each audience may
   * be at most 256 characters. A maximum of 10 audiences may be configured. If this list is empty,
   * the OIDC token audience must be equal to the full canonical resource name of the
   * WorkloadIdentityPoolProvider, with or without the HTTPS prefix. For example: ```
   * //iam.googleapis.com/projects//locations//workloadIdentityPools//providers/
   * https://iam.googleapis.com/projects//locations//workloadIdentityPools//providers/ ```
   * @param allowedAudiences allowedAudiences or {@code null} for none
   */
  public Oidc setAllowedAudiences(java.util.List<java.lang.String> allowedAudiences) {
    this.allowedAudiences = allowedAudiences;
    return this;
  }

  /**
   * Required. The OIDC issuer URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getIssuerUri() {
    return issuerUri;
  }

  /**
   * Required. The OIDC issuer URL.
   * @param issuerUri issuerUri or {@code null} for none
   */
  public Oidc setIssuerUri(java.lang.String issuerUri) {
    this.issuerUri = issuerUri;
    return this;
  }

  @Override
  public Oidc set(String fieldName, Object value) {
    return (Oidc) super.set(fieldName, value);
  }

  @Override
  public Oidc clone() {
    return (Oidc) super.clone();
  }

}
