/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1.model;

/**
 * The service account key upload request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UploadServiceAccountKeyRequest extends com.google.api.client.json.GenericJson {

  /**
   * A field that allows clients to upload their own public key. If set, use this public key data to
   * create a service account key for given service account. Please note, the expected format for
   * this field is X509_PEM.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String publicKeyData;

  /**
   * A field that allows clients to upload their own public key. If set, use this public key data to
   * create a service account key for given service account. Please note, the expected format for
   * this field is X509_PEM.
   * @see #decodePublicKeyData()
   * @return value or {@code null} for none
   */
  public java.lang.String getPublicKeyData() {
    return publicKeyData;
  }

  /**
   * A field that allows clients to upload their own public key. If set, use this public key data to
   * create a service account key for given service account. Please note, the expected format for
   * this field is X509_PEM.
   * @see #getPublicKeyData()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodePublicKeyData() {
    return com.google.api.client.util.Base64.decodeBase64(publicKeyData);
  }

  /**
   * A field that allows clients to upload their own public key. If set, use this public key data to
   * create a service account key for given service account. Please note, the expected format for
   * this field is X509_PEM.
   * @see #encodePublicKeyData()
   * @param publicKeyData publicKeyData or {@code null} for none
   */
  public UploadServiceAccountKeyRequest setPublicKeyData(java.lang.String publicKeyData) {
    this.publicKeyData = publicKeyData;
    return this;
  }

  /**
   * A field that allows clients to upload their own public key. If set, use this public key data to
   * create a service account key for given service account. Please note, the expected format for
   * this field is X509_PEM.
   * @see #setPublicKeyData()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public UploadServiceAccountKeyRequest encodePublicKeyData(byte[] publicKeyData) {
    this.publicKeyData = com.google.api.client.util.Base64.encodeBase64URLSafeString(publicKeyData);
    return this;
  }

  @Override
  public UploadServiceAccountKeyRequest set(String fieldName, Object value) {
    return (UploadServiceAccountKeyRequest) super.set(fieldName, value);
  }

  @Override
  public UploadServiceAccountKeyRequest clone() {
    return (UploadServiceAccountKeyRequest) super.clone();
  }

}
