/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1.model;

/**
 * A PermissionDelta message to record the added_permissions and removed_permissions inside a role.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PermissionDelta extends com.google.api.client.json.GenericJson {

  /**
   * Added permissions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> addedPermissions;

  /**
   * Removed permissions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> removedPermissions;

  /**
   * Added permissions.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAddedPermissions() {
    return addedPermissions;
  }

  /**
   * Added permissions.
   * @param addedPermissions addedPermissions or {@code null} for none
   */
  public PermissionDelta setAddedPermissions(java.util.List<java.lang.String> addedPermissions) {
    this.addedPermissions = addedPermissions;
    return this;
  }

  /**
   * Removed permissions.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRemovedPermissions() {
    return removedPermissions;
  }

  /**
   * Removed permissions.
   * @param removedPermissions removedPermissions or {@code null} for none
   */
  public PermissionDelta setRemovedPermissions(java.util.List<java.lang.String> removedPermissions) {
    this.removedPermissions = removedPermissions;
    return this;
  }

  @Override
  public PermissionDelta set(String fieldName, Object value) {
    return (PermissionDelta) super.set(fieldName, value);
  }

  @Override
  public PermissionDelta clone() {
    return (PermissionDelta) super.clone();
  }

}
