/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.iam.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.iam.v1.IamRequest;
import com.google.api.services.iam.v1.IamRequestInitializer;
import com.google.api.services.iam.v1.model.CreateRoleRequest;
import com.google.api.services.iam.v1.model.CreateServiceAccountKeyRequest;
import com.google.api.services.iam.v1.model.CreateServiceAccountRequest;
import com.google.api.services.iam.v1.model.DisableServiceAccountKeyRequest;
import com.google.api.services.iam.v1.model.DisableServiceAccountRequest;
import com.google.api.services.iam.v1.model.Empty;
import com.google.api.services.iam.v1.model.EnableServiceAccountKeyRequest;
import com.google.api.services.iam.v1.model.EnableServiceAccountRequest;
import com.google.api.services.iam.v1.model.LintPolicyRequest;
import com.google.api.services.iam.v1.model.LintPolicyResponse;
import com.google.api.services.iam.v1.model.ListRolesResponse;
import com.google.api.services.iam.v1.model.ListServiceAccountKeysResponse;
import com.google.api.services.iam.v1.model.ListServiceAccountsResponse;
import com.google.api.services.iam.v1.model.ListWorkloadIdentityPoolProvidersResponse;
import com.google.api.services.iam.v1.model.ListWorkloadIdentityPoolsResponse;
import com.google.api.services.iam.v1.model.Operation;
import com.google.api.services.iam.v1.model.PatchServiceAccountRequest;
import com.google.api.services.iam.v1.model.Policy;
import com.google.api.services.iam.v1.model.QueryAuditableServicesRequest;
import com.google.api.services.iam.v1.model.QueryAuditableServicesResponse;
import com.google.api.services.iam.v1.model.QueryGrantableRolesRequest;
import com.google.api.services.iam.v1.model.QueryGrantableRolesResponse;
import com.google.api.services.iam.v1.model.QueryTestablePermissionsRequest;
import com.google.api.services.iam.v1.model.QueryTestablePermissionsResponse;
import com.google.api.services.iam.v1.model.Role;
import com.google.api.services.iam.v1.model.ServiceAccount;
import com.google.api.services.iam.v1.model.ServiceAccountKey;
import com.google.api.services.iam.v1.model.SetIamPolicyRequest;
import com.google.api.services.iam.v1.model.SignBlobRequest;
import com.google.api.services.iam.v1.model.SignBlobResponse;
import com.google.api.services.iam.v1.model.SignJwtRequest;
import com.google.api.services.iam.v1.model.SignJwtResponse;
import com.google.api.services.iam.v1.model.TestIamPermissionsRequest;
import com.google.api.services.iam.v1.model.TestIamPermissionsResponse;
import com.google.api.services.iam.v1.model.UndeleteRoleRequest;
import com.google.api.services.iam.v1.model.UndeleteServiceAccountRequest;
import com.google.api.services.iam.v1.model.UndeleteServiceAccountResponse;
import com.google.api.services.iam.v1.model.UndeleteWorkloadIdentityPoolProviderRequest;
import com.google.api.services.iam.v1.model.UndeleteWorkloadIdentityPoolRequest;
import com.google.api.services.iam.v1.model.UploadServiceAccountKeyRequest;
import com.google.api.services.iam.v1.model.WorkloadIdentityPool;
import com.google.api.services.iam.v1.model.WorkloadIdentityPoolProvider;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

public class Iam
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://iam.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://iam.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://iam.googleapis.com/";

    public Iam(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Iam(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public IamPolicies iamPolicies() {
        return new IamPolicies();
    }

    public Locations locations() {
        return new Locations();
    }

    public Organizations organizations() {
        return new Organizations();
    }

    public Permissions permissions() {
        return new Permissions();
    }

    public Projects projects() {
        return new Projects();
    }

    public Roles roles() {
        return new Roles();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.32.1 of the Identity and Access Management (IAM) API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Iam.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://iam.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Iam.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Iam.DEFAULT_BATCH_PATH);
        }

        public Iam build() {
            return new Iam(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setIamRequestInitializer(IamRequestInitializer iamRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)iamRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Roles {
        public Get get(String name) throws IOException {
            Get result = new Get(name);
            Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public QueryGrantableRoles queryGrantableRoles(QueryGrantableRolesRequest content) throws IOException {
            QueryGrantableRoles result = new QueryGrantableRoles(content);
            Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class QueryGrantableRoles
        extends IamRequest<QueryGrantableRolesResponse> {
            private static final String REST_PATH = "v1/roles:queryGrantableRoles";

            protected QueryGrantableRoles(QueryGrantableRolesRequest content) {
                super(Iam.this, "POST", REST_PATH, (Object)content, QueryGrantableRolesResponse.class);
            }

            public QueryGrantableRoles set$Xgafv(String $Xgafv) {
                return (QueryGrantableRoles)super.set$Xgafv($Xgafv);
            }

            public QueryGrantableRoles setAccessToken(String accessToken) {
                return (QueryGrantableRoles)super.setAccessToken(accessToken);
            }

            public QueryGrantableRoles setAlt(String alt) {
                return (QueryGrantableRoles)super.setAlt(alt);
            }

            public QueryGrantableRoles setCallback(String callback) {
                return (QueryGrantableRoles)super.setCallback(callback);
            }

            public QueryGrantableRoles setFields(String fields) {
                return (QueryGrantableRoles)super.setFields(fields);
            }

            public QueryGrantableRoles setKey(String key) {
                return (QueryGrantableRoles)super.setKey(key);
            }

            public QueryGrantableRoles setOauthToken(String oauthToken) {
                return (QueryGrantableRoles)super.setOauthToken(oauthToken);
            }

            public QueryGrantableRoles setPrettyPrint(Boolean prettyPrint) {
                return (QueryGrantableRoles)super.setPrettyPrint(prettyPrint);
            }

            public QueryGrantableRoles setQuotaUser(String quotaUser) {
                return (QueryGrantableRoles)super.setQuotaUser(quotaUser);
            }

            public QueryGrantableRoles setUploadType(String uploadType) {
                return (QueryGrantableRoles)super.setUploadType(uploadType);
            }

            public QueryGrantableRoles setUploadProtocol(String uploadProtocol) {
                return (QueryGrantableRoles)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public QueryGrantableRoles set(String parameterName, Object value) {
                return (QueryGrantableRoles)super.set(parameterName, value);
            }
        }

        public class List
        extends IamRequest<ListRolesResponse> {
            private static final String REST_PATH = "v1/roles";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String parent;
            @Key
            private Boolean showDeleted;
            @Key
            private String view;

            protected List() {
                super(Iam.this, "GET", REST_PATH, null, ListRolesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String parent) {
                this.parent = parent;
                return this;
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public List setShowDeleted(Boolean showDeleted) {
                this.showDeleted = showDeleted;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public List setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends IamRequest<Role> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(Iam.this, "GET", REST_PATH, null, Role.class);
                this.NAME_PATTERN = Pattern.compile("^roles/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Iam.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^roles/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!Iam.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^roles/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Projects {
        public Locations locations() {
            return new Locations();
        }

        public Roles roles() {
            return new Roles();
        }

        public ServiceAccounts serviceAccounts() {
            return new ServiceAccounts();
        }

        public class ServiceAccounts {
            public Create create(String name, CreateServiceAccountRequest content) throws IOException {
                Create result = new Create(name, content);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Disable disable(String name, DisableServiceAccountRequest content) throws IOException {
                Disable result = new Disable(name, content);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Enable enable(String name, EnableServiceAccountRequest content) throws IOException {
                Enable result = new Enable(name, content);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetIamPolicy getIamPolicy(String resource) throws IOException {
                GetIamPolicy result = new GetIamPolicy(resource);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, PatchServiceAccountRequest content) throws IOException {
                Patch result = new Patch(name, content);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                SetIamPolicy result = new SetIamPolicy(resource, content);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public SignBlob signBlob(String name, SignBlobRequest content) throws IOException {
                SignBlob result = new SignBlob(name, content);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public SignJwt signJwt(String name, SignJwtRequest content) throws IOException {
                SignJwt result = new SignJwt(name, content);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                TestIamPermissions result = new TestIamPermissions(resource, content);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Undelete undelete(String name, UndeleteServiceAccountRequest content) throws IOException {
                Undelete result = new Undelete(name, content);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String name, ServiceAccount content) throws IOException {
                Update result = new Update(name, content);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Keys keys() {
                return new Keys();
            }

            public class Keys {
                public Create create(String name, CreateServiceAccountKeyRequest content) throws IOException {
                    Create result = new Create(name, content);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Disable disable(String name, DisableServiceAccountKeyRequest content) throws IOException {
                    Disable result = new Disable(name, content);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Enable enable(String name, EnableServiceAccountKeyRequest content) throws IOException {
                    Enable result = new Enable(name, content);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String name) throws IOException {
                    List result = new List(name);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Upload upload(String name, UploadServiceAccountKeyRequest content) throws IOException {
                    Upload result = new Upload(name, content);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Upload
                extends IamRequest<ServiceAccountKey> {
                    private static final String REST_PATH = "v1/{+name}/keys:upload";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Upload(String name, UploadServiceAccountKeyRequest content) {
                        super(Iam.this, "POST", REST_PATH, (Object)content, ServiceAccountKey.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                        }
                    }

                    public Upload set$Xgafv(String $Xgafv) {
                        return (Upload)super.set$Xgafv($Xgafv);
                    }

                    public Upload setAccessToken(String accessToken) {
                        return (Upload)super.setAccessToken(accessToken);
                    }

                    public Upload setAlt(String alt) {
                        return (Upload)super.setAlt(alt);
                    }

                    public Upload setCallback(String callback) {
                        return (Upload)super.setCallback(callback);
                    }

                    public Upload setFields(String fields) {
                        return (Upload)super.setFields(fields);
                    }

                    public Upload setKey(String key) {
                        return (Upload)super.setKey(key);
                    }

                    public Upload setOauthToken(String oauthToken) {
                        return (Upload)super.setOauthToken(oauthToken);
                    }

                    public Upload setPrettyPrint(Boolean prettyPrint) {
                        return (Upload)super.setPrettyPrint(prettyPrint);
                    }

                    public Upload setQuotaUser(String quotaUser) {
                        return (Upload)super.setQuotaUser(quotaUser);
                    }

                    public Upload setUploadType(String uploadType) {
                        return (Upload)super.setUploadType(uploadType);
                    }

                    public Upload setUploadProtocol(String uploadProtocol) {
                        return (Upload)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Upload setName(String name) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Upload set(String parameterName, Object value) {
                        return (Upload)super.set(parameterName, value);
                    }
                }

                public class List
                extends IamRequest<ListServiceAccountKeysResponse> {
                    private static final String REST_PATH = "v1/{+name}/keys";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private java.util.List<String> keyTypes;

                    protected List(String name) {
                        super(Iam.this, "GET", REST_PATH, null, ListServiceAccountKeysResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String name) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public java.util.List<String> getKeyTypes() {
                        return this.keyTypes;
                    }

                    public List setKeyTypes(java.util.List<String> keyTypes) {
                        this.keyTypes = keyTypes;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends IamRequest<ServiceAccountKey> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String publicKeyType;

                    protected Get(String name) {
                        super(Iam.this, "GET", REST_PATH, null, ServiceAccountKey.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getPublicKeyType() {
                        return this.publicKeyType;
                    }

                    public Get setPublicKeyType(String publicKeyType) {
                        this.publicKeyType = publicKeyType;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Enable
                extends IamRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}:enable";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Enable(String name, EnableServiceAccountKeyRequest content) {
                        super(Iam.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        }
                    }

                    public Enable set$Xgafv(String $Xgafv) {
                        return (Enable)super.set$Xgafv($Xgafv);
                    }

                    public Enable setAccessToken(String accessToken) {
                        return (Enable)super.setAccessToken(accessToken);
                    }

                    public Enable setAlt(String alt) {
                        return (Enable)super.setAlt(alt);
                    }

                    public Enable setCallback(String callback) {
                        return (Enable)super.setCallback(callback);
                    }

                    public Enable setFields(String fields) {
                        return (Enable)super.setFields(fields);
                    }

                    public Enable setKey(String key) {
                        return (Enable)super.setKey(key);
                    }

                    public Enable setOauthToken(String oauthToken) {
                        return (Enable)super.setOauthToken(oauthToken);
                    }

                    public Enable setPrettyPrint(Boolean prettyPrint) {
                        return (Enable)super.setPrettyPrint(prettyPrint);
                    }

                    public Enable setQuotaUser(String quotaUser) {
                        return (Enable)super.setQuotaUser(quotaUser);
                    }

                    public Enable setUploadType(String uploadType) {
                        return (Enable)super.setUploadType(uploadType);
                    }

                    public Enable setUploadProtocol(String uploadProtocol) {
                        return (Enable)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Enable setName(String name) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Enable set(String parameterName, Object value) {
                        return (Enable)super.set(parameterName, value);
                    }
                }

                public class Disable
                extends IamRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}:disable";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Disable(String name, DisableServiceAccountKeyRequest content) {
                        super(Iam.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        }
                    }

                    public Disable set$Xgafv(String $Xgafv) {
                        return (Disable)super.set$Xgafv($Xgafv);
                    }

                    public Disable setAccessToken(String accessToken) {
                        return (Disable)super.setAccessToken(accessToken);
                    }

                    public Disable setAlt(String alt) {
                        return (Disable)super.setAlt(alt);
                    }

                    public Disable setCallback(String callback) {
                        return (Disable)super.setCallback(callback);
                    }

                    public Disable setFields(String fields) {
                        return (Disable)super.setFields(fields);
                    }

                    public Disable setKey(String key) {
                        return (Disable)super.setKey(key);
                    }

                    public Disable setOauthToken(String oauthToken) {
                        return (Disable)super.setOauthToken(oauthToken);
                    }

                    public Disable setPrettyPrint(Boolean prettyPrint) {
                        return (Disable)super.setPrettyPrint(prettyPrint);
                    }

                    public Disable setQuotaUser(String quotaUser) {
                        return (Disable)super.setQuotaUser(quotaUser);
                    }

                    public Disable setUploadType(String uploadType) {
                        return (Disable)super.setUploadType(uploadType);
                    }

                    public Disable setUploadProtocol(String uploadProtocol) {
                        return (Disable)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Disable setName(String name) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Disable set(String parameterName, Object value) {
                        return (Disable)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends IamRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Iam.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends IamRequest<ServiceAccountKey> {
                    private static final String REST_PATH = "v1/{+name}/keys";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Create(String name, CreateServiceAccountKeyRequest content) {
                        super(Iam.this, "POST", REST_PATH, (Object)content, ServiceAccountKey.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Create setName(String name) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Update
            extends IamRequest<ServiceAccount> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Update(String name, ServiceAccount content) {
                    super(Iam.this, "PUT", REST_PATH, (Object)content, ServiceAccount.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Update setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Undelete
            extends IamRequest<UndeleteServiceAccountResponse> {
                private static final String REST_PATH = "v1/{+name}:undelete";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Undelete(String name, UndeleteServiceAccountRequest content) {
                    super(Iam.this, "POST", REST_PATH, (Object)content, UndeleteServiceAccountResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public Undelete set$Xgafv(String $Xgafv) {
                    return (Undelete)super.set$Xgafv($Xgafv);
                }

                public Undelete setAccessToken(String accessToken) {
                    return (Undelete)super.setAccessToken(accessToken);
                }

                public Undelete setAlt(String alt) {
                    return (Undelete)super.setAlt(alt);
                }

                public Undelete setCallback(String callback) {
                    return (Undelete)super.setCallback(callback);
                }

                public Undelete setFields(String fields) {
                    return (Undelete)super.setFields(fields);
                }

                public Undelete setKey(String key) {
                    return (Undelete)super.setKey(key);
                }

                public Undelete setOauthToken(String oauthToken) {
                    return (Undelete)super.setOauthToken(oauthToken);
                }

                public Undelete setPrettyPrint(Boolean prettyPrint) {
                    return (Undelete)super.setPrettyPrint(prettyPrint);
                }

                public Undelete setQuotaUser(String quotaUser) {
                    return (Undelete)super.setQuotaUser(quotaUser);
                }

                public Undelete setUploadType(String uploadType) {
                    return (Undelete)super.setUploadType(uploadType);
                }

                public Undelete setUploadProtocol(String uploadProtocol) {
                    return (Undelete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Undelete setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Undelete set(String parameterName, Object value) {
                    return (Undelete)super.set(parameterName, value);
                }
            }

            public class TestIamPermissions
            extends IamRequest<TestIamPermissionsResponse> {
                private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                    super(Iam.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public TestIamPermissions set$Xgafv(String $Xgafv) {
                    return (TestIamPermissions)super.set$Xgafv($Xgafv);
                }

                public TestIamPermissions setAccessToken(String accessToken) {
                    return (TestIamPermissions)super.setAccessToken(accessToken);
                }

                public TestIamPermissions setAlt(String alt) {
                    return (TestIamPermissions)super.setAlt(alt);
                }

                public TestIamPermissions setCallback(String callback) {
                    return (TestIamPermissions)super.setCallback(callback);
                }

                public TestIamPermissions setFields(String fields) {
                    return (TestIamPermissions)super.setFields(fields);
                }

                public TestIamPermissions setKey(String key) {
                    return (TestIamPermissions)super.setKey(key);
                }

                public TestIamPermissions setOauthToken(String oauthToken) {
                    return (TestIamPermissions)super.setOauthToken(oauthToken);
                }

                public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                    return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                }

                public TestIamPermissions setQuotaUser(String quotaUser) {
                    return (TestIamPermissions)super.setQuotaUser(quotaUser);
                }

                public TestIamPermissions setUploadType(String uploadType) {
                    return (TestIamPermissions)super.setUploadType(uploadType);
                }

                public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                    return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public TestIamPermissions setResource(String resource) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public TestIamPermissions set(String parameterName, Object value) {
                    return (TestIamPermissions)super.set(parameterName, value);
                }
            }

            public class SignJwt
            extends IamRequest<SignJwtResponse> {
                private static final String REST_PATH = "v1/{+name}:signJwt";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected SignJwt(String name, SignJwtRequest content) {
                    super(Iam.this, "POST", REST_PATH, (Object)content, SignJwtResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public SignJwt set$Xgafv(String $Xgafv) {
                    return (SignJwt)super.set$Xgafv($Xgafv);
                }

                public SignJwt setAccessToken(String accessToken) {
                    return (SignJwt)super.setAccessToken(accessToken);
                }

                public SignJwt setAlt(String alt) {
                    return (SignJwt)super.setAlt(alt);
                }

                public SignJwt setCallback(String callback) {
                    return (SignJwt)super.setCallback(callback);
                }

                public SignJwt setFields(String fields) {
                    return (SignJwt)super.setFields(fields);
                }

                public SignJwt setKey(String key) {
                    return (SignJwt)super.setKey(key);
                }

                public SignJwt setOauthToken(String oauthToken) {
                    return (SignJwt)super.setOauthToken(oauthToken);
                }

                public SignJwt setPrettyPrint(Boolean prettyPrint) {
                    return (SignJwt)super.setPrettyPrint(prettyPrint);
                }

                public SignJwt setQuotaUser(String quotaUser) {
                    return (SignJwt)super.setQuotaUser(quotaUser);
                }

                public SignJwt setUploadType(String uploadType) {
                    return (SignJwt)super.setUploadType(uploadType);
                }

                public SignJwt setUploadProtocol(String uploadProtocol) {
                    return (SignJwt)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public SignJwt setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public SignJwt set(String parameterName, Object value) {
                    return (SignJwt)super.set(parameterName, value);
                }
            }

            public class SignBlob
            extends IamRequest<SignBlobResponse> {
                private static final String REST_PATH = "v1/{+name}:signBlob";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected SignBlob(String name, SignBlobRequest content) {
                    super(Iam.this, "POST", REST_PATH, (Object)content, SignBlobResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public SignBlob set$Xgafv(String $Xgafv) {
                    return (SignBlob)super.set$Xgafv($Xgafv);
                }

                public SignBlob setAccessToken(String accessToken) {
                    return (SignBlob)super.setAccessToken(accessToken);
                }

                public SignBlob setAlt(String alt) {
                    return (SignBlob)super.setAlt(alt);
                }

                public SignBlob setCallback(String callback) {
                    return (SignBlob)super.setCallback(callback);
                }

                public SignBlob setFields(String fields) {
                    return (SignBlob)super.setFields(fields);
                }

                public SignBlob setKey(String key) {
                    return (SignBlob)super.setKey(key);
                }

                public SignBlob setOauthToken(String oauthToken) {
                    return (SignBlob)super.setOauthToken(oauthToken);
                }

                public SignBlob setPrettyPrint(Boolean prettyPrint) {
                    return (SignBlob)super.setPrettyPrint(prettyPrint);
                }

                public SignBlob setQuotaUser(String quotaUser) {
                    return (SignBlob)super.setQuotaUser(quotaUser);
                }

                public SignBlob setUploadType(String uploadType) {
                    return (SignBlob)super.setUploadType(uploadType);
                }

                public SignBlob setUploadProtocol(String uploadProtocol) {
                    return (SignBlob)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public SignBlob setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public SignBlob set(String parameterName, Object value) {
                    return (SignBlob)super.set(parameterName, value);
                }
            }

            public class SetIamPolicy
            extends IamRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                    super(Iam.this, "POST", REST_PATH, (Object)content, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public SetIamPolicy set$Xgafv(String $Xgafv) {
                    return (SetIamPolicy)super.set$Xgafv($Xgafv);
                }

                public SetIamPolicy setAccessToken(String accessToken) {
                    return (SetIamPolicy)super.setAccessToken(accessToken);
                }

                public SetIamPolicy setAlt(String alt) {
                    return (SetIamPolicy)super.setAlt(alt);
                }

                public SetIamPolicy setCallback(String callback) {
                    return (SetIamPolicy)super.setCallback(callback);
                }

                public SetIamPolicy setFields(String fields) {
                    return (SetIamPolicy)super.setFields(fields);
                }

                public SetIamPolicy setKey(String key) {
                    return (SetIamPolicy)super.setKey(key);
                }

                public SetIamPolicy setOauthToken(String oauthToken) {
                    return (SetIamPolicy)super.setOauthToken(oauthToken);
                }

                public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                    return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                }

                public SetIamPolicy setQuotaUser(String quotaUser) {
                    return (SetIamPolicy)super.setQuotaUser(quotaUser);
                }

                public SetIamPolicy setUploadType(String uploadType) {
                    return (SetIamPolicy)super.setUploadType(uploadType);
                }

                public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                    return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public SetIamPolicy setResource(String resource) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public SetIamPolicy set(String parameterName, Object value) {
                    return (SetIamPolicy)super.set(parameterName, value);
                }
            }

            public class Patch
            extends IamRequest<ServiceAccount> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Patch(String name, PatchServiceAccountRequest content) {
                    super(Iam.this, "PATCH", REST_PATH, (Object)content, ServiceAccount.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends IamRequest<ListServiceAccountsResponse> {
                private static final String REST_PATH = "v1/{+name}/serviceAccounts";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(Iam.this, "GET", REST_PATH, null, ListServiceAccountsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class GetIamPolicy
            extends IamRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;
                @Key(value="options.requestedPolicyVersion")
                private Integer optionsRequestedPolicyVersion;

                protected GetIamPolicy(String resource) {
                    super(Iam.this, "POST", REST_PATH, null, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public GetIamPolicy set$Xgafv(String $Xgafv) {
                    return (GetIamPolicy)super.set$Xgafv($Xgafv);
                }

                public GetIamPolicy setAccessToken(String accessToken) {
                    return (GetIamPolicy)super.setAccessToken(accessToken);
                }

                public GetIamPolicy setAlt(String alt) {
                    return (GetIamPolicy)super.setAlt(alt);
                }

                public GetIamPolicy setCallback(String callback) {
                    return (GetIamPolicy)super.setCallback(callback);
                }

                public GetIamPolicy setFields(String fields) {
                    return (GetIamPolicy)super.setFields(fields);
                }

                public GetIamPolicy setKey(String key) {
                    return (GetIamPolicy)super.setKey(key);
                }

                public GetIamPolicy setOauthToken(String oauthToken) {
                    return (GetIamPolicy)super.setOauthToken(oauthToken);
                }

                public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                    return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                }

                public GetIamPolicy setQuotaUser(String quotaUser) {
                    return (GetIamPolicy)super.setQuotaUser(quotaUser);
                }

                public GetIamPolicy setUploadType(String uploadType) {
                    return (GetIamPolicy)super.setUploadType(uploadType);
                }

                public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                    return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public GetIamPolicy setResource(String resource) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                public Integer getOptionsRequestedPolicyVersion() {
                    return this.optionsRequestedPolicyVersion;
                }

                public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                    this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                    return this;
                }

                @Override
                public GetIamPolicy set(String parameterName, Object value) {
                    return (GetIamPolicy)super.set(parameterName, value);
                }
            }

            public class Get
            extends IamRequest<ServiceAccount> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Iam.this, "GET", REST_PATH, null, ServiceAccount.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Enable
            extends IamRequest<Empty> {
                private static final String REST_PATH = "v1/{+name}:enable";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Enable(String name, EnableServiceAccountRequest content) {
                    super(Iam.this, "POST", REST_PATH, (Object)content, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public Enable set$Xgafv(String $Xgafv) {
                    return (Enable)super.set$Xgafv($Xgafv);
                }

                public Enable setAccessToken(String accessToken) {
                    return (Enable)super.setAccessToken(accessToken);
                }

                public Enable setAlt(String alt) {
                    return (Enable)super.setAlt(alt);
                }

                public Enable setCallback(String callback) {
                    return (Enable)super.setCallback(callback);
                }

                public Enable setFields(String fields) {
                    return (Enable)super.setFields(fields);
                }

                public Enable setKey(String key) {
                    return (Enable)super.setKey(key);
                }

                public Enable setOauthToken(String oauthToken) {
                    return (Enable)super.setOauthToken(oauthToken);
                }

                public Enable setPrettyPrint(Boolean prettyPrint) {
                    return (Enable)super.setPrettyPrint(prettyPrint);
                }

                public Enable setQuotaUser(String quotaUser) {
                    return (Enable)super.setQuotaUser(quotaUser);
                }

                public Enable setUploadType(String uploadType) {
                    return (Enable)super.setUploadType(uploadType);
                }

                public Enable setUploadProtocol(String uploadProtocol) {
                    return (Enable)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Enable setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Enable set(String parameterName, Object value) {
                    return (Enable)super.set(parameterName, value);
                }
            }

            public class Disable
            extends IamRequest<Empty> {
                private static final String REST_PATH = "v1/{+name}:disable";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Disable(String name, DisableServiceAccountRequest content) {
                    super(Iam.this, "POST", REST_PATH, (Object)content, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public Disable set$Xgafv(String $Xgafv) {
                    return (Disable)super.set$Xgafv($Xgafv);
                }

                public Disable setAccessToken(String accessToken) {
                    return (Disable)super.setAccessToken(accessToken);
                }

                public Disable setAlt(String alt) {
                    return (Disable)super.setAlt(alt);
                }

                public Disable setCallback(String callback) {
                    return (Disable)super.setCallback(callback);
                }

                public Disable setFields(String fields) {
                    return (Disable)super.setFields(fields);
                }

                public Disable setKey(String key) {
                    return (Disable)super.setKey(key);
                }

                public Disable setOauthToken(String oauthToken) {
                    return (Disable)super.setOauthToken(oauthToken);
                }

                public Disable setPrettyPrint(Boolean prettyPrint) {
                    return (Disable)super.setPrettyPrint(prettyPrint);
                }

                public Disable setQuotaUser(String quotaUser) {
                    return (Disable)super.setQuotaUser(quotaUser);
                }

                public Disable setUploadType(String uploadType) {
                    return (Disable)super.setUploadType(uploadType);
                }

                public Disable setUploadProtocol(String uploadProtocol) {
                    return (Disable)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Disable setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Disable set(String parameterName, Object value) {
                    return (Disable)super.set(parameterName, value);
                }
            }

            public class Delete
            extends IamRequest<Empty> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(Iam.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends IamRequest<ServiceAccount> {
                private static final String REST_PATH = "v1/{+name}/serviceAccounts";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Create(String name, CreateServiceAccountRequest content) {
                    super(Iam.this, "POST", REST_PATH, (Object)content, ServiceAccount.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Create setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Roles {
            public Create create(String parent, CreateRoleRequest content) throws IOException {
                Create result = new Create(parent, content);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, Role content) throws IOException {
                Patch result = new Patch(name, content);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Undelete undelete(String name, UndeleteRoleRequest content) throws IOException {
                Undelete result = new Undelete(name, content);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Undelete
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}:undelete";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Undelete(String name, UndeleteRoleRequest content) {
                    super(Iam.this, "POST", REST_PATH, (Object)content, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                }

                public Undelete set$Xgafv(String $Xgafv) {
                    return (Undelete)super.set$Xgafv($Xgafv);
                }

                public Undelete setAccessToken(String accessToken) {
                    return (Undelete)super.setAccessToken(accessToken);
                }

                public Undelete setAlt(String alt) {
                    return (Undelete)super.setAlt(alt);
                }

                public Undelete setCallback(String callback) {
                    return (Undelete)super.setCallback(callback);
                }

                public Undelete setFields(String fields) {
                    return (Undelete)super.setFields(fields);
                }

                public Undelete setKey(String key) {
                    return (Undelete)super.setKey(key);
                }

                public Undelete setOauthToken(String oauthToken) {
                    return (Undelete)super.setOauthToken(oauthToken);
                }

                public Undelete setPrettyPrint(Boolean prettyPrint) {
                    return (Undelete)super.setPrettyPrint(prettyPrint);
                }

                public Undelete setQuotaUser(String quotaUser) {
                    return (Undelete)super.setQuotaUser(quotaUser);
                }

                public Undelete setUploadType(String uploadType) {
                    return (Undelete)super.setUploadType(uploadType);
                }

                public Undelete setUploadProtocol(String uploadProtocol) {
                    return (Undelete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Undelete setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Undelete set(String parameterName, Object value) {
                    return (Undelete)super.set(parameterName, value);
                }
            }

            public class Patch
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String name, Role content) {
                    super(Iam.this, "PATCH", REST_PATH, (Object)content, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends IamRequest<ListRolesResponse> {
                private static final String REST_PATH = "v1/{+parent}/roles";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private Boolean showDeleted;
                @Key
                private String view;

                protected List(String parent) {
                    super(Iam.this, "GET", REST_PATH, null, ListRolesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public Boolean getShowDeleted() {
                    return this.showDeleted;
                }

                public List setShowDeleted(Boolean showDeleted) {
                    this.showDeleted = showDeleted;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public List setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Iam.this, "GET", REST_PATH, null, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String etag;

                protected Delete(String name) {
                    super(Iam.this, "DELETE", REST_PATH, null, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getEtag() {
                    return this.etag;
                }

                public Delete setEtag(String etag) {
                    this.etag = etag;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+parent}/roles";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, CreateRoleRequest content) {
                    super(Iam.this, "POST", REST_PATH, (Object)content, Role.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Locations {
            public WorkloadIdentityPools workloadIdentityPools() {
                return new WorkloadIdentityPools();
            }

            public class WorkloadIdentityPools {
                public Create create(String parent, WorkloadIdentityPool content) throws IOException {
                    Create result = new Create(parent, content);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, WorkloadIdentityPool content) throws IOException {
                    Patch result = new Patch(name, content);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Undelete undelete(String name, UndeleteWorkloadIdentityPoolRequest content) throws IOException {
                    Undelete result = new Undelete(name, content);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Operations operations() {
                    return new Operations();
                }

                public Providers providers() {
                    return new Providers();
                }

                public class Providers {
                    public Create create(String parent, WorkloadIdentityPoolProvider content) throws IOException {
                        Create result = new Create(parent, content);
                        Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String name, WorkloadIdentityPoolProvider content) throws IOException {
                        Patch result = new Patch(name, content);
                        Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Undelete undelete(String name, UndeleteWorkloadIdentityPoolProviderRequest content) throws IOException {
                        Undelete result = new Undelete(name, content);
                        Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Operations operations() {
                        return new Operations();
                    }

                    public class Operations {
                        public Get get(String name) throws IOException {
                            Get result = new Get(name);
                            Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public class Get
                        extends IamRequest<Operation> {
                            private static final String REST_PATH = "v1/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected Get(String name) {
                                super(Iam.this, "GET", REST_PATH, null, Operation.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/providers/[^/]+/operations/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!Iam.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/providers/[^/]+/operations/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public Get set$Xgafv(String $Xgafv) {
                                return (Get)super.set$Xgafv($Xgafv);
                            }

                            public Get setAccessToken(String accessToken) {
                                return (Get)super.setAccessToken(accessToken);
                            }

                            public Get setAlt(String alt) {
                                return (Get)super.setAlt(alt);
                            }

                            public Get setCallback(String callback) {
                                return (Get)super.setCallback(callback);
                            }

                            public Get setFields(String fields) {
                                return (Get)super.setFields(fields);
                            }

                            public Get setKey(String key) {
                                return (Get)super.setKey(key);
                            }

                            public Get setOauthToken(String oauthToken) {
                                return (Get)super.setOauthToken(oauthToken);
                            }

                            public Get setPrettyPrint(Boolean prettyPrint) {
                                return (Get)super.setPrettyPrint(prettyPrint);
                            }

                            public Get setQuotaUser(String quotaUser) {
                                return (Get)super.setQuotaUser(quotaUser);
                            }

                            public Get setUploadType(String uploadType) {
                                return (Get)super.setUploadType(uploadType);
                            }

                            public Get setUploadProtocol(String uploadProtocol) {
                                return (Get)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Get setName(String name) {
                                if (!Iam.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/providers/[^/]+/operations/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public Get set(String parameterName, Object value) {
                                return (Get)super.set(parameterName, value);
                            }
                        }
                    }

                    public class Undelete
                    extends IamRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}:undelete";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Undelete(String name, UndeleteWorkloadIdentityPoolProviderRequest content) {
                            super(Iam.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/providers/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Iam.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/providers/[^/]+$");
                            }
                        }

                        public Undelete set$Xgafv(String $Xgafv) {
                            return (Undelete)super.set$Xgafv($Xgafv);
                        }

                        public Undelete setAccessToken(String accessToken) {
                            return (Undelete)super.setAccessToken(accessToken);
                        }

                        public Undelete setAlt(String alt) {
                            return (Undelete)super.setAlt(alt);
                        }

                        public Undelete setCallback(String callback) {
                            return (Undelete)super.setCallback(callback);
                        }

                        public Undelete setFields(String fields) {
                            return (Undelete)super.setFields(fields);
                        }

                        public Undelete setKey(String key) {
                            return (Undelete)super.setKey(key);
                        }

                        public Undelete setOauthToken(String oauthToken) {
                            return (Undelete)super.setOauthToken(oauthToken);
                        }

                        public Undelete setPrettyPrint(Boolean prettyPrint) {
                            return (Undelete)super.setPrettyPrint(prettyPrint);
                        }

                        public Undelete setQuotaUser(String quotaUser) {
                            return (Undelete)super.setQuotaUser(quotaUser);
                        }

                        public Undelete setUploadType(String uploadType) {
                            return (Undelete)super.setUploadType(uploadType);
                        }

                        public Undelete setUploadProtocol(String uploadProtocol) {
                            return (Undelete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Undelete setName(String name) {
                            if (!Iam.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/providers/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Undelete set(String parameterName, Object value) {
                            return (Undelete)super.set(parameterName, value);
                        }
                    }

                    public class Patch
                    extends IamRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String updateMask;

                        protected Patch(String name, WorkloadIdentityPoolProvider content) {
                            super(Iam.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/providers/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Iam.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/providers/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String $Xgafv) {
                            return (Patch)super.set$Xgafv($Xgafv);
                        }

                        public Patch setAccessToken(String accessToken) {
                            return (Patch)super.setAccessToken(accessToken);
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setCallback(String callback) {
                            return (Patch)super.setCallback(callback);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUploadType(String uploadType) {
                            return (Patch)super.setUploadType(uploadType);
                        }

                        public Patch setUploadProtocol(String uploadProtocol) {
                            return (Patch)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String name) {
                            if (!Iam.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/providers/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String updateMask) {
                            this.updateMask = updateMask;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends IamRequest<ListWorkloadIdentityPoolProvidersResponse> {
                        private static final String REST_PATH = "v1/{+parent}/providers";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;
                        @Key
                        private Boolean showDeleted;

                        protected List(String parent) {
                            super(Iam.this, "GET", REST_PATH, null, ListWorkloadIdentityPoolProvidersResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Iam.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!Iam.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        public Boolean getShowDeleted() {
                            return this.showDeleted;
                        }

                        public List setShowDeleted(Boolean showDeleted) {
                            this.showDeleted = showDeleted;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends IamRequest<WorkloadIdentityPoolProvider> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(Iam.this, "GET", REST_PATH, null, WorkloadIdentityPoolProvider.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/providers/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Iam.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/providers/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!Iam.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/providers/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends IamRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String name) {
                            super(Iam.this, "DELETE", REST_PATH, null, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/providers/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Iam.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/providers/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!Iam.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/providers/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends IamRequest<Operation> {
                        private static final String REST_PATH = "v1/{+parent}/providers";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String workloadIdentityPoolProviderId;

                        protected Create(String parent, WorkloadIdentityPoolProvider content) {
                            super(Iam.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Iam.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!Iam.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getWorkloadIdentityPoolProviderId() {
                            return this.workloadIdentityPoolProviderId;
                        }

                        public Create setWorkloadIdentityPoolProviderId(String workloadIdentityPoolProviderId) {
                            this.workloadIdentityPoolProviderId = workloadIdentityPoolProviderId;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                public class Operations {
                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class Get
                    extends IamRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(Iam.this, "GET", REST_PATH, null, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/operations/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Iam.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/operations/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!Iam.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+/operations/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }
                }

                public class Undelete
                extends IamRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:undelete";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Undelete(String name, UndeleteWorkloadIdentityPoolRequest content) {
                        super(Iam.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+$");
                        }
                    }

                    public Undelete set$Xgafv(String $Xgafv) {
                        return (Undelete)super.set$Xgafv($Xgafv);
                    }

                    public Undelete setAccessToken(String accessToken) {
                        return (Undelete)super.setAccessToken(accessToken);
                    }

                    public Undelete setAlt(String alt) {
                        return (Undelete)super.setAlt(alt);
                    }

                    public Undelete setCallback(String callback) {
                        return (Undelete)super.setCallback(callback);
                    }

                    public Undelete setFields(String fields) {
                        return (Undelete)super.setFields(fields);
                    }

                    public Undelete setKey(String key) {
                        return (Undelete)super.setKey(key);
                    }

                    public Undelete setOauthToken(String oauthToken) {
                        return (Undelete)super.setOauthToken(oauthToken);
                    }

                    public Undelete setPrettyPrint(Boolean prettyPrint) {
                        return (Undelete)super.setPrettyPrint(prettyPrint);
                    }

                    public Undelete setQuotaUser(String quotaUser) {
                        return (Undelete)super.setQuotaUser(quotaUser);
                    }

                    public Undelete setUploadType(String uploadType) {
                        return (Undelete)super.setUploadType(uploadType);
                    }

                    public Undelete setUploadProtocol(String uploadProtocol) {
                        return (Undelete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Undelete setName(String name) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Undelete set(String parameterName, Object value) {
                        return (Undelete)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends IamRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, WorkloadIdentityPool content) {
                        super(Iam.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends IamRequest<ListWorkloadIdentityPoolsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/workloadIdentityPools";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;
                    @Key
                    private Boolean showDeleted;

                    protected List(String parent) {
                        super(Iam.this, "GET", REST_PATH, null, ListWorkloadIdentityPoolsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    public Boolean getShowDeleted() {
                        return this.showDeleted;
                    }

                    public List setShowDeleted(Boolean showDeleted) {
                        this.showDeleted = showDeleted;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends IamRequest<WorkloadIdentityPool> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Iam.this, "GET", REST_PATH, null, WorkloadIdentityPool.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends IamRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Iam.this, "DELETE", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/workloadIdentityPools/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends IamRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/workloadIdentityPools";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String workloadIdentityPoolId;

                    protected Create(String parent, WorkloadIdentityPool content) {
                        super(Iam.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getWorkloadIdentityPoolId() {
                        return this.workloadIdentityPoolId;
                    }

                    public Create setWorkloadIdentityPoolId(String workloadIdentityPoolId) {
                        this.workloadIdentityPoolId = workloadIdentityPoolId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }
        }
    }

    public class Permissions {
        public QueryTestablePermissions queryTestablePermissions(QueryTestablePermissionsRequest content) throws IOException {
            QueryTestablePermissions result = new QueryTestablePermissions(content);
            Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class QueryTestablePermissions
        extends IamRequest<QueryTestablePermissionsResponse> {
            private static final String REST_PATH = "v1/permissions:queryTestablePermissions";

            protected QueryTestablePermissions(QueryTestablePermissionsRequest content) {
                super(Iam.this, "POST", REST_PATH, (Object)content, QueryTestablePermissionsResponse.class);
            }

            public QueryTestablePermissions set$Xgafv(String $Xgafv) {
                return (QueryTestablePermissions)super.set$Xgafv($Xgafv);
            }

            public QueryTestablePermissions setAccessToken(String accessToken) {
                return (QueryTestablePermissions)super.setAccessToken(accessToken);
            }

            public QueryTestablePermissions setAlt(String alt) {
                return (QueryTestablePermissions)super.setAlt(alt);
            }

            public QueryTestablePermissions setCallback(String callback) {
                return (QueryTestablePermissions)super.setCallback(callback);
            }

            public QueryTestablePermissions setFields(String fields) {
                return (QueryTestablePermissions)super.setFields(fields);
            }

            public QueryTestablePermissions setKey(String key) {
                return (QueryTestablePermissions)super.setKey(key);
            }

            public QueryTestablePermissions setOauthToken(String oauthToken) {
                return (QueryTestablePermissions)super.setOauthToken(oauthToken);
            }

            public QueryTestablePermissions setPrettyPrint(Boolean prettyPrint) {
                return (QueryTestablePermissions)super.setPrettyPrint(prettyPrint);
            }

            public QueryTestablePermissions setQuotaUser(String quotaUser) {
                return (QueryTestablePermissions)super.setQuotaUser(quotaUser);
            }

            public QueryTestablePermissions setUploadType(String uploadType) {
                return (QueryTestablePermissions)super.setUploadType(uploadType);
            }

            public QueryTestablePermissions setUploadProtocol(String uploadProtocol) {
                return (QueryTestablePermissions)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public QueryTestablePermissions set(String parameterName, Object value) {
                return (QueryTestablePermissions)super.set(parameterName, value);
            }
        }
    }

    public class Organizations {
        public Roles roles() {
            return new Roles();
        }

        public class Roles {
            public Create create(String parent, CreateRoleRequest content) throws IOException {
                Create result = new Create(parent, content);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, Role content) throws IOException {
                Patch result = new Patch(name, content);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Undelete undelete(String name, UndeleteRoleRequest content) throws IOException {
                Undelete result = new Undelete(name, content);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Undelete
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}:undelete";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Undelete(String name, UndeleteRoleRequest content) {
                    super(Iam.this, "POST", REST_PATH, (Object)content, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                }

                public Undelete set$Xgafv(String $Xgafv) {
                    return (Undelete)super.set$Xgafv($Xgafv);
                }

                public Undelete setAccessToken(String accessToken) {
                    return (Undelete)super.setAccessToken(accessToken);
                }

                public Undelete setAlt(String alt) {
                    return (Undelete)super.setAlt(alt);
                }

                public Undelete setCallback(String callback) {
                    return (Undelete)super.setCallback(callback);
                }

                public Undelete setFields(String fields) {
                    return (Undelete)super.setFields(fields);
                }

                public Undelete setKey(String key) {
                    return (Undelete)super.setKey(key);
                }

                public Undelete setOauthToken(String oauthToken) {
                    return (Undelete)super.setOauthToken(oauthToken);
                }

                public Undelete setPrettyPrint(Boolean prettyPrint) {
                    return (Undelete)super.setPrettyPrint(prettyPrint);
                }

                public Undelete setQuotaUser(String quotaUser) {
                    return (Undelete)super.setQuotaUser(quotaUser);
                }

                public Undelete setUploadType(String uploadType) {
                    return (Undelete)super.setUploadType(uploadType);
                }

                public Undelete setUploadProtocol(String uploadProtocol) {
                    return (Undelete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Undelete setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Undelete set(String parameterName, Object value) {
                    return (Undelete)super.set(parameterName, value);
                }
            }

            public class Patch
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String name, Role content) {
                    super(Iam.this, "PATCH", REST_PATH, (Object)content, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends IamRequest<ListRolesResponse> {
                private static final String REST_PATH = "v1/{+parent}/roles";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private Boolean showDeleted;
                @Key
                private String view;

                protected List(String parent) {
                    super(Iam.this, "GET", REST_PATH, null, ListRolesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public Boolean getShowDeleted() {
                    return this.showDeleted;
                }

                public List setShowDeleted(Boolean showDeleted) {
                    this.showDeleted = showDeleted;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public List setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Iam.this, "GET", REST_PATH, null, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String etag;

                protected Delete(String name) {
                    super(Iam.this, "DELETE", REST_PATH, null, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getEtag() {
                    return this.etag;
                }

                public Delete setEtag(String etag) {
                    this.etag = etag;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+parent}/roles";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, CreateRoleRequest content) {
                    super(Iam.this, "POST", REST_PATH, (Object)content, Role.class);
                    this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }
    }

    public class Locations {
        public WorkforcePools workforcePools() {
            return new WorkforcePools();
        }

        public class WorkforcePools {
            public Operations operations() {
                return new Operations();
            }

            public Providers providers() {
                return new Providers();
            }

            public class Providers {
                public Operations operations() {
                    return new Operations();
                }

                public class Operations {
                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class Get
                    extends IamRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(Iam.this, "GET", REST_PATH, null, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^locations/[^/]+/workforcePools/[^/]+/providers/[^/]+/operations/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Iam.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^locations/[^/]+/workforcePools/[^/]+/providers/[^/]+/operations/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!Iam.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^locations/[^/]+/workforcePools/[^/]+/providers/[^/]+/operations/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }
                }
            }

            public class Operations {
                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Get
                extends IamRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Iam.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^locations/[^/]+/workforcePools/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^locations/[^/]+/workforcePools/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^locations/[^/]+/workforcePools/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }
            }
        }
    }

    public class IamPolicies {
        public LintPolicy lintPolicy(LintPolicyRequest content) throws IOException {
            LintPolicy result = new LintPolicy(content);
            Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public QueryAuditableServices queryAuditableServices(QueryAuditableServicesRequest content) throws IOException {
            QueryAuditableServices result = new QueryAuditableServices(content);
            Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class QueryAuditableServices
        extends IamRequest<QueryAuditableServicesResponse> {
            private static final String REST_PATH = "v1/iamPolicies:queryAuditableServices";

            protected QueryAuditableServices(QueryAuditableServicesRequest content) {
                super(Iam.this, "POST", REST_PATH, (Object)content, QueryAuditableServicesResponse.class);
            }

            public QueryAuditableServices set$Xgafv(String $Xgafv) {
                return (QueryAuditableServices)super.set$Xgafv($Xgafv);
            }

            public QueryAuditableServices setAccessToken(String accessToken) {
                return (QueryAuditableServices)super.setAccessToken(accessToken);
            }

            public QueryAuditableServices setAlt(String alt) {
                return (QueryAuditableServices)super.setAlt(alt);
            }

            public QueryAuditableServices setCallback(String callback) {
                return (QueryAuditableServices)super.setCallback(callback);
            }

            public QueryAuditableServices setFields(String fields) {
                return (QueryAuditableServices)super.setFields(fields);
            }

            public QueryAuditableServices setKey(String key) {
                return (QueryAuditableServices)super.setKey(key);
            }

            public QueryAuditableServices setOauthToken(String oauthToken) {
                return (QueryAuditableServices)super.setOauthToken(oauthToken);
            }

            public QueryAuditableServices setPrettyPrint(Boolean prettyPrint) {
                return (QueryAuditableServices)super.setPrettyPrint(prettyPrint);
            }

            public QueryAuditableServices setQuotaUser(String quotaUser) {
                return (QueryAuditableServices)super.setQuotaUser(quotaUser);
            }

            public QueryAuditableServices setUploadType(String uploadType) {
                return (QueryAuditableServices)super.setUploadType(uploadType);
            }

            public QueryAuditableServices setUploadProtocol(String uploadProtocol) {
                return (QueryAuditableServices)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public QueryAuditableServices set(String parameterName, Object value) {
                return (QueryAuditableServices)super.set(parameterName, value);
            }
        }

        public class LintPolicy
        extends IamRequest<LintPolicyResponse> {
            private static final String REST_PATH = "v1/iamPolicies:lintPolicy";

            protected LintPolicy(LintPolicyRequest content) {
                super(Iam.this, "POST", REST_PATH, (Object)content, LintPolicyResponse.class);
            }

            public LintPolicy set$Xgafv(String $Xgafv) {
                return (LintPolicy)super.set$Xgafv($Xgafv);
            }

            public LintPolicy setAccessToken(String accessToken) {
                return (LintPolicy)super.setAccessToken(accessToken);
            }

            public LintPolicy setAlt(String alt) {
                return (LintPolicy)super.setAlt(alt);
            }

            public LintPolicy setCallback(String callback) {
                return (LintPolicy)super.setCallback(callback);
            }

            public LintPolicy setFields(String fields) {
                return (LintPolicy)super.setFields(fields);
            }

            public LintPolicy setKey(String key) {
                return (LintPolicy)super.setKey(key);
            }

            public LintPolicy setOauthToken(String oauthToken) {
                return (LintPolicy)super.setOauthToken(oauthToken);
            }

            public LintPolicy setPrettyPrint(Boolean prettyPrint) {
                return (LintPolicy)super.setPrettyPrint(prettyPrint);
            }

            public LintPolicy setQuotaUser(String quotaUser) {
                return (LintPolicy)super.setQuotaUser(quotaUser);
            }

            public LintPolicy setUploadType(String uploadType) {
                return (LintPolicy)super.setUploadType(uploadType);
            }

            public LintPolicy setUploadProtocol(String uploadProtocol) {
                return (LintPolicy)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public LintPolicy set(String parameterName, Object value) {
                return (LintPolicy)super.set(parameterName, value);
            }
        }
    }
}

