/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1.model;

/**
 * Represents an SAML 2.0 identity provider.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Saml extends com.google.api.client.json.GenericJson {

  /**
   * Required. SAML Identity provider configuration metadata xml doc. The xml document should comply
   * with [SAML 2.0 specification](https://www.oasis-open.org/committees/download.php/56785/sstc-
   * saml-metadata-errata-2.0-wd-05.pdf). The max size of the acceptable xml document will be
   * bounded to 128k characters. The metadata xml document should satisfy the following constraints:
   * 1) Must contain an Identity Provider Entity ID. 2) Must contain at least one non-expired
   * signing key certificate. 3) For each signing key: a) Valid from should be no more than 7 days
   * from now. b) Valid to should be no more than 10 years in the future. 4) Upto 3 IdP signing keys
   * are allowed in the metadata xml. When updating the provider's metadata xml, at lease one non-
   * expired signing key must overlap with the existing metadata. This requirement is skipped if
   * there are no non-expired signing keys present in the existing metadata
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String idpMetadataXml;

  /**
   * Required. SAML Identity provider configuration metadata xml doc. The xml document should comply
   * with [SAML 2.0 specification](https://www.oasis-open.org/committees/download.php/56785/sstc-
   * saml-metadata-errata-2.0-wd-05.pdf). The max size of the acceptable xml document will be
   * bounded to 128k characters. The metadata xml document should satisfy the following constraints:
   * 1) Must contain an Identity Provider Entity ID. 2) Must contain at least one non-expired
   * signing key certificate. 3) For each signing key: a) Valid from should be no more than 7 days
   * from now. b) Valid to should be no more than 10 years in the future. 4) Upto 3 IdP signing keys
   * are allowed in the metadata xml. When updating the provider's metadata xml, at lease one non-
   * expired signing key must overlap with the existing metadata. This requirement is skipped if
   * there are no non-expired signing keys present in the existing metadata
   * @return value or {@code null} for none
   */
  public java.lang.String getIdpMetadataXml() {
    return idpMetadataXml;
  }

  /**
   * Required. SAML Identity provider configuration metadata xml doc. The xml document should comply
   * with [SAML 2.0 specification](https://www.oasis-open.org/committees/download.php/56785/sstc-
   * saml-metadata-errata-2.0-wd-05.pdf). The max size of the acceptable xml document will be
   * bounded to 128k characters. The metadata xml document should satisfy the following constraints:
   * 1) Must contain an Identity Provider Entity ID. 2) Must contain at least one non-expired
   * signing key certificate. 3) For each signing key: a) Valid from should be no more than 7 days
   * from now. b) Valid to should be no more than 10 years in the future. 4) Upto 3 IdP signing keys
   * are allowed in the metadata xml. When updating the provider's metadata xml, at lease one non-
   * expired signing key must overlap with the existing metadata. This requirement is skipped if
   * there are no non-expired signing keys present in the existing metadata
   * @param idpMetadataXml idpMetadataXml or {@code null} for none
   */
  public Saml setIdpMetadataXml(java.lang.String idpMetadataXml) {
    this.idpMetadataXml = idpMetadataXml;
    return this;
  }

  @Override
  public Saml set(String fieldName, Object value) {
    return (Saml) super.set(fieldName, value);
  }

  @Override
  public Saml clone() {
    return (Saml) super.clone();
  }

}
