/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1.model;

/**
 * An IAM service account. A service account is an account for an application or a virtual machine
 * (VM) instance, not a person. You can use a service account to call Google APIs. To learn more,
 * read the [overview of service accounts](https://cloud.google.com/iam/help/service-
 * accounts/overview). When you create a service account, you specify the project ID that owns the
 * service account, as well as a name that must be unique within the project. IAM uses these values
 * to create an email address that identifies the service //
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ServiceAccount extends com.google.api.client.json.GenericJson {

  /**
   * Optional. A user-specified, human-readable description of the service account. The maximum
   * length is 256 UTF-8 bytes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Output only. Whether the service account is disabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disabled;

  /**
   * Optional. A user-specified, human-readable name for the service account. The maximum length is
   * 100 UTF-8 bytes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Output only. The email address of the service account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * Deprecated. Do not use.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The resource name of the service account. Use one of the following formats: *
   * `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}` *
   * `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}` As an alternative, you can use the `-`
   * wildcard character instead of the project ID: * `projects/-/serviceAccounts/{EMAIL_ADDRESS}` *
   * `projects/-/serviceAccounts/{UNIQUE_ID}` When possible, avoid using the `-` wildcard character,
   * because it can cause response messages to contain misleading error codes. For example, if you
   * try to get the service account `projects/-/serviceAccounts/fake@example.com`, which does not
   * exist, the response contains an HTTP `403 Forbidden` error instead of a `404 Not Found` error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. The OAuth 2.0 client ID for the service account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String oauth2ClientId;

  /**
   * Output only. The ID of the project that owns the service account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * Output only. The unique, stable numeric ID for the service account. Each service account
   * retains its unique ID even if you delete the service account. For example, if you delete a
   * service account, then create a new service account with the same name, the new service account
   * has a different unique ID than the deleted service account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String uniqueId;

  /**
   * Optional. A user-specified, human-readable description of the service account. The maximum
   * length is 256 UTF-8 bytes.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Optional. A user-specified, human-readable description of the service account. The maximum
   * length is 256 UTF-8 bytes.
   * @param description description or {@code null} for none
   */
  public ServiceAccount setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Output only. Whether the service account is disabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisabled() {
    return disabled;
  }

  /**
   * Output only. Whether the service account is disabled.
   * @param disabled disabled or {@code null} for none
   */
  public ServiceAccount setDisabled(java.lang.Boolean disabled) {
    this.disabled = disabled;
    return this;
  }

  /**
   * Optional. A user-specified, human-readable name for the service account. The maximum length is
   * 100 UTF-8 bytes.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Optional. A user-specified, human-readable name for the service account. The maximum length is
   * 100 UTF-8 bytes.
   * @param displayName displayName or {@code null} for none
   */
  public ServiceAccount setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Output only. The email address of the service account.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * Output only. The email address of the service account.
   * @param email email or {@code null} for none
   */
  public ServiceAccount setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * Deprecated. Do not use.
   * @see #decodeEtag()
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Deprecated. Do not use.
   * @see #getEtag()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeEtag() {
    return com.google.api.client.util.Base64.decodeBase64(etag);
  }

  /**
   * Deprecated. Do not use.
   * @see #encodeEtag()
   * @param etag etag or {@code null} for none
   */
  public ServiceAccount setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Deprecated. Do not use.
   * @see #setEtag()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public ServiceAccount encodeEtag(byte[] etag) {
    this.etag = com.google.api.client.util.Base64.encodeBase64URLSafeString(etag);
    return this;
  }

  /**
   * The resource name of the service account. Use one of the following formats: *
   * `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}` *
   * `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}` As an alternative, you can use the `-`
   * wildcard character instead of the project ID: * `projects/-/serviceAccounts/{EMAIL_ADDRESS}` *
   * `projects/-/serviceAccounts/{UNIQUE_ID}` When possible, avoid using the `-` wildcard character,
   * because it can cause response messages to contain misleading error codes. For example, if you
   * try to get the service account `projects/-/serviceAccounts/fake@example.com`, which does not
   * exist, the response contains an HTTP `403 Forbidden` error instead of a `404 Not Found` error.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The resource name of the service account. Use one of the following formats: *
   * `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}` *
   * `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}` As an alternative, you can use the `-`
   * wildcard character instead of the project ID: * `projects/-/serviceAccounts/{EMAIL_ADDRESS}` *
   * `projects/-/serviceAccounts/{UNIQUE_ID}` When possible, avoid using the `-` wildcard character,
   * because it can cause response messages to contain misleading error codes. For example, if you
   * try to get the service account `projects/-/serviceAccounts/fake@example.com`, which does not
   * exist, the response contains an HTTP `403 Forbidden` error instead of a `404 Not Found` error.
   * @param name name or {@code null} for none
   */
  public ServiceAccount setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. The OAuth 2.0 client ID for the service account.
   * @return value or {@code null} for none
   */
  public java.lang.String getOauth2ClientId() {
    return oauth2ClientId;
  }

  /**
   * Output only. The OAuth 2.0 client ID for the service account.
   * @param oauth2ClientId oauth2ClientId or {@code null} for none
   */
  public ServiceAccount setOauth2ClientId(java.lang.String oauth2ClientId) {
    this.oauth2ClientId = oauth2ClientId;
    return this;
  }

  /**
   * Output only. The ID of the project that owns the service account.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * Output only. The ID of the project that owns the service account.
   * @param projectId projectId or {@code null} for none
   */
  public ServiceAccount setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Output only. The unique, stable numeric ID for the service account. Each service account
   * retains its unique ID even if you delete the service account. For example, if you delete a
   * service account, then create a new service account with the same name, the new service account
   * has a different unique ID than the deleted service account.
   * @return value or {@code null} for none
   */
  public java.lang.String getUniqueId() {
    return uniqueId;
  }

  /**
   * Output only. The unique, stable numeric ID for the service account. Each service account
   * retains its unique ID even if you delete the service account. For example, if you delete a
   * service account, then create a new service account with the same name, the new service account
   * has a different unique ID than the deleted service account.
   * @param uniqueId uniqueId or {@code null} for none
   */
  public ServiceAccount setUniqueId(java.lang.String uniqueId) {
    this.uniqueId = uniqueId;
    return this;
  }

  @Override
  public ServiceAccount set(String fieldName, Object value) {
    return (ServiceAccount) super.set(fieldName, value);
  }

  @Override
  public ServiceAccount clone() {
    return (ServiceAccount) super.clone();
  }

}
