/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1.model;

/**
 * The service account key create request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreateServiceAccountKeyRequest extends com.google.api.client.json.GenericJson {

  /**
   * Which type of key and algorithm to use for the key. The default is currently a 2K RSA key.
   * However this may change in the future.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String keyAlgorithm;

  /**
   * The output format of the private key. The default value is `TYPE_GOOGLE_CREDENTIALS_FILE`,
   * which is the Google Credentials File format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String privateKeyType;

  /**
   * Which type of key and algorithm to use for the key. The default is currently a 2K RSA key.
   * However this may change in the future.
   * @return value or {@code null} for none
   */
  public java.lang.String getKeyAlgorithm() {
    return keyAlgorithm;
  }

  /**
   * Which type of key and algorithm to use for the key. The default is currently a 2K RSA key.
   * However this may change in the future.
   * @param keyAlgorithm keyAlgorithm or {@code null} for none
   */
  public CreateServiceAccountKeyRequest setKeyAlgorithm(java.lang.String keyAlgorithm) {
    this.keyAlgorithm = keyAlgorithm;
    return this;
  }

  /**
   * The output format of the private key. The default value is `TYPE_GOOGLE_CREDENTIALS_FILE`,
   * which is the Google Credentials File format.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrivateKeyType() {
    return privateKeyType;
  }

  /**
   * The output format of the private key. The default value is `TYPE_GOOGLE_CREDENTIALS_FILE`,
   * which is the Google Credentials File format.
   * @param privateKeyType privateKeyType or {@code null} for none
   */
  public CreateServiceAccountKeyRequest setPrivateKeyType(java.lang.String privateKeyType) {
    this.privateKeyType = privateKeyType;
    return this;
  }

  @Override
  public CreateServiceAccountKeyRequest set(String fieldName, Object value) {
    return (CreateServiceAccountKeyRequest) super.set(fieldName, value);
  }

  @Override
  public CreateServiceAccountKeyRequest clone() {
    return (CreateServiceAccountKeyRequest) super.clone();
  }

}
