/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1.model;

/**
 * Represents a public key data along with its format.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class KeyData extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The format of the key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String format;

  /**
   * Output only. The key data. The format of the key is represented by the format field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String key;

  /**
   * Required. The specifications for the key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String keySpec;

  /**
   * Output only. Latest timestamp when this key is valid. Attempts to use this key after this time
   * will fail. Only present if the key data represents a X.509 certificate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String notAfterTime;

  /**
   * Output only. Earliest timestamp when this key is valid. Attempts to use this key before this
   * time will fail. Only present if the key data represents a X.509 certificate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String notBeforeTime;

  /**
   * Output only. The format of the key.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormat() {
    return format;
  }

  /**
   * Output only. The format of the key.
   * @param format format or {@code null} for none
   */
  public KeyData setFormat(java.lang.String format) {
    this.format = format;
    return this;
  }

  /**
   * Output only. The key data. The format of the key is represented by the format field.
   * @return value or {@code null} for none
   */
  public java.lang.String getKey() {
    return key;
  }

  /**
   * Output only. The key data. The format of the key is represented by the format field.
   * @param key key or {@code null} for none
   */
  public KeyData setKey(java.lang.String key) {
    this.key = key;
    return this;
  }

  /**
   * Required. The specifications for the key.
   * @return value or {@code null} for none
   */
  public java.lang.String getKeySpec() {
    return keySpec;
  }

  /**
   * Required. The specifications for the key.
   * @param keySpec keySpec or {@code null} for none
   */
  public KeyData setKeySpec(java.lang.String keySpec) {
    this.keySpec = keySpec;
    return this;
  }

  /**
   * Output only. Latest timestamp when this key is valid. Attempts to use this key after this time
   * will fail. Only present if the key data represents a X.509 certificate.
   * @return value or {@code null} for none
   */
  public String getNotAfterTime() {
    return notAfterTime;
  }

  /**
   * Output only. Latest timestamp when this key is valid. Attempts to use this key after this time
   * will fail. Only present if the key data represents a X.509 certificate.
   * @param notAfterTime notAfterTime or {@code null} for none
   */
  public KeyData setNotAfterTime(String notAfterTime) {
    this.notAfterTime = notAfterTime;
    return this;
  }

  /**
   * Output only. Earliest timestamp when this key is valid. Attempts to use this key before this
   * time will fail. Only present if the key data represents a X.509 certificate.
   * @return value or {@code null} for none
   */
  public String getNotBeforeTime() {
    return notBeforeTime;
  }

  /**
   * Output only. Earliest timestamp when this key is valid. Attempts to use this key before this
   * time will fail. Only present if the key data represents a X.509 certificate.
   * @param notBeforeTime notBeforeTime or {@code null} for none
   */
  public KeyData setNotBeforeTime(String notBeforeTime) {
    this.notBeforeTime = notBeforeTime;
    return this;
  }

  @Override
  public KeyData set(String fieldName, Object value) {
    return (KeyData) super.set(fieldName, value);
  }

  @Override
  public KeyData clone() {
    return (KeyData) super.clone();
  }

}
