/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1.model;

/**
 * Represents a collection of external workforces. Provides namespaces for federated users that can
 * be referenced in IAM policies.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WorkforcePool extends com.google.api.client.json.GenericJson {

  /**
   * A user-specified description of the pool. Cannot exceed 256 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Disables the workforce pool. You cannot use a disabled pool to exchange tokens, or use existing
   * tokens to access resources. If the pool is re-enabled, existing tokens grant access again.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disabled;

  /**
   * A user-specified display name of the pool in Google Cloud Console. Cannot exceed 32 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Output only. Time after which the workforce pool will be permanently purged and cannot be
   * recovered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String expireTime;

  /**
   * Output only. The resource name of the pool. Format:
   * `locations/{location}/workforcePools/{workforce_pool_id}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Immutable. The resource name of the parent. Format: `organizations/{org-id}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String parent;

  /**
   * Duration that the Google Cloud access tokens, console sign-in sessions, and `gcloud` sign-in
   * sessions from this pool are valid. Must be greater than 15 minutes (900s) and less than 12
   * hours (43200s). If `session_duration` is not configured, minted credentials have a default
   * duration of one hour (3600s). For SAML providers, the lifetime of the token is the minimum of
   * the `session_duration` and the `SessionNotOnOrAfter` claim in the SAML assertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String sessionDuration;

  /**
   * Output only. The state of the pool.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * A user-specified description of the pool. Cannot exceed 256 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A user-specified description of the pool. Cannot exceed 256 characters.
   * @param description description or {@code null} for none
   */
  public WorkforcePool setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Disables the workforce pool. You cannot use a disabled pool to exchange tokens, or use existing
   * tokens to access resources. If the pool is re-enabled, existing tokens grant access again.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisabled() {
    return disabled;
  }

  /**
   * Disables the workforce pool. You cannot use a disabled pool to exchange tokens, or use existing
   * tokens to access resources. If the pool is re-enabled, existing tokens grant access again.
   * @param disabled disabled or {@code null} for none
   */
  public WorkforcePool setDisabled(java.lang.Boolean disabled) {
    this.disabled = disabled;
    return this;
  }

  /**
   * A user-specified display name of the pool in Google Cloud Console. Cannot exceed 32 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * A user-specified display name of the pool in Google Cloud Console. Cannot exceed 32 characters.
   * @param displayName displayName or {@code null} for none
   */
  public WorkforcePool setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Output only. Time after which the workforce pool will be permanently purged and cannot be
   * recovered.
   * @return value or {@code null} for none
   */
  public String getExpireTime() {
    return expireTime;
  }

  /**
   * Output only. Time after which the workforce pool will be permanently purged and cannot be
   * recovered.
   * @param expireTime expireTime or {@code null} for none
   */
  public WorkforcePool setExpireTime(String expireTime) {
    this.expireTime = expireTime;
    return this;
  }

  /**
   * Output only. The resource name of the pool. Format:
   * `locations/{location}/workforcePools/{workforce_pool_id}`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The resource name of the pool. Format:
   * `locations/{location}/workforcePools/{workforce_pool_id}`
   * @param name name or {@code null} for none
   */
  public WorkforcePool setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Immutable. The resource name of the parent. Format: `organizations/{org-id}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getParent() {
    return parent;
  }

  /**
   * Immutable. The resource name of the parent. Format: `organizations/{org-id}`.
   * @param parent parent or {@code null} for none
   */
  public WorkforcePool setParent(java.lang.String parent) {
    this.parent = parent;
    return this;
  }

  /**
   * Duration that the Google Cloud access tokens, console sign-in sessions, and `gcloud` sign-in
   * sessions from this pool are valid. Must be greater than 15 minutes (900s) and less than 12
   * hours (43200s). If `session_duration` is not configured, minted credentials have a default
   * duration of one hour (3600s). For SAML providers, the lifetime of the token is the minimum of
   * the `session_duration` and the `SessionNotOnOrAfter` claim in the SAML assertion.
   * @return value or {@code null} for none
   */
  public String getSessionDuration() {
    return sessionDuration;
  }

  /**
   * Duration that the Google Cloud access tokens, console sign-in sessions, and `gcloud` sign-in
   * sessions from this pool are valid. Must be greater than 15 minutes (900s) and less than 12
   * hours (43200s). If `session_duration` is not configured, minted credentials have a default
   * duration of one hour (3600s). For SAML providers, the lifetime of the token is the minimum of
   * the `session_duration` and the `SessionNotOnOrAfter` claim in the SAML assertion.
   * @param sessionDuration sessionDuration or {@code null} for none
   */
  public WorkforcePool setSessionDuration(String sessionDuration) {
    this.sessionDuration = sessionDuration;
    return this;
  }

  /**
   * Output only. The state of the pool.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Output only. The state of the pool.
   * @param state state or {@code null} for none
   */
  public WorkforcePool setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public WorkforcePool set(String fieldName, Object value) {
    return (WorkforcePool) super.set(fieldName, value);
  }

  @Override
  public WorkforcePool clone() {
    return (WorkforcePool) super.clone();
  }

}
