/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1.model;

/**
 * Representation of the value of the client secret.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleIamAdminV1WorkforcePoolProviderOidcClientSecretValue extends com.google.api.client.json.GenericJson {

  /**
   * Input only. The plain text of the client secret value. For security reasons, this field is only
   * used for input and will never be populated in any response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String plainText;

  /**
   * Output only. A thumbprint to represent the current client secret value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String thumbprint;

  /**
   * Input only. The plain text of the client secret value. For security reasons, this field is only
   * used for input and will never be populated in any response.
   * @return value or {@code null} for none
   */
  public java.lang.String getPlainText() {
    return plainText;
  }

  /**
   * Input only. The plain text of the client secret value. For security reasons, this field is only
   * used for input and will never be populated in any response.
   * @param plainText plainText or {@code null} for none
   */
  public GoogleIamAdminV1WorkforcePoolProviderOidcClientSecretValue setPlainText(java.lang.String plainText) {
    this.plainText = plainText;
    return this;
  }

  /**
   * Output only. A thumbprint to represent the current client secret value.
   * @return value or {@code null} for none
   */
  public java.lang.String getThumbprint() {
    return thumbprint;
  }

  /**
   * Output only. A thumbprint to represent the current client secret value.
   * @param thumbprint thumbprint or {@code null} for none
   */
  public GoogleIamAdminV1WorkforcePoolProviderOidcClientSecretValue setThumbprint(java.lang.String thumbprint) {
    this.thumbprint = thumbprint;
    return this;
  }

  @Override
  public GoogleIamAdminV1WorkforcePoolProviderOidcClientSecretValue set(String fieldName, Object value) {
    return (GoogleIamAdminV1WorkforcePoolProviderOidcClientSecretValue) super.set(fieldName, value);
  }

  @Override
  public GoogleIamAdminV1WorkforcePoolProviderOidcClientSecretValue clone() {
    return (GoogleIamAdminV1WorkforcePoolProviderOidcClientSecretValue) super.clone();
  }

}
