/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1.model;

/**
 * Configuration for web single sign-on for the OIDC provider.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleIamAdminV1WorkforcePoolProviderOidcWebSsoConfig extends com.google.api.client.json.GenericJson {

  /**
   * Additional scopes to request for in the OIDC authentication request on top of scopes requested
   * by default. By default, the `openid`, `profile` and `email` scopes that are supported by the
   * identity provider are requested. Each additional scope may be at most 256 characters. A maximum
   * of 10 additional scopes may be configured.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> additionalScopes;

  /**
   * Required. The behavior for how OIDC Claims are included in the `assertion` object used for
   * attribute mapping and attribute condition.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String assertionClaimsBehavior;

  /**
   * Required. The Response Type to request for in the OIDC Authorization Request for web sign-in.
   * The `CODE` Response Type is recommended to avoid the Implicit Flow, for security reasons.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String responseType;

  /**
   * Additional scopes to request for in the OIDC authentication request on top of scopes requested
   * by default. By default, the `openid`, `profile` and `email` scopes that are supported by the
   * identity provider are requested. Each additional scope may be at most 256 characters. A maximum
   * of 10 additional scopes may be configured.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAdditionalScopes() {
    return additionalScopes;
  }

  /**
   * Additional scopes to request for in the OIDC authentication request on top of scopes requested
   * by default. By default, the `openid`, `profile` and `email` scopes that are supported by the
   * identity provider are requested. Each additional scope may be at most 256 characters. A maximum
   * of 10 additional scopes may be configured.
   * @param additionalScopes additionalScopes or {@code null} for none
   */
  public GoogleIamAdminV1WorkforcePoolProviderOidcWebSsoConfig setAdditionalScopes(java.util.List<java.lang.String> additionalScopes) {
    this.additionalScopes = additionalScopes;
    return this;
  }

  /**
   * Required. The behavior for how OIDC Claims are included in the `assertion` object used for
   * attribute mapping and attribute condition.
   * @return value or {@code null} for none
   */
  public java.lang.String getAssertionClaimsBehavior() {
    return assertionClaimsBehavior;
  }

  /**
   * Required. The behavior for how OIDC Claims are included in the `assertion` object used for
   * attribute mapping and attribute condition.
   * @param assertionClaimsBehavior assertionClaimsBehavior or {@code null} for none
   */
  public GoogleIamAdminV1WorkforcePoolProviderOidcWebSsoConfig setAssertionClaimsBehavior(java.lang.String assertionClaimsBehavior) {
    this.assertionClaimsBehavior = assertionClaimsBehavior;
    return this;
  }

  /**
   * Required. The Response Type to request for in the OIDC Authorization Request for web sign-in.
   * The `CODE` Response Type is recommended to avoid the Implicit Flow, for security reasons.
   * @return value or {@code null} for none
   */
  public java.lang.String getResponseType() {
    return responseType;
  }

  /**
   * Required. The Response Type to request for in the OIDC Authorization Request for web sign-in.
   * The `CODE` Response Type is recommended to avoid the Implicit Flow, for security reasons.
   * @param responseType responseType or {@code null} for none
   */
  public GoogleIamAdminV1WorkforcePoolProviderOidcWebSsoConfig setResponseType(java.lang.String responseType) {
    this.responseType = responseType;
    return this;
  }

  @Override
  public GoogleIamAdminV1WorkforcePoolProviderOidcWebSsoConfig set(String fieldName, Object value) {
    return (GoogleIamAdminV1WorkforcePoolProviderOidcWebSsoConfig) super.set(fieldName, value);
  }

  @Override
  public GoogleIamAdminV1WorkforcePoolProviderOidcWebSsoConfig clone() {
    return (GoogleIamAdminV1WorkforcePoolProviderOidcWebSsoConfig) super.clone();
  }

}
