/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1.model;

/**
 * Represents a public key configuration for a Workforce Pool Provider. The key can be configured in
 * your identity provider to encrypt SAML assertions. Google holds the corresponding private key,
 * which it uses to decrypt encrypted tokens.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WorkforcePoolProviderKey extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The time after which the key will be permanently deleted and cannot be recovered.
   * Note that the key may get purged before this time if the total limit of keys per provider is
   * exceeded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String expireTime;

  /**
   * Immutable. Public half of the asymmetric key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private KeyData keyData;

  /**
   * Output only. The resource name of the key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. The state of the key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Required. The purpose of the key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String use;

  /**
   * Output only. The time after which the key will be permanently deleted and cannot be recovered.
   * Note that the key may get purged before this time if the total limit of keys per provider is
   * exceeded.
   * @return value or {@code null} for none
   */
  public String getExpireTime() {
    return expireTime;
  }

  /**
   * Output only. The time after which the key will be permanently deleted and cannot be recovered.
   * Note that the key may get purged before this time if the total limit of keys per provider is
   * exceeded.
   * @param expireTime expireTime or {@code null} for none
   */
  public WorkforcePoolProviderKey setExpireTime(String expireTime) {
    this.expireTime = expireTime;
    return this;
  }

  /**
   * Immutable. Public half of the asymmetric key.
   * @return value or {@code null} for none
   */
  public KeyData getKeyData() {
    return keyData;
  }

  /**
   * Immutable. Public half of the asymmetric key.
   * @param keyData keyData or {@code null} for none
   */
  public WorkforcePoolProviderKey setKeyData(KeyData keyData) {
    this.keyData = keyData;
    return this;
  }

  /**
   * Output only. The resource name of the key.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The resource name of the key.
   * @param name name or {@code null} for none
   */
  public WorkforcePoolProviderKey setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. The state of the key.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Output only. The state of the key.
   * @param state state or {@code null} for none
   */
  public WorkforcePoolProviderKey setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Required. The purpose of the key.
   * @return value or {@code null} for none
   */
  public java.lang.String getUse() {
    return use;
  }

  /**
   * Required. The purpose of the key.
   * @param use use or {@code null} for none
   */
  public WorkforcePoolProviderKey setUse(java.lang.String use) {
    this.use = use;
    return this;
  }

  @Override
  public WorkforcePoolProviderKey set(String fieldName, Object value) {
    return (WorkforcePoolProviderKey) super.set(fieldName, value);
  }

  @Override
  public WorkforcePoolProviderKey clone() {
    return (WorkforcePoolProviderKey) super.clone();
  }

}
