/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1.model;

/**
 * A configuration for an external identity provider.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WorkforcePoolProvider extends com.google.api.client.json.GenericJson {

  /**
   * A [Common Expression Language](https://opensource.google/projects/cel) expression, in plain
   * text, to restrict what otherwise valid authentication credentials issued by the provider should
   * not be accepted. The expression must output a boolean representing whether to allow the
   * federation. The following keywords may be referenced in the expressions: * `assertion`: JSON
   * representing the authentication credential issued by the provider. * `google`: The Google
   * attributes mapped from the assertion in the `attribute_mappings`. `google.profile_photo`,
   * `google.display_name` and `google.posix_username` are not supported. * `attribute`: The custom
   * attributes mapped from the assertion in the `attribute_mappings`. The maximum length of the
   * attribute condition expression is 4096 characters. If unspecified, all valid authentication
   * credentials will be accepted. The following example shows how to only allow credentials with a
   * mapped `google.groups` value of `admins`: ``` "'admins' in google.groups" ```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String attributeCondition;

  /**
   * Required. Maps attributes from the authentication credentials issued by an external identity
   * provider to Google Cloud attributes, such as `subject` and `segment`. Each key must be a string
   * specifying the Google Cloud IAM attribute to map to. The following keys are supported: *
   * `google.subject`: The principal IAM is authenticating. You can reference this value in IAM
   * bindings. This is also the subject that appears in Cloud Logging logs. This is a required field
   * and the mapped subject cannot exceed 127 bytes. * `google.groups`: Groups the authenticating
   * user belongs to. You can grant groups access to resources using an IAM `principalSet` binding;
   * access applies to all members of the group. * `google.display_name`: The name of the
   * authenticated user. This is an optional field and the mapped display name cannot exceed 100
   * bytes. If not set, `google.subject` will be displayed instead. This attribute cannot be
   * referenced in IAM bindings. * `google.profile_photo`: The URL that specifies the authenticated
   * user's thumbnail photo. This is an optional field. When set, the image will be visible as the
   * user's profile picture. If not set, a generic user icon will be displayed instead. This
   * attribute cannot be referenced in IAM bindings. * `google.posix_username`: The linux username
   * used by OS login. This is an optional field and the mapped posix username cannot exceed 32
   * characters, The key must match the regex "^a-zA-Z0-9._{0,31}$". This attribute cannot be
   * referenced in IAM bindings. You can also provide custom attributes by specifying
   * `attribute.{custom_attribute}`, where {custom_attribute} is the name of the custom attribute to
   * be mapped. You can define a maximum of 50 custom attributes. The maximum length of a mapped
   * attribute key is 100 characters, and the key may only contain the characters [a-z0-9_]. You can
   * reference these attributes in IAM policies to define fine-grained access for a workforce pool
   * to Google Cloud resources. For example: * `google.subject`:
   * `principal://iam.googleapis.com/locations/global/workforcePools/{pool}/subject/{value}` *
   * `google.groups`:
   * `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool}/group/{value}` *
   * `attribute.{custom_attribute}`: `principalSet://iam.googleapis.com/locations/global/workforcePo
   * ols/{pool}/attribute.{custom_attribute}/{value}` Each value must be a [Common Expression
   * Language] (https://opensource.google/projects/cel) function that maps an identity provider
   * credential to the normalized attribute specified by the corresponding map key. You can use the
   * `assertion` keyword in the expression to access a JSON representation of the authentication
   * credential issued by the provider. The maximum length of an attribute mapping expression is
   * 2048 characters. When evaluated, the total size of all mapped attributes must not exceed 4KB.
   * For OIDC providers, you must supply a custom mapping that includes the `google.subject`
   * attribute. For example, the following maps the `sub` claim of the incoming credential to the
   * `subject` attribute on a Google token: ``` {"google.subject": "assertion.sub"} ```
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> attributeMapping;

  /**
   * A user-specified description of the provider. Cannot exceed 256 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Disables the workforce pool provider. You cannot use a disabled provider to exchange tokens.
   * However, existing tokens still grant access.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disabled;

  /**
   * A user-specified display name for the provider. Cannot exceed 32 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Output only. Time after which the workload pool provider will be permanently purged and cannot
   * be recovered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String expireTime;

  /**
   * Output only. The resource name of the provider. Format:
   * `locations/{location}/workforcePools/{workforce_pool_id}/providers/{provider_id}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * An OpenId Connect 1.0 identity provider configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleIamAdminV1WorkforcePoolProviderOidc oidc;

  /**
   * A SAML identity provider configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleIamAdminV1WorkforcePoolProviderSaml saml;

  /**
   * Output only. The state of the provider.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * A [Common Expression Language](https://opensource.google/projects/cel) expression, in plain
   * text, to restrict what otherwise valid authentication credentials issued by the provider should
   * not be accepted. The expression must output a boolean representing whether to allow the
   * federation. The following keywords may be referenced in the expressions: * `assertion`: JSON
   * representing the authentication credential issued by the provider. * `google`: The Google
   * attributes mapped from the assertion in the `attribute_mappings`. `google.profile_photo`,
   * `google.display_name` and `google.posix_username` are not supported. * `attribute`: The custom
   * attributes mapped from the assertion in the `attribute_mappings`. The maximum length of the
   * attribute condition expression is 4096 characters. If unspecified, all valid authentication
   * credentials will be accepted. The following example shows how to only allow credentials with a
   * mapped `google.groups` value of `admins`: ``` "'admins' in google.groups" ```
   * @return value or {@code null} for none
   */
  public java.lang.String getAttributeCondition() {
    return attributeCondition;
  }

  /**
   * A [Common Expression Language](https://opensource.google/projects/cel) expression, in plain
   * text, to restrict what otherwise valid authentication credentials issued by the provider should
   * not be accepted. The expression must output a boolean representing whether to allow the
   * federation. The following keywords may be referenced in the expressions: * `assertion`: JSON
   * representing the authentication credential issued by the provider. * `google`: The Google
   * attributes mapped from the assertion in the `attribute_mappings`. `google.profile_photo`,
   * `google.display_name` and `google.posix_username` are not supported. * `attribute`: The custom
   * attributes mapped from the assertion in the `attribute_mappings`. The maximum length of the
   * attribute condition expression is 4096 characters. If unspecified, all valid authentication
   * credentials will be accepted. The following example shows how to only allow credentials with a
   * mapped `google.groups` value of `admins`: ``` "'admins' in google.groups" ```
   * @param attributeCondition attributeCondition or {@code null} for none
   */
  public WorkforcePoolProvider setAttributeCondition(java.lang.String attributeCondition) {
    this.attributeCondition = attributeCondition;
    return this;
  }

  /**
   * Required. Maps attributes from the authentication credentials issued by an external identity
   * provider to Google Cloud attributes, such as `subject` and `segment`. Each key must be a string
   * specifying the Google Cloud IAM attribute to map to. The following keys are supported: *
   * `google.subject`: The principal IAM is authenticating. You can reference this value in IAM
   * bindings. This is also the subject that appears in Cloud Logging logs. This is a required field
   * and the mapped subject cannot exceed 127 bytes. * `google.groups`: Groups the authenticating
   * user belongs to. You can grant groups access to resources using an IAM `principalSet` binding;
   * access applies to all members of the group. * `google.display_name`: The name of the
   * authenticated user. This is an optional field and the mapped display name cannot exceed 100
   * bytes. If not set, `google.subject` will be displayed instead. This attribute cannot be
   * referenced in IAM bindings. * `google.profile_photo`: The URL that specifies the authenticated
   * user's thumbnail photo. This is an optional field. When set, the image will be visible as the
   * user's profile picture. If not set, a generic user icon will be displayed instead. This
   * attribute cannot be referenced in IAM bindings. * `google.posix_username`: The linux username
   * used by OS login. This is an optional field and the mapped posix username cannot exceed 32
   * characters, The key must match the regex "^a-zA-Z0-9._{0,31}$". This attribute cannot be
   * referenced in IAM bindings. You can also provide custom attributes by specifying
   * `attribute.{custom_attribute}`, where {custom_attribute} is the name of the custom attribute to
   * be mapped. You can define a maximum of 50 custom attributes. The maximum length of a mapped
   * attribute key is 100 characters, and the key may only contain the characters [a-z0-9_]. You can
   * reference these attributes in IAM policies to define fine-grained access for a workforce pool
   * to Google Cloud resources. For example: * `google.subject`:
   * `principal://iam.googleapis.com/locations/global/workforcePools/{pool}/subject/{value}` *
   * `google.groups`:
   * `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool}/group/{value}` *
   * `attribute.{custom_attribute}`: `principalSet://iam.googleapis.com/locations/global/workforcePo
   * ols/{pool}/attribute.{custom_attribute}/{value}` Each value must be a [Common Expression
   * Language] (https://opensource.google/projects/cel) function that maps an identity provider
   * credential to the normalized attribute specified by the corresponding map key. You can use the
   * `assertion` keyword in the expression to access a JSON representation of the authentication
   * credential issued by the provider. The maximum length of an attribute mapping expression is
   * 2048 characters. When evaluated, the total size of all mapped attributes must not exceed 4KB.
   * For OIDC providers, you must supply a custom mapping that includes the `google.subject`
   * attribute. For example, the following maps the `sub` claim of the incoming credential to the
   * `subject` attribute on a Google token: ``` {"google.subject": "assertion.sub"} ```
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getAttributeMapping() {
    return attributeMapping;
  }

  /**
   * Required. Maps attributes from the authentication credentials issued by an external identity
   * provider to Google Cloud attributes, such as `subject` and `segment`. Each key must be a string
   * specifying the Google Cloud IAM attribute to map to. The following keys are supported: *
   * `google.subject`: The principal IAM is authenticating. You can reference this value in IAM
   * bindings. This is also the subject that appears in Cloud Logging logs. This is a required field
   * and the mapped subject cannot exceed 127 bytes. * `google.groups`: Groups the authenticating
   * user belongs to. You can grant groups access to resources using an IAM `principalSet` binding;
   * access applies to all members of the group. * `google.display_name`: The name of the
   * authenticated user. This is an optional field and the mapped display name cannot exceed 100
   * bytes. If not set, `google.subject` will be displayed instead. This attribute cannot be
   * referenced in IAM bindings. * `google.profile_photo`: The URL that specifies the authenticated
   * user's thumbnail photo. This is an optional field. When set, the image will be visible as the
   * user's profile picture. If not set, a generic user icon will be displayed instead. This
   * attribute cannot be referenced in IAM bindings. * `google.posix_username`: The linux username
   * used by OS login. This is an optional field and the mapped posix username cannot exceed 32
   * characters, The key must match the regex "^a-zA-Z0-9._{0,31}$". This attribute cannot be
   * referenced in IAM bindings. You can also provide custom attributes by specifying
   * `attribute.{custom_attribute}`, where {custom_attribute} is the name of the custom attribute to
   * be mapped. You can define a maximum of 50 custom attributes. The maximum length of a mapped
   * attribute key is 100 characters, and the key may only contain the characters [a-z0-9_]. You can
   * reference these attributes in IAM policies to define fine-grained access for a workforce pool
   * to Google Cloud resources. For example: * `google.subject`:
   * `principal://iam.googleapis.com/locations/global/workforcePools/{pool}/subject/{value}` *
   * `google.groups`:
   * `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool}/group/{value}` *
   * `attribute.{custom_attribute}`: `principalSet://iam.googleapis.com/locations/global/workforcePo
   * ols/{pool}/attribute.{custom_attribute}/{value}` Each value must be a [Common Expression
   * Language] (https://opensource.google/projects/cel) function that maps an identity provider
   * credential to the normalized attribute specified by the corresponding map key. You can use the
   * `assertion` keyword in the expression to access a JSON representation of the authentication
   * credential issued by the provider. The maximum length of an attribute mapping expression is
   * 2048 characters. When evaluated, the total size of all mapped attributes must not exceed 4KB.
   * For OIDC providers, you must supply a custom mapping that includes the `google.subject`
   * attribute. For example, the following maps the `sub` claim of the incoming credential to the
   * `subject` attribute on a Google token: ``` {"google.subject": "assertion.sub"} ```
   * @param attributeMapping attributeMapping or {@code null} for none
   */
  public WorkforcePoolProvider setAttributeMapping(java.util.Map<String, java.lang.String> attributeMapping) {
    this.attributeMapping = attributeMapping;
    return this;
  }

  /**
   * A user-specified description of the provider. Cannot exceed 256 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A user-specified description of the provider. Cannot exceed 256 characters.
   * @param description description or {@code null} for none
   */
  public WorkforcePoolProvider setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Disables the workforce pool provider. You cannot use a disabled provider to exchange tokens.
   * However, existing tokens still grant access.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisabled() {
    return disabled;
  }

  /**
   * Disables the workforce pool provider. You cannot use a disabled provider to exchange tokens.
   * However, existing tokens still grant access.
   * @param disabled disabled or {@code null} for none
   */
  public WorkforcePoolProvider setDisabled(java.lang.Boolean disabled) {
    this.disabled = disabled;
    return this;
  }

  /**
   * A user-specified display name for the provider. Cannot exceed 32 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * A user-specified display name for the provider. Cannot exceed 32 characters.
   * @param displayName displayName or {@code null} for none
   */
  public WorkforcePoolProvider setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Output only. Time after which the workload pool provider will be permanently purged and cannot
   * be recovered.
   * @return value or {@code null} for none
   */
  public String getExpireTime() {
    return expireTime;
  }

  /**
   * Output only. Time after which the workload pool provider will be permanently purged and cannot
   * be recovered.
   * @param expireTime expireTime or {@code null} for none
   */
  public WorkforcePoolProvider setExpireTime(String expireTime) {
    this.expireTime = expireTime;
    return this;
  }

  /**
   * Output only. The resource name of the provider. Format:
   * `locations/{location}/workforcePools/{workforce_pool_id}/providers/{provider_id}`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The resource name of the provider. Format:
   * `locations/{location}/workforcePools/{workforce_pool_id}/providers/{provider_id}`
   * @param name name or {@code null} for none
   */
  public WorkforcePoolProvider setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * An OpenId Connect 1.0 identity provider configuration.
   * @return value or {@code null} for none
   */
  public GoogleIamAdminV1WorkforcePoolProviderOidc getOidc() {
    return oidc;
  }

  /**
   * An OpenId Connect 1.0 identity provider configuration.
   * @param oidc oidc or {@code null} for none
   */
  public WorkforcePoolProvider setOidc(GoogleIamAdminV1WorkforcePoolProviderOidc oidc) {
    this.oidc = oidc;
    return this;
  }

  /**
   * A SAML identity provider configuration.
   * @return value or {@code null} for none
   */
  public GoogleIamAdminV1WorkforcePoolProviderSaml getSaml() {
    return saml;
  }

  /**
   * A SAML identity provider configuration.
   * @param saml saml or {@code null} for none
   */
  public WorkforcePoolProvider setSaml(GoogleIamAdminV1WorkforcePoolProviderSaml saml) {
    this.saml = saml;
    return this;
  }

  /**
   * Output only. The state of the provider.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Output only. The state of the provider.
   * @param state state or {@code null} for none
   */
  public WorkforcePoolProvider setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public WorkforcePoolProvider set(String fieldName, Object value) {
    return (WorkforcePoolProvider) super.set(fieldName, value);
  }

  @Override
  public WorkforcePoolProvider clone() {
    return (WorkforcePoolProvider) super.clone();
  }

}
