/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1.model;

/**
 * Represents a collection of workload identities. You can define IAM policies to grant these
 * identities access to Google Cloud resources.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WorkloadIdentityPool extends com.google.api.client.json.GenericJson {

  /**
   * A description of the pool. Cannot exceed 256 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Whether the pool is disabled. You cannot use a disabled pool to exchange tokens, or use
   * existing tokens to access resources. If the pool is re-enabled, existing tokens grant access
   * again.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disabled;

  /**
   * A display name for the pool. Cannot exceed 32 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Output only. Time after which the workload identity pool will be permanently purged and cannot
   * be recovered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String expireTime;

  /**
   * Output only. The resource name of the pool.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. The state of the pool.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * A description of the pool. Cannot exceed 256 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A description of the pool. Cannot exceed 256 characters.
   * @param description description or {@code null} for none
   */
  public WorkloadIdentityPool setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Whether the pool is disabled. You cannot use a disabled pool to exchange tokens, or use
   * existing tokens to access resources. If the pool is re-enabled, existing tokens grant access
   * again.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisabled() {
    return disabled;
  }

  /**
   * Whether the pool is disabled. You cannot use a disabled pool to exchange tokens, or use
   * existing tokens to access resources. If the pool is re-enabled, existing tokens grant access
   * again.
   * @param disabled disabled or {@code null} for none
   */
  public WorkloadIdentityPool setDisabled(java.lang.Boolean disabled) {
    this.disabled = disabled;
    return this;
  }

  /**
   * A display name for the pool. Cannot exceed 32 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * A display name for the pool. Cannot exceed 32 characters.
   * @param displayName displayName or {@code null} for none
   */
  public WorkloadIdentityPool setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Output only. Time after which the workload identity pool will be permanently purged and cannot
   * be recovered.
   * @return value or {@code null} for none
   */
  public String getExpireTime() {
    return expireTime;
  }

  /**
   * Output only. Time after which the workload identity pool will be permanently purged and cannot
   * be recovered.
   * @param expireTime expireTime or {@code null} for none
   */
  public WorkloadIdentityPool setExpireTime(String expireTime) {
    this.expireTime = expireTime;
    return this;
  }

  /**
   * Output only. The resource name of the pool.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The resource name of the pool.
   * @param name name or {@code null} for none
   */
  public WorkloadIdentityPool setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. The state of the pool.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Output only. The state of the pool.
   * @param state state or {@code null} for none
   */
  public WorkloadIdentityPool setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public WorkloadIdentityPool set(String fieldName, Object value) {
    return (WorkloadIdentityPool) super.set(fieldName, value);
  }

  @Override
  public WorkloadIdentityPool clone() {
    return (WorkloadIdentityPool) super.clone();
  }

}
