/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-30 at 23:29:06 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1.model;

/**
 * Structured response of a single validation unit.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LintResult extends com.google.api.client.json.GenericJson {

  /**
   * 0-based index ordinality of the binding in the input object associated with this result. This
   * field is populated only if the input object to lint is of type google.iam.v1.Policy, which can
   * comprise more than one binding. It is set to -1 if the result is not associated with any
   * particular binding and only targets the policy as a whole, such as results about policy size
   * violations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer bindingOrdinal;

  /**
   * Human readable debug message associated with the issue.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String debugMessage;

  /**
   * The name of the field for which this lint result is about.
   *
   * For nested messages, `field_name` consists of names of the embedded fields separated by period
   * character. The top-level qualifier is the input object to lint in the request. For instance, if
   * the lint request is on a google.iam.v1.Policy and this lint result is about a condition
   * expression of one of the input policy bindings, the field would be populated as
   * `policy.bindings.condition.expression`.
   *
   * This field does not identify the ordinality of the repetitive fields (for instance bindings in
   * a policy).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fieldName;

  /**
   * The validation unit level.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String level;

  /**
   * 0-based character position of problematic construct within the object identified by
   * `field_name`. Currently, this is populated only for condition expression.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer locationOffset;

  /**
   * The validation unit severity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String severity;

  /**
   * The validation unit name, for instance “lintValidationUnits/ConditionComplexityCheck”.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String validationUnitName;

  /**
   * 0-based index ordinality of the binding in the input object associated with this result. This
   * field is populated only if the input object to lint is of type google.iam.v1.Policy, which can
   * comprise more than one binding. It is set to -1 if the result is not associated with any
   * particular binding and only targets the policy as a whole, such as results about policy size
   * violations.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getBindingOrdinal() {
    return bindingOrdinal;
  }

  /**
   * 0-based index ordinality of the binding in the input object associated with this result. This
   * field is populated only if the input object to lint is of type google.iam.v1.Policy, which can
   * comprise more than one binding. It is set to -1 if the result is not associated with any
   * particular binding and only targets the policy as a whole, such as results about policy size
   * violations.
   * @param bindingOrdinal bindingOrdinal or {@code null} for none
   */
  public LintResult setBindingOrdinal(java.lang.Integer bindingOrdinal) {
    this.bindingOrdinal = bindingOrdinal;
    return this;
  }

  /**
   * Human readable debug message associated with the issue.
   * @return value or {@code null} for none
   */
  public java.lang.String getDebugMessage() {
    return debugMessage;
  }

  /**
   * Human readable debug message associated with the issue.
   * @param debugMessage debugMessage or {@code null} for none
   */
  public LintResult setDebugMessage(java.lang.String debugMessage) {
    this.debugMessage = debugMessage;
    return this;
  }

  /**
   * The name of the field for which this lint result is about.
   *
   * For nested messages, `field_name` consists of names of the embedded fields separated by period
   * character. The top-level qualifier is the input object to lint in the request. For instance, if
   * the lint request is on a google.iam.v1.Policy and this lint result is about a condition
   * expression of one of the input policy bindings, the field would be populated as
   * `policy.bindings.condition.expression`.
   *
   * This field does not identify the ordinality of the repetitive fields (for instance bindings in
   * a policy).
   * @return value or {@code null} for none
   */
  public java.lang.String getFieldName() {
    return fieldName;
  }

  /**
   * The name of the field for which this lint result is about.
   *
   * For nested messages, `field_name` consists of names of the embedded fields separated by period
   * character. The top-level qualifier is the input object to lint in the request. For instance, if
   * the lint request is on a google.iam.v1.Policy and this lint result is about a condition
   * expression of one of the input policy bindings, the field would be populated as
   * `policy.bindings.condition.expression`.
   *
   * This field does not identify the ordinality of the repetitive fields (for instance bindings in
   * a policy).
   * @param fieldName fieldName or {@code null} for none
   */
  public LintResult setFieldName(java.lang.String fieldName) {
    this.fieldName = fieldName;
    return this;
  }

  /**
   * The validation unit level.
   * @return value or {@code null} for none
   */
  public java.lang.String getLevel() {
    return level;
  }

  /**
   * The validation unit level.
   * @param level level or {@code null} for none
   */
  public LintResult setLevel(java.lang.String level) {
    this.level = level;
    return this;
  }

  /**
   * 0-based character position of problematic construct within the object identified by
   * `field_name`. Currently, this is populated only for condition expression.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getLocationOffset() {
    return locationOffset;
  }

  /**
   * 0-based character position of problematic construct within the object identified by
   * `field_name`. Currently, this is populated only for condition expression.
   * @param locationOffset locationOffset or {@code null} for none
   */
  public LintResult setLocationOffset(java.lang.Integer locationOffset) {
    this.locationOffset = locationOffset;
    return this;
  }

  /**
   * The validation unit severity.
   * @return value or {@code null} for none
   */
  public java.lang.String getSeverity() {
    return severity;
  }

  /**
   * The validation unit severity.
   * @param severity severity or {@code null} for none
   */
  public LintResult setSeverity(java.lang.String severity) {
    this.severity = severity;
    return this;
  }

  /**
   * The validation unit name, for instance “lintValidationUnits/ConditionComplexityCheck”.
   * @return value or {@code null} for none
   */
  public java.lang.String getValidationUnitName() {
    return validationUnitName;
  }

  /**
   * The validation unit name, for instance “lintValidationUnits/ConditionComplexityCheck”.
   * @param validationUnitName validationUnitName or {@code null} for none
   */
  public LintResult setValidationUnitName(java.lang.String validationUnitName) {
    this.validationUnitName = validationUnitName;
    return this;
  }

  @Override
  public LintResult set(String fieldName, Object value) {
    return (LintResult) super.set(fieldName, value);
  }

  @Override
  public LintResult clone() {
    return (LintResult) super.clone();
  }

}
