/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-30 at 23:29:06 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1.model;

/**
 * A response containing a list of auditable services for a resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class QueryAuditableServicesResponse extends com.google.api.client.json.GenericJson {

  /**
   * The auditable services for a resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AuditableService> services;

  static {
    // hack to force ProGuard to consider AuditableService used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AuditableService.class);
  }

  /**
   * The auditable services for a resource.
   * @return value or {@code null} for none
   */
  public java.util.List<AuditableService> getServices() {
    return services;
  }

  /**
   * The auditable services for a resource.
   * @param services services or {@code null} for none
   */
  public QueryAuditableServicesResponse setServices(java.util.List<AuditableService> services) {
    this.services = services;
    return this;
  }

  @Override
  public QueryAuditableServicesResponse set(String fieldName, Object value) {
    return (QueryAuditableServicesResponse) super.set(fieldName, value);
  }

  @Override
  public QueryAuditableServicesResponse clone() {
    return (QueryAuditableServicesResponse) super.clone();
  }

}
