/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-09-22 at 02:06:32 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1;

/**
 * Service definition for Iam (v1).
 *
 * <p>
 * Manages identity and access control for Google Cloud Platform resources, including the creation of service accounts, which you can use to authenticate to Google and make API calls.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/iam/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link IamRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Iam extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.22.0 of the Google Identity and Access Management (IAM) API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://iam.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Iam(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Iam(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Iam iam = new Iam(...);}
   *   {@code Iam.Projects.List request = iam.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * An accessor for creating requests from the ServiceAccounts collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Iam iam = new Iam(...);}
     *   {@code Iam.ServiceAccounts.List request = iam.serviceAccounts().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public ServiceAccounts serviceAccounts() {
      return new ServiceAccounts();
    }

    /**
     * The "serviceAccounts" collection of methods.
     */
    public class ServiceAccounts {

      /**
       * Creates a ServiceAccount and returns it.
       *
       * Create a request for the method "serviceAccounts.create".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name of the project associated with the service accounts, such as `projects
       *        /my-project-123`.
       * @param content the {@link com.google.api.services.iam.v1.model.CreateServiceAccountRequest}
       * @return the request
       */
      public Create create(java.lang.String name, com.google.api.services.iam.v1.model.CreateServiceAccountRequest content) throws java.io.IOException {
        Create result = new Create(name, content);
        initialize(result);
        return result;
      }

      public class Create extends IamRequest<com.google.api.services.iam.v1.model.ServiceAccount> {

        private static final String REST_PATH = "v1/{+name}/serviceAccounts";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]*$");

        /**
         * Creates a ServiceAccount and returns it.
         *
         * Create a request for the method "serviceAccounts.create".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name of the project associated with the service accounts, such as `projects
       *        /my-project-123`.
         * @param content the {@link com.google.api.services.iam.v1.model.CreateServiceAccountRequest}
         * @since 1.13
         */
        protected Create(java.lang.String name, com.google.api.services.iam.v1.model.CreateServiceAccountRequest content) {
          super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.ServiceAccount.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]*$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setBearerToken(java.lang.String bearerToken) {
          return (Create) super.setBearerToken(bearerToken);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPp(java.lang.Boolean pp) {
          return (Create) super.setPp(pp);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The resource name of the project associated with the service accounts, such as
         * `projects/my-project-123`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name of the project associated with the service accounts, such as `projects
       /my-project-123`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The resource name of the project associated with the service accounts, such as
         * `projects/my-project-123`.
         */
        public Create setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]*$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a ServiceAccount.
       *
       * Create a request for the method "serviceAccounts.delete".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name The resource name of the service account in the following format:
       *        `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project
       *        will infer the project from the account. The `account` value can be the `email` address or
       *        the `unique_id` of the service account.
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends IamRequest<com.google.api.services.iam.v1.model.Empty> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]*/serviceAccounts/[^/]*$");

        /**
         * Deletes a ServiceAccount.
         *
         * Create a request for the method "serviceAccounts.delete".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource name of the service account in the following format:
       *        `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project
       *        will infer the project from the account. The `account` value can be the `email` address or
       *        the `unique_id` of the service account.
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(Iam.this, "DELETE", REST_PATH, null, com.google.api.services.iam.v1.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]*/serviceAccounts/[^/]*$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setBearerToken(java.lang.String bearerToken) {
          return (Delete) super.setBearerToken(bearerToken);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPp(java.lang.Boolean pp) {
          return (Delete) super.setPp(pp);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The resource name of the service account in the following format:
         * `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project
         * will infer the project from the account. The `account` value can be the `email` address
         * or the `unique_id` of the service account.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource name of the service account in the following format:
       `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project will infer
       the project from the account. The `account` value can be the `email` address or the `unique_id` of
       the service account.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The resource name of the service account in the following format:
         * `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project
         * will infer the project from the account. The `account` value can be the `email` address
         * or the `unique_id` of the service account.
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]*/serviceAccounts/[^/]*$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets a ServiceAccount.
       *
       * Create a request for the method "serviceAccounts.get".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name The resource name of the service account in the following format:
       *        `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project
       *        will infer the project from the account. The `account` value can be the `email` address or
       *        the `unique_id` of the service account.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends IamRequest<com.google.api.services.iam.v1.model.ServiceAccount> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]*/serviceAccounts/[^/]*$");

        /**
         * Gets a ServiceAccount.
         *
         * Create a request for the method "serviceAccounts.get".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource name of the service account in the following format:
       *        `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project
       *        will infer the project from the account. The `account` value can be the `email` address or
       *        the `unique_id` of the service account.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Iam.this, "GET", REST_PATH, null, com.google.api.services.iam.v1.model.ServiceAccount.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]*/serviceAccounts/[^/]*$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setBearerToken(java.lang.String bearerToken) {
          return (Get) super.setBearerToken(bearerToken);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPp(java.lang.Boolean pp) {
          return (Get) super.setPp(pp);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The resource name of the service account in the following format:
         * `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project
         * will infer the project from the account. The `account` value can be the `email` address
         * or the `unique_id` of the service account.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource name of the service account in the following format:
       `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project will infer
       the project from the account. The `account` value can be the `email` address or the `unique_id` of
       the service account.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The resource name of the service account in the following format:
         * `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project
         * will infer the project from the account. The `account` value can be the `email` address
         * or the `unique_id` of the service account.
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]*/serviceAccounts/[^/]*$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Returns the IAM access control policy for a ServiceAccount.
       *
       * Create a request for the method "serviceAccounts.getIamPolicy".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being requested. `resource` is usually specified as a
       *        path. For example, a Project resource is specified as `projects/{project}`.
       * @return the request
       */
      public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
        GetIamPolicy result = new GetIamPolicy(resource);
        initialize(result);
        return result;
      }

      public class GetIamPolicy extends IamRequest<com.google.api.services.iam.v1.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]*/serviceAccounts/[^/]*$");

        /**
         * Returns the IAM access control policy for a ServiceAccount.
         *
         * Create a request for the method "serviceAccounts.getIamPolicy".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation. <p>
         * {@link
         * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being requested. `resource` is usually specified as a
       *        path. For example, a Project resource is specified as `projects/{project}`.
         * @since 1.13
         */
        protected GetIamPolicy(java.lang.String resource) {
          super(Iam.this, "POST", REST_PATH, null, com.google.api.services.iam.v1.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]*/serviceAccounts/[^/]*$");
          }
        }

        @Override
        public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (GetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (GetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public GetIamPolicy setAlt(java.lang.String alt) {
          return (GetIamPolicy) super.setAlt(alt);
        }

        @Override
        public GetIamPolicy setBearerToken(java.lang.String bearerToken) {
          return (GetIamPolicy) super.setBearerToken(bearerToken);
        }

        @Override
        public GetIamPolicy setCallback(java.lang.String callback) {
          return (GetIamPolicy) super.setCallback(callback);
        }

        @Override
        public GetIamPolicy setFields(java.lang.String fields) {
          return (GetIamPolicy) super.setFields(fields);
        }

        @Override
        public GetIamPolicy setKey(java.lang.String key) {
          return (GetIamPolicy) super.setKey(key);
        }

        @Override
        public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (GetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public GetIamPolicy setPp(java.lang.Boolean pp) {
          return (GetIamPolicy) super.setPp(pp);
        }

        @Override
        public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (GetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetIamPolicy setUploadType(java.lang.String uploadType) {
          return (GetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. `resource` is usually
         * specified as a path. For example, a Project resource is specified as
         * `projects/{project}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being requested. `resource` is usually specified as
       a path. For example, a Project resource is specified as `projects/{project}`.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. `resource` is usually
         * specified as a path. For example, a Project resource is specified as
         * `projects/{project}`.
         */
        public GetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]*/serviceAccounts/[^/]*$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public GetIamPolicy set(String parameterName, Object value) {
          return (GetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Lists ServiceAccounts for a project.
       *
       * Create a request for the method "serviceAccounts.list".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name of the project associated with the service accounts, such as `projects
       *        /my-project-123`.
       * @return the request
       */
      public List list(java.lang.String name) throws java.io.IOException {
        List result = new List(name);
        initialize(result);
        return result;
      }

      public class List extends IamRequest<com.google.api.services.iam.v1.model.ListServiceAccountsResponse> {

        private static final String REST_PATH = "v1/{+name}/serviceAccounts";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]*$");

        /**
         * Lists ServiceAccounts for a project.
         *
         * Create a request for the method "serviceAccounts.list".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name of the project associated with the service accounts, such as `projects
       *        /my-project-123`.
         * @since 1.13
         */
        protected List(java.lang.String name) {
          super(Iam.this, "GET", REST_PATH, null, com.google.api.services.iam.v1.model.ListServiceAccountsResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]*$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setBearerToken(java.lang.String bearerToken) {
          return (List) super.setBearerToken(bearerToken);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPp(java.lang.Boolean pp) {
          return (List) super.setPp(pp);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The resource name of the project associated with the service accounts, such as
         * `projects/my-project-123`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name of the project associated with the service accounts, such as `projects
       /my-project-123`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The resource name of the project associated with the service accounts, such as
         * `projects/my-project-123`.
         */
        public List setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]*$");
          }
          this.name = name;
          return this;
        }

        /**
         * Optional limit on the number of service accounts to include in the response. Further
         * accounts can subsequently be obtained by including the
         * ListServiceAccountsResponse.next_page_token in a subsequent request.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** Optional limit on the number of service accounts to include in the response. Further accounts can
       subsequently be obtained by including the ListServiceAccountsResponse.next_page_token in a
       subsequent request.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * Optional limit on the number of service accounts to include in the response. Further
         * accounts can subsequently be obtained by including the
         * ListServiceAccountsResponse.next_page_token in a subsequent request.
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * Optional pagination token returned in an earlier
         * ListServiceAccountsResponse.next_page_token.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** Optional pagination token returned in an earlier ListServiceAccountsResponse.next_page_token.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * Optional pagination token returned in an earlier
         * ListServiceAccountsResponse.next_page_token.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Sets the IAM access control policy for a ServiceAccount.
       *
       * Create a request for the method "serviceAccounts.setIamPolicy".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being specified. `resource` is usually specified as a
       *        path. For example, a Project resource is specified as `projects/{project}`.
       * @param content the {@link com.google.api.services.iam.v1.model.SetIamPolicyRequest}
       * @return the request
       */
      public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.iam.v1.model.SetIamPolicyRequest content) throws java.io.IOException {
        SetIamPolicy result = new SetIamPolicy(resource, content);
        initialize(result);
        return result;
      }

      public class SetIamPolicy extends IamRequest<com.google.api.services.iam.v1.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]*/serviceAccounts/[^/]*$");

        /**
         * Sets the IAM access control policy for a ServiceAccount.
         *
         * Create a request for the method "serviceAccounts.setIamPolicy".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation. <p>
         * {@link
         * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being specified. `resource` is usually specified as a
       *        path. For example, a Project resource is specified as `projects/{project}`.
         * @param content the {@link com.google.api.services.iam.v1.model.SetIamPolicyRequest}
         * @since 1.13
         */
        protected SetIamPolicy(java.lang.String resource, com.google.api.services.iam.v1.model.SetIamPolicyRequest content) {
          super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]*/serviceAccounts/[^/]*$");
          }
        }

        @Override
        public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (SetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public SetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (SetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public SetIamPolicy setAlt(java.lang.String alt) {
          return (SetIamPolicy) super.setAlt(alt);
        }

        @Override
        public SetIamPolicy setBearerToken(java.lang.String bearerToken) {
          return (SetIamPolicy) super.setBearerToken(bearerToken);
        }

        @Override
        public SetIamPolicy setCallback(java.lang.String callback) {
          return (SetIamPolicy) super.setCallback(callback);
        }

        @Override
        public SetIamPolicy setFields(java.lang.String fields) {
          return (SetIamPolicy) super.setFields(fields);
        }

        @Override
        public SetIamPolicy setKey(java.lang.String key) {
          return (SetIamPolicy) super.setKey(key);
        }

        @Override
        public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (SetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public SetIamPolicy setPp(java.lang.Boolean pp) {
          return (SetIamPolicy) super.setPp(pp);
        }

        @Override
        public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (SetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public SetIamPolicy setUploadType(java.lang.String uploadType) {
          return (SetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. `resource` is usually
         * specified as a path. For example, a Project resource is specified as
         * `projects/{project}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being specified. `resource` is usually specified as
       a path. For example, a Project resource is specified as `projects/{project}`.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. `resource` is usually
         * specified as a path. For example, a Project resource is specified as
         * `projects/{project}`.
         */
        public SetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]*/serviceAccounts/[^/]*$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public SetIamPolicy set(String parameterName, Object value) {
          return (SetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Signs a blob using a service account's system-managed private key.
       *
       * Create a request for the method "serviceAccounts.signBlob".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link SignBlob#execute()} method to invoke the remote operation.
       *
       * @param name The resource name of the service account in the following format:
       *        `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project
       *        will infer the project from the account. The `account` value can be the `email` address or
       *        the `unique_id` of the service account.
       * @param content the {@link com.google.api.services.iam.v1.model.SignBlobRequest}
       * @return the request
       */
      public SignBlob signBlob(java.lang.String name, com.google.api.services.iam.v1.model.SignBlobRequest content) throws java.io.IOException {
        SignBlob result = new SignBlob(name, content);
        initialize(result);
        return result;
      }

      public class SignBlob extends IamRequest<com.google.api.services.iam.v1.model.SignBlobResponse> {

        private static final String REST_PATH = "v1/{+name}:signBlob";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]*/serviceAccounts/[^/]*$");

        /**
         * Signs a blob using a service account's system-managed private key.
         *
         * Create a request for the method "serviceAccounts.signBlob".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link SignBlob#execute()} method to invoke the remote operation. <p>
         * {@link
         * SignBlob#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource name of the service account in the following format:
       *        `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project
       *        will infer the project from the account. The `account` value can be the `email` address or
       *        the `unique_id` of the service account.
         * @param content the {@link com.google.api.services.iam.v1.model.SignBlobRequest}
         * @since 1.13
         */
        protected SignBlob(java.lang.String name, com.google.api.services.iam.v1.model.SignBlobRequest content) {
          super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.SignBlobResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]*/serviceAccounts/[^/]*$");
          }
        }

        @Override
        public SignBlob set$Xgafv(java.lang.String $Xgafv) {
          return (SignBlob) super.set$Xgafv($Xgafv);
        }

        @Override
        public SignBlob setAccessToken(java.lang.String accessToken) {
          return (SignBlob) super.setAccessToken(accessToken);
        }

        @Override
        public SignBlob setAlt(java.lang.String alt) {
          return (SignBlob) super.setAlt(alt);
        }

        @Override
        public SignBlob setBearerToken(java.lang.String bearerToken) {
          return (SignBlob) super.setBearerToken(bearerToken);
        }

        @Override
        public SignBlob setCallback(java.lang.String callback) {
          return (SignBlob) super.setCallback(callback);
        }

        @Override
        public SignBlob setFields(java.lang.String fields) {
          return (SignBlob) super.setFields(fields);
        }

        @Override
        public SignBlob setKey(java.lang.String key) {
          return (SignBlob) super.setKey(key);
        }

        @Override
        public SignBlob setOauthToken(java.lang.String oauthToken) {
          return (SignBlob) super.setOauthToken(oauthToken);
        }

        @Override
        public SignBlob setPp(java.lang.Boolean pp) {
          return (SignBlob) super.setPp(pp);
        }

        @Override
        public SignBlob setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (SignBlob) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public SignBlob setQuotaUser(java.lang.String quotaUser) {
          return (SignBlob) super.setQuotaUser(quotaUser);
        }

        @Override
        public SignBlob setUploadType(java.lang.String uploadType) {
          return (SignBlob) super.setUploadType(uploadType);
        }

        @Override
        public SignBlob setUploadProtocol(java.lang.String uploadProtocol) {
          return (SignBlob) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The resource name of the service account in the following format:
         * `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project
         * will infer the project from the account. The `account` value can be the `email` address
         * or the `unique_id` of the service account.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource name of the service account in the following format:
       `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project will infer
       the project from the account. The `account` value can be the `email` address or the `unique_id` of
       the service account.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The resource name of the service account in the following format:
         * `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project
         * will infer the project from the account. The `account` value can be the `email` address
         * or the `unique_id` of the service account.
         */
        public SignBlob setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]*/serviceAccounts/[^/]*$");
          }
          this.name = name;
          return this;
        }

        @Override
        public SignBlob set(String parameterName, Object value) {
          return (SignBlob) super.set(parameterName, value);
        }
      }
      /**
       * Tests the specified permissions against the IAM access control policy for a ServiceAccount.
       *
       * Create a request for the method "serviceAccounts.testIamPermissions".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy detail is being requested. `resource` is usually
       *        specified as a path. For example, a Project resource is specified as `projects/{project}`.
       * @param content the {@link com.google.api.services.iam.v1.model.TestIamPermissionsRequest}
       * @return the request
       */
      public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.iam.v1.model.TestIamPermissionsRequest content) throws java.io.IOException {
        TestIamPermissions result = new TestIamPermissions(resource, content);
        initialize(result);
        return result;
      }

      public class TestIamPermissions extends IamRequest<com.google.api.services.iam.v1.model.TestIamPermissionsResponse> {

        private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]*/serviceAccounts/[^/]*$");

        /**
         * Tests the specified permissions against the IAM access control policy for a ServiceAccount.
         *
         * Create a request for the method "serviceAccounts.testIamPermissions".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
         * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
         * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy detail is being requested. `resource` is usually
       *        specified as a path. For example, a Project resource is specified as `projects/{project}`.
         * @param content the {@link com.google.api.services.iam.v1.model.TestIamPermissionsRequest}
         * @since 1.13
         */
        protected TestIamPermissions(java.lang.String resource, com.google.api.services.iam.v1.model.TestIamPermissionsRequest content) {
          super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.TestIamPermissionsResponse.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]*/serviceAccounts/[^/]*$");
          }
        }

        @Override
        public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
          return (TestIamPermissions) super.set$Xgafv($Xgafv);
        }

        @Override
        public TestIamPermissions setAccessToken(java.lang.String accessToken) {
          return (TestIamPermissions) super.setAccessToken(accessToken);
        }

        @Override
        public TestIamPermissions setAlt(java.lang.String alt) {
          return (TestIamPermissions) super.setAlt(alt);
        }

        @Override
        public TestIamPermissions setBearerToken(java.lang.String bearerToken) {
          return (TestIamPermissions) super.setBearerToken(bearerToken);
        }

        @Override
        public TestIamPermissions setCallback(java.lang.String callback) {
          return (TestIamPermissions) super.setCallback(callback);
        }

        @Override
        public TestIamPermissions setFields(java.lang.String fields) {
          return (TestIamPermissions) super.setFields(fields);
        }

        @Override
        public TestIamPermissions setKey(java.lang.String key) {
          return (TestIamPermissions) super.setKey(key);
        }

        @Override
        public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
          return (TestIamPermissions) super.setOauthToken(oauthToken);
        }

        @Override
        public TestIamPermissions setPp(java.lang.Boolean pp) {
          return (TestIamPermissions) super.setPp(pp);
        }

        @Override
        public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
          return (TestIamPermissions) super.setQuotaUser(quotaUser);
        }

        @Override
        public TestIamPermissions setUploadType(java.lang.String uploadType) {
          return (TestIamPermissions) super.setUploadType(uploadType);
        }

        @Override
        public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
          return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. `resource` is
         * usually specified as a path. For example, a Project resource is specified as
         * `projects/{project}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy detail is being requested. `resource` is usually
       specified as a path. For example, a Project resource is specified as `projects/{project}`.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. `resource` is
         * usually specified as a path. For example, a Project resource is specified as
         * `projects/{project}`.
         */
        public TestIamPermissions setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]*/serviceAccounts/[^/]*$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public TestIamPermissions set(String parameterName, Object value) {
          return (TestIamPermissions) super.set(parameterName, value);
        }
      }
      /**
       * Updates a ServiceAccount. Currently, only the following fields are updatable: `display_name` .
       * The `etag` is mandatory.
       *
       * Create a request for the method "serviceAccounts.update".
       *
       * This request holds the parameters needed by the iam server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param name The resource name of the service account in the following format:
       *        `projects/{project}/serviceAccounts/{account}`. Requests using `-` as a wildcard for the
       *        project will infer the project from the `account` and the `account` value can be the
       *        `email` address or the `unique_id` of the service account. In responses the resource name
       *        will always be in the format `projects/{project}/serviceAccounts/{email}`.
       * @param content the {@link com.google.api.services.iam.v1.model.ServiceAccount}
       * @return the request
       */
      public Update update(java.lang.String name, com.google.api.services.iam.v1.model.ServiceAccount content) throws java.io.IOException {
        Update result = new Update(name, content);
        initialize(result);
        return result;
      }

      public class Update extends IamRequest<com.google.api.services.iam.v1.model.ServiceAccount> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]*/serviceAccounts/[^/]*$");

        /**
         * Updates a ServiceAccount. Currently, only the following fields are updatable: `display_name` .
         * The `etag` is mandatory.
         *
         * Create a request for the method "serviceAccounts.update".
         *
         * This request holds the parameters needed by the the iam server.  After setting any optional
         * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource name of the service account in the following format:
       *        `projects/{project}/serviceAccounts/{account}`. Requests using `-` as a wildcard for the
       *        project will infer the project from the `account` and the `account` value can be the
       *        `email` address or the `unique_id` of the service account. In responses the resource name
       *        will always be in the format `projects/{project}/serviceAccounts/{email}`.
         * @param content the {@link com.google.api.services.iam.v1.model.ServiceAccount}
         * @since 1.13
         */
        protected Update(java.lang.String name, com.google.api.services.iam.v1.model.ServiceAccount content) {
          super(Iam.this, "PUT", REST_PATH, content, com.google.api.services.iam.v1.model.ServiceAccount.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]*/serviceAccounts/[^/]*$");
          }
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setBearerToken(java.lang.String bearerToken) {
          return (Update) super.setBearerToken(bearerToken);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPp(java.lang.Boolean pp) {
          return (Update) super.setPp(pp);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The resource name of the service account in the following format:
         * `projects/{project}/serviceAccounts/{account}`. Requests using `-` as a wildcard for the
         * project will infer the project from the `account` and the `account` value can be the
         * `email` address or the `unique_id` of the service account. In responses the resource name
         * will always be in the format `projects/{project}/serviceAccounts/{email}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource name of the service account in the following format:
       `projects/{project}/serviceAccounts/{account}`. Requests using `-` as a wildcard for the project
       will infer the project from the `account` and the `account` value can be the `email` address or the
       `unique_id` of the service account. In responses the resource name will always be in the format
       `projects/{project}/serviceAccounts/{email}`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The resource name of the service account in the following format:
         * `projects/{project}/serviceAccounts/{account}`. Requests using `-` as a wildcard for the
         * project will infer the project from the `account` and the `account` value can be the
         * `email` address or the `unique_id` of the service account. In responses the resource name
         * will always be in the format `projects/{project}/serviceAccounts/{email}`.
         */
        public Update setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]*/serviceAccounts/[^/]*$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the Keys collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Iam iam = new Iam(...);}
       *   {@code Iam.Keys.List request = iam.keys().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Keys keys() {
        return new Keys();
      }

      /**
       * The "keys" collection of methods.
       */
      public class Keys {

        /**
         * Creates a ServiceAccountKey and returns it.
         *
         * Create a request for the method "keys.create".
         *
         * This request holds the parameters needed by the iam server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param name The resource name of the service account in the following format:
         *        `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project
         *        will infer the project from the account. The `account` value can be the `email` address or
         *        the `unique_id` of the service account.
         * @param content the {@link com.google.api.services.iam.v1.model.CreateServiceAccountKeyRequest}
         * @return the request
         */
        public Create create(java.lang.String name, com.google.api.services.iam.v1.model.CreateServiceAccountKeyRequest content) throws java.io.IOException {
          Create result = new Create(name, content);
          initialize(result);
          return result;
        }

        public class Create extends IamRequest<com.google.api.services.iam.v1.model.ServiceAccountKey> {

          private static final String REST_PATH = "v1/{+name}/keys";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]*/serviceAccounts/[^/]*$");

          /**
           * Creates a ServiceAccountKey and returns it.
           *
           * Create a request for the method "keys.create".
           *
           * This request holds the parameters needed by the the iam server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The resource name of the service account in the following format:
         *        `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project
         *        will infer the project from the account. The `account` value can be the `email` address or
         *        the `unique_id` of the service account.
           * @param content the {@link com.google.api.services.iam.v1.model.CreateServiceAccountKeyRequest}
           * @since 1.13
           */
          protected Create(java.lang.String name, com.google.api.services.iam.v1.model.CreateServiceAccountKeyRequest content) {
            super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.ServiceAccountKey.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]*/serviceAccounts/[^/]*$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setBearerToken(java.lang.String bearerToken) {
            return (Create) super.setBearerToken(bearerToken);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPp(java.lang.Boolean pp) {
            return (Create) super.setPp(pp);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The resource name of the service account in the following format:
           * `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project
           * will infer the project from the account. The `account` value can be the `email` address
           * or the `unique_id` of the service account.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The resource name of the service account in the following format:
         `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project will infer
         the project from the account. The `account` value can be the `email` address or the `unique_id` of
         the service account.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The resource name of the service account in the following format:
           * `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project
           * will infer the project from the account. The `account` value can be the `email` address
           * or the `unique_id` of the service account.
           */
          public Create setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]*/serviceAccounts/[^/]*$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes a ServiceAccountKey.
         *
         * Create a request for the method "keys.delete".
         *
         * This request holds the parameters needed by the iam server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name The resource name of the service account key in the following format:
         *        `projects/{project}/serviceAccounts/{account}/keys/{key}`. Using `-` as a wildcard for the
         *        project will infer the project from the account. The `account` value can be the `email`
         *        address or the `unique_id` of the service account.
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends IamRequest<com.google.api.services.iam.v1.model.Empty> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]*/serviceAccounts/[^/]*/keys/[^/]*$");

          /**
           * Deletes a ServiceAccountKey.
           *
           * Create a request for the method "keys.delete".
           *
           * This request holds the parameters needed by the the iam server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The resource name of the service account key in the following format:
         *        `projects/{project}/serviceAccounts/{account}/keys/{key}`. Using `-` as a wildcard for the
         *        project will infer the project from the account. The `account` value can be the `email`
         *        address or the `unique_id` of the service account.
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(Iam.this, "DELETE", REST_PATH, null, com.google.api.services.iam.v1.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]*/serviceAccounts/[^/]*/keys/[^/]*$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setBearerToken(java.lang.String bearerToken) {
            return (Delete) super.setBearerToken(bearerToken);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPp(java.lang.Boolean pp) {
            return (Delete) super.setPp(pp);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The resource name of the service account key in the following format:
           * `projects/{project}/serviceAccounts/{account}/keys/{key}`. Using `-` as a wildcard for
           * the project will infer the project from the account. The `account` value can be the
           * `email` address or the `unique_id` of the service account.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The resource name of the service account key in the following format:
         `projects/{project}/serviceAccounts/{account}/keys/{key}`. Using `-` as a wildcard for the project
         will infer the project from the account. The `account` value can be the `email` address or the
         `unique_id` of the service account.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The resource name of the service account key in the following format:
           * `projects/{project}/serviceAccounts/{account}/keys/{key}`. Using `-` as a wildcard for
           * the project will infer the project from the account. The `account` value can be the
           * `email` address or the `unique_id` of the service account.
           */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]*/serviceAccounts/[^/]*/keys/[^/]*$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets the ServiceAccountKey by key id.
         *
         * Create a request for the method "keys.get".
         *
         * This request holds the parameters needed by the iam server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name The resource name of the service account key in the following format:
         *        `projects/{project}/serviceAccounts/{account}/keys/{key}`. Using `-` as a wildcard for the
         *        project will infer the project from the account. The `account` value can be the `email`
         *        address or the `unique_id` of the service account.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends IamRequest<com.google.api.services.iam.v1.model.ServiceAccountKey> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]*/serviceAccounts/[^/]*/keys/[^/]*$");

          /**
           * Gets the ServiceAccountKey by key id.
           *
           * Create a request for the method "keys.get".
           *
           * This request holds the parameters needed by the the iam server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
           * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The resource name of the service account key in the following format:
         *        `projects/{project}/serviceAccounts/{account}/keys/{key}`. Using `-` as a wildcard for the
         *        project will infer the project from the account. The `account` value can be the `email`
         *        address or the `unique_id` of the service account.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(Iam.this, "GET", REST_PATH, null, com.google.api.services.iam.v1.model.ServiceAccountKey.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]*/serviceAccounts/[^/]*/keys/[^/]*$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setBearerToken(java.lang.String bearerToken) {
            return (Get) super.setBearerToken(bearerToken);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPp(java.lang.Boolean pp) {
            return (Get) super.setPp(pp);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The resource name of the service account key in the following format:
           * `projects/{project}/serviceAccounts/{account}/keys/{key}`. Using `-` as a wildcard for
           * the project will infer the project from the account. The `account` value can be the
           * `email` address or the `unique_id` of the service account.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The resource name of the service account key in the following format:
         `projects/{project}/serviceAccounts/{account}/keys/{key}`. Using `-` as a wildcard for the project
         will infer the project from the account. The `account` value can be the `email` address or the
         `unique_id` of the service account.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The resource name of the service account key in the following format:
           * `projects/{project}/serviceAccounts/{account}/keys/{key}`. Using `-` as a wildcard for
           * the project will infer the project from the account. The `account` value can be the
           * `email` address or the `unique_id` of the service account.
           */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]*/serviceAccounts/[^/]*/keys/[^/]*$");
            }
            this.name = name;
            return this;
          }

          /**
           * The output format of the public key requested. X509_PEM is the default output format.
           */
          @com.google.api.client.util.Key
          private java.lang.String publicKeyType;

          /** The output format of the public key requested. X509_PEM is the default output format.
           */
          public java.lang.String getPublicKeyType() {
            return publicKeyType;
          }

          /**
           * The output format of the public key requested. X509_PEM is the default output format.
           */
          public Get setPublicKeyType(java.lang.String publicKeyType) {
            this.publicKeyType = publicKeyType;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists ServiceAccountKeys.
         *
         * Create a request for the method "keys.list".
         *
         * This request holds the parameters needed by the iam server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param name The resource name of the service account in the following format:
         *        `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project,
         *        will infer the project from the account. The `account` value can be the `email` address or
         *        the `unique_id` of the service account.
         * @return the request
         */
        public List list(java.lang.String name) throws java.io.IOException {
          List result = new List(name);
          initialize(result);
          return result;
        }

        public class List extends IamRequest<com.google.api.services.iam.v1.model.ListServiceAccountKeysResponse> {

          private static final String REST_PATH = "v1/{+name}/keys";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]*/serviceAccounts/[^/]*$");

          /**
           * Lists ServiceAccountKeys.
           *
           * Create a request for the method "keys.list".
           *
           * This request holds the parameters needed by the the iam server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
           * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The resource name of the service account in the following format:
         *        `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project,
         *        will infer the project from the account. The `account` value can be the `email` address or
         *        the `unique_id` of the service account.
           * @since 1.13
           */
          protected List(java.lang.String name) {
            super(Iam.this, "GET", REST_PATH, null, com.google.api.services.iam.v1.model.ListServiceAccountKeysResponse.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]*/serviceAccounts/[^/]*$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setBearerToken(java.lang.String bearerToken) {
            return (List) super.setBearerToken(bearerToken);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPp(java.lang.Boolean pp) {
            return (List) super.setPp(pp);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The resource name of the service account in the following format:
           * `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the
           * project, will infer the project from the account. The `account` value can be the
           * `email` address or the `unique_id` of the service account.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The resource name of the service account in the following format:
         `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the project, will infer
         the project from the account. The `account` value can be the `email` address or the `unique_id` of
         the service account.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The resource name of the service account in the following format:
           * `projects/{project}/serviceAccounts/{account}`. Using `-` as a wildcard for the
           * project, will infer the project from the account. The `account` value can be the
           * `email` address or the `unique_id` of the service account.
           */
          public List setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]*/serviceAccounts/[^/]*$");
            }
            this.name = name;
            return this;
          }

          /**
           * Filters the types of keys the user wants to include in the list response. Duplicate key
           * types are not allowed. If no key type is provided, all keys are returned.
           */
          @com.google.api.client.util.Key
          private java.util.List<java.lang.String> keyTypes;

          /** Filters the types of keys the user wants to include in the list response. Duplicate key types are
         not allowed. If no key type is provided, all keys are returned.
           */
          public java.util.List<java.lang.String> getKeyTypes() {
            return keyTypes;
          }

          /**
           * Filters the types of keys the user wants to include in the list response. Duplicate key
           * types are not allowed. If no key type is provided, all keys are returned.
           */
          public List setKeyTypes(java.util.List<java.lang.String> keyTypes) {
            this.keyTypes = keyTypes;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
    }
  }

  /**
   * An accessor for creating requests from the Roles collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Iam iam = new Iam(...);}
   *   {@code Iam.Roles.List request = iam.roles().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Roles roles() {
    return new Roles();
  }

  /**
   * The "roles" collection of methods.
   */
  public class Roles {

    /**
     * Queries roles that can be granted on a particular resource. A role is grantable if it can be used
     * as the role in a binding for a policy for that resource.
     *
     * Create a request for the method "roles.queryGrantableRoles".
     *
     * This request holds the parameters needed by the iam server.  After setting any optional
     * parameters, call the {@link QueryGrantableRoles#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.iam.v1.model.QueryGrantableRolesRequest}
     * @return the request
     */
    public QueryGrantableRoles queryGrantableRoles(com.google.api.services.iam.v1.model.QueryGrantableRolesRequest content) throws java.io.IOException {
      QueryGrantableRoles result = new QueryGrantableRoles(content);
      initialize(result);
      return result;
    }

    public class QueryGrantableRoles extends IamRequest<com.google.api.services.iam.v1.model.QueryGrantableRolesResponse> {

      private static final String REST_PATH = "v1/roles:queryGrantableRoles";

      /**
       * Queries roles that can be granted on a particular resource. A role is grantable if it can be
       * used as the role in a binding for a policy for that resource.
       *
       * Create a request for the method "roles.queryGrantableRoles".
       *
       * This request holds the parameters needed by the the iam server.  After setting any optional
       * parameters, call the {@link QueryGrantableRoles#execute()} method to invoke the remote
       * operation. <p> {@link QueryGrantableRoles#initialize(com.google.api.client.googleapis.services.
       * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.iam.v1.model.QueryGrantableRolesRequest}
       * @since 1.13
       */
      protected QueryGrantableRoles(com.google.api.services.iam.v1.model.QueryGrantableRolesRequest content) {
        super(Iam.this, "POST", REST_PATH, content, com.google.api.services.iam.v1.model.QueryGrantableRolesResponse.class);
      }

      @Override
      public QueryGrantableRoles set$Xgafv(java.lang.String $Xgafv) {
        return (QueryGrantableRoles) super.set$Xgafv($Xgafv);
      }

      @Override
      public QueryGrantableRoles setAccessToken(java.lang.String accessToken) {
        return (QueryGrantableRoles) super.setAccessToken(accessToken);
      }

      @Override
      public QueryGrantableRoles setAlt(java.lang.String alt) {
        return (QueryGrantableRoles) super.setAlt(alt);
      }

      @Override
      public QueryGrantableRoles setBearerToken(java.lang.String bearerToken) {
        return (QueryGrantableRoles) super.setBearerToken(bearerToken);
      }

      @Override
      public QueryGrantableRoles setCallback(java.lang.String callback) {
        return (QueryGrantableRoles) super.setCallback(callback);
      }

      @Override
      public QueryGrantableRoles setFields(java.lang.String fields) {
        return (QueryGrantableRoles) super.setFields(fields);
      }

      @Override
      public QueryGrantableRoles setKey(java.lang.String key) {
        return (QueryGrantableRoles) super.setKey(key);
      }

      @Override
      public QueryGrantableRoles setOauthToken(java.lang.String oauthToken) {
        return (QueryGrantableRoles) super.setOauthToken(oauthToken);
      }

      @Override
      public QueryGrantableRoles setPp(java.lang.Boolean pp) {
        return (QueryGrantableRoles) super.setPp(pp);
      }

      @Override
      public QueryGrantableRoles setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (QueryGrantableRoles) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public QueryGrantableRoles setQuotaUser(java.lang.String quotaUser) {
        return (QueryGrantableRoles) super.setQuotaUser(quotaUser);
      }

      @Override
      public QueryGrantableRoles setUploadType(java.lang.String uploadType) {
        return (QueryGrantableRoles) super.setUploadType(uploadType);
      }

      @Override
      public QueryGrantableRoles setUploadProtocol(java.lang.String uploadProtocol) {
        return (QueryGrantableRoles) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public QueryGrantableRoles set(String parameterName, Object value) {
        return (QueryGrantableRoles) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Iam}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Iam}. */
    @Override
    public Iam build() {
      return new Iam(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link IamRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setIamRequestInitializer(
        IamRequestInitializer iamRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(iamRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
