/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-09-22 at 02:06:32 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.iam.v1.model;

/**
 * A role in the Identity and Access Management API.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity and Access Management (IAM) API. For
 * a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Role extends com.google.api.client.json.GenericJson {

  /**
   * Optional. A human-readable description for the role.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The name of the role. When Role is used in CreateRole, the role name must not be set. When Role
   * is used in output and other input such as UpdateRole, the role name is the complete path, e.g.,
   * roles/logging.viewer for curated roles and organizations/{organization-id}/roles/logging.viewer
   * for custom roles.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Optional. A human-readable title for the role. Typically this is limited to 100 UTF-8 bytes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * Optional. A human-readable description for the role.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Optional. A human-readable description for the role.
   * @param description description or {@code null} for none
   */
  public Role setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The name of the role. When Role is used in CreateRole, the role name must not be set. When Role
   * is used in output and other input such as UpdateRole, the role name is the complete path, e.g.,
   * roles/logging.viewer for curated roles and organizations/{organization-id}/roles/logging.viewer
   * for custom roles.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the role. When Role is used in CreateRole, the role name must not be set. When Role
   * is used in output and other input such as UpdateRole, the role name is the complete path, e.g.,
   * roles/logging.viewer for curated roles and organizations/{organization-id}/roles/logging.viewer
   * for custom roles.
   * @param name name or {@code null} for none
   */
  public Role setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Optional. A human-readable title for the role. Typically this is limited to 100 UTF-8 bytes.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Optional. A human-readable title for the role. Typically this is limited to 100 UTF-8 bytes.
   * @param title title or {@code null} for none
   */
  public Role setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public Role set(String fieldName, Object value) {
    return (Role) super.set(fieldName, value);
  }

  @Override
  public Role clone() {
    return (Role) super.clone();
  }

}
