/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iam.v2.model;

/**
 * The difference delta between two policies.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleIamV1PolicyDelta extends com.google.api.client.json.GenericJson {

  /**
   * The delta for Bindings between two policies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GoogleIamV1BindingDelta> bindingDeltas;

  static {
    // hack to force ProGuard to consider GoogleIamV1BindingDelta used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GoogleIamV1BindingDelta.class);
  }

  /**
   * The delta for Bindings between two policies.
   * @return value or {@code null} for none
   */
  public java.util.List<GoogleIamV1BindingDelta> getBindingDeltas() {
    return bindingDeltas;
  }

  /**
   * The delta for Bindings between two policies.
   * @param bindingDeltas bindingDeltas or {@code null} for none
   */
  public GoogleIamV1PolicyDelta setBindingDeltas(java.util.List<GoogleIamV1BindingDelta> bindingDeltas) {
    this.bindingDeltas = bindingDeltas;
    return this;
  }

  @Override
  public GoogleIamV1PolicyDelta set(String fieldName, Object value) {
    return (GoogleIamV1PolicyDelta) super.set(fieldName, value);
  }

  @Override
  public GoogleIamV1PolicyDelta clone() {
    return (GoogleIamV1PolicyDelta) super.clone();
  }

}
