/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iam.v2.model;

/**
 * Response message for `ListPolicies`.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleIamV2ListPoliciesResponse extends com.google.api.client.json.GenericJson {

  /**
   * A page token that you can use in a ListPoliciesRequest to retrieve the next page. If this field
   * is omitted, there are no additional pages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Metadata for the policies that are attached to the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GoogleIamV2Policy> policies;

  /**
   * A page token that you can use in a ListPoliciesRequest to retrieve the next page. If this field
   * is omitted, there are no additional pages.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A page token that you can use in a ListPoliciesRequest to retrieve the next page. If this field
   * is omitted, there are no additional pages.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public GoogleIamV2ListPoliciesResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * Metadata for the policies that are attached to the resource.
   * @return value or {@code null} for none
   */
  public java.util.List<GoogleIamV2Policy> getPolicies() {
    return policies;
  }

  /**
   * Metadata for the policies that are attached to the resource.
   * @param policies policies or {@code null} for none
   */
  public GoogleIamV2ListPoliciesResponse setPolicies(java.util.List<GoogleIamV2Policy> policies) {
    this.policies = policies;
    return this;
  }

  @Override
  public GoogleIamV2ListPoliciesResponse set(String fieldName, Object value) {
    return (GoogleIamV2ListPoliciesResponse) super.set(fieldName, value);
  }

  @Override
  public GoogleIamV2ListPoliciesResponse clone() {
    return (GoogleIamV2ListPoliciesResponse) super.clone();
  }

}
