/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iam.v2.model;

/**
 * A single rule in a `Policy`.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Identity and Access Management (IAM) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleIamV2PolicyRule extends com.google.api.client.json.GenericJson {

  /**
   * A rule for a deny policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleIamV2DenyRule denyRule;

  /**
   * A user-specified description of the rule. This value can be up to 256 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * A rule for a deny policy.
   * @return value or {@code null} for none
   */
  public GoogleIamV2DenyRule getDenyRule() {
    return denyRule;
  }

  /**
   * A rule for a deny policy.
   * @param denyRule denyRule or {@code null} for none
   */
  public GoogleIamV2PolicyRule setDenyRule(GoogleIamV2DenyRule denyRule) {
    this.denyRule = denyRule;
    return this;
  }

  /**
   * A user-specified description of the rule. This value can be up to 256 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A user-specified description of the rule. This value can be up to 256 characters.
   * @param description description or {@code null} for none
   */
  public GoogleIamV2PolicyRule setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  @Override
  public GoogleIamV2PolicyRule set(String fieldName, Object value) {
    return (GoogleIamV2PolicyRule) super.set(fieldName, value);
  }

  @Override
  public GoogleIamV2PolicyRule clone() {
    return (GoogleIamV2PolicyRule) super.clone();
  }

}
