/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.iam.v2;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.iam.v2.IamRequest;
import com.google.api.services.iam.v2.IamRequestInitializer;
import com.google.api.services.iam.v2.model.GoogleIamV2ListPoliciesResponse;
import com.google.api.services.iam.v2.model.GoogleIamV2Policy;
import com.google.api.services.iam.v2.model.GoogleLongrunningOperation;
import java.io.IOException;
import java.util.regex.Pattern;

public class Iam
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://iam.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://iam.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://iam.googleapis.com/";

    public Iam(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Iam(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Policies policies() {
        return new Policies();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Identity and Access Management (IAM) API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Iam.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://iam.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Iam.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Iam.DEFAULT_BATCH_PATH);
        }

        public Iam build() {
            return new Iam(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setIamRequestInitializer(IamRequestInitializer iamRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)iamRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Policies {
        public CreatePolicy createPolicy(String parent, GoogleIamV2Policy content) throws IOException {
            CreatePolicy result = new CreatePolicy(parent, content);
            Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListPolicies listPolicies(String parent) throws IOException {
            ListPolicies result = new ListPolicies(parent);
            Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String name, GoogleIamV2Policy content) throws IOException {
            Update result = new Update(name, content);
            Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Operations operations() {
            return new Operations();
        }

        public class Operations {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Get
            extends IamRequest<GoogleLongrunningOperation> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Iam.this, "GET", REST_PATH, null, GoogleLongrunningOperation.class);
                    this.NAME_PATTERN = Pattern.compile("^policies/[^/]+/[^/]+/[^/]+/operations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^policies/[^/]+/[^/]+/[^/]+/operations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^policies/[^/]+/[^/]+/[^/]+/operations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Update
        extends IamRequest<GoogleLongrunningOperation> {
            private static final String REST_PATH = "v2/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Update(String name, GoogleIamV2Policy content) {
                super(Iam.this, "PUT", REST_PATH, (Object)content, GoogleLongrunningOperation.class);
                this.NAME_PATTERN = Pattern.compile("^policies/[^/]+/[^/]+/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Iam.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^policies/[^/]+/[^/]+/[^/]+$");
                }
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Update setName(String name) {
                if (!Iam.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^policies/[^/]+/[^/]+/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class ListPolicies
        extends IamRequest<GoogleIamV2ListPoliciesResponse> {
            private static final String REST_PATH = "v2/{+parent}";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected ListPolicies(String parent) {
                super(Iam.this, "GET", REST_PATH, null, GoogleIamV2ListPoliciesResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^policies/[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!Iam.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^policies/[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListPolicies set$Xgafv(String $Xgafv) {
                return (ListPolicies)super.set$Xgafv($Xgafv);
            }

            public ListPolicies setAccessToken(String accessToken) {
                return (ListPolicies)super.setAccessToken(accessToken);
            }

            public ListPolicies setAlt(String alt) {
                return (ListPolicies)super.setAlt(alt);
            }

            public ListPolicies setCallback(String callback) {
                return (ListPolicies)super.setCallback(callback);
            }

            public ListPolicies setFields(String fields) {
                return (ListPolicies)super.setFields(fields);
            }

            public ListPolicies setKey(String key) {
                return (ListPolicies)super.setKey(key);
            }

            public ListPolicies setOauthToken(String oauthToken) {
                return (ListPolicies)super.setOauthToken(oauthToken);
            }

            public ListPolicies setPrettyPrint(Boolean prettyPrint) {
                return (ListPolicies)super.setPrettyPrint(prettyPrint);
            }

            public ListPolicies setQuotaUser(String quotaUser) {
                return (ListPolicies)super.setQuotaUser(quotaUser);
            }

            public ListPolicies setUploadType(String uploadType) {
                return (ListPolicies)super.setUploadType(uploadType);
            }

            public ListPolicies setUploadProtocol(String uploadProtocol) {
                return (ListPolicies)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public ListPolicies setParent(String parent) {
                if (!Iam.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^policies/[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public ListPolicies setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListPolicies setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public ListPolicies set(String parameterName, Object value) {
                return (ListPolicies)super.set(parameterName, value);
            }
        }

        public class Get
        extends IamRequest<GoogleIamV2Policy> {
            private static final String REST_PATH = "v2/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(Iam.this, "GET", REST_PATH, null, GoogleIamV2Policy.class);
                this.NAME_PATTERN = Pattern.compile("^policies/[^/]+/[^/]+/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Iam.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^policies/[^/]+/[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!Iam.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^policies/[^/]+/[^/]+/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends IamRequest<GoogleLongrunningOperation> {
            private static final String REST_PATH = "v2/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String etag;

            protected Delete(String name) {
                super(Iam.this, "DELETE", REST_PATH, null, GoogleLongrunningOperation.class);
                this.NAME_PATTERN = Pattern.compile("^policies/[^/]+/[^/]+/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Iam.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^policies/[^/]+/[^/]+/[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                if (!Iam.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^policies/[^/]+/[^/]+/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getEtag() {
                return this.etag;
            }

            public Delete setEtag(String etag) {
                this.etag = etag;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class CreatePolicy
        extends IamRequest<GoogleLongrunningOperation> {
            private static final String REST_PATH = "v2/{+parent}";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private String policyId;

            protected CreatePolicy(String parent, GoogleIamV2Policy content) {
                super(Iam.this, "POST", REST_PATH, (Object)content, GoogleLongrunningOperation.class);
                this.PARENT_PATTERN = Pattern.compile("^policies/[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!Iam.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^policies/[^/]+/[^/]+$");
                }
            }

            public CreatePolicy set$Xgafv(String $Xgafv) {
                return (CreatePolicy)super.set$Xgafv($Xgafv);
            }

            public CreatePolicy setAccessToken(String accessToken) {
                return (CreatePolicy)super.setAccessToken(accessToken);
            }

            public CreatePolicy setAlt(String alt) {
                return (CreatePolicy)super.setAlt(alt);
            }

            public CreatePolicy setCallback(String callback) {
                return (CreatePolicy)super.setCallback(callback);
            }

            public CreatePolicy setFields(String fields) {
                return (CreatePolicy)super.setFields(fields);
            }

            public CreatePolicy setKey(String key) {
                return (CreatePolicy)super.setKey(key);
            }

            public CreatePolicy setOauthToken(String oauthToken) {
                return (CreatePolicy)super.setOauthToken(oauthToken);
            }

            public CreatePolicy setPrettyPrint(Boolean prettyPrint) {
                return (CreatePolicy)super.setPrettyPrint(prettyPrint);
            }

            public CreatePolicy setQuotaUser(String quotaUser) {
                return (CreatePolicy)super.setQuotaUser(quotaUser);
            }

            public CreatePolicy setUploadType(String uploadType) {
                return (CreatePolicy)super.setUploadType(uploadType);
            }

            public CreatePolicy setUploadProtocol(String uploadProtocol) {
                return (CreatePolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public CreatePolicy setParent(String parent) {
                if (!Iam.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^policies/[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public String getPolicyId() {
                return this.policyId;
            }

            public CreatePolicy setPolicyId(String policyId) {
                this.policyId = policyId;
                return this;
            }

            @Override
            public CreatePolicy set(String parameterName, Object value) {
                return (CreatePolicy)super.set(parameterName, value);
            }
        }
    }
}

