/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iamcredentials.v1.model;

/**
 * Model definition for GenerateAccessTokenRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the IAM Service Account Credentials API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GenerateAccessTokenRequest extends com.google.api.client.json.GenericJson {

  /**
   * The sequence of service accounts in a delegation chain. Each service account must be granted
   * the `roles/iam.serviceAccountTokenCreator` role on its next service account in the chain. The
   * last service account in the chain must be granted the `roles/iam.serviceAccountTokenCreator`
   * role on the service account that is specified in the `name` field of the request. The delegates
   * must have the following format: `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The
   * `-` wildcard character is required; replacing it with a project ID is invalid.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> delegates;

  /**
   * The desired lifetime duration of the access token in seconds. Must be set to a value less than
   * or equal to 3600 (1 hour). If a value is not specified, the token's lifetime will be set to a
   * default value of one hour.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String lifetime;

  /**
   * Required. Code to identify the scopes to be included in the OAuth 2.0 access token. See
   * https://developers.google.com/identity/protocols/googlescopes for more information. At least
   * one value required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> scope;

  /**
   * The sequence of service accounts in a delegation chain. Each service account must be granted
   * the `roles/iam.serviceAccountTokenCreator` role on its next service account in the chain. The
   * last service account in the chain must be granted the `roles/iam.serviceAccountTokenCreator`
   * role on the service account that is specified in the `name` field of the request. The delegates
   * must have the following format: `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The
   * `-` wildcard character is required; replacing it with a project ID is invalid.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDelegates() {
    return delegates;
  }

  /**
   * The sequence of service accounts in a delegation chain. Each service account must be granted
   * the `roles/iam.serviceAccountTokenCreator` role on its next service account in the chain. The
   * last service account in the chain must be granted the `roles/iam.serviceAccountTokenCreator`
   * role on the service account that is specified in the `name` field of the request. The delegates
   * must have the following format: `projects/-/serviceAccounts/{ACCOUNT_EMAIL_OR_UNIQUEID}`. The
   * `-` wildcard character is required; replacing it with a project ID is invalid.
   * @param delegates delegates or {@code null} for none
   */
  public GenerateAccessTokenRequest setDelegates(java.util.List<java.lang.String> delegates) {
    this.delegates = delegates;
    return this;
  }

  /**
   * The desired lifetime duration of the access token in seconds. Must be set to a value less than
   * or equal to 3600 (1 hour). If a value is not specified, the token's lifetime will be set to a
   * default value of one hour.
   * @return value or {@code null} for none
   */
  public String getLifetime() {
    return lifetime;
  }

  /**
   * The desired lifetime duration of the access token in seconds. Must be set to a value less than
   * or equal to 3600 (1 hour). If a value is not specified, the token's lifetime will be set to a
   * default value of one hour.
   * @param lifetime lifetime or {@code null} for none
   */
  public GenerateAccessTokenRequest setLifetime(String lifetime) {
    this.lifetime = lifetime;
    return this;
  }

  /**
   * Required. Code to identify the scopes to be included in the OAuth 2.0 access token. See
   * https://developers.google.com/identity/protocols/googlescopes for more information. At least
   * one value required.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getScope() {
    return scope;
  }

  /**
   * Required. Code to identify the scopes to be included in the OAuth 2.0 access token. See
   * https://developers.google.com/identity/protocols/googlescopes for more information. At least
   * one value required.
   * @param scope scope or {@code null} for none
   */
  public GenerateAccessTokenRequest setScope(java.util.List<java.lang.String> scope) {
    this.scope = scope;
    return this;
  }

  @Override
  public GenerateAccessTokenRequest set(String fieldName, Object value) {
    return (GenerateAccessTokenRequest) super.set(fieldName, value);
  }

  @Override
  public GenerateAccessTokenRequest clone() {
    return (GenerateAccessTokenRequest) super.clone();
  }

}
