/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iamcredentials.v1.model;

/**
 * Represents a list of allowed locations for given service account.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the IAM Service Account Credentials API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ServiceAccountAllowedLocations extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The hex encoded bitmap of the trust boundary locations
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String encodedLocations;

  /**
   * Output only. The human readable trust boundary locations. For example, ["us-central1", "europe-
   * west1"]
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> locations;

  /**
   * Output only. The hex encoded bitmap of the trust boundary locations
   * @return value or {@code null} for none
   */
  public java.lang.String getEncodedLocations() {
    return encodedLocations;
  }

  /**
   * Output only. The hex encoded bitmap of the trust boundary locations
   * @param encodedLocations encodedLocations or {@code null} for none
   */
  public ServiceAccountAllowedLocations setEncodedLocations(java.lang.String encodedLocations) {
    this.encodedLocations = encodedLocations;
    return this;
  }

  /**
   * Output only. The human readable trust boundary locations. For example, ["us-central1", "europe-
   * west1"]
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLocations() {
    return locations;
  }

  /**
   * Output only. The human readable trust boundary locations. For example, ["us-central1", "europe-
   * west1"]
   * @param locations locations or {@code null} for none
   */
  public ServiceAccountAllowedLocations setLocations(java.util.List<java.lang.String> locations) {
    this.locations = locations;
    return this;
  }

  @Override
  public ServiceAccountAllowedLocations set(String fieldName, Object value) {
    return (ServiceAccountAllowedLocations) super.set(fieldName, value);
  }

  @Override
  public ServiceAccountAllowedLocations clone() {
    return (ServiceAccountAllowedLocations) super.clone();
  }

}
