/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.kgsearch.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.kgsearch.v1.KgsearchRequest;
import com.google.api.services.kgsearch.v1.KgsearchRequestInitializer;
import com.google.api.services.kgsearch.v1.model.SearchResponse;
import java.io.IOException;
import java.util.List;

public class Kgsearch
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://kgsearch.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://kgsearch.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://kgsearch.googleapis.com/";

    public Kgsearch(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Kgsearch(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Entities entities() {
        return new Entities();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.31.0 of the Knowledge Graph Search API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Kgsearch.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://kgsearch.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Kgsearch.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Kgsearch.DEFAULT_BATCH_PATH);
        }

        public Kgsearch build() {
            return new Kgsearch(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setKgsearchRequestInitializer(KgsearchRequestInitializer kgsearchRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)kgsearchRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Entities {
        public Search search() throws IOException {
            Search result = new Search();
            Kgsearch.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Search
        extends KgsearchRequest<SearchResponse> {
            private static final String REST_PATH = "v1/entities:search";
            @Key
            private List<String> ids;
            @Key
            private Boolean indent;
            @Key
            private List<String> languages;
            @Key
            private Integer limit;
            @Key
            private Boolean prefix;
            @Key
            private String query;
            @Key
            private List<String> types;

            protected Search() {
                super(Kgsearch.this, "GET", REST_PATH, null, SearchResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Search set$Xgafv(String $Xgafv) {
                return (Search)super.set$Xgafv($Xgafv);
            }

            public Search setAccessToken(String accessToken) {
                return (Search)super.setAccessToken(accessToken);
            }

            public Search setAlt(String alt) {
                return (Search)super.setAlt(alt);
            }

            public Search setCallback(String callback) {
                return (Search)super.setCallback(callback);
            }

            public Search setFields(String fields) {
                return (Search)super.setFields(fields);
            }

            public Search setKey(String key) {
                return (Search)super.setKey(key);
            }

            public Search setOauthToken(String oauthToken) {
                return (Search)super.setOauthToken(oauthToken);
            }

            public Search setPrettyPrint(Boolean prettyPrint) {
                return (Search)super.setPrettyPrint(prettyPrint);
            }

            public Search setQuotaUser(String quotaUser) {
                return (Search)super.setQuotaUser(quotaUser);
            }

            public Search setUploadType(String uploadType) {
                return (Search)super.setUploadType(uploadType);
            }

            public Search setUploadProtocol(String uploadProtocol) {
                return (Search)super.setUploadProtocol(uploadProtocol);
            }

            public List<String> getIds() {
                return this.ids;
            }

            public Search setIds(List<String> ids) {
                this.ids = ids;
                return this;
            }

            public Boolean getIndent() {
                return this.indent;
            }

            public Search setIndent(Boolean indent) {
                this.indent = indent;
                return this;
            }

            public List<String> getLanguages() {
                return this.languages;
            }

            public Search setLanguages(List<String> languages) {
                this.languages = languages;
                return this;
            }

            public Integer getLimit() {
                return this.limit;
            }

            public Search setLimit(Integer limit) {
                this.limit = limit;
                return this;
            }

            public Boolean getPrefix() {
                return this.prefix;
            }

            public Search setPrefix(Boolean prefix) {
                this.prefix = prefix;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public Search setQuery(String query) {
                this.query = query;
                return this;
            }

            public List<String> getTypes() {
                return this.types;
            }

            public Search setTypes(List<String> types) {
                this.types = types;
                return this;
            }

            @Override
            public Search set(String parameterName, Object value) {
                return (Search)super.set(parameterName, value);
            }
        }
    }
}

