/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.logging;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.logging.LoggingRequest;
import com.google.api.services.logging.LoggingRequestInitializer;
import com.google.api.services.logging.model.Empty;
import com.google.api.services.logging.model.ListLogServiceIndexesResponse;
import com.google.api.services.logging.model.ListLogServiceSinksResponse;
import com.google.api.services.logging.model.ListLogServicesResponse;
import com.google.api.services.logging.model.ListLogSinksResponse;
import com.google.api.services.logging.model.ListLogsResponse;
import com.google.api.services.logging.model.ListSinksResponse;
import com.google.api.services.logging.model.LogSink;
import com.google.api.services.logging.model.WriteLogEntriesRequest;
import com.google.api.services.logging.model.WriteLogEntriesResponse;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logging
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://logging.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BASE_URL = "https://logging.googleapis.com/";

    public Logging(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Logging(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.20.0 of the Google Cloud Logging API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://logging.googleapis.com/", Logging.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Logging build() {
            return new Logging(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setLoggingRequestInitializer(LoggingRequestInitializer loggingRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)loggingRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public LogServices logServices() {
            return new LogServices();
        }

        public Logs logs() {
            return new Logs();
        }

        public Sinks sinks() {
            return new Sinks();
        }

        public class Sinks {
            public Create create(String string, LogSink logSink) throws IOException {
                Create create = new Create(string, logSink);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Update update(String string, String string2, LogSink logSink) throws IOException {
                Update update = new Update(string, string2, logSink);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v1beta3/projects/{projectsId}/sinks/{sinksId}";
                @Key
                private String projectsId;
                @Key
                private String sinksId;

                protected Update(String string, String string2, LogSink logSink) {
                    super(Logging.this, "PUT", REST_PATH, (Object)logSink, LogSink.class);
                    this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                    this.sinksId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter sinksId must be specified.");
                }

                public Update set$Xgafv(String string) {
                    return (Update)super.set$Xgafv(string);
                }

                public Update setAccessToken(String string) {
                    return (Update)super.setAccessToken(string);
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setBearerToken(String string) {
                    return (Update)super.setBearerToken(string);
                }

                public Update setCallback(String string) {
                    return (Update)super.setCallback(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPp(Boolean bl) {
                    return (Update)super.setPp(bl);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUploadType(String string) {
                    return (Update)super.setUploadType(string);
                }

                public Update setUploadProtocol(String string) {
                    return (Update)super.setUploadProtocol(string);
                }

                public String getProjectsId() {
                    return this.projectsId;
                }

                public Update setProjectsId(String string) {
                    this.projectsId = string;
                    return this;
                }

                public String getSinksId() {
                    return this.sinksId;
                }

                public Update setSinksId(String string) {
                    this.sinksId = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends LoggingRequest<ListSinksResponse> {
                private static final String REST_PATH = "v1beta3/projects/{projectsId}/sinks";
                @Key
                private String projectsId;

                protected List(String string) {
                    super(Logging.this, "GET", REST_PATH, null, ListSinksResponse.class);
                    this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getProjectsId() {
                    return this.projectsId;
                }

                public List setProjectsId(String string) {
                    this.projectsId = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v1beta3/projects/{projectsId}/sinks/{sinksId}";
                @Key
                private String projectsId;
                @Key
                private String sinksId;

                protected Get(String string, String string2) {
                    super(Logging.this, "GET", REST_PATH, null, LogSink.class);
                    this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                    this.sinksId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter sinksId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getProjectsId() {
                    return this.projectsId;
                }

                public Get setProjectsId(String string) {
                    this.projectsId = string;
                    return this;
                }

                public String getSinksId() {
                    return this.sinksId;
                }

                public Get setSinksId(String string) {
                    this.sinksId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v1beta3/projects/{projectsId}/sinks/{sinksId}";
                @Key
                private String projectsId;
                @Key
                private String sinksId;

                protected Delete(String string, String string2) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                    this.sinksId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter sinksId must be specified.");
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getProjectsId() {
                    return this.projectsId;
                }

                public Delete setProjectsId(String string) {
                    this.projectsId = string;
                    return this;
                }

                public String getSinksId() {
                    return this.sinksId;
                }

                public Delete setSinksId(String string) {
                    this.sinksId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v1beta3/projects/{projectsId}/sinks";
                @Key
                private String projectsId;

                protected Create(String string, LogSink logSink) {
                    super(Logging.this, "POST", REST_PATH, (Object)logSink, LogSink.class);
                    this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getProjectsId() {
                    return this.projectsId;
                }

                public Create setProjectsId(String string) {
                    this.projectsId = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        public class Logs {
            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Entries entries() {
                return new Entries();
            }

            public Sinks sinks() {
                return new Sinks();
            }

            public class Sinks {
                public Create create(String string, String string2, LogSink logSink) throws IOException {
                    Create create = new Create(string, string2, logSink);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string, String string2, String string3) throws IOException {
                    Delete delete = new Delete(string, string2, string3);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string, String string2, String string3) throws IOException {
                    Get get = new Get(string, string2, string3);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string, String string2) throws IOException {
                    List list = new List(string, string2);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Update update(String string, String string2, String string3, LogSink logSink) throws IOException {
                    Update update = new Update(string, string2, string3, logSink);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)update);
                    return update;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Update
                extends LoggingRequest<LogSink> {
                    private static final String REST_PATH = "v1beta3/projects/{projectsId}/logs/{logsId}/sinks/{sinksId}";
                    @Key
                    private String projectsId;
                    @Key
                    private String logsId;
                    @Key
                    private String sinksId;

                    protected Update(String string, String string2, String string3, LogSink logSink) {
                        super(Logging.this, "PUT", REST_PATH, (Object)logSink, LogSink.class);
                        this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                        this.logsId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter logsId must be specified.");
                        this.sinksId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter sinksId must be specified.");
                    }

                    public Update set$Xgafv(String string) {
                        return (Update)super.set$Xgafv(string);
                    }

                    public Update setAccessToken(String string) {
                        return (Update)super.setAccessToken(string);
                    }

                    public Update setAlt(String string) {
                        return (Update)super.setAlt(string);
                    }

                    public Update setBearerToken(String string) {
                        return (Update)super.setBearerToken(string);
                    }

                    public Update setCallback(String string) {
                        return (Update)super.setCallback(string);
                    }

                    public Update setFields(String string) {
                        return (Update)super.setFields(string);
                    }

                    public Update setKey(String string) {
                        return (Update)super.setKey(string);
                    }

                    public Update setOauthToken(String string) {
                        return (Update)super.setOauthToken(string);
                    }

                    public Update setPp(Boolean bl) {
                        return (Update)super.setPp(bl);
                    }

                    public Update setPrettyPrint(Boolean bl) {
                        return (Update)super.setPrettyPrint(bl);
                    }

                    public Update setQuotaUser(String string) {
                        return (Update)super.setQuotaUser(string);
                    }

                    public Update setUploadType(String string) {
                        return (Update)super.setUploadType(string);
                    }

                    public Update setUploadProtocol(String string) {
                        return (Update)super.setUploadProtocol(string);
                    }

                    public String getProjectsId() {
                        return this.projectsId;
                    }

                    public Update setProjectsId(String string) {
                        this.projectsId = string;
                        return this;
                    }

                    public String getLogsId() {
                        return this.logsId;
                    }

                    public Update setLogsId(String string) {
                        this.logsId = string;
                        return this;
                    }

                    public String getSinksId() {
                        return this.sinksId;
                    }

                    public Update setSinksId(String string) {
                        this.sinksId = string;
                        return this;
                    }

                    @Override
                    public Update set(String string, Object object) {
                        return (Update)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends LoggingRequest<ListLogSinksResponse> {
                    private static final String REST_PATH = "v1beta3/projects/{projectsId}/logs/{logsId}/sinks";
                    @Key
                    private String projectsId;
                    @Key
                    private String logsId;

                    protected List(String string, String string2) {
                        super(Logging.this, "GET", REST_PATH, null, ListLogSinksResponse.class);
                        this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                        this.logsId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter logsId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setBearerToken(String string) {
                        return (List)super.setBearerToken(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPp(Boolean bl) {
                        return (List)super.setPp(bl);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getProjectsId() {
                        return this.projectsId;
                    }

                    public List setProjectsId(String string) {
                        this.projectsId = string;
                        return this;
                    }

                    public String getLogsId() {
                        return this.logsId;
                    }

                    public List setLogsId(String string) {
                        this.logsId = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends LoggingRequest<LogSink> {
                    private static final String REST_PATH = "v1beta3/projects/{projectsId}/logs/{logsId}/sinks/{sinksId}";
                    @Key
                    private String projectsId;
                    @Key
                    private String logsId;
                    @Key
                    private String sinksId;

                    protected Get(String string, String string2, String string3) {
                        super(Logging.this, "GET", REST_PATH, null, LogSink.class);
                        this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                        this.logsId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter logsId must be specified.");
                        this.sinksId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter sinksId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setBearerToken(String string) {
                        return (Get)super.setBearerToken(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPp(Boolean bl) {
                        return (Get)super.setPp(bl);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getProjectsId() {
                        return this.projectsId;
                    }

                    public Get setProjectsId(String string) {
                        this.projectsId = string;
                        return this;
                    }

                    public String getLogsId() {
                        return this.logsId;
                    }

                    public Get setLogsId(String string) {
                        this.logsId = string;
                        return this;
                    }

                    public String getSinksId() {
                        return this.sinksId;
                    }

                    public Get setSinksId(String string) {
                        this.sinksId = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends LoggingRequest<Empty> {
                    private static final String REST_PATH = "v1beta3/projects/{projectsId}/logs/{logsId}/sinks/{sinksId}";
                    @Key
                    private String projectsId;
                    @Key
                    private String logsId;
                    @Key
                    private String sinksId;

                    protected Delete(String string, String string2, String string3) {
                        super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                        this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                        this.logsId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter logsId must be specified.");
                        this.sinksId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter sinksId must be specified.");
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setBearerToken(String string) {
                        return (Delete)super.setBearerToken(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPp(Boolean bl) {
                        return (Delete)super.setPp(bl);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getProjectsId() {
                        return this.projectsId;
                    }

                    public Delete setProjectsId(String string) {
                        this.projectsId = string;
                        return this;
                    }

                    public String getLogsId() {
                        return this.logsId;
                    }

                    public Delete setLogsId(String string) {
                        this.logsId = string;
                        return this;
                    }

                    public String getSinksId() {
                        return this.sinksId;
                    }

                    public Delete setSinksId(String string) {
                        this.sinksId = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends LoggingRequest<LogSink> {
                    private static final String REST_PATH = "v1beta3/projects/{projectsId}/logs/{logsId}/sinks";
                    @Key
                    private String projectsId;
                    @Key
                    private String logsId;

                    protected Create(String string, String string2, LogSink logSink) {
                        super(Logging.this, "POST", REST_PATH, (Object)logSink, LogSink.class);
                        this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                        this.logsId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter logsId must be specified.");
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setBearerToken(String string) {
                        return (Create)super.setBearerToken(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPp(Boolean bl) {
                        return (Create)super.setPp(bl);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getProjectsId() {
                        return this.projectsId;
                    }

                    public Create setProjectsId(String string) {
                        this.projectsId = string;
                        return this;
                    }

                    public String getLogsId() {
                        return this.logsId;
                    }

                    public Create setLogsId(String string) {
                        this.logsId = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }
            }

            public class Entries {
                public Write write(String string, String string2, WriteLogEntriesRequest writeLogEntriesRequest) throws IOException {
                    Write write = new Write(string, string2, writeLogEntriesRequest);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)write);
                    return write;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Write
                extends LoggingRequest<WriteLogEntriesResponse> {
                    private static final String REST_PATH = "v1beta3/projects/{projectsId}/logs/{logsId}/entries:write";
                    @Key
                    private String projectsId;
                    @Key
                    private String logsId;

                    protected Write(String string, String string2, WriteLogEntriesRequest writeLogEntriesRequest) {
                        super(Logging.this, "POST", REST_PATH, (Object)writeLogEntriesRequest, WriteLogEntriesResponse.class);
                        this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                        this.logsId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter logsId must be specified.");
                    }

                    public Write set$Xgafv(String string) {
                        return (Write)super.set$Xgafv(string);
                    }

                    public Write setAccessToken(String string) {
                        return (Write)super.setAccessToken(string);
                    }

                    public Write setAlt(String string) {
                        return (Write)super.setAlt(string);
                    }

                    public Write setBearerToken(String string) {
                        return (Write)super.setBearerToken(string);
                    }

                    public Write setCallback(String string) {
                        return (Write)super.setCallback(string);
                    }

                    public Write setFields(String string) {
                        return (Write)super.setFields(string);
                    }

                    public Write setKey(String string) {
                        return (Write)super.setKey(string);
                    }

                    public Write setOauthToken(String string) {
                        return (Write)super.setOauthToken(string);
                    }

                    public Write setPp(Boolean bl) {
                        return (Write)super.setPp(bl);
                    }

                    public Write setPrettyPrint(Boolean bl) {
                        return (Write)super.setPrettyPrint(bl);
                    }

                    public Write setQuotaUser(String string) {
                        return (Write)super.setQuotaUser(string);
                    }

                    public Write setUploadType(String string) {
                        return (Write)super.setUploadType(string);
                    }

                    public Write setUploadProtocol(String string) {
                        return (Write)super.setUploadProtocol(string);
                    }

                    public String getProjectsId() {
                        return this.projectsId;
                    }

                    public Write setProjectsId(String string) {
                        this.projectsId = string;
                        return this;
                    }

                    public String getLogsId() {
                        return this.logsId;
                    }

                    public Write setLogsId(String string) {
                        this.logsId = string;
                        return this;
                    }

                    @Override
                    public Write set(String string, Object object) {
                        return (Write)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends LoggingRequest<ListLogsResponse> {
                private static final String REST_PATH = "v1beta3/projects/{projectsId}/logs";
                @Key
                private String projectsId;
                @Key
                private String pageToken;
                @Key
                private String serviceName;
                @Key
                private String serviceIndexPrefix;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Logging.this, "GET", REST_PATH, null, ListLogsResponse.class);
                    this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getProjectsId() {
                    return this.projectsId;
                }

                public List setProjectsId(String string) {
                    this.projectsId = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public String getServiceName() {
                    return this.serviceName;
                }

                public List setServiceName(String string) {
                    this.serviceName = string;
                    return this;
                }

                public String getServiceIndexPrefix() {
                    return this.serviceIndexPrefix;
                }

                public List setServiceIndexPrefix(String string) {
                    this.serviceIndexPrefix = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v1beta3/projects/{projectsId}/logs/{logsId}";
                @Key
                private String projectsId;
                @Key
                private String logsId;

                protected Delete(String string, String string2) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                    this.logsId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter logsId must be specified.");
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getProjectsId() {
                    return this.projectsId;
                }

                public Delete setProjectsId(String string) {
                    this.projectsId = string;
                    return this;
                }

                public String getLogsId() {
                    return this.logsId;
                }

                public Delete setLogsId(String string) {
                    this.logsId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class LogServices {
            public List list(String string) throws IOException {
                List list = new List(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Indexes indexes() {
                return new Indexes();
            }

            public Sinks sinks() {
                return new Sinks();
            }

            public class Sinks {
                public Create create(String string, String string2, LogSink logSink) throws IOException {
                    Create create = new Create(string, string2, logSink);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string, String string2, String string3) throws IOException {
                    Delete delete = new Delete(string, string2, string3);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string, String string2, String string3) throws IOException {
                    Get get = new Get(string, string2, string3);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string, String string2) throws IOException {
                    List list = new List(string, string2);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Update update(String string, String string2, String string3, LogSink logSink) throws IOException {
                    Update update = new Update(string, string2, string3, logSink);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)update);
                    return update;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Update
                extends LoggingRequest<LogSink> {
                    private static final String REST_PATH = "v1beta3/projects/{projectsId}/logServices/{logServicesId}/sinks/{sinksId}";
                    @Key
                    private String projectsId;
                    @Key
                    private String logServicesId;
                    @Key
                    private String sinksId;

                    protected Update(String string, String string2, String string3, LogSink logSink) {
                        super(Logging.this, "PUT", REST_PATH, (Object)logSink, LogSink.class);
                        this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                        this.logServicesId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter logServicesId must be specified.");
                        this.sinksId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter sinksId must be specified.");
                    }

                    public Update set$Xgafv(String string) {
                        return (Update)super.set$Xgafv(string);
                    }

                    public Update setAccessToken(String string) {
                        return (Update)super.setAccessToken(string);
                    }

                    public Update setAlt(String string) {
                        return (Update)super.setAlt(string);
                    }

                    public Update setBearerToken(String string) {
                        return (Update)super.setBearerToken(string);
                    }

                    public Update setCallback(String string) {
                        return (Update)super.setCallback(string);
                    }

                    public Update setFields(String string) {
                        return (Update)super.setFields(string);
                    }

                    public Update setKey(String string) {
                        return (Update)super.setKey(string);
                    }

                    public Update setOauthToken(String string) {
                        return (Update)super.setOauthToken(string);
                    }

                    public Update setPp(Boolean bl) {
                        return (Update)super.setPp(bl);
                    }

                    public Update setPrettyPrint(Boolean bl) {
                        return (Update)super.setPrettyPrint(bl);
                    }

                    public Update setQuotaUser(String string) {
                        return (Update)super.setQuotaUser(string);
                    }

                    public Update setUploadType(String string) {
                        return (Update)super.setUploadType(string);
                    }

                    public Update setUploadProtocol(String string) {
                        return (Update)super.setUploadProtocol(string);
                    }

                    public String getProjectsId() {
                        return this.projectsId;
                    }

                    public Update setProjectsId(String string) {
                        this.projectsId = string;
                        return this;
                    }

                    public String getLogServicesId() {
                        return this.logServicesId;
                    }

                    public Update setLogServicesId(String string) {
                        this.logServicesId = string;
                        return this;
                    }

                    public String getSinksId() {
                        return this.sinksId;
                    }

                    public Update setSinksId(String string) {
                        this.sinksId = string;
                        return this;
                    }

                    @Override
                    public Update set(String string, Object object) {
                        return (Update)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends LoggingRequest<ListLogServiceSinksResponse> {
                    private static final String REST_PATH = "v1beta3/projects/{projectsId}/logServices/{logServicesId}/sinks";
                    @Key
                    private String projectsId;
                    @Key
                    private String logServicesId;

                    protected List(String string, String string2) {
                        super(Logging.this, "GET", REST_PATH, null, ListLogServiceSinksResponse.class);
                        this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                        this.logServicesId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter logServicesId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setBearerToken(String string) {
                        return (List)super.setBearerToken(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPp(Boolean bl) {
                        return (List)super.setPp(bl);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getProjectsId() {
                        return this.projectsId;
                    }

                    public List setProjectsId(String string) {
                        this.projectsId = string;
                        return this;
                    }

                    public String getLogServicesId() {
                        return this.logServicesId;
                    }

                    public List setLogServicesId(String string) {
                        this.logServicesId = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends LoggingRequest<LogSink> {
                    private static final String REST_PATH = "v1beta3/projects/{projectsId}/logServices/{logServicesId}/sinks/{sinksId}";
                    @Key
                    private String projectsId;
                    @Key
                    private String logServicesId;
                    @Key
                    private String sinksId;

                    protected Get(String string, String string2, String string3) {
                        super(Logging.this, "GET", REST_PATH, null, LogSink.class);
                        this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                        this.logServicesId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter logServicesId must be specified.");
                        this.sinksId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter sinksId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setBearerToken(String string) {
                        return (Get)super.setBearerToken(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPp(Boolean bl) {
                        return (Get)super.setPp(bl);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getProjectsId() {
                        return this.projectsId;
                    }

                    public Get setProjectsId(String string) {
                        this.projectsId = string;
                        return this;
                    }

                    public String getLogServicesId() {
                        return this.logServicesId;
                    }

                    public Get setLogServicesId(String string) {
                        this.logServicesId = string;
                        return this;
                    }

                    public String getSinksId() {
                        return this.sinksId;
                    }

                    public Get setSinksId(String string) {
                        this.sinksId = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends LoggingRequest<Empty> {
                    private static final String REST_PATH = "v1beta3/projects/{projectsId}/logServices/{logServicesId}/sinks/{sinksId}";
                    @Key
                    private String projectsId;
                    @Key
                    private String logServicesId;
                    @Key
                    private String sinksId;

                    protected Delete(String string, String string2, String string3) {
                        super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                        this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                        this.logServicesId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter logServicesId must be specified.");
                        this.sinksId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter sinksId must be specified.");
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setBearerToken(String string) {
                        return (Delete)super.setBearerToken(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPp(Boolean bl) {
                        return (Delete)super.setPp(bl);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getProjectsId() {
                        return this.projectsId;
                    }

                    public Delete setProjectsId(String string) {
                        this.projectsId = string;
                        return this;
                    }

                    public String getLogServicesId() {
                        return this.logServicesId;
                    }

                    public Delete setLogServicesId(String string) {
                        this.logServicesId = string;
                        return this;
                    }

                    public String getSinksId() {
                        return this.sinksId;
                    }

                    public Delete setSinksId(String string) {
                        this.sinksId = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends LoggingRequest<LogSink> {
                    private static final String REST_PATH = "v1beta3/projects/{projectsId}/logServices/{logServicesId}/sinks";
                    @Key
                    private String projectsId;
                    @Key
                    private String logServicesId;

                    protected Create(String string, String string2, LogSink logSink) {
                        super(Logging.this, "POST", REST_PATH, (Object)logSink, LogSink.class);
                        this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                        this.logServicesId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter logServicesId must be specified.");
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setBearerToken(String string) {
                        return (Create)super.setBearerToken(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPp(Boolean bl) {
                        return (Create)super.setPp(bl);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getProjectsId() {
                        return this.projectsId;
                    }

                    public Create setProjectsId(String string) {
                        this.projectsId = string;
                        return this;
                    }

                    public String getLogServicesId() {
                        return this.logServicesId;
                    }

                    public Create setLogServicesId(String string) {
                        this.logServicesId = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }
            }

            public class Indexes {
                public List list(String string, String string2) throws IOException {
                    List list = new List(string, string2);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends LoggingRequest<ListLogServiceIndexesResponse> {
                    private static final String REST_PATH = "v1beta3/projects/{projectsId}/logServices/{logServicesId}/indexes";
                    @Key
                    private String projectsId;
                    @Key
                    private String logServicesId;
                    @Key
                    private String log;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer depth;
                    @Key
                    private String indexPrefix;

                    protected List(String string, String string2) {
                        super(Logging.this, "GET", REST_PATH, null, ListLogServiceIndexesResponse.class);
                        this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                        this.logServicesId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter logServicesId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setBearerToken(String string) {
                        return (List)super.setBearerToken(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPp(Boolean bl) {
                        return (List)super.setPp(bl);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getProjectsId() {
                        return this.projectsId;
                    }

                    public List setProjectsId(String string) {
                        this.projectsId = string;
                        return this;
                    }

                    public String getLogServicesId() {
                        return this.logServicesId;
                    }

                    public List setLogServicesId(String string) {
                        this.logServicesId = string;
                        return this;
                    }

                    public String getLog() {
                        return this.log;
                    }

                    public List setLog(String string) {
                        this.log = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getDepth() {
                        return this.depth;
                    }

                    public List setDepth(Integer n) {
                        this.depth = n;
                        return this;
                    }

                    public String getIndexPrefix() {
                        return this.indexPrefix;
                    }

                    public List setIndexPrefix(String string) {
                        this.indexPrefix = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends LoggingRequest<ListLogServicesResponse> {
                private static final String REST_PATH = "v1beta3/projects/{projectsId}/logServices";
                @Key
                private String projectsId;
                @Key
                private String pageToken;
                @Key
                private String log;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Logging.this, "GET", REST_PATH, null, ListLogServicesResponse.class);
                    this.projectsId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectsId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getProjectsId() {
                    return this.projectsId;
                }

                public List setProjectsId(String string) {
                    this.projectsId = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public String getLog() {
                    return this.log;
                }

                public List setLog(String string) {
                    this.log = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }
    }
}

