/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.logging.v2;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.logging.v2.LoggingRequest;
import com.google.api.services.logging.v2.LoggingRequestInitializer;
import com.google.api.services.logging.v2.model.CancelOperationRequest;
import com.google.api.services.logging.v2.model.CmekSettings;
import com.google.api.services.logging.v2.model.CopyLogEntriesRequest;
import com.google.api.services.logging.v2.model.Empty;
import com.google.api.services.logging.v2.model.ListBucketsResponse;
import com.google.api.services.logging.v2.model.ListExclusionsResponse;
import com.google.api.services.logging.v2.model.ListLocationsResponse;
import com.google.api.services.logging.v2.model.ListLogEntriesRequest;
import com.google.api.services.logging.v2.model.ListLogEntriesResponse;
import com.google.api.services.logging.v2.model.ListLogMetricsResponse;
import com.google.api.services.logging.v2.model.ListLogsResponse;
import com.google.api.services.logging.v2.model.ListMonitoredResourceDescriptorsResponse;
import com.google.api.services.logging.v2.model.ListOperationsResponse;
import com.google.api.services.logging.v2.model.ListSinksResponse;
import com.google.api.services.logging.v2.model.ListViewsResponse;
import com.google.api.services.logging.v2.model.Location;
import com.google.api.services.logging.v2.model.LogBucket;
import com.google.api.services.logging.v2.model.LogExclusion;
import com.google.api.services.logging.v2.model.LogMetric;
import com.google.api.services.logging.v2.model.LogSink;
import com.google.api.services.logging.v2.model.LogView;
import com.google.api.services.logging.v2.model.Operation;
import com.google.api.services.logging.v2.model.Settings;
import com.google.api.services.logging.v2.model.TailLogEntriesRequest;
import com.google.api.services.logging.v2.model.TailLogEntriesResponse;
import com.google.api.services.logging.v2.model.UndeleteBucketRequest;
import com.google.api.services.logging.v2.model.WriteLogEntriesRequest;
import com.google.api.services.logging.v2.model.WriteLogEntriesResponse;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

public class Logging
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://logging.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://logging.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://logging.googleapis.com/";

    public Logging(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Logging(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public BillingAccounts billingAccounts() {
        return new BillingAccounts();
    }

    public Entries entries() {
        return new Entries();
    }

    public Exclusions exclusions() {
        return new Exclusions();
    }

    public Folders folders() {
        return new Folders();
    }

    public Locations locations() {
        return new Locations();
    }

    public Logs logs() {
        return new Logs();
    }

    public MonitoredResourceDescriptors monitoredResourceDescriptors() {
        return new MonitoredResourceDescriptors();
    }

    public Organizations organizations() {
        return new Organizations();
    }

    public Projects projects() {
        return new Projects();
    }

    public Sinks sinks() {
        return new Sinks();
    }

    public V2 v2() {
        return new V2();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.32.1 of the Cloud Logging API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Logging.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://logging.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Logging.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Logging.DEFAULT_BATCH_PATH);
        }

        public Logging build() {
            return new Logging(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setLoggingRequestInitializer(LoggingRequestInitializer loggingRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)loggingRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class V2 {
        public GetCmekSettings getCmekSettings(String name) throws IOException {
            GetCmekSettings result = new GetCmekSettings(name);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetSettings getSettings(String name) throws IOException {
            GetSettings result = new GetSettings(name);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UpdateCmekSettings updateCmekSettings(String name, CmekSettings content) throws IOException {
            UpdateCmekSettings result = new UpdateCmekSettings(name, content);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UpdateSettings updateSettings(String name, Settings content) throws IOException {
            UpdateSettings result = new UpdateSettings(name, content);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class UpdateSettings
        extends LoggingRequest<Settings> {
            private static final String REST_PATH = "v2/{+name}/settings";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected UpdateSettings(String name, Settings content) {
                super(Logging.this, "PATCH", REST_PATH, (Object)content, Settings.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public UpdateSettings set$Xgafv(String $Xgafv) {
                return (UpdateSettings)super.set$Xgafv($Xgafv);
            }

            public UpdateSettings setAccessToken(String accessToken) {
                return (UpdateSettings)super.setAccessToken(accessToken);
            }

            public UpdateSettings setAlt(String alt) {
                return (UpdateSettings)super.setAlt(alt);
            }

            public UpdateSettings setCallback(String callback) {
                return (UpdateSettings)super.setCallback(callback);
            }

            public UpdateSettings setFields(String fields) {
                return (UpdateSettings)super.setFields(fields);
            }

            public UpdateSettings setKey(String key) {
                return (UpdateSettings)super.setKey(key);
            }

            public UpdateSettings setOauthToken(String oauthToken) {
                return (UpdateSettings)super.setOauthToken(oauthToken);
            }

            public UpdateSettings setPrettyPrint(Boolean prettyPrint) {
                return (UpdateSettings)super.setPrettyPrint(prettyPrint);
            }

            public UpdateSettings setQuotaUser(String quotaUser) {
                return (UpdateSettings)super.setQuotaUser(quotaUser);
            }

            public UpdateSettings setUploadType(String uploadType) {
                return (UpdateSettings)super.setUploadType(uploadType);
            }

            public UpdateSettings setUploadProtocol(String uploadProtocol) {
                return (UpdateSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public UpdateSettings setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public UpdateSettings setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public UpdateSettings set(String parameterName, Object value) {
                return (UpdateSettings)super.set(parameterName, value);
            }
        }

        public class UpdateCmekSettings
        extends LoggingRequest<CmekSettings> {
            private static final String REST_PATH = "v2/{+name}/cmekSettings";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected UpdateCmekSettings(String name, CmekSettings content) {
                super(Logging.this, "PATCH", REST_PATH, (Object)content, CmekSettings.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public UpdateCmekSettings set$Xgafv(String $Xgafv) {
                return (UpdateCmekSettings)super.set$Xgafv($Xgafv);
            }

            public UpdateCmekSettings setAccessToken(String accessToken) {
                return (UpdateCmekSettings)super.setAccessToken(accessToken);
            }

            public UpdateCmekSettings setAlt(String alt) {
                return (UpdateCmekSettings)super.setAlt(alt);
            }

            public UpdateCmekSettings setCallback(String callback) {
                return (UpdateCmekSettings)super.setCallback(callback);
            }

            public UpdateCmekSettings setFields(String fields) {
                return (UpdateCmekSettings)super.setFields(fields);
            }

            public UpdateCmekSettings setKey(String key) {
                return (UpdateCmekSettings)super.setKey(key);
            }

            public UpdateCmekSettings setOauthToken(String oauthToken) {
                return (UpdateCmekSettings)super.setOauthToken(oauthToken);
            }

            public UpdateCmekSettings setPrettyPrint(Boolean prettyPrint) {
                return (UpdateCmekSettings)super.setPrettyPrint(prettyPrint);
            }

            public UpdateCmekSettings setQuotaUser(String quotaUser) {
                return (UpdateCmekSettings)super.setQuotaUser(quotaUser);
            }

            public UpdateCmekSettings setUploadType(String uploadType) {
                return (UpdateCmekSettings)super.setUploadType(uploadType);
            }

            public UpdateCmekSettings setUploadProtocol(String uploadProtocol) {
                return (UpdateCmekSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public UpdateCmekSettings setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public UpdateCmekSettings setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public UpdateCmekSettings set(String parameterName, Object value) {
                return (UpdateCmekSettings)super.set(parameterName, value);
            }
        }

        public class GetSettings
        extends LoggingRequest<Settings> {
            private static final String REST_PATH = "v2/{+name}/settings";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GetSettings(String name) {
                super(Logging.this, "GET", REST_PATH, null, Settings.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetSettings set$Xgafv(String $Xgafv) {
                return (GetSettings)super.set$Xgafv($Xgafv);
            }

            public GetSettings setAccessToken(String accessToken) {
                return (GetSettings)super.setAccessToken(accessToken);
            }

            public GetSettings setAlt(String alt) {
                return (GetSettings)super.setAlt(alt);
            }

            public GetSettings setCallback(String callback) {
                return (GetSettings)super.setCallback(callback);
            }

            public GetSettings setFields(String fields) {
                return (GetSettings)super.setFields(fields);
            }

            public GetSettings setKey(String key) {
                return (GetSettings)super.setKey(key);
            }

            public GetSettings setOauthToken(String oauthToken) {
                return (GetSettings)super.setOauthToken(oauthToken);
            }

            public GetSettings setPrettyPrint(Boolean prettyPrint) {
                return (GetSettings)super.setPrettyPrint(prettyPrint);
            }

            public GetSettings setQuotaUser(String quotaUser) {
                return (GetSettings)super.setQuotaUser(quotaUser);
            }

            public GetSettings setUploadType(String uploadType) {
                return (GetSettings)super.setUploadType(uploadType);
            }

            public GetSettings setUploadProtocol(String uploadProtocol) {
                return (GetSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GetSettings setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public GetSettings set(String parameterName, Object value) {
                return (GetSettings)super.set(parameterName, value);
            }
        }

        public class GetCmekSettings
        extends LoggingRequest<CmekSettings> {
            private static final String REST_PATH = "v2/{+name}/cmekSettings";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GetCmekSettings(String name) {
                super(Logging.this, "GET", REST_PATH, null, CmekSettings.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetCmekSettings set$Xgafv(String $Xgafv) {
                return (GetCmekSettings)super.set$Xgafv($Xgafv);
            }

            public GetCmekSettings setAccessToken(String accessToken) {
                return (GetCmekSettings)super.setAccessToken(accessToken);
            }

            public GetCmekSettings setAlt(String alt) {
                return (GetCmekSettings)super.setAlt(alt);
            }

            public GetCmekSettings setCallback(String callback) {
                return (GetCmekSettings)super.setCallback(callback);
            }

            public GetCmekSettings setFields(String fields) {
                return (GetCmekSettings)super.setFields(fields);
            }

            public GetCmekSettings setKey(String key) {
                return (GetCmekSettings)super.setKey(key);
            }

            public GetCmekSettings setOauthToken(String oauthToken) {
                return (GetCmekSettings)super.setOauthToken(oauthToken);
            }

            public GetCmekSettings setPrettyPrint(Boolean prettyPrint) {
                return (GetCmekSettings)super.setPrettyPrint(prettyPrint);
            }

            public GetCmekSettings setQuotaUser(String quotaUser) {
                return (GetCmekSettings)super.setQuotaUser(quotaUser);
            }

            public GetCmekSettings setUploadType(String uploadType) {
                return (GetCmekSettings)super.setUploadType(uploadType);
            }

            public GetCmekSettings setUploadProtocol(String uploadProtocol) {
                return (GetCmekSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GetCmekSettings setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public GetCmekSettings set(String parameterName, Object value) {
                return (GetCmekSettings)super.set(parameterName, value);
            }
        }
    }

    public class Sinks {
        public Create create(String parent, LogSink content) throws IOException {
            Create result = new Create(parent, content);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String sinkName) throws IOException {
            Delete result = new Delete(sinkName);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String sinkName) throws IOException {
            Get result = new Get(sinkName);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String parent) throws IOException {
            List result = new List(parent);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String sinkName, LogSink content) throws IOException {
            Update result = new Update(sinkName, content);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends LoggingRequest<LogSink> {
            private static final String REST_PATH = "v2/{+sinkName}";
            private final Pattern SINK_NAME_PATTERN;
            @Key
            private String sinkName;
            @Key
            private Boolean uniqueWriterIdentity;
            @Key
            private String updateMask;

            protected Update(String sinkName, LogSink content) {
                super(Logging.this, "PUT", REST_PATH, (Object)content, LogSink.class);
                this.SINK_NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/sinks/[^/]+$");
                this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^[^/]+/[^/]+/sinks/[^/]+$");
                }
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getSinkName() {
                return this.sinkName;
            }

            public Update setSinkName(String sinkName) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^[^/]+/[^/]+/sinks/[^/]+$");
                }
                this.sinkName = sinkName;
                return this;
            }

            public Boolean getUniqueWriterIdentity() {
                return this.uniqueWriterIdentity;
            }

            public Update setUniqueWriterIdentity(Boolean uniqueWriterIdentity) {
                this.uniqueWriterIdentity = uniqueWriterIdentity;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Update setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends LoggingRequest<ListSinksResponse> {
            private static final String REST_PATH = "v2/{+parent}/sinks";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String parent) {
                super(Logging.this, "GET", REST_PATH, null, ListSinksResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String parent) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends LoggingRequest<LogSink> {
            private static final String REST_PATH = "v2/{+sinkName}";
            private final Pattern SINK_NAME_PATTERN;
            @Key
            private String sinkName;

            protected Get(String sinkName) {
                super(Logging.this, "GET", REST_PATH, null, LogSink.class);
                this.SINK_NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/sinks/[^/]+$");
                this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^[^/]+/[^/]+/sinks/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getSinkName() {
                return this.sinkName;
            }

            public Get setSinkName(String sinkName) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^[^/]+/[^/]+/sinks/[^/]+$");
                }
                this.sinkName = sinkName;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends LoggingRequest<Empty> {
            private static final String REST_PATH = "v2/{+sinkName}";
            private final Pattern SINK_NAME_PATTERN;
            @Key
            private String sinkName;

            protected Delete(String sinkName) {
                super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                this.SINK_NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/sinks/[^/]+$");
                this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^[^/]+/[^/]+/sinks/[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getSinkName() {
                return this.sinkName;
            }

            public Delete setSinkName(String sinkName) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^[^/]+/[^/]+/sinks/[^/]+$");
                }
                this.sinkName = sinkName;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends LoggingRequest<LogSink> {
            private static final String REST_PATH = "v2/{+parent}/sinks";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private Boolean uniqueWriterIdentity;

            protected Create(String parent, LogSink content) {
                super(Logging.this, "POST", REST_PATH, (Object)content, LogSink.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public Create setParent(String parent) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public Boolean getUniqueWriterIdentity() {
                return this.uniqueWriterIdentity;
            }

            public Create setUniqueWriterIdentity(Boolean uniqueWriterIdentity) {
                this.uniqueWriterIdentity = uniqueWriterIdentity;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Projects {
        public GetCmekSettings getCmekSettings(String name) throws IOException {
            GetCmekSettings result = new GetCmekSettings(name);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetSettings getSettings(String name) throws IOException {
            GetSettings result = new GetSettings(name);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Exclusions exclusions() {
            return new Exclusions();
        }

        public Locations locations() {
            return new Locations();
        }

        public Logs logs() {
            return new Logs();
        }

        public Metrics metrics() {
            return new Metrics();
        }

        public Sinks sinks() {
            return new Sinks();
        }

        public class Sinks {
            public Create create(String parent, LogSink content) throws IOException {
                Create result = new Create(parent, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String sinkName) throws IOException {
                Delete result = new Delete(sinkName);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String sinkName) throws IOException {
                Get result = new Get(sinkName);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String sinkName, LogSink content) throws IOException {
                Patch result = new Patch(sinkName, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String sinkName, LogSink content) throws IOException {
                Update result = new Update(sinkName, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;
                @Key
                private Boolean uniqueWriterIdentity;
                @Key
                private String updateMask;

                protected Update(String sinkName, LogSink content) {
                    super(Logging.this, "PUT", REST_PATH, (Object)content, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^projects/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^projects/[^/]+/sinks/[^/]+$");
                    }
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Update setSinkName(String sinkName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^projects/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = sinkName;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Update setUniqueWriterIdentity(Boolean uniqueWriterIdentity) {
                    this.uniqueWriterIdentity = uniqueWriterIdentity;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Update setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;
                @Key
                private Boolean uniqueWriterIdentity;
                @Key
                private String updateMask;

                protected Patch(String sinkName, LogSink content) {
                    super(Logging.this, "PATCH", REST_PATH, (Object)content, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^projects/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^projects/[^/]+/sinks/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Patch setSinkName(String sinkName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^projects/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = sinkName;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Patch setUniqueWriterIdentity(Boolean uniqueWriterIdentity) {
                    this.uniqueWriterIdentity = uniqueWriterIdentity;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends LoggingRequest<ListSinksResponse> {
                private static final String REST_PATH = "v2/{+parent}/sinks";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(Logging.this, "GET", REST_PATH, null, ListSinksResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;

                protected Get(String sinkName) {
                    super(Logging.this, "GET", REST_PATH, null, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^projects/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^projects/[^/]+/sinks/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Get setSinkName(String sinkName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^projects/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = sinkName;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;

                protected Delete(String sinkName) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^projects/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^projects/[^/]+/sinks/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Delete setSinkName(String sinkName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^projects/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = sinkName;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+parent}/sinks";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Boolean uniqueWriterIdentity;

                protected Create(String parent, LogSink content) {
                    super(Logging.this, "POST", REST_PATH, (Object)content, LogSink.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Create setUniqueWriterIdentity(Boolean uniqueWriterIdentity) {
                    this.uniqueWriterIdentity = uniqueWriterIdentity;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Metrics {
            public Create create(String parent, LogMetric content) throws IOException {
                Create result = new Create(parent, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String metricName) throws IOException {
                Delete result = new Delete(metricName);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String metricName) throws IOException {
                Get result = new Get(metricName);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String metricName, LogMetric content) throws IOException {
                Update result = new Update(metricName, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends LoggingRequest<LogMetric> {
                private static final String REST_PATH = "v2/{+metricName}";
                private final Pattern METRIC_NAME_PATTERN;
                @Key
                private String metricName;

                protected Update(String metricName, LogMetric content) {
                    super(Logging.this, "PUT", REST_PATH, (Object)content, LogMetric.class);
                    this.METRIC_NAME_PATTERN = Pattern.compile("^projects/[^/]+/metrics/[^/]+$");
                    this.metricName = (String)Preconditions.checkNotNull((Object)metricName, (Object)"Required parameter metricName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRIC_NAME_PATTERN.matcher(metricName).matches(), (Object)"Parameter metricName must conform to the pattern ^projects/[^/]+/metrics/[^/]+$");
                    }
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getMetricName() {
                    return this.metricName;
                }

                public Update setMetricName(String metricName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRIC_NAME_PATTERN.matcher(metricName).matches(), (Object)"Parameter metricName must conform to the pattern ^projects/[^/]+/metrics/[^/]+$");
                    }
                    this.metricName = metricName;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class List
            extends LoggingRequest<ListLogMetricsResponse> {
                private static final String REST_PATH = "v2/{+parent}/metrics";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(Logging.this, "GET", REST_PATH, null, ListLogMetricsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends LoggingRequest<LogMetric> {
                private static final String REST_PATH = "v2/{+metricName}";
                private final Pattern METRIC_NAME_PATTERN;
                @Key
                private String metricName;

                protected Get(String metricName) {
                    super(Logging.this, "GET", REST_PATH, null, LogMetric.class);
                    this.METRIC_NAME_PATTERN = Pattern.compile("^projects/[^/]+/metrics/[^/]+$");
                    this.metricName = (String)Preconditions.checkNotNull((Object)metricName, (Object)"Required parameter metricName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRIC_NAME_PATTERN.matcher(metricName).matches(), (Object)"Parameter metricName must conform to the pattern ^projects/[^/]+/metrics/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getMetricName() {
                    return this.metricName;
                }

                public Get setMetricName(String metricName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRIC_NAME_PATTERN.matcher(metricName).matches(), (Object)"Parameter metricName must conform to the pattern ^projects/[^/]+/metrics/[^/]+$");
                    }
                    this.metricName = metricName;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+metricName}";
                private final Pattern METRIC_NAME_PATTERN;
                @Key
                private String metricName;

                protected Delete(String metricName) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.METRIC_NAME_PATTERN = Pattern.compile("^projects/[^/]+/metrics/[^/]+$");
                    this.metricName = (String)Preconditions.checkNotNull((Object)metricName, (Object)"Required parameter metricName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRIC_NAME_PATTERN.matcher(metricName).matches(), (Object)"Parameter metricName must conform to the pattern ^projects/[^/]+/metrics/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getMetricName() {
                    return this.metricName;
                }

                public Delete setMetricName(String metricName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRIC_NAME_PATTERN.matcher(metricName).matches(), (Object)"Parameter metricName must conform to the pattern ^projects/[^/]+/metrics/[^/]+$");
                    }
                    this.metricName = metricName;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends LoggingRequest<LogMetric> {
                private static final String REST_PATH = "v2/{+parent}/metrics";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, LogMetric content) {
                    super(Logging.this, "POST", REST_PATH, (Object)content, LogMetric.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Logs {
            public Delete delete(String logName) throws IOException {
                Delete result = new Delete(logName);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends LoggingRequest<ListLogsResponse> {
                private static final String REST_PATH = "v2/{+parent}/logs";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private java.util.List<String> resourceNames;

                protected List(String parent) {
                    super(Logging.this, "GET", REST_PATH, null, ListLogsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public java.util.List<String> getResourceNames() {
                    return this.resourceNames;
                }

                public List setResourceNames(java.util.List<String> resourceNames) {
                    this.resourceNames = resourceNames;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+logName}";
                private final Pattern LOG_NAME_PATTERN;
                @Key
                private String logName;

                protected Delete(String logName) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.LOG_NAME_PATTERN = Pattern.compile("^projects/[^/]+/logs/[^/]+$");
                    this.logName = (String)Preconditions.checkNotNull((Object)logName, (Object)"Required parameter logName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LOG_NAME_PATTERN.matcher(logName).matches(), (Object)"Parameter logName must conform to the pattern ^projects/[^/]+/logs/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getLogName() {
                    return this.logName;
                }

                public Delete setLogName(String logName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LOG_NAME_PATTERN.matcher(logName).matches(), (Object)"Parameter logName must conform to the pattern ^projects/[^/]+/logs/[^/]+$");
                    }
                    this.logName = logName;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Locations {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Buckets buckets() {
                return new Buckets();
            }

            public Operations operations() {
                return new Operations();
            }

            public class Operations {
                public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
                    Cancel result = new Cancel(name, content);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String name) throws IOException {
                    List result = new List(name);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends LoggingRequest<ListOperationsResponse> {
                    private static final String REST_PATH = "v2/{+name}/operations";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String name) {
                        super(Logging.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends LoggingRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Logging.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Cancel
                extends LoggingRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}:cancel";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Cancel(String name, CancelOperationRequest content) {
                        super(Logging.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Cancel set$Xgafv(String $Xgafv) {
                        return (Cancel)super.set$Xgafv($Xgafv);
                    }

                    public Cancel setAccessToken(String accessToken) {
                        return (Cancel)super.setAccessToken(accessToken);
                    }

                    public Cancel setAlt(String alt) {
                        return (Cancel)super.setAlt(alt);
                    }

                    public Cancel setCallback(String callback) {
                        return (Cancel)super.setCallback(callback);
                    }

                    public Cancel setFields(String fields) {
                        return (Cancel)super.setFields(fields);
                    }

                    public Cancel setKey(String key) {
                        return (Cancel)super.setKey(key);
                    }

                    public Cancel setOauthToken(String oauthToken) {
                        return (Cancel)super.setOauthToken(oauthToken);
                    }

                    public Cancel setPrettyPrint(Boolean prettyPrint) {
                        return (Cancel)super.setPrettyPrint(prettyPrint);
                    }

                    public Cancel setQuotaUser(String quotaUser) {
                        return (Cancel)super.setQuotaUser(quotaUser);
                    }

                    public Cancel setUploadType(String uploadType) {
                        return (Cancel)super.setUploadType(uploadType);
                    }

                    public Cancel setUploadProtocol(String uploadProtocol) {
                        return (Cancel)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Cancel setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Cancel set(String parameterName, Object value) {
                        return (Cancel)super.set(parameterName, value);
                    }
                }
            }

            public class Buckets {
                public Create create(String parent, LogBucket content) throws IOException {
                    Create result = new Create(parent, content);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, LogBucket content) throws IOException {
                    Patch result = new Patch(name, content);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Undelete undelete(String name, UndeleteBucketRequest content) throws IOException {
                    Undelete result = new Undelete(name, content);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Views views() {
                    return new Views();
                }

                public class Views {
                    public Create create(String parent, LogView content) throws IOException {
                        Create result = new Create(parent, content);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String name, LogView content) throws IOException {
                        Patch result = new Patch(name, content);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Logs logs() {
                        return new Logs();
                    }

                    public class Logs {
                        public List list(String parent) throws IOException {
                            List result = new List(parent);
                            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public class List
                        extends LoggingRequest<ListLogsResponse> {
                            private static final String REST_PATH = "v2/{+parent}/logs";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private Integer pageSize;
                            @Key
                            private String pageToken;
                            @Key
                            private java.util.List<String> resourceNames;

                            protected List(String parent) {
                                super(Logging.this, "GET", REST_PATH, null, ListLogsResponse.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!Logging.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public List set$Xgafv(String $Xgafv) {
                                return (List)super.set$Xgafv($Xgafv);
                            }

                            public List setAccessToken(String accessToken) {
                                return (List)super.setAccessToken(accessToken);
                            }

                            public List setAlt(String alt) {
                                return (List)super.setAlt(alt);
                            }

                            public List setCallback(String callback) {
                                return (List)super.setCallback(callback);
                            }

                            public List setFields(String fields) {
                                return (List)super.setFields(fields);
                            }

                            public List setKey(String key) {
                                return (List)super.setKey(key);
                            }

                            public List setOauthToken(String oauthToken) {
                                return (List)super.setOauthToken(oauthToken);
                            }

                            public List setPrettyPrint(Boolean prettyPrint) {
                                return (List)super.setPrettyPrint(prettyPrint);
                            }

                            public List setQuotaUser(String quotaUser) {
                                return (List)super.setQuotaUser(quotaUser);
                            }

                            public List setUploadType(String uploadType) {
                                return (List)super.setUploadType(uploadType);
                            }

                            public List setUploadProtocol(String uploadProtocol) {
                                return (List)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public List setParent(String parent) {
                                if (!Logging.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public Integer getPageSize() {
                                return this.pageSize;
                            }

                            public List setPageSize(Integer pageSize) {
                                this.pageSize = pageSize;
                                return this;
                            }

                            public String getPageToken() {
                                return this.pageToken;
                            }

                            public List setPageToken(String pageToken) {
                                this.pageToken = pageToken;
                                return this;
                            }

                            public java.util.List<String> getResourceNames() {
                                return this.resourceNames;
                            }

                            public List setResourceNames(java.util.List<String> resourceNames) {
                                this.resourceNames = resourceNames;
                                return this;
                            }

                            @Override
                            public List set(String parameterName, Object value) {
                                return (List)super.set(parameterName, value);
                            }
                        }
                    }

                    public class Patch
                    extends LoggingRequest<LogView> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String updateMask;

                        protected Patch(String name, LogView content) {
                            super(Logging.this, "PATCH", REST_PATH, (Object)content, LogView.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String $Xgafv) {
                            return (Patch)super.set$Xgafv($Xgafv);
                        }

                        public Patch setAccessToken(String accessToken) {
                            return (Patch)super.setAccessToken(accessToken);
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setCallback(String callback) {
                            return (Patch)super.setCallback(callback);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUploadType(String uploadType) {
                            return (Patch)super.setUploadType(uploadType);
                        }

                        public Patch setUploadProtocol(String uploadProtocol) {
                            return (Patch)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String name) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String updateMask) {
                            this.updateMask = updateMask;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends LoggingRequest<ListViewsResponse> {
                        private static final String REST_PATH = "v2/{+parent}/views";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(Logging.this, "GET", REST_PATH, null, ListViewsResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends LoggingRequest<LogView> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(Logging.this, "GET", REST_PATH, null, LogView.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends LoggingRequest<Empty> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String name) {
                            super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends LoggingRequest<LogView> {
                        private static final String REST_PATH = "v2/{+parent}/views";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String viewId;

                        protected Create(String parent, LogView content) {
                            super(Logging.this, "POST", REST_PATH, (Object)content, LogView.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getViewId() {
                            return this.viewId;
                        }

                        public Create setViewId(String viewId) {
                            this.viewId = viewId;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                public class Undelete
                extends LoggingRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}:undelete";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Undelete(String name, UndeleteBucketRequest content) {
                        super(Logging.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                    }

                    public Undelete set$Xgafv(String $Xgafv) {
                        return (Undelete)super.set$Xgafv($Xgafv);
                    }

                    public Undelete setAccessToken(String accessToken) {
                        return (Undelete)super.setAccessToken(accessToken);
                    }

                    public Undelete setAlt(String alt) {
                        return (Undelete)super.setAlt(alt);
                    }

                    public Undelete setCallback(String callback) {
                        return (Undelete)super.setCallback(callback);
                    }

                    public Undelete setFields(String fields) {
                        return (Undelete)super.setFields(fields);
                    }

                    public Undelete setKey(String key) {
                        return (Undelete)super.setKey(key);
                    }

                    public Undelete setOauthToken(String oauthToken) {
                        return (Undelete)super.setOauthToken(oauthToken);
                    }

                    public Undelete setPrettyPrint(Boolean prettyPrint) {
                        return (Undelete)super.setPrettyPrint(prettyPrint);
                    }

                    public Undelete setQuotaUser(String quotaUser) {
                        return (Undelete)super.setQuotaUser(quotaUser);
                    }

                    public Undelete setUploadType(String uploadType) {
                        return (Undelete)super.setUploadType(uploadType);
                    }

                    public Undelete setUploadProtocol(String uploadProtocol) {
                        return (Undelete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Undelete setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Undelete set(String parameterName, Object value) {
                        return (Undelete)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends LoggingRequest<LogBucket> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, LogBucket content) {
                        super(Logging.this, "PATCH", REST_PATH, (Object)content, LogBucket.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends LoggingRequest<ListBucketsResponse> {
                    private static final String REST_PATH = "v2/{+parent}/buckets";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(Logging.this, "GET", REST_PATH, null, ListBucketsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends LoggingRequest<LogBucket> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Logging.this, "GET", REST_PATH, null, LogBucket.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends LoggingRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends LoggingRequest<LogBucket> {
                    private static final String REST_PATH = "v2/{+parent}/buckets";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String bucketId;

                    protected Create(String parent, LogBucket content) {
                        super(Logging.this, "POST", REST_PATH, (Object)content, LogBucket.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getBucketId() {
                        return this.bucketId;
                    }

                    public Create setBucketId(String bucketId) {
                        this.bucketId = bucketId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class List
            extends LoggingRequest<ListLocationsResponse> {
                private static final String REST_PATH = "v2/{+name}/locations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(Logging.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends LoggingRequest<Location> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Logging.this, "GET", REST_PATH, null, Location.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Exclusions {
            public Create create(String parent, LogExclusion content) throws IOException {
                Create result = new Create(parent, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, LogExclusion content) throws IOException {
                Patch result = new Patch(name, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends LoggingRequest<LogExclusion> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String name, LogExclusion content) {
                    super(Logging.this, "PATCH", REST_PATH, (Object)content, LogExclusion.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/exclusions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/exclusions/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/exclusions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends LoggingRequest<ListExclusionsResponse> {
                private static final String REST_PATH = "v2/{+parent}/exclusions";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(Logging.this, "GET", REST_PATH, null, ListExclusionsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends LoggingRequest<LogExclusion> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Logging.this, "GET", REST_PATH, null, LogExclusion.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/exclusions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/exclusions/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/exclusions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/exclusions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/exclusions/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/exclusions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends LoggingRequest<LogExclusion> {
                private static final String REST_PATH = "v2/{+parent}/exclusions";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, LogExclusion content) {
                    super(Logging.this, "POST", REST_PATH, (Object)content, LogExclusion.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class GetSettings
        extends LoggingRequest<Settings> {
            private static final String REST_PATH = "v2/{+name}/settings";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GetSettings(String name) {
                super(Logging.this, "GET", REST_PATH, null, Settings.class);
                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetSettings set$Xgafv(String $Xgafv) {
                return (GetSettings)super.set$Xgafv($Xgafv);
            }

            public GetSettings setAccessToken(String accessToken) {
                return (GetSettings)super.setAccessToken(accessToken);
            }

            public GetSettings setAlt(String alt) {
                return (GetSettings)super.setAlt(alt);
            }

            public GetSettings setCallback(String callback) {
                return (GetSettings)super.setCallback(callback);
            }

            public GetSettings setFields(String fields) {
                return (GetSettings)super.setFields(fields);
            }

            public GetSettings setKey(String key) {
                return (GetSettings)super.setKey(key);
            }

            public GetSettings setOauthToken(String oauthToken) {
                return (GetSettings)super.setOauthToken(oauthToken);
            }

            public GetSettings setPrettyPrint(Boolean prettyPrint) {
                return (GetSettings)super.setPrettyPrint(prettyPrint);
            }

            public GetSettings setQuotaUser(String quotaUser) {
                return (GetSettings)super.setQuotaUser(quotaUser);
            }

            public GetSettings setUploadType(String uploadType) {
                return (GetSettings)super.setUploadType(uploadType);
            }

            public GetSettings setUploadProtocol(String uploadProtocol) {
                return (GetSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GetSettings setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public GetSettings set(String parameterName, Object value) {
                return (GetSettings)super.set(parameterName, value);
            }
        }

        public class GetCmekSettings
        extends LoggingRequest<CmekSettings> {
            private static final String REST_PATH = "v2/{+name}/cmekSettings";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GetCmekSettings(String name) {
                super(Logging.this, "GET", REST_PATH, null, CmekSettings.class);
                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetCmekSettings set$Xgafv(String $Xgafv) {
                return (GetCmekSettings)super.set$Xgafv($Xgafv);
            }

            public GetCmekSettings setAccessToken(String accessToken) {
                return (GetCmekSettings)super.setAccessToken(accessToken);
            }

            public GetCmekSettings setAlt(String alt) {
                return (GetCmekSettings)super.setAlt(alt);
            }

            public GetCmekSettings setCallback(String callback) {
                return (GetCmekSettings)super.setCallback(callback);
            }

            public GetCmekSettings setFields(String fields) {
                return (GetCmekSettings)super.setFields(fields);
            }

            public GetCmekSettings setKey(String key) {
                return (GetCmekSettings)super.setKey(key);
            }

            public GetCmekSettings setOauthToken(String oauthToken) {
                return (GetCmekSettings)super.setOauthToken(oauthToken);
            }

            public GetCmekSettings setPrettyPrint(Boolean prettyPrint) {
                return (GetCmekSettings)super.setPrettyPrint(prettyPrint);
            }

            public GetCmekSettings setQuotaUser(String quotaUser) {
                return (GetCmekSettings)super.setQuotaUser(quotaUser);
            }

            public GetCmekSettings setUploadType(String uploadType) {
                return (GetCmekSettings)super.setUploadType(uploadType);
            }

            public GetCmekSettings setUploadProtocol(String uploadProtocol) {
                return (GetCmekSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GetCmekSettings setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public GetCmekSettings set(String parameterName, Object value) {
                return (GetCmekSettings)super.set(parameterName, value);
            }
        }
    }

    public class Organizations {
        public GetCmekSettings getCmekSettings(String name) throws IOException {
            GetCmekSettings result = new GetCmekSettings(name);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetSettings getSettings(String name) throws IOException {
            GetSettings result = new GetSettings(name);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UpdateCmekSettings updateCmekSettings(String name, CmekSettings content) throws IOException {
            UpdateCmekSettings result = new UpdateCmekSettings(name, content);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UpdateSettings updateSettings(String name, Settings content) throws IOException {
            UpdateSettings result = new UpdateSettings(name, content);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Exclusions exclusions() {
            return new Exclusions();
        }

        public Locations locations() {
            return new Locations();
        }

        public Logs logs() {
            return new Logs();
        }

        public Sinks sinks() {
            return new Sinks();
        }

        public class Sinks {
            public Create create(String parent, LogSink content) throws IOException {
                Create result = new Create(parent, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String sinkName) throws IOException {
                Delete result = new Delete(sinkName);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String sinkName) throws IOException {
                Get result = new Get(sinkName);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String sinkName, LogSink content) throws IOException {
                Patch result = new Patch(sinkName, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String sinkName, LogSink content) throws IOException {
                Update result = new Update(sinkName, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;
                @Key
                private Boolean uniqueWriterIdentity;
                @Key
                private String updateMask;

                protected Update(String sinkName, LogSink content) {
                    super(Logging.this, "PUT", REST_PATH, (Object)content, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^organizations/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^organizations/[^/]+/sinks/[^/]+$");
                    }
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Update setSinkName(String sinkName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^organizations/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = sinkName;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Update setUniqueWriterIdentity(Boolean uniqueWriterIdentity) {
                    this.uniqueWriterIdentity = uniqueWriterIdentity;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Update setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;
                @Key
                private Boolean uniqueWriterIdentity;
                @Key
                private String updateMask;

                protected Patch(String sinkName, LogSink content) {
                    super(Logging.this, "PATCH", REST_PATH, (Object)content, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^organizations/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^organizations/[^/]+/sinks/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Patch setSinkName(String sinkName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^organizations/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = sinkName;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Patch setUniqueWriterIdentity(Boolean uniqueWriterIdentity) {
                    this.uniqueWriterIdentity = uniqueWriterIdentity;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends LoggingRequest<ListSinksResponse> {
                private static final String REST_PATH = "v2/{+parent}/sinks";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(Logging.this, "GET", REST_PATH, null, ListSinksResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;

                protected Get(String sinkName) {
                    super(Logging.this, "GET", REST_PATH, null, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^organizations/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^organizations/[^/]+/sinks/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Get setSinkName(String sinkName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^organizations/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = sinkName;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;

                protected Delete(String sinkName) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^organizations/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^organizations/[^/]+/sinks/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Delete setSinkName(String sinkName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^organizations/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = sinkName;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+parent}/sinks";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Boolean uniqueWriterIdentity;

                protected Create(String parent, LogSink content) {
                    super(Logging.this, "POST", REST_PATH, (Object)content, LogSink.class);
                    this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Create setUniqueWriterIdentity(Boolean uniqueWriterIdentity) {
                    this.uniqueWriterIdentity = uniqueWriterIdentity;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Logs {
            public Delete delete(String logName) throws IOException {
                Delete result = new Delete(logName);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends LoggingRequest<ListLogsResponse> {
                private static final String REST_PATH = "v2/{+parent}/logs";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private java.util.List<String> resourceNames;

                protected List(String parent) {
                    super(Logging.this, "GET", REST_PATH, null, ListLogsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public java.util.List<String> getResourceNames() {
                    return this.resourceNames;
                }

                public List setResourceNames(java.util.List<String> resourceNames) {
                    this.resourceNames = resourceNames;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+logName}";
                private final Pattern LOG_NAME_PATTERN;
                @Key
                private String logName;

                protected Delete(String logName) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.LOG_NAME_PATTERN = Pattern.compile("^organizations/[^/]+/logs/[^/]+$");
                    this.logName = (String)Preconditions.checkNotNull((Object)logName, (Object)"Required parameter logName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LOG_NAME_PATTERN.matcher(logName).matches(), (Object)"Parameter logName must conform to the pattern ^organizations/[^/]+/logs/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getLogName() {
                    return this.logName;
                }

                public Delete setLogName(String logName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LOG_NAME_PATTERN.matcher(logName).matches(), (Object)"Parameter logName must conform to the pattern ^organizations/[^/]+/logs/[^/]+$");
                    }
                    this.logName = logName;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Locations {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Buckets buckets() {
                return new Buckets();
            }

            public Operations operations() {
                return new Operations();
            }

            public class Operations {
                public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
                    Cancel result = new Cancel(name, content);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String name) throws IOException {
                    List result = new List(name);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends LoggingRequest<ListOperationsResponse> {
                    private static final String REST_PATH = "v2/{+name}/operations";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String name) {
                        super(Logging.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/locations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends LoggingRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Logging.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Cancel
                extends LoggingRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}:cancel";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Cancel(String name, CancelOperationRequest content) {
                        super(Logging.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Cancel set$Xgafv(String $Xgafv) {
                        return (Cancel)super.set$Xgafv($Xgafv);
                    }

                    public Cancel setAccessToken(String accessToken) {
                        return (Cancel)super.setAccessToken(accessToken);
                    }

                    public Cancel setAlt(String alt) {
                        return (Cancel)super.setAlt(alt);
                    }

                    public Cancel setCallback(String callback) {
                        return (Cancel)super.setCallback(callback);
                    }

                    public Cancel setFields(String fields) {
                        return (Cancel)super.setFields(fields);
                    }

                    public Cancel setKey(String key) {
                        return (Cancel)super.setKey(key);
                    }

                    public Cancel setOauthToken(String oauthToken) {
                        return (Cancel)super.setOauthToken(oauthToken);
                    }

                    public Cancel setPrettyPrint(Boolean prettyPrint) {
                        return (Cancel)super.setPrettyPrint(prettyPrint);
                    }

                    public Cancel setQuotaUser(String quotaUser) {
                        return (Cancel)super.setQuotaUser(quotaUser);
                    }

                    public Cancel setUploadType(String uploadType) {
                        return (Cancel)super.setUploadType(uploadType);
                    }

                    public Cancel setUploadProtocol(String uploadProtocol) {
                        return (Cancel)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Cancel setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Cancel set(String parameterName, Object value) {
                        return (Cancel)super.set(parameterName, value);
                    }
                }
            }

            public class Buckets {
                public Create create(String parent, LogBucket content) throws IOException {
                    Create result = new Create(parent, content);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, LogBucket content) throws IOException {
                    Patch result = new Patch(name, content);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Undelete undelete(String name, UndeleteBucketRequest content) throws IOException {
                    Undelete result = new Undelete(name, content);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Views views() {
                    return new Views();
                }

                public class Views {
                    public Create create(String parent, LogView content) throws IOException {
                        Create result = new Create(parent, content);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String name, LogView content) throws IOException {
                        Patch result = new Patch(name, content);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Logs logs() {
                        return new Logs();
                    }

                    public class Logs {
                        public List list(String parent) throws IOException {
                            List result = new List(parent);
                            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public class List
                        extends LoggingRequest<ListLogsResponse> {
                            private static final String REST_PATH = "v2/{+parent}/logs";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private Integer pageSize;
                            @Key
                            private String pageToken;
                            @Key
                            private java.util.List<String> resourceNames;

                            protected List(String parent) {
                                super(Logging.this, "GET", REST_PATH, null, ListLogsResponse.class);
                                this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!Logging.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public List set$Xgafv(String $Xgafv) {
                                return (List)super.set$Xgafv($Xgafv);
                            }

                            public List setAccessToken(String accessToken) {
                                return (List)super.setAccessToken(accessToken);
                            }

                            public List setAlt(String alt) {
                                return (List)super.setAlt(alt);
                            }

                            public List setCallback(String callback) {
                                return (List)super.setCallback(callback);
                            }

                            public List setFields(String fields) {
                                return (List)super.setFields(fields);
                            }

                            public List setKey(String key) {
                                return (List)super.setKey(key);
                            }

                            public List setOauthToken(String oauthToken) {
                                return (List)super.setOauthToken(oauthToken);
                            }

                            public List setPrettyPrint(Boolean prettyPrint) {
                                return (List)super.setPrettyPrint(prettyPrint);
                            }

                            public List setQuotaUser(String quotaUser) {
                                return (List)super.setQuotaUser(quotaUser);
                            }

                            public List setUploadType(String uploadType) {
                                return (List)super.setUploadType(uploadType);
                            }

                            public List setUploadProtocol(String uploadProtocol) {
                                return (List)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public List setParent(String parent) {
                                if (!Logging.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public Integer getPageSize() {
                                return this.pageSize;
                            }

                            public List setPageSize(Integer pageSize) {
                                this.pageSize = pageSize;
                                return this;
                            }

                            public String getPageToken() {
                                return this.pageToken;
                            }

                            public List setPageToken(String pageToken) {
                                this.pageToken = pageToken;
                                return this;
                            }

                            public java.util.List<String> getResourceNames() {
                                return this.resourceNames;
                            }

                            public List setResourceNames(java.util.List<String> resourceNames) {
                                this.resourceNames = resourceNames;
                                return this;
                            }

                            @Override
                            public List set(String parameterName, Object value) {
                                return (List)super.set(parameterName, value);
                            }
                        }
                    }

                    public class Patch
                    extends LoggingRequest<LogView> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String updateMask;

                        protected Patch(String name, LogView content) {
                            super(Logging.this, "PATCH", REST_PATH, (Object)content, LogView.class);
                            this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String $Xgafv) {
                            return (Patch)super.set$Xgafv($Xgafv);
                        }

                        public Patch setAccessToken(String accessToken) {
                            return (Patch)super.setAccessToken(accessToken);
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setCallback(String callback) {
                            return (Patch)super.setCallback(callback);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUploadType(String uploadType) {
                            return (Patch)super.setUploadType(uploadType);
                        }

                        public Patch setUploadProtocol(String uploadProtocol) {
                            return (Patch)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String name) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String updateMask) {
                            this.updateMask = updateMask;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends LoggingRequest<ListViewsResponse> {
                        private static final String REST_PATH = "v2/{+parent}/views";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(Logging.this, "GET", REST_PATH, null, ListViewsResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends LoggingRequest<LogView> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(Logging.this, "GET", REST_PATH, null, LogView.class);
                            this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends LoggingRequest<Empty> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String name) {
                            super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends LoggingRequest<LogView> {
                        private static final String REST_PATH = "v2/{+parent}/views";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String viewId;

                        protected Create(String parent, LogView content) {
                            super(Logging.this, "POST", REST_PATH, (Object)content, LogView.class);
                            this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getViewId() {
                            return this.viewId;
                        }

                        public Create setViewId(String viewId) {
                            this.viewId = viewId;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                public class Undelete
                extends LoggingRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}:undelete";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Undelete(String name, UndeleteBucketRequest content) {
                        super(Logging.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                    }

                    public Undelete set$Xgafv(String $Xgafv) {
                        return (Undelete)super.set$Xgafv($Xgafv);
                    }

                    public Undelete setAccessToken(String accessToken) {
                        return (Undelete)super.setAccessToken(accessToken);
                    }

                    public Undelete setAlt(String alt) {
                        return (Undelete)super.setAlt(alt);
                    }

                    public Undelete setCallback(String callback) {
                        return (Undelete)super.setCallback(callback);
                    }

                    public Undelete setFields(String fields) {
                        return (Undelete)super.setFields(fields);
                    }

                    public Undelete setKey(String key) {
                        return (Undelete)super.setKey(key);
                    }

                    public Undelete setOauthToken(String oauthToken) {
                        return (Undelete)super.setOauthToken(oauthToken);
                    }

                    public Undelete setPrettyPrint(Boolean prettyPrint) {
                        return (Undelete)super.setPrettyPrint(prettyPrint);
                    }

                    public Undelete setQuotaUser(String quotaUser) {
                        return (Undelete)super.setQuotaUser(quotaUser);
                    }

                    public Undelete setUploadType(String uploadType) {
                        return (Undelete)super.setUploadType(uploadType);
                    }

                    public Undelete setUploadProtocol(String uploadProtocol) {
                        return (Undelete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Undelete setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Undelete set(String parameterName, Object value) {
                        return (Undelete)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends LoggingRequest<LogBucket> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, LogBucket content) {
                        super(Logging.this, "PATCH", REST_PATH, (Object)content, LogBucket.class);
                        this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends LoggingRequest<ListBucketsResponse> {
                    private static final String REST_PATH = "v2/{+parent}/buckets";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(Logging.this, "GET", REST_PATH, null, ListBucketsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends LoggingRequest<LogBucket> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Logging.this, "GET", REST_PATH, null, LogBucket.class);
                        this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends LoggingRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends LoggingRequest<LogBucket> {
                    private static final String REST_PATH = "v2/{+parent}/buckets";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String bucketId;

                    protected Create(String parent, LogBucket content) {
                        super(Logging.this, "POST", REST_PATH, (Object)content, LogBucket.class);
                        this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getBucketId() {
                        return this.bucketId;
                    }

                    public Create setBucketId(String bucketId) {
                        this.bucketId = bucketId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class List
            extends LoggingRequest<ListLocationsResponse> {
                private static final String REST_PATH = "v2/{+name}/locations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(Logging.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends LoggingRequest<Location> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Logging.this, "GET", REST_PATH, null, Location.class);
                    this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Exclusions {
            public Create create(String parent, LogExclusion content) throws IOException {
                Create result = new Create(parent, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, LogExclusion content) throws IOException {
                Patch result = new Patch(name, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends LoggingRequest<LogExclusion> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String name, LogExclusion content) {
                    super(Logging.this, "PATCH", REST_PATH, (Object)content, LogExclusion.class);
                    this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/exclusions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/exclusions/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/exclusions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends LoggingRequest<ListExclusionsResponse> {
                private static final String REST_PATH = "v2/{+parent}/exclusions";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(Logging.this, "GET", REST_PATH, null, ListExclusionsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends LoggingRequest<LogExclusion> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Logging.this, "GET", REST_PATH, null, LogExclusion.class);
                    this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/exclusions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/exclusions/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/exclusions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/exclusions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/exclusions/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/exclusions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends LoggingRequest<LogExclusion> {
                private static final String REST_PATH = "v2/{+parent}/exclusions";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, LogExclusion content) {
                    super(Logging.this, "POST", REST_PATH, (Object)content, LogExclusion.class);
                    this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class UpdateSettings
        extends LoggingRequest<Settings> {
            private static final String REST_PATH = "v2/{+name}/settings";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected UpdateSettings(String name, Settings content) {
                super(Logging.this, "PATCH", REST_PATH, (Object)content, Settings.class);
                this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public UpdateSettings set$Xgafv(String $Xgafv) {
                return (UpdateSettings)super.set$Xgafv($Xgafv);
            }

            public UpdateSettings setAccessToken(String accessToken) {
                return (UpdateSettings)super.setAccessToken(accessToken);
            }

            public UpdateSettings setAlt(String alt) {
                return (UpdateSettings)super.setAlt(alt);
            }

            public UpdateSettings setCallback(String callback) {
                return (UpdateSettings)super.setCallback(callback);
            }

            public UpdateSettings setFields(String fields) {
                return (UpdateSettings)super.setFields(fields);
            }

            public UpdateSettings setKey(String key) {
                return (UpdateSettings)super.setKey(key);
            }

            public UpdateSettings setOauthToken(String oauthToken) {
                return (UpdateSettings)super.setOauthToken(oauthToken);
            }

            public UpdateSettings setPrettyPrint(Boolean prettyPrint) {
                return (UpdateSettings)super.setPrettyPrint(prettyPrint);
            }

            public UpdateSettings setQuotaUser(String quotaUser) {
                return (UpdateSettings)super.setQuotaUser(quotaUser);
            }

            public UpdateSettings setUploadType(String uploadType) {
                return (UpdateSettings)super.setUploadType(uploadType);
            }

            public UpdateSettings setUploadProtocol(String uploadProtocol) {
                return (UpdateSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public UpdateSettings setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public UpdateSettings setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public UpdateSettings set(String parameterName, Object value) {
                return (UpdateSettings)super.set(parameterName, value);
            }
        }

        public class UpdateCmekSettings
        extends LoggingRequest<CmekSettings> {
            private static final String REST_PATH = "v2/{+name}/cmekSettings";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected UpdateCmekSettings(String name, CmekSettings content) {
                super(Logging.this, "PATCH", REST_PATH, (Object)content, CmekSettings.class);
                this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public UpdateCmekSettings set$Xgafv(String $Xgafv) {
                return (UpdateCmekSettings)super.set$Xgafv($Xgafv);
            }

            public UpdateCmekSettings setAccessToken(String accessToken) {
                return (UpdateCmekSettings)super.setAccessToken(accessToken);
            }

            public UpdateCmekSettings setAlt(String alt) {
                return (UpdateCmekSettings)super.setAlt(alt);
            }

            public UpdateCmekSettings setCallback(String callback) {
                return (UpdateCmekSettings)super.setCallback(callback);
            }

            public UpdateCmekSettings setFields(String fields) {
                return (UpdateCmekSettings)super.setFields(fields);
            }

            public UpdateCmekSettings setKey(String key) {
                return (UpdateCmekSettings)super.setKey(key);
            }

            public UpdateCmekSettings setOauthToken(String oauthToken) {
                return (UpdateCmekSettings)super.setOauthToken(oauthToken);
            }

            public UpdateCmekSettings setPrettyPrint(Boolean prettyPrint) {
                return (UpdateCmekSettings)super.setPrettyPrint(prettyPrint);
            }

            public UpdateCmekSettings setQuotaUser(String quotaUser) {
                return (UpdateCmekSettings)super.setQuotaUser(quotaUser);
            }

            public UpdateCmekSettings setUploadType(String uploadType) {
                return (UpdateCmekSettings)super.setUploadType(uploadType);
            }

            public UpdateCmekSettings setUploadProtocol(String uploadProtocol) {
                return (UpdateCmekSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public UpdateCmekSettings setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public UpdateCmekSettings setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public UpdateCmekSettings set(String parameterName, Object value) {
                return (UpdateCmekSettings)super.set(parameterName, value);
            }
        }

        public class GetSettings
        extends LoggingRequest<Settings> {
            private static final String REST_PATH = "v2/{+name}/settings";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GetSettings(String name) {
                super(Logging.this, "GET", REST_PATH, null, Settings.class);
                this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetSettings set$Xgafv(String $Xgafv) {
                return (GetSettings)super.set$Xgafv($Xgafv);
            }

            public GetSettings setAccessToken(String accessToken) {
                return (GetSettings)super.setAccessToken(accessToken);
            }

            public GetSettings setAlt(String alt) {
                return (GetSettings)super.setAlt(alt);
            }

            public GetSettings setCallback(String callback) {
                return (GetSettings)super.setCallback(callback);
            }

            public GetSettings setFields(String fields) {
                return (GetSettings)super.setFields(fields);
            }

            public GetSettings setKey(String key) {
                return (GetSettings)super.setKey(key);
            }

            public GetSettings setOauthToken(String oauthToken) {
                return (GetSettings)super.setOauthToken(oauthToken);
            }

            public GetSettings setPrettyPrint(Boolean prettyPrint) {
                return (GetSettings)super.setPrettyPrint(prettyPrint);
            }

            public GetSettings setQuotaUser(String quotaUser) {
                return (GetSettings)super.setQuotaUser(quotaUser);
            }

            public GetSettings setUploadType(String uploadType) {
                return (GetSettings)super.setUploadType(uploadType);
            }

            public GetSettings setUploadProtocol(String uploadProtocol) {
                return (GetSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GetSettings setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public GetSettings set(String parameterName, Object value) {
                return (GetSettings)super.set(parameterName, value);
            }
        }

        public class GetCmekSettings
        extends LoggingRequest<CmekSettings> {
            private static final String REST_PATH = "v2/{+name}/cmekSettings";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GetCmekSettings(String name) {
                super(Logging.this, "GET", REST_PATH, null, CmekSettings.class);
                this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetCmekSettings set$Xgafv(String $Xgafv) {
                return (GetCmekSettings)super.set$Xgafv($Xgafv);
            }

            public GetCmekSettings setAccessToken(String accessToken) {
                return (GetCmekSettings)super.setAccessToken(accessToken);
            }

            public GetCmekSettings setAlt(String alt) {
                return (GetCmekSettings)super.setAlt(alt);
            }

            public GetCmekSettings setCallback(String callback) {
                return (GetCmekSettings)super.setCallback(callback);
            }

            public GetCmekSettings setFields(String fields) {
                return (GetCmekSettings)super.setFields(fields);
            }

            public GetCmekSettings setKey(String key) {
                return (GetCmekSettings)super.setKey(key);
            }

            public GetCmekSettings setOauthToken(String oauthToken) {
                return (GetCmekSettings)super.setOauthToken(oauthToken);
            }

            public GetCmekSettings setPrettyPrint(Boolean prettyPrint) {
                return (GetCmekSettings)super.setPrettyPrint(prettyPrint);
            }

            public GetCmekSettings setQuotaUser(String quotaUser) {
                return (GetCmekSettings)super.setQuotaUser(quotaUser);
            }

            public GetCmekSettings setUploadType(String uploadType) {
                return (GetCmekSettings)super.setUploadType(uploadType);
            }

            public GetCmekSettings setUploadProtocol(String uploadProtocol) {
                return (GetCmekSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GetCmekSettings setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public GetCmekSettings set(String parameterName, Object value) {
                return (GetCmekSettings)super.set(parameterName, value);
            }
        }
    }

    public class MonitoredResourceDescriptors {
        public List list() throws IOException {
            List result = new List();
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends LoggingRequest<ListMonitoredResourceDescriptorsResponse> {
            private static final String REST_PATH = "v2/monitoredResourceDescriptors";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(Logging.this, "GET", REST_PATH, null, ListMonitoredResourceDescriptorsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Logs {
        public Delete delete(String logName) throws IOException {
            Delete result = new Delete(logName);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String parent) throws IOException {
            List result = new List(parent);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends LoggingRequest<ListLogsResponse> {
            private static final String REST_PATH = "v2/{+parent}/logs";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private java.util.List<String> resourceNames;

            protected List(String parent) {
                super(Logging.this, "GET", REST_PATH, null, ListLogsResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String parent) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public java.util.List<String> getResourceNames() {
                return this.resourceNames;
            }

            public List setResourceNames(java.util.List<String> resourceNames) {
                this.resourceNames = resourceNames;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Delete
        extends LoggingRequest<Empty> {
            private static final String REST_PATH = "v2/{+logName}";
            private final Pattern LOG_NAME_PATTERN;
            @Key
            private String logName;

            protected Delete(String logName) {
                super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                this.LOG_NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/logs/[^/]+$");
                this.logName = (String)Preconditions.checkNotNull((Object)logName, (Object)"Required parameter logName must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.LOG_NAME_PATTERN.matcher(logName).matches(), (Object)"Parameter logName must conform to the pattern ^[^/]+/[^/]+/logs/[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getLogName() {
                return this.logName;
            }

            public Delete setLogName(String logName) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.LOG_NAME_PATTERN.matcher(logName).matches(), (Object)"Parameter logName must conform to the pattern ^[^/]+/[^/]+/logs/[^/]+$");
                }
                this.logName = logName;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Locations {
        public Get get(String name) throws IOException {
            Get result = new Get(name);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String name) throws IOException {
            List result = new List(name);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Buckets buckets() {
            return new Buckets();
        }

        public Operations operations() {
            return new Operations();
        }

        public class Operations {
            public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
                Cancel result = new Cancel(name, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends LoggingRequest<ListOperationsResponse> {
                private static final String REST_PATH = "v2/{+name}/operations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(Logging.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends LoggingRequest<Operation> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Logging.this, "GET", REST_PATH, null, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/locations/[^/]+/operations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/operations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/operations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Cancel
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+name}:cancel";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Cancel(String name, CancelOperationRequest content) {
                    super(Logging.this, "POST", REST_PATH, (Object)content, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/locations/[^/]+/operations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/operations/[^/]+$");
                    }
                }

                public Cancel set$Xgafv(String $Xgafv) {
                    return (Cancel)super.set$Xgafv($Xgafv);
                }

                public Cancel setAccessToken(String accessToken) {
                    return (Cancel)super.setAccessToken(accessToken);
                }

                public Cancel setAlt(String alt) {
                    return (Cancel)super.setAlt(alt);
                }

                public Cancel setCallback(String callback) {
                    return (Cancel)super.setCallback(callback);
                }

                public Cancel setFields(String fields) {
                    return (Cancel)super.setFields(fields);
                }

                public Cancel setKey(String key) {
                    return (Cancel)super.setKey(key);
                }

                public Cancel setOauthToken(String oauthToken) {
                    return (Cancel)super.setOauthToken(oauthToken);
                }

                public Cancel setPrettyPrint(Boolean prettyPrint) {
                    return (Cancel)super.setPrettyPrint(prettyPrint);
                }

                public Cancel setQuotaUser(String quotaUser) {
                    return (Cancel)super.setQuotaUser(quotaUser);
                }

                public Cancel setUploadType(String uploadType) {
                    return (Cancel)super.setUploadType(uploadType);
                }

                public Cancel setUploadProtocol(String uploadProtocol) {
                    return (Cancel)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Cancel setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/operations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Cancel set(String parameterName, Object value) {
                    return (Cancel)super.set(parameterName, value);
                }
            }
        }

        public class Buckets {
            public Create create(String parent, LogBucket content) throws IOException {
                Create result = new Create(parent, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, LogBucket content) throws IOException {
                Patch result = new Patch(name, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Undelete undelete(String name, UndeleteBucketRequest content) throws IOException {
                Undelete result = new Undelete(name, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Views views() {
                return new Views();
            }

            public class Views {
                public Create create(String parent, LogView content) throws IOException {
                    Create result = new Create(parent, content);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, LogView content) throws IOException {
                    Patch result = new Patch(name, content);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Patch
                extends LoggingRequest<LogView> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, LogView content) {
                        super(Logging.this, "PATCH", REST_PATH, (Object)content, LogView.class);
                        this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends LoggingRequest<ListViewsResponse> {
                    private static final String REST_PATH = "v2/{+parent}/views";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(Logging.this, "GET", REST_PATH, null, ListViewsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends LoggingRequest<LogView> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Logging.this, "GET", REST_PATH, null, LogView.class);
                        this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends LoggingRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends LoggingRequest<LogView> {
                    private static final String REST_PATH = "v2/{+parent}/views";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String viewId;

                    protected Create(String parent, LogView content) {
                        super(Logging.this, "POST", REST_PATH, (Object)content, LogView.class);
                        this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getViewId() {
                        return this.viewId;
                    }

                    public Create setViewId(String viewId) {
                        this.viewId = viewId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Undelete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+name}:undelete";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Undelete(String name, UndeleteBucketRequest content) {
                    super(Logging.this, "POST", REST_PATH, (Object)content, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+$");
                    }
                }

                public Undelete set$Xgafv(String $Xgafv) {
                    return (Undelete)super.set$Xgafv($Xgafv);
                }

                public Undelete setAccessToken(String accessToken) {
                    return (Undelete)super.setAccessToken(accessToken);
                }

                public Undelete setAlt(String alt) {
                    return (Undelete)super.setAlt(alt);
                }

                public Undelete setCallback(String callback) {
                    return (Undelete)super.setCallback(callback);
                }

                public Undelete setFields(String fields) {
                    return (Undelete)super.setFields(fields);
                }

                public Undelete setKey(String key) {
                    return (Undelete)super.setKey(key);
                }

                public Undelete setOauthToken(String oauthToken) {
                    return (Undelete)super.setOauthToken(oauthToken);
                }

                public Undelete setPrettyPrint(Boolean prettyPrint) {
                    return (Undelete)super.setPrettyPrint(prettyPrint);
                }

                public Undelete setQuotaUser(String quotaUser) {
                    return (Undelete)super.setQuotaUser(quotaUser);
                }

                public Undelete setUploadType(String uploadType) {
                    return (Undelete)super.setUploadType(uploadType);
                }

                public Undelete setUploadProtocol(String uploadProtocol) {
                    return (Undelete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Undelete setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Undelete set(String parameterName, Object value) {
                    return (Undelete)super.set(parameterName, value);
                }
            }

            public class Patch
            extends LoggingRequest<LogBucket> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String name, LogBucket content) {
                    super(Logging.this, "PATCH", REST_PATH, (Object)content, LogBucket.class);
                    this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends LoggingRequest<ListBucketsResponse> {
                private static final String REST_PATH = "v2/{+parent}/buckets";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(Logging.this, "GET", REST_PATH, null, ListBucketsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+/locations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends LoggingRequest<LogBucket> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Logging.this, "GET", REST_PATH, null, LogBucket.class);
                    this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+/buckets/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends LoggingRequest<LogBucket> {
                private static final String REST_PATH = "v2/{+parent}/buckets";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String bucketId;

                protected Create(String parent, LogBucket content) {
                    super(Logging.this, "POST", REST_PATH, (Object)content, LogBucket.class);
                    this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+/locations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getBucketId() {
                    return this.bucketId;
                }

                public Create setBucketId(String bucketId) {
                    this.bucketId = bucketId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class List
        extends LoggingRequest<ListLocationsResponse> {
            private static final String REST_PATH = "v2/{+name}/locations";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String name) {
                super(Logging.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public List setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends LoggingRequest<Location> {
            private static final String REST_PATH = "v2/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(Logging.this, "GET", REST_PATH, null, Location.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/locations/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/locations/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Folders {
        public GetCmekSettings getCmekSettings(String name) throws IOException {
            GetCmekSettings result = new GetCmekSettings(name);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetSettings getSettings(String name) throws IOException {
            GetSettings result = new GetSettings(name);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UpdateSettings updateSettings(String name, Settings content) throws IOException {
            UpdateSettings result = new UpdateSettings(name, content);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Exclusions exclusions() {
            return new Exclusions();
        }

        public Locations locations() {
            return new Locations();
        }

        public Logs logs() {
            return new Logs();
        }

        public Sinks sinks() {
            return new Sinks();
        }

        public class Sinks {
            public Create create(String parent, LogSink content) throws IOException {
                Create result = new Create(parent, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String sinkName) throws IOException {
                Delete result = new Delete(sinkName);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String sinkName) throws IOException {
                Get result = new Get(sinkName);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String sinkName, LogSink content) throws IOException {
                Patch result = new Patch(sinkName, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String sinkName, LogSink content) throws IOException {
                Update result = new Update(sinkName, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;
                @Key
                private Boolean uniqueWriterIdentity;
                @Key
                private String updateMask;

                protected Update(String sinkName, LogSink content) {
                    super(Logging.this, "PUT", REST_PATH, (Object)content, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^folders/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^folders/[^/]+/sinks/[^/]+$");
                    }
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Update setSinkName(String sinkName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^folders/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = sinkName;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Update setUniqueWriterIdentity(Boolean uniqueWriterIdentity) {
                    this.uniqueWriterIdentity = uniqueWriterIdentity;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Update setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;
                @Key
                private Boolean uniqueWriterIdentity;
                @Key
                private String updateMask;

                protected Patch(String sinkName, LogSink content) {
                    super(Logging.this, "PATCH", REST_PATH, (Object)content, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^folders/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^folders/[^/]+/sinks/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Patch setSinkName(String sinkName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^folders/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = sinkName;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Patch setUniqueWriterIdentity(Boolean uniqueWriterIdentity) {
                    this.uniqueWriterIdentity = uniqueWriterIdentity;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends LoggingRequest<ListSinksResponse> {
                private static final String REST_PATH = "v2/{+parent}/sinks";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(Logging.this, "GET", REST_PATH, null, ListSinksResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^folders/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;

                protected Get(String sinkName) {
                    super(Logging.this, "GET", REST_PATH, null, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^folders/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^folders/[^/]+/sinks/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Get setSinkName(String sinkName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^folders/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = sinkName;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;

                protected Delete(String sinkName) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^folders/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^folders/[^/]+/sinks/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Delete setSinkName(String sinkName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^folders/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = sinkName;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+parent}/sinks";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Boolean uniqueWriterIdentity;

                protected Create(String parent, LogSink content) {
                    super(Logging.this, "POST", REST_PATH, (Object)content, LogSink.class);
                    this.PARENT_PATTERN = Pattern.compile("^folders/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Create setUniqueWriterIdentity(Boolean uniqueWriterIdentity) {
                    this.uniqueWriterIdentity = uniqueWriterIdentity;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Logs {
            public Delete delete(String logName) throws IOException {
                Delete result = new Delete(logName);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends LoggingRequest<ListLogsResponse> {
                private static final String REST_PATH = "v2/{+parent}/logs";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private java.util.List<String> resourceNames;

                protected List(String parent) {
                    super(Logging.this, "GET", REST_PATH, null, ListLogsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^folders/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public java.util.List<String> getResourceNames() {
                    return this.resourceNames;
                }

                public List setResourceNames(java.util.List<String> resourceNames) {
                    this.resourceNames = resourceNames;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+logName}";
                private final Pattern LOG_NAME_PATTERN;
                @Key
                private String logName;

                protected Delete(String logName) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.LOG_NAME_PATTERN = Pattern.compile("^folders/[^/]+/logs/[^/]+$");
                    this.logName = (String)Preconditions.checkNotNull((Object)logName, (Object)"Required parameter logName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LOG_NAME_PATTERN.matcher(logName).matches(), (Object)"Parameter logName must conform to the pattern ^folders/[^/]+/logs/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getLogName() {
                    return this.logName;
                }

                public Delete setLogName(String logName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LOG_NAME_PATTERN.matcher(logName).matches(), (Object)"Parameter logName must conform to the pattern ^folders/[^/]+/logs/[^/]+$");
                    }
                    this.logName = logName;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Locations {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Buckets buckets() {
                return new Buckets();
            }

            public Operations operations() {
                return new Operations();
            }

            public class Operations {
                public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
                    Cancel result = new Cancel(name, content);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String name) throws IOException {
                    List result = new List(name);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends LoggingRequest<ListOperationsResponse> {
                    private static final String REST_PATH = "v2/{+name}/operations";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String name) {
                        super(Logging.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^folders/[^/]+/locations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends LoggingRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Logging.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^folders/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Cancel
                extends LoggingRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}:cancel";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Cancel(String name, CancelOperationRequest content) {
                        super(Logging.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^folders/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Cancel set$Xgafv(String $Xgafv) {
                        return (Cancel)super.set$Xgafv($Xgafv);
                    }

                    public Cancel setAccessToken(String accessToken) {
                        return (Cancel)super.setAccessToken(accessToken);
                    }

                    public Cancel setAlt(String alt) {
                        return (Cancel)super.setAlt(alt);
                    }

                    public Cancel setCallback(String callback) {
                        return (Cancel)super.setCallback(callback);
                    }

                    public Cancel setFields(String fields) {
                        return (Cancel)super.setFields(fields);
                    }

                    public Cancel setKey(String key) {
                        return (Cancel)super.setKey(key);
                    }

                    public Cancel setOauthToken(String oauthToken) {
                        return (Cancel)super.setOauthToken(oauthToken);
                    }

                    public Cancel setPrettyPrint(Boolean prettyPrint) {
                        return (Cancel)super.setPrettyPrint(prettyPrint);
                    }

                    public Cancel setQuotaUser(String quotaUser) {
                        return (Cancel)super.setQuotaUser(quotaUser);
                    }

                    public Cancel setUploadType(String uploadType) {
                        return (Cancel)super.setUploadType(uploadType);
                    }

                    public Cancel setUploadProtocol(String uploadProtocol) {
                        return (Cancel)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Cancel setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Cancel set(String parameterName, Object value) {
                        return (Cancel)super.set(parameterName, value);
                    }
                }
            }

            public class Buckets {
                public Create create(String parent, LogBucket content) throws IOException {
                    Create result = new Create(parent, content);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, LogBucket content) throws IOException {
                    Patch result = new Patch(name, content);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Undelete undelete(String name, UndeleteBucketRequest content) throws IOException {
                    Undelete result = new Undelete(name, content);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Views views() {
                    return new Views();
                }

                public class Views {
                    public Create create(String parent, LogView content) throws IOException {
                        Create result = new Create(parent, content);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String name, LogView content) throws IOException {
                        Patch result = new Patch(name, content);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Logs logs() {
                        return new Logs();
                    }

                    public class Logs {
                        public List list(String parent) throws IOException {
                            List result = new List(parent);
                            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public class List
                        extends LoggingRequest<ListLogsResponse> {
                            private static final String REST_PATH = "v2/{+parent}/logs";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private Integer pageSize;
                            @Key
                            private String pageToken;
                            @Key
                            private java.util.List<String> resourceNames;

                            protected List(String parent) {
                                super(Logging.this, "GET", REST_PATH, null, ListLogsResponse.class);
                                this.PARENT_PATTERN = Pattern.compile("^folders/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!Logging.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public List set$Xgafv(String $Xgafv) {
                                return (List)super.set$Xgafv($Xgafv);
                            }

                            public List setAccessToken(String accessToken) {
                                return (List)super.setAccessToken(accessToken);
                            }

                            public List setAlt(String alt) {
                                return (List)super.setAlt(alt);
                            }

                            public List setCallback(String callback) {
                                return (List)super.setCallback(callback);
                            }

                            public List setFields(String fields) {
                                return (List)super.setFields(fields);
                            }

                            public List setKey(String key) {
                                return (List)super.setKey(key);
                            }

                            public List setOauthToken(String oauthToken) {
                                return (List)super.setOauthToken(oauthToken);
                            }

                            public List setPrettyPrint(Boolean prettyPrint) {
                                return (List)super.setPrettyPrint(prettyPrint);
                            }

                            public List setQuotaUser(String quotaUser) {
                                return (List)super.setQuotaUser(quotaUser);
                            }

                            public List setUploadType(String uploadType) {
                                return (List)super.setUploadType(uploadType);
                            }

                            public List setUploadProtocol(String uploadProtocol) {
                                return (List)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public List setParent(String parent) {
                                if (!Logging.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public Integer getPageSize() {
                                return this.pageSize;
                            }

                            public List setPageSize(Integer pageSize) {
                                this.pageSize = pageSize;
                                return this;
                            }

                            public String getPageToken() {
                                return this.pageToken;
                            }

                            public List setPageToken(String pageToken) {
                                this.pageToken = pageToken;
                                return this;
                            }

                            public java.util.List<String> getResourceNames() {
                                return this.resourceNames;
                            }

                            public List setResourceNames(java.util.List<String> resourceNames) {
                                this.resourceNames = resourceNames;
                                return this;
                            }

                            @Override
                            public List set(String parameterName, Object value) {
                                return (List)super.set(parameterName, value);
                            }
                        }
                    }

                    public class Patch
                    extends LoggingRequest<LogView> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String updateMask;

                        protected Patch(String name, LogView content) {
                            super(Logging.this, "PATCH", REST_PATH, (Object)content, LogView.class);
                            this.NAME_PATTERN = Pattern.compile("^folders/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String $Xgafv) {
                            return (Patch)super.set$Xgafv($Xgafv);
                        }

                        public Patch setAccessToken(String accessToken) {
                            return (Patch)super.setAccessToken(accessToken);
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setCallback(String callback) {
                            return (Patch)super.setCallback(callback);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUploadType(String uploadType) {
                            return (Patch)super.setUploadType(uploadType);
                        }

                        public Patch setUploadProtocol(String uploadProtocol) {
                            return (Patch)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String name) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String updateMask) {
                            this.updateMask = updateMask;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends LoggingRequest<ListViewsResponse> {
                        private static final String REST_PATH = "v2/{+parent}/views";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(Logging.this, "GET", REST_PATH, null, ListViewsResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^folders/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends LoggingRequest<LogView> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(Logging.this, "GET", REST_PATH, null, LogView.class);
                            this.NAME_PATTERN = Pattern.compile("^folders/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends LoggingRequest<Empty> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String name) {
                            super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^folders/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends LoggingRequest<LogView> {
                        private static final String REST_PATH = "v2/{+parent}/views";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String viewId;

                        protected Create(String parent, LogView content) {
                            super(Logging.this, "POST", REST_PATH, (Object)content, LogView.class);
                            this.PARENT_PATTERN = Pattern.compile("^folders/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getViewId() {
                            return this.viewId;
                        }

                        public Create setViewId(String viewId) {
                            this.viewId = viewId;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                public class Undelete
                extends LoggingRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}:undelete";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Undelete(String name, UndeleteBucketRequest content) {
                        super(Logging.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^folders/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                    }

                    public Undelete set$Xgafv(String $Xgafv) {
                        return (Undelete)super.set$Xgafv($Xgafv);
                    }

                    public Undelete setAccessToken(String accessToken) {
                        return (Undelete)super.setAccessToken(accessToken);
                    }

                    public Undelete setAlt(String alt) {
                        return (Undelete)super.setAlt(alt);
                    }

                    public Undelete setCallback(String callback) {
                        return (Undelete)super.setCallback(callback);
                    }

                    public Undelete setFields(String fields) {
                        return (Undelete)super.setFields(fields);
                    }

                    public Undelete setKey(String key) {
                        return (Undelete)super.setKey(key);
                    }

                    public Undelete setOauthToken(String oauthToken) {
                        return (Undelete)super.setOauthToken(oauthToken);
                    }

                    public Undelete setPrettyPrint(Boolean prettyPrint) {
                        return (Undelete)super.setPrettyPrint(prettyPrint);
                    }

                    public Undelete setQuotaUser(String quotaUser) {
                        return (Undelete)super.setQuotaUser(quotaUser);
                    }

                    public Undelete setUploadType(String uploadType) {
                        return (Undelete)super.setUploadType(uploadType);
                    }

                    public Undelete setUploadProtocol(String uploadProtocol) {
                        return (Undelete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Undelete setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Undelete set(String parameterName, Object value) {
                        return (Undelete)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends LoggingRequest<LogBucket> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, LogBucket content) {
                        super(Logging.this, "PATCH", REST_PATH, (Object)content, LogBucket.class);
                        this.NAME_PATTERN = Pattern.compile("^folders/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends LoggingRequest<ListBucketsResponse> {
                    private static final String REST_PATH = "v2/{+parent}/buckets";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(Logging.this, "GET", REST_PATH, null, ListBucketsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^folders/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends LoggingRequest<LogBucket> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Logging.this, "GET", REST_PATH, null, LogBucket.class);
                        this.NAME_PATTERN = Pattern.compile("^folders/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends LoggingRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^folders/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends LoggingRequest<LogBucket> {
                    private static final String REST_PATH = "v2/{+parent}/buckets";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String bucketId;

                    protected Create(String parent, LogBucket content) {
                        super(Logging.this, "POST", REST_PATH, (Object)content, LogBucket.class);
                        this.PARENT_PATTERN = Pattern.compile("^folders/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getBucketId() {
                        return this.bucketId;
                    }

                    public Create setBucketId(String bucketId) {
                        this.bucketId = bucketId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class List
            extends LoggingRequest<ListLocationsResponse> {
                private static final String REST_PATH = "v2/{+name}/locations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(Logging.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^folders/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends LoggingRequest<Location> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Logging.this, "GET", REST_PATH, null, Location.class);
                    this.NAME_PATTERN = Pattern.compile("^folders/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Exclusions {
            public Create create(String parent, LogExclusion content) throws IOException {
                Create result = new Create(parent, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, LogExclusion content) throws IOException {
                Patch result = new Patch(name, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends LoggingRequest<LogExclusion> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String name, LogExclusion content) {
                    super(Logging.this, "PATCH", REST_PATH, (Object)content, LogExclusion.class);
                    this.NAME_PATTERN = Pattern.compile("^folders/[^/]+/exclusions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/exclusions/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/exclusions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends LoggingRequest<ListExclusionsResponse> {
                private static final String REST_PATH = "v2/{+parent}/exclusions";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(Logging.this, "GET", REST_PATH, null, ListExclusionsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^folders/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends LoggingRequest<LogExclusion> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Logging.this, "GET", REST_PATH, null, LogExclusion.class);
                    this.NAME_PATTERN = Pattern.compile("^folders/[^/]+/exclusions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/exclusions/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/exclusions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^folders/[^/]+/exclusions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/exclusions/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/exclusions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends LoggingRequest<LogExclusion> {
                private static final String REST_PATH = "v2/{+parent}/exclusions";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, LogExclusion content) {
                    super(Logging.this, "POST", REST_PATH, (Object)content, LogExclusion.class);
                    this.PARENT_PATTERN = Pattern.compile("^folders/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class UpdateSettings
        extends LoggingRequest<Settings> {
            private static final String REST_PATH = "v2/{+name}/settings";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected UpdateSettings(String name, Settings content) {
                super(Logging.this, "PATCH", REST_PATH, (Object)content, Settings.class);
                this.NAME_PATTERN = Pattern.compile("^folders/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+$");
                }
            }

            public UpdateSettings set$Xgafv(String $Xgafv) {
                return (UpdateSettings)super.set$Xgafv($Xgafv);
            }

            public UpdateSettings setAccessToken(String accessToken) {
                return (UpdateSettings)super.setAccessToken(accessToken);
            }

            public UpdateSettings setAlt(String alt) {
                return (UpdateSettings)super.setAlt(alt);
            }

            public UpdateSettings setCallback(String callback) {
                return (UpdateSettings)super.setCallback(callback);
            }

            public UpdateSettings setFields(String fields) {
                return (UpdateSettings)super.setFields(fields);
            }

            public UpdateSettings setKey(String key) {
                return (UpdateSettings)super.setKey(key);
            }

            public UpdateSettings setOauthToken(String oauthToken) {
                return (UpdateSettings)super.setOauthToken(oauthToken);
            }

            public UpdateSettings setPrettyPrint(Boolean prettyPrint) {
                return (UpdateSettings)super.setPrettyPrint(prettyPrint);
            }

            public UpdateSettings setQuotaUser(String quotaUser) {
                return (UpdateSettings)super.setQuotaUser(quotaUser);
            }

            public UpdateSettings setUploadType(String uploadType) {
                return (UpdateSettings)super.setUploadType(uploadType);
            }

            public UpdateSettings setUploadProtocol(String uploadProtocol) {
                return (UpdateSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public UpdateSettings setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public UpdateSettings setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public UpdateSettings set(String parameterName, Object value) {
                return (UpdateSettings)super.set(parameterName, value);
            }
        }

        public class GetSettings
        extends LoggingRequest<Settings> {
            private static final String REST_PATH = "v2/{+name}/settings";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GetSettings(String name) {
                super(Logging.this, "GET", REST_PATH, null, Settings.class);
                this.NAME_PATTERN = Pattern.compile("^folders/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetSettings set$Xgafv(String $Xgafv) {
                return (GetSettings)super.set$Xgafv($Xgafv);
            }

            public GetSettings setAccessToken(String accessToken) {
                return (GetSettings)super.setAccessToken(accessToken);
            }

            public GetSettings setAlt(String alt) {
                return (GetSettings)super.setAlt(alt);
            }

            public GetSettings setCallback(String callback) {
                return (GetSettings)super.setCallback(callback);
            }

            public GetSettings setFields(String fields) {
                return (GetSettings)super.setFields(fields);
            }

            public GetSettings setKey(String key) {
                return (GetSettings)super.setKey(key);
            }

            public GetSettings setOauthToken(String oauthToken) {
                return (GetSettings)super.setOauthToken(oauthToken);
            }

            public GetSettings setPrettyPrint(Boolean prettyPrint) {
                return (GetSettings)super.setPrettyPrint(prettyPrint);
            }

            public GetSettings setQuotaUser(String quotaUser) {
                return (GetSettings)super.setQuotaUser(quotaUser);
            }

            public GetSettings setUploadType(String uploadType) {
                return (GetSettings)super.setUploadType(uploadType);
            }

            public GetSettings setUploadProtocol(String uploadProtocol) {
                return (GetSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GetSettings setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public GetSettings set(String parameterName, Object value) {
                return (GetSettings)super.set(parameterName, value);
            }
        }

        public class GetCmekSettings
        extends LoggingRequest<CmekSettings> {
            private static final String REST_PATH = "v2/{+name}/cmekSettings";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GetCmekSettings(String name) {
                super(Logging.this, "GET", REST_PATH, null, CmekSettings.class);
                this.NAME_PATTERN = Pattern.compile("^folders/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetCmekSettings set$Xgafv(String $Xgafv) {
                return (GetCmekSettings)super.set$Xgafv($Xgafv);
            }

            public GetCmekSettings setAccessToken(String accessToken) {
                return (GetCmekSettings)super.setAccessToken(accessToken);
            }

            public GetCmekSettings setAlt(String alt) {
                return (GetCmekSettings)super.setAlt(alt);
            }

            public GetCmekSettings setCallback(String callback) {
                return (GetCmekSettings)super.setCallback(callback);
            }

            public GetCmekSettings setFields(String fields) {
                return (GetCmekSettings)super.setFields(fields);
            }

            public GetCmekSettings setKey(String key) {
                return (GetCmekSettings)super.setKey(key);
            }

            public GetCmekSettings setOauthToken(String oauthToken) {
                return (GetCmekSettings)super.setOauthToken(oauthToken);
            }

            public GetCmekSettings setPrettyPrint(Boolean prettyPrint) {
                return (GetCmekSettings)super.setPrettyPrint(prettyPrint);
            }

            public GetCmekSettings setQuotaUser(String quotaUser) {
                return (GetCmekSettings)super.setQuotaUser(quotaUser);
            }

            public GetCmekSettings setUploadType(String uploadType) {
                return (GetCmekSettings)super.setUploadType(uploadType);
            }

            public GetCmekSettings setUploadProtocol(String uploadProtocol) {
                return (GetCmekSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GetCmekSettings setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public GetCmekSettings set(String parameterName, Object value) {
                return (GetCmekSettings)super.set(parameterName, value);
            }
        }
    }

    public class Exclusions {
        public Create create(String parent, LogExclusion content) throws IOException {
            Create result = new Create(parent, content);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String parent) throws IOException {
            List result = new List(parent);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String name, LogExclusion content) throws IOException {
            Patch result = new Patch(name, content);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends LoggingRequest<LogExclusion> {
            private static final String REST_PATH = "v2/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected Patch(String name, LogExclusion content) {
                super(Logging.this, "PATCH", REST_PATH, (Object)content, LogExclusion.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/exclusions/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/exclusions/[^/]+$");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Patch setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/exclusions/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends LoggingRequest<ListExclusionsResponse> {
            private static final String REST_PATH = "v2/{+parent}/exclusions";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String parent) {
                super(Logging.this, "GET", REST_PATH, null, ListExclusionsResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String parent) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends LoggingRequest<LogExclusion> {
            private static final String REST_PATH = "v2/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(Logging.this, "GET", REST_PATH, null, LogExclusion.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/exclusions/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/exclusions/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/exclusions/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends LoggingRequest<Empty> {
            private static final String REST_PATH = "v2/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String name) {
                super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/exclusions/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/exclusions/[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/exclusions/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends LoggingRequest<LogExclusion> {
            private static final String REST_PATH = "v2/{+parent}/exclusions";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected Create(String parent, LogExclusion content) {
                super(Logging.this, "POST", REST_PATH, (Object)content, LogExclusion.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public Create setParent(String parent) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Entries {
        public Copy copy(CopyLogEntriesRequest content) throws IOException {
            Copy result = new Copy(content);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(ListLogEntriesRequest content) throws IOException {
            List result = new List(content);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Tail tail(TailLogEntriesRequest content) throws IOException {
            Tail result = new Tail(content);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Write write(WriteLogEntriesRequest content) throws IOException {
            Write result = new Write(content);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Write
        extends LoggingRequest<WriteLogEntriesResponse> {
            private static final String REST_PATH = "v2/entries:write";

            protected Write(WriteLogEntriesRequest content) {
                super(Logging.this, "POST", REST_PATH, (Object)content, WriteLogEntriesResponse.class);
            }

            public Write set$Xgafv(String $Xgafv) {
                return (Write)super.set$Xgafv($Xgafv);
            }

            public Write setAccessToken(String accessToken) {
                return (Write)super.setAccessToken(accessToken);
            }

            public Write setAlt(String alt) {
                return (Write)super.setAlt(alt);
            }

            public Write setCallback(String callback) {
                return (Write)super.setCallback(callback);
            }

            public Write setFields(String fields) {
                return (Write)super.setFields(fields);
            }

            public Write setKey(String key) {
                return (Write)super.setKey(key);
            }

            public Write setOauthToken(String oauthToken) {
                return (Write)super.setOauthToken(oauthToken);
            }

            public Write setPrettyPrint(Boolean prettyPrint) {
                return (Write)super.setPrettyPrint(prettyPrint);
            }

            public Write setQuotaUser(String quotaUser) {
                return (Write)super.setQuotaUser(quotaUser);
            }

            public Write setUploadType(String uploadType) {
                return (Write)super.setUploadType(uploadType);
            }

            public Write setUploadProtocol(String uploadProtocol) {
                return (Write)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Write set(String parameterName, Object value) {
                return (Write)super.set(parameterName, value);
            }
        }

        public class Tail
        extends LoggingRequest<TailLogEntriesResponse> {
            private static final String REST_PATH = "v2/entries:tail";

            protected Tail(TailLogEntriesRequest content) {
                super(Logging.this, "POST", REST_PATH, (Object)content, TailLogEntriesResponse.class);
            }

            public Tail set$Xgafv(String $Xgafv) {
                return (Tail)super.set$Xgafv($Xgafv);
            }

            public Tail setAccessToken(String accessToken) {
                return (Tail)super.setAccessToken(accessToken);
            }

            public Tail setAlt(String alt) {
                return (Tail)super.setAlt(alt);
            }

            public Tail setCallback(String callback) {
                return (Tail)super.setCallback(callback);
            }

            public Tail setFields(String fields) {
                return (Tail)super.setFields(fields);
            }

            public Tail setKey(String key) {
                return (Tail)super.setKey(key);
            }

            public Tail setOauthToken(String oauthToken) {
                return (Tail)super.setOauthToken(oauthToken);
            }

            public Tail setPrettyPrint(Boolean prettyPrint) {
                return (Tail)super.setPrettyPrint(prettyPrint);
            }

            public Tail setQuotaUser(String quotaUser) {
                return (Tail)super.setQuotaUser(quotaUser);
            }

            public Tail setUploadType(String uploadType) {
                return (Tail)super.setUploadType(uploadType);
            }

            public Tail setUploadProtocol(String uploadProtocol) {
                return (Tail)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Tail set(String parameterName, Object value) {
                return (Tail)super.set(parameterName, value);
            }
        }

        public class List
        extends LoggingRequest<ListLogEntriesResponse> {
            private static final String REST_PATH = "v2/entries:list";

            protected List(ListLogEntriesRequest content) {
                super(Logging.this, "POST", REST_PATH, (Object)content, ListLogEntriesResponse.class);
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Copy
        extends LoggingRequest<Operation> {
            private static final String REST_PATH = "v2/entries:copy";

            protected Copy(CopyLogEntriesRequest content) {
                super(Logging.this, "POST", REST_PATH, (Object)content, Operation.class);
            }

            public Copy set$Xgafv(String $Xgafv) {
                return (Copy)super.set$Xgafv($Xgafv);
            }

            public Copy setAccessToken(String accessToken) {
                return (Copy)super.setAccessToken(accessToken);
            }

            public Copy setAlt(String alt) {
                return (Copy)super.setAlt(alt);
            }

            public Copy setCallback(String callback) {
                return (Copy)super.setCallback(callback);
            }

            public Copy setFields(String fields) {
                return (Copy)super.setFields(fields);
            }

            public Copy setKey(String key) {
                return (Copy)super.setKey(key);
            }

            public Copy setOauthToken(String oauthToken) {
                return (Copy)super.setOauthToken(oauthToken);
            }

            public Copy setPrettyPrint(Boolean prettyPrint) {
                return (Copy)super.setPrettyPrint(prettyPrint);
            }

            public Copy setQuotaUser(String quotaUser) {
                return (Copy)super.setQuotaUser(quotaUser);
            }

            public Copy setUploadType(String uploadType) {
                return (Copy)super.setUploadType(uploadType);
            }

            public Copy setUploadProtocol(String uploadProtocol) {
                return (Copy)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Copy set(String parameterName, Object value) {
                return (Copy)super.set(parameterName, value);
            }
        }
    }

    public class BillingAccounts {
        public GetCmekSettings getCmekSettings(String name) throws IOException {
            GetCmekSettings result = new GetCmekSettings(name);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetSettings getSettings(String name) throws IOException {
            GetSettings result = new GetSettings(name);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Exclusions exclusions() {
            return new Exclusions();
        }

        public Locations locations() {
            return new Locations();
        }

        public Logs logs() {
            return new Logs();
        }

        public Sinks sinks() {
            return new Sinks();
        }

        public class Sinks {
            public Create create(String parent, LogSink content) throws IOException {
                Create result = new Create(parent, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String sinkName) throws IOException {
                Delete result = new Delete(sinkName);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String sinkName) throws IOException {
                Get result = new Get(sinkName);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String sinkName, LogSink content) throws IOException {
                Patch result = new Patch(sinkName, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String sinkName, LogSink content) throws IOException {
                Update result = new Update(sinkName, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;
                @Key
                private Boolean uniqueWriterIdentity;
                @Key
                private String updateMask;

                protected Update(String sinkName, LogSink content) {
                    super(Logging.this, "PUT", REST_PATH, (Object)content, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^billingAccounts/[^/]+/sinks/[^/]+$");
                    }
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Update setSinkName(String sinkName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^billingAccounts/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = sinkName;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Update setUniqueWriterIdentity(Boolean uniqueWriterIdentity) {
                    this.uniqueWriterIdentity = uniqueWriterIdentity;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Update setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;
                @Key
                private Boolean uniqueWriterIdentity;
                @Key
                private String updateMask;

                protected Patch(String sinkName, LogSink content) {
                    super(Logging.this, "PATCH", REST_PATH, (Object)content, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^billingAccounts/[^/]+/sinks/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Patch setSinkName(String sinkName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^billingAccounts/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = sinkName;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Patch setUniqueWriterIdentity(Boolean uniqueWriterIdentity) {
                    this.uniqueWriterIdentity = uniqueWriterIdentity;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends LoggingRequest<ListSinksResponse> {
                private static final String REST_PATH = "v2/{+parent}/sinks";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(Logging.this, "GET", REST_PATH, null, ListSinksResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;

                protected Get(String sinkName) {
                    super(Logging.this, "GET", REST_PATH, null, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^billingAccounts/[^/]+/sinks/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Get setSinkName(String sinkName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^billingAccounts/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = sinkName;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;

                protected Delete(String sinkName) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)sinkName, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^billingAccounts/[^/]+/sinks/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Delete setSinkName(String sinkName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(sinkName).matches(), (Object)"Parameter sinkName must conform to the pattern ^billingAccounts/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = sinkName;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+parent}/sinks";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Boolean uniqueWriterIdentity;

                protected Create(String parent, LogSink content) {
                    super(Logging.this, "POST", REST_PATH, (Object)content, LogSink.class);
                    this.PARENT_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Create setUniqueWriterIdentity(Boolean uniqueWriterIdentity) {
                    this.uniqueWriterIdentity = uniqueWriterIdentity;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Logs {
            public Delete delete(String logName) throws IOException {
                Delete result = new Delete(logName);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends LoggingRequest<ListLogsResponse> {
                private static final String REST_PATH = "v2/{+parent}/logs";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private java.util.List<String> resourceNames;

                protected List(String parent) {
                    super(Logging.this, "GET", REST_PATH, null, ListLogsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public java.util.List<String> getResourceNames() {
                    return this.resourceNames;
                }

                public List setResourceNames(java.util.List<String> resourceNames) {
                    this.resourceNames = resourceNames;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+logName}";
                private final Pattern LOG_NAME_PATTERN;
                @Key
                private String logName;

                protected Delete(String logName) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.LOG_NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/logs/[^/]+$");
                    this.logName = (String)Preconditions.checkNotNull((Object)logName, (Object)"Required parameter logName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LOG_NAME_PATTERN.matcher(logName).matches(), (Object)"Parameter logName must conform to the pattern ^billingAccounts/[^/]+/logs/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getLogName() {
                    return this.logName;
                }

                public Delete setLogName(String logName) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LOG_NAME_PATTERN.matcher(logName).matches(), (Object)"Parameter logName must conform to the pattern ^billingAccounts/[^/]+/logs/[^/]+$");
                    }
                    this.logName = logName;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Locations {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Buckets buckets() {
                return new Buckets();
            }

            public Operations operations() {
                return new Operations();
            }

            public class Operations {
                public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
                    Cancel result = new Cancel(name, content);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String name) throws IOException {
                    List result = new List(name);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends LoggingRequest<ListOperationsResponse> {
                    private static final String REST_PATH = "v2/{+name}/operations";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String name) {
                        super(Logging.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/locations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends LoggingRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Logging.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Cancel
                extends LoggingRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}:cancel";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Cancel(String name, CancelOperationRequest content) {
                        super(Logging.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Cancel set$Xgafv(String $Xgafv) {
                        return (Cancel)super.set$Xgafv($Xgafv);
                    }

                    public Cancel setAccessToken(String accessToken) {
                        return (Cancel)super.setAccessToken(accessToken);
                    }

                    public Cancel setAlt(String alt) {
                        return (Cancel)super.setAlt(alt);
                    }

                    public Cancel setCallback(String callback) {
                        return (Cancel)super.setCallback(callback);
                    }

                    public Cancel setFields(String fields) {
                        return (Cancel)super.setFields(fields);
                    }

                    public Cancel setKey(String key) {
                        return (Cancel)super.setKey(key);
                    }

                    public Cancel setOauthToken(String oauthToken) {
                        return (Cancel)super.setOauthToken(oauthToken);
                    }

                    public Cancel setPrettyPrint(Boolean prettyPrint) {
                        return (Cancel)super.setPrettyPrint(prettyPrint);
                    }

                    public Cancel setQuotaUser(String quotaUser) {
                        return (Cancel)super.setQuotaUser(quotaUser);
                    }

                    public Cancel setUploadType(String uploadType) {
                        return (Cancel)super.setUploadType(uploadType);
                    }

                    public Cancel setUploadProtocol(String uploadProtocol) {
                        return (Cancel)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Cancel setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Cancel set(String parameterName, Object value) {
                        return (Cancel)super.set(parameterName, value);
                    }
                }
            }

            public class Buckets {
                public Create create(String parent, LogBucket content) throws IOException {
                    Create result = new Create(parent, content);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, LogBucket content) throws IOException {
                    Patch result = new Patch(name, content);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Undelete undelete(String name, UndeleteBucketRequest content) throws IOException {
                    Undelete result = new Undelete(name, content);
                    Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Views views() {
                    return new Views();
                }

                public class Views {
                    public Create create(String parent, LogView content) throws IOException {
                        Create result = new Create(parent, content);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String name, LogView content) throws IOException {
                        Patch result = new Patch(name, content);
                        Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Logs logs() {
                        return new Logs();
                    }

                    public class Logs {
                        public List list(String parent) throws IOException {
                            List result = new List(parent);
                            Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public class List
                        extends LoggingRequest<ListLogsResponse> {
                            private static final String REST_PATH = "v2/{+parent}/logs";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private Integer pageSize;
                            @Key
                            private String pageToken;
                            @Key
                            private java.util.List<String> resourceNames;

                            protected List(String parent) {
                                super(Logging.this, "GET", REST_PATH, null, ListLogsResponse.class);
                                this.PARENT_PATTERN = Pattern.compile("^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!Logging.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public List set$Xgafv(String $Xgafv) {
                                return (List)super.set$Xgafv($Xgafv);
                            }

                            public List setAccessToken(String accessToken) {
                                return (List)super.setAccessToken(accessToken);
                            }

                            public List setAlt(String alt) {
                                return (List)super.setAlt(alt);
                            }

                            public List setCallback(String callback) {
                                return (List)super.setCallback(callback);
                            }

                            public List setFields(String fields) {
                                return (List)super.setFields(fields);
                            }

                            public List setKey(String key) {
                                return (List)super.setKey(key);
                            }

                            public List setOauthToken(String oauthToken) {
                                return (List)super.setOauthToken(oauthToken);
                            }

                            public List setPrettyPrint(Boolean prettyPrint) {
                                return (List)super.setPrettyPrint(prettyPrint);
                            }

                            public List setQuotaUser(String quotaUser) {
                                return (List)super.setQuotaUser(quotaUser);
                            }

                            public List setUploadType(String uploadType) {
                                return (List)super.setUploadType(uploadType);
                            }

                            public List setUploadProtocol(String uploadProtocol) {
                                return (List)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public List setParent(String parent) {
                                if (!Logging.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public Integer getPageSize() {
                                return this.pageSize;
                            }

                            public List setPageSize(Integer pageSize) {
                                this.pageSize = pageSize;
                                return this;
                            }

                            public String getPageToken() {
                                return this.pageToken;
                            }

                            public List setPageToken(String pageToken) {
                                this.pageToken = pageToken;
                                return this;
                            }

                            public java.util.List<String> getResourceNames() {
                                return this.resourceNames;
                            }

                            public List setResourceNames(java.util.List<String> resourceNames) {
                                this.resourceNames = resourceNames;
                                return this;
                            }

                            @Override
                            public List set(String parameterName, Object value) {
                                return (List)super.set(parameterName, value);
                            }
                        }
                    }

                    public class Patch
                    extends LoggingRequest<LogView> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String updateMask;

                        protected Patch(String name, LogView content) {
                            super(Logging.this, "PATCH", REST_PATH, (Object)content, LogView.class);
                            this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String $Xgafv) {
                            return (Patch)super.set$Xgafv($Xgafv);
                        }

                        public Patch setAccessToken(String accessToken) {
                            return (Patch)super.setAccessToken(accessToken);
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setCallback(String callback) {
                            return (Patch)super.setCallback(callback);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUploadType(String uploadType) {
                            return (Patch)super.setUploadType(uploadType);
                        }

                        public Patch setUploadProtocol(String uploadProtocol) {
                            return (Patch)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String name) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String updateMask) {
                            this.updateMask = updateMask;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends LoggingRequest<ListViewsResponse> {
                        private static final String REST_PATH = "v2/{+parent}/views";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(Logging.this, "GET", REST_PATH, null, ListViewsResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends LoggingRequest<LogView> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(Logging.this, "GET", REST_PATH, null, LogView.class);
                            this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends LoggingRequest<Empty> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String name) {
                            super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+/views/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends LoggingRequest<LogView> {
                        private static final String REST_PATH = "v2/{+parent}/views";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String viewId;

                        protected Create(String parent, LogView content) {
                            super(Logging.this, "POST", REST_PATH, (Object)content, LogView.class);
                            this.PARENT_PATTERN = Pattern.compile("^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!Logging.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getViewId() {
                            return this.viewId;
                        }

                        public Create setViewId(String viewId) {
                            this.viewId = viewId;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                public class Undelete
                extends LoggingRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}:undelete";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Undelete(String name, UndeleteBucketRequest content) {
                        super(Logging.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                    }

                    public Undelete set$Xgafv(String $Xgafv) {
                        return (Undelete)super.set$Xgafv($Xgafv);
                    }

                    public Undelete setAccessToken(String accessToken) {
                        return (Undelete)super.setAccessToken(accessToken);
                    }

                    public Undelete setAlt(String alt) {
                        return (Undelete)super.setAlt(alt);
                    }

                    public Undelete setCallback(String callback) {
                        return (Undelete)super.setCallback(callback);
                    }

                    public Undelete setFields(String fields) {
                        return (Undelete)super.setFields(fields);
                    }

                    public Undelete setKey(String key) {
                        return (Undelete)super.setKey(key);
                    }

                    public Undelete setOauthToken(String oauthToken) {
                        return (Undelete)super.setOauthToken(oauthToken);
                    }

                    public Undelete setPrettyPrint(Boolean prettyPrint) {
                        return (Undelete)super.setPrettyPrint(prettyPrint);
                    }

                    public Undelete setQuotaUser(String quotaUser) {
                        return (Undelete)super.setQuotaUser(quotaUser);
                    }

                    public Undelete setUploadType(String uploadType) {
                        return (Undelete)super.setUploadType(uploadType);
                    }

                    public Undelete setUploadProtocol(String uploadProtocol) {
                        return (Undelete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Undelete setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Undelete set(String parameterName, Object value) {
                        return (Undelete)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends LoggingRequest<LogBucket> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, LogBucket content) {
                        super(Logging.this, "PATCH", REST_PATH, (Object)content, LogBucket.class);
                        this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends LoggingRequest<ListBucketsResponse> {
                    private static final String REST_PATH = "v2/{+parent}/buckets";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(Logging.this, "GET", REST_PATH, null, ListBucketsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^billingAccounts/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends LoggingRequest<LogBucket> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Logging.this, "GET", REST_PATH, null, LogBucket.class);
                        this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends LoggingRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+/buckets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends LoggingRequest<LogBucket> {
                    private static final String REST_PATH = "v2/{+parent}/buckets";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String bucketId;

                    protected Create(String parent, LogBucket content) {
                        super(Logging.this, "POST", REST_PATH, (Object)content, LogBucket.class);
                        this.PARENT_PATTERN = Pattern.compile("^billingAccounts/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!Logging.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getBucketId() {
                        return this.bucketId;
                    }

                    public Create setBucketId(String bucketId) {
                        this.bucketId = bucketId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class List
            extends LoggingRequest<ListLocationsResponse> {
                private static final String REST_PATH = "v2/{+name}/locations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(Logging.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends LoggingRequest<Location> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Logging.this, "GET", REST_PATH, null, Location.class);
                    this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Exclusions {
            public Create create(String parent, LogExclusion content) throws IOException {
                Create result = new Create(parent, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, LogExclusion content) throws IOException {
                Patch result = new Patch(name, content);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends LoggingRequest<LogExclusion> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String name, LogExclusion content) {
                    super(Logging.this, "PATCH", REST_PATH, (Object)content, LogExclusion.class);
                    this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/exclusions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/exclusions/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/exclusions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends LoggingRequest<ListExclusionsResponse> {
                private static final String REST_PATH = "v2/{+parent}/exclusions";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(Logging.this, "GET", REST_PATH, null, ListExclusionsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends LoggingRequest<LogExclusion> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Logging.this, "GET", REST_PATH, null, LogExclusion.class);
                    this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/exclusions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/exclusions/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/exclusions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/exclusions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/exclusions/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+/exclusions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends LoggingRequest<LogExclusion> {
                private static final String REST_PATH = "v2/{+parent}/exclusions";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, LogExclusion content) {
                    super(Logging.this, "POST", REST_PATH, (Object)content, LogExclusion.class);
                    this.PARENT_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class GetSettings
        extends LoggingRequest<Settings> {
            private static final String REST_PATH = "v2/{+name}/settings";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GetSettings(String name) {
                super(Logging.this, "GET", REST_PATH, null, Settings.class);
                this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetSettings set$Xgafv(String $Xgafv) {
                return (GetSettings)super.set$Xgafv($Xgafv);
            }

            public GetSettings setAccessToken(String accessToken) {
                return (GetSettings)super.setAccessToken(accessToken);
            }

            public GetSettings setAlt(String alt) {
                return (GetSettings)super.setAlt(alt);
            }

            public GetSettings setCallback(String callback) {
                return (GetSettings)super.setCallback(callback);
            }

            public GetSettings setFields(String fields) {
                return (GetSettings)super.setFields(fields);
            }

            public GetSettings setKey(String key) {
                return (GetSettings)super.setKey(key);
            }

            public GetSettings setOauthToken(String oauthToken) {
                return (GetSettings)super.setOauthToken(oauthToken);
            }

            public GetSettings setPrettyPrint(Boolean prettyPrint) {
                return (GetSettings)super.setPrettyPrint(prettyPrint);
            }

            public GetSettings setQuotaUser(String quotaUser) {
                return (GetSettings)super.setQuotaUser(quotaUser);
            }

            public GetSettings setUploadType(String uploadType) {
                return (GetSettings)super.setUploadType(uploadType);
            }

            public GetSettings setUploadProtocol(String uploadProtocol) {
                return (GetSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GetSettings setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public GetSettings set(String parameterName, Object value) {
                return (GetSettings)super.set(parameterName, value);
            }
        }

        public class GetCmekSettings
        extends LoggingRequest<CmekSettings> {
            private static final String REST_PATH = "v2/{+name}/cmekSettings";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GetCmekSettings(String name) {
                super(Logging.this, "GET", REST_PATH, null, CmekSettings.class);
                this.NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetCmekSettings set$Xgafv(String $Xgafv) {
                return (GetCmekSettings)super.set$Xgafv($Xgafv);
            }

            public GetCmekSettings setAccessToken(String accessToken) {
                return (GetCmekSettings)super.setAccessToken(accessToken);
            }

            public GetCmekSettings setAlt(String alt) {
                return (GetCmekSettings)super.setAlt(alt);
            }

            public GetCmekSettings setCallback(String callback) {
                return (GetCmekSettings)super.setCallback(callback);
            }

            public GetCmekSettings setFields(String fields) {
                return (GetCmekSettings)super.setFields(fields);
            }

            public GetCmekSettings setKey(String key) {
                return (GetCmekSettings)super.setKey(key);
            }

            public GetCmekSettings setOauthToken(String oauthToken) {
                return (GetCmekSettings)super.setOauthToken(oauthToken);
            }

            public GetCmekSettings setPrettyPrint(Boolean prettyPrint) {
                return (GetCmekSettings)super.setPrettyPrint(prettyPrint);
            }

            public GetCmekSettings setQuotaUser(String quotaUser) {
                return (GetCmekSettings)super.setQuotaUser(quotaUser);
            }

            public GetCmekSettings setUploadType(String uploadType) {
                return (GetCmekSettings)super.setUploadType(uploadType);
            }

            public GetCmekSettings setUploadProtocol(String uploadProtocol) {
                return (GetCmekSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GetCmekSettings setName(String name) {
                if (!Logging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^billingAccounts/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public GetCmekSettings set(String parameterName, Object value) {
                return (GetCmekSettings)super.set(parameterName, value);
            }
        }
    }
}

