/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.manufacturers.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.manufacturers.v1.ManufacturerCenterRequest;
import com.google.api.services.manufacturers.v1.ManufacturerCenterRequestInitializer;
import com.google.api.services.manufacturers.v1.model.Attributes;
import com.google.api.services.manufacturers.v1.model.Empty;
import com.google.api.services.manufacturers.v1.model.ListProductsResponse;
import com.google.api.services.manufacturers.v1.model.Product;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManufacturerCenter
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://manufacturers.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://manufacturers.googleapis.com/";

    public ManufacturerCenter(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    ManufacturerCenter(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Accounts accounts() {
        return new Accounts();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.23.0 of the Manufacturer Center API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://manufacturers.googleapis.com/", ManufacturerCenter.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(ManufacturerCenter.DEFAULT_BATCH_PATH);
        }

        public ManufacturerCenter build() {
            return new ManufacturerCenter(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setManufacturerCenterRequestInitializer(ManufacturerCenterRequestInitializer manufacturerCenterRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)manufacturerCenterRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Accounts {
        public Products products() {
            return new Products();
        }

        public class Products {
            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                ManufacturerCenter.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                ManufacturerCenter.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                ManufacturerCenter.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Update update(String string, String string2, Attributes attributes) throws IOException {
                Update update = new Update(string, string2, attributes);
                ManufacturerCenter.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends ManufacturerCenterRequest<Empty> {
                private static final String REST_PATH = "v1/{+parent}/products/{+name}";
                private final Pattern PARENT_PATTERN;
                private final Pattern NAME_PATTERN;
                @Key
                private String parent;
                @Key
                private String name;

                protected Update(String string, String string2, Attributes attributes) {
                    super(ManufacturerCenter.this, "PUT", REST_PATH, (Object)attributes, Empty.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.NAME_PATTERN = Pattern.compile("^[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!ManufacturerCenter.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.name = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter name must be specified.");
                    if (!ManufacturerCenter.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string2).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+$");
                    }
                }

                public Update set$Xgafv(String string) {
                    return (Update)super.set$Xgafv(string);
                }

                public Update setAccessToken(String string) {
                    return (Update)super.setAccessToken(string);
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setBearerToken(String string) {
                    return (Update)super.setBearerToken(string);
                }

                public Update setCallback(String string) {
                    return (Update)super.setCallback(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPp(Boolean bl) {
                    return (Update)super.setPp(bl);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUploadType(String string) {
                    return (Update)super.setUploadType(string);
                }

                public Update setUploadProtocol(String string) {
                    return (Update)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Update setParent(String string) {
                    if (!ManufacturerCenter.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getName() {
                    return this.name;
                }

                public Update setName(String string) {
                    if (!ManufacturerCenter.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends ManufacturerCenterRequest<ListProductsResponse> {
                private static final String REST_PATH = "v1/{+parent}/products";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private java.util.List<String> include;
                @Key
                private String pageToken;

                protected List(String string) {
                    super(ManufacturerCenter.this, "GET", REST_PATH, null, ListProductsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!ManufacturerCenter.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!ManufacturerCenter.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public java.util.List<String> getInclude() {
                    return this.include;
                }

                public List setInclude(java.util.List<String> list) {
                    this.include = list;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends ManufacturerCenterRequest<Product> {
                private static final String REST_PATH = "v1/{+parent}/products/{+name}";
                private final Pattern PARENT_PATTERN;
                private final Pattern NAME_PATTERN;
                @Key
                private String parent;
                @Key
                private String name;
                @Key
                private java.util.List<String> include;

                protected Get(String string, String string2) {
                    super(ManufacturerCenter.this, "GET", REST_PATH, null, Product.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.NAME_PATTERN = Pattern.compile("^[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!ManufacturerCenter.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.name = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter name must be specified.");
                    if (!ManufacturerCenter.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string2).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Get setParent(String string) {
                    if (!ManufacturerCenter.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String string) {
                    if (!ManufacturerCenter.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                public java.util.List<String> getInclude() {
                    return this.include;
                }

                public Get setInclude(java.util.List<String> list) {
                    this.include = list;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends ManufacturerCenterRequest<Empty> {
                private static final String REST_PATH = "v1/{+parent}/products/{+name}";
                private final Pattern PARENT_PATTERN;
                private final Pattern NAME_PATTERN;
                @Key
                private String parent;
                @Key
                private String name;

                protected Delete(String string, String string2) {
                    super(ManufacturerCenter.this, "DELETE", REST_PATH, null, Empty.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.NAME_PATTERN = Pattern.compile("^[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!ManufacturerCenter.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.name = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter name must be specified.");
                    if (!ManufacturerCenter.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string2).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Delete setParent(String string) {
                    if (!ManufacturerCenter.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String string) {
                    if (!ManufacturerCenter.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }
    }
}

