/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.mirror;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.mirror.MirrorRequest;
import com.google.api.services.mirror.MirrorRequestInitializer;
import com.google.api.services.mirror.model.Attachment;
import com.google.api.services.mirror.model.AttachmentsListResponse;
import com.google.api.services.mirror.model.Contact;
import com.google.api.services.mirror.model.ContactsListResponse;
import com.google.api.services.mirror.model.Location;
import com.google.api.services.mirror.model.LocationsListResponse;
import com.google.api.services.mirror.model.Subscription;
import com.google.api.services.mirror.model.SubscriptionsListResponse;
import com.google.api.services.mirror.model.TimelineItem;
import com.google.api.services.mirror.model.TimelineListResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mirror
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "mirror/v1/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/mirror/v1/";

    public Mirror(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Mirror(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Contacts contacts() {
        return new Contacts();
    }

    public Locations locations() {
        return new Locations();
    }

    public Subscriptions subscriptions() {
        return new Subscriptions();
    }

    public Timeline timeline() {
        return new Timeline();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.17.0-rc of the Google Mirror API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Mirror.DEFAULT_ROOT_URL, Mirror.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Mirror build() {
            return new Mirror(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setMirrorRequestInitializer(MirrorRequestInitializer mirrorRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)mirrorRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Timeline {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(TimelineItem timelineItem) throws IOException {
            Insert insert = new Insert(timelineItem);
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public Insert insert(TimelineItem timelineItem, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Insert insert = new Insert(timelineItem, abstractInputStreamContent);
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list() throws IOException {
            List list = new List();
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, TimelineItem timelineItem) throws IOException {
            Patch patch = new Patch(string, timelineItem);
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, TimelineItem timelineItem) throws IOException {
            Update update = new Update(string, timelineItem);
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        public Update update(String string, TimelineItem timelineItem, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Update update = new Update(string, timelineItem, abstractInputStreamContent);
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        public Attachments attachments() {
            return new Attachments();
        }

        public class Attachments {
            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Mirror.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Mirror.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Insert insert(String string) throws IOException {
                Insert insert = new Insert(string);
                Mirror.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public Insert insert(String string, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                Insert insert = new Insert(string, abstractInputStreamContent);
                Mirror.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Mirror.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MirrorRequest<AttachmentsListResponse> {
                private static final String REST_PATH = "timeline/{itemId}/attachments";
                @Key
                private String itemId;

                protected List(String string) {
                    super(Mirror.this, "GET", REST_PATH, null, AttachmentsListResponse.class);
                    this.itemId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter itemId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getItemId() {
                    return this.itemId;
                }

                public List setItemId(String string) {
                    this.itemId = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends MirrorRequest<Attachment> {
                private static final String REST_PATH = "timeline/{itemId}/attachments";
                @Key
                private String itemId;

                protected Insert(String string) {
                    super(Mirror.this, "POST", REST_PATH, null, Attachment.class);
                    this.itemId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter itemId must be specified.");
                }

                protected Insert(String string, AbstractInputStreamContent abstractInputStreamContent) {
                    super(Mirror.this, "POST", "/upload/" + Mirror.this.getServicePath() + REST_PATH, null, Attachment.class);
                    this.itemId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter itemId must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getItemId() {
                    return this.itemId;
                }

                public Insert setItemId(String string) {
                    this.itemId = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends MirrorRequest<Attachment> {
                private static final String REST_PATH = "timeline/{itemId}/attachments/{attachmentId}";
                @Key
                private String itemId;
                @Key
                private String attachmentId;

                protected Get(String string, String string2) {
                    super(Mirror.this, "GET", REST_PATH, null, Attachment.class);
                    this.itemId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter itemId must be specified.");
                    this.attachmentId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter attachmentId must be specified.");
                    this.initializeMediaDownload();
                }

                public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                    super.executeMediaAndDownloadTo(outputStream);
                }

                public InputStream executeMediaAsInputStream() throws IOException {
                    return super.executeMediaAsInputStream();
                }

                public HttpResponse executeMedia() throws IOException {
                    return super.executeMedia();
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getItemId() {
                    return this.itemId;
                }

                public Get setItemId(String string) {
                    this.itemId = string;
                    return this;
                }

                public String getAttachmentId() {
                    return this.attachmentId;
                }

                public Get setAttachmentId(String string) {
                    this.attachmentId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends MirrorRequest<Void> {
                private static final String REST_PATH = "timeline/{itemId}/attachments/{attachmentId}";
                @Key
                private String itemId;
                @Key
                private String attachmentId;

                protected Delete(String string, String string2) {
                    super(Mirror.this, "DELETE", REST_PATH, null, Void.class);
                    this.itemId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter itemId must be specified.");
                    this.attachmentId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter attachmentId must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getItemId() {
                    return this.itemId;
                }

                public Delete setItemId(String string) {
                    this.itemId = string;
                    return this;
                }

                public String getAttachmentId() {
                    return this.attachmentId;
                }

                public Delete setAttachmentId(String string) {
                    this.attachmentId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends MirrorRequest<TimelineItem> {
            private static final String REST_PATH = "timeline/{id}";
            @Key
            private String id;

            protected Update(String string, TimelineItem timelineItem) {
                super(Mirror.this, "PUT", REST_PATH, (Object)timelineItem, TimelineItem.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            protected Update(String string, TimelineItem timelineItem, AbstractInputStreamContent abstractInputStreamContent) {
                super(Mirror.this, "PUT", "/upload/" + Mirror.this.getServicePath() + REST_PATH, (Object)timelineItem, TimelineItem.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Update setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends MirrorRequest<TimelineItem> {
            private static final String REST_PATH = "timeline/{id}";
            @Key
            private String id;

            protected Patch(String string, TimelineItem timelineItem) {
                super(Mirror.this, "PATCH", REST_PATH, (Object)timelineItem, TimelineItem.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Patch setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends MirrorRequest<TimelineListResponse> {
            private static final String REST_PATH = "timeline";
            @Key
            private String orderBy;
            @Key
            private Boolean includeDeleted;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String sourceItemId;
            @Key
            private Boolean pinnedOnly;
            @Key
            private String bundleId;

            protected List() {
                super(Mirror.this, "GET", REST_PATH, null, TimelineListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public List setIncludeDeleted(Boolean bl) {
                this.includeDeleted = bl;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getSourceItemId() {
                return this.sourceItemId;
            }

            public List setSourceItemId(String string) {
                this.sourceItemId = string;
                return this;
            }

            public Boolean getPinnedOnly() {
                return this.pinnedOnly;
            }

            public List setPinnedOnly(Boolean bl) {
                this.pinnedOnly = bl;
                return this;
            }

            public String getBundleId() {
                return this.bundleId;
            }

            public List setBundleId(String string) {
                this.bundleId = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends MirrorRequest<TimelineItem> {
            private static final String REST_PATH = "timeline";

            protected Insert(TimelineItem timelineItem) {
                super(Mirror.this, "POST", REST_PATH, (Object)timelineItem, TimelineItem.class);
            }

            protected Insert(TimelineItem timelineItem, AbstractInputStreamContent abstractInputStreamContent) {
                super(Mirror.this, "POST", "/upload/" + Mirror.this.getServicePath() + REST_PATH, (Object)timelineItem, TimelineItem.class);
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends MirrorRequest<TimelineItem> {
            private static final String REST_PATH = "timeline/{id}";
            @Key
            private String id;

            protected Get(String string) {
                super(Mirror.this, "GET", REST_PATH, null, TimelineItem.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends MirrorRequest<Void> {
            private static final String REST_PATH = "timeline/{id}";
            @Key
            private String id;

            protected Delete(String string) {
                super(Mirror.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Subscriptions {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Insert insert(Subscription subscription) throws IOException {
            Insert insert = new Insert(subscription);
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list() throws IOException {
            List list = new List();
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Update update(String string, Subscription subscription) throws IOException {
            Update update = new Update(string, subscription);
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends MirrorRequest<Subscription> {
            private static final String REST_PATH = "subscriptions/{id}";
            @Key
            private String id;

            protected Update(String string, Subscription subscription) {
                super(Mirror.this, "PUT", REST_PATH, (Object)subscription, Subscription.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                this.checkRequiredParameter((Object)subscription, "content");
                this.checkRequiredParameter(subscription.getCallbackUrl(), "Subscription.getCallbackUrl()");
                this.checkRequiredParameter((Object)subscription, "content");
                this.checkRequiredParameter(subscription.getCollection(), "Subscription.getCollection()");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Update setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends MirrorRequest<SubscriptionsListResponse> {
            private static final String REST_PATH = "subscriptions";

            protected List() {
                super(Mirror.this, "GET", REST_PATH, null, SubscriptionsListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends MirrorRequest<Subscription> {
            private static final String REST_PATH = "subscriptions";

            protected Insert(Subscription subscription) {
                super(Mirror.this, "POST", REST_PATH, (Object)subscription, Subscription.class);
                this.checkRequiredParameter((Object)subscription, "content");
                this.checkRequiredParameter(subscription.getCallbackUrl(), "Subscription.getCallbackUrl()");
                this.checkRequiredParameter((Object)subscription, "content");
                this.checkRequiredParameter(subscription.getCollection(), "Subscription.getCollection()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends MirrorRequest<Void> {
            private static final String REST_PATH = "subscriptions/{id}";
            @Key
            private String id;

            protected Delete(String string) {
                super(Mirror.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Locations {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends MirrorRequest<LocationsListResponse> {
            private static final String REST_PATH = "locations";

            protected List() {
                super(Mirror.this, "GET", REST_PATH, null, LocationsListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends MirrorRequest<Location> {
            private static final String REST_PATH = "locations/{id}";
            @Key
            private String id;

            protected Get(String string) {
                super(Mirror.this, "GET", REST_PATH, null, Location.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Contacts {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(Contact contact) throws IOException {
            Insert insert = new Insert(contact);
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list() throws IOException {
            List list = new List();
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, Contact contact) throws IOException {
            Patch patch = new Patch(string, contact);
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, Contact contact) throws IOException {
            Update update = new Update(string, contact);
            Mirror.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends MirrorRequest<Contact> {
            private static final String REST_PATH = "contacts/{id}";
            @Key
            private String id;

            protected Update(String string, Contact contact) {
                super(Mirror.this, "PUT", REST_PATH, (Object)contact, Contact.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                this.checkRequiredParameter((Object)contact, "content");
                this.checkRequiredParameter(contact.getDisplayName(), "Contact.getDisplayName()");
                this.checkRequiredParameter((Object)contact, "content");
                this.checkRequiredParameter(contact.getId(), "Contact.getId()");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Update setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends MirrorRequest<Contact> {
            private static final String REST_PATH = "contacts/{id}";
            @Key
            private String id;

            protected Patch(String string, Contact contact) {
                super(Mirror.this, "PATCH", REST_PATH, (Object)contact, Contact.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Patch setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends MirrorRequest<ContactsListResponse> {
            private static final String REST_PATH = "contacts";

            protected List() {
                super(Mirror.this, "GET", REST_PATH, null, ContactsListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends MirrorRequest<Contact> {
            private static final String REST_PATH = "contacts";

            protected Insert(Contact contact) {
                super(Mirror.this, "POST", REST_PATH, (Object)contact, Contact.class);
                this.checkRequiredParameter((Object)contact, "content");
                this.checkRequiredParameter(contact.getDisplayName(), "Contact.getDisplayName()");
                this.checkRequiredParameter((Object)contact, "content");
                this.checkRequiredParameter(contact.getId(), "Contact.getId()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends MirrorRequest<Contact> {
            private static final String REST_PATH = "contacts/{id}";
            @Key
            private String id;

            protected Get(String string) {
                super(Mirror.this, "GET", REST_PATH, null, Contact.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends MirrorRequest<Void> {
            private static final String REST_PATH = "contacts/{id}";
            @Key
            private String id;

            protected Delete(String string) {
                super(Mirror.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }
}

