/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-12 at 20:40:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.monitoring.v3;

/**
 * Service definition for Monitoring (v3).
 *
 * <p>
 * Manages your Stackdriver Monitoring data and configurations. Most projects must be associated with a Stackdriver account, with a few exceptions as noted on the individual method pages.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/monitoring/api/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link MonitoringRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Monitoring extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.25.0 of the Stackdriver Monitoring API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://monitoring.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Monitoring(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Monitoring(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Monitoring monitoring = new Monitoring(...);}
   *   {@code Monitoring.Projects.List request = monitoring.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * An accessor for creating requests from the AlertPolicies collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Monitoring monitoring = new Monitoring(...);}
     *   {@code Monitoring.AlertPolicies.List request = monitoring.alertPolicies().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public AlertPolicies alertPolicies() {
      return new AlertPolicies();
    }

    /**
     * The "alertPolicies" collection of methods.
     */
    public class AlertPolicies {

      /**
       * Creates a new alerting policy.
       *
       * Create a request for the method "alertPolicies.create".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param name The project in which to create the alerting policy. The format is projects/[PROJECT_ID].Note that
       *        this field names the parent container in which the alerting policy will be written, not
       *        the name of the created policy. The alerting policy that is returned will have a name that
       *        contains a normalized representation of this name as a prefix but adds a suffix of the
       *        form /alertPolicies/[POLICY_ID], identifying the policy in the container.
       * @param content the {@link com.google.api.services.monitoring.v3.model.AlertPolicy}
       * @return the request
       */
      public Create create(java.lang.String name, com.google.api.services.monitoring.v3.model.AlertPolicy content) throws java.io.IOException {
        Create result = new Create(name, content);
        initialize(result);
        return result;
      }

      public class Create extends MonitoringRequest<com.google.api.services.monitoring.v3.model.AlertPolicy> {

        private static final String REST_PATH = "v3/{+name}/alertPolicies";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Creates a new alerting policy.
         *
         * Create a request for the method "alertPolicies.create".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The project in which to create the alerting policy. The format is projects/[PROJECT_ID].Note that
       *        this field names the parent container in which the alerting policy will be written, not
       *        the name of the created policy. The alerting policy that is returned will have a name that
       *        contains a normalized representation of this name as a prefix but adds a suffix of the
       *        form /alertPolicies/[POLICY_ID], identifying the policy in the container.
         * @param content the {@link com.google.api.services.monitoring.v3.model.AlertPolicy}
         * @since 1.13
         */
        protected Create(java.lang.String name, com.google.api.services.monitoring.v3.model.AlertPolicy content) {
          super(Monitoring.this, "POST", REST_PATH, content, com.google.api.services.monitoring.v3.model.AlertPolicy.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The project in which to create the alerting policy. The format is
         * projects/[PROJECT_ID].Note that this field names the parent container in which the
         * alerting policy will be written, not the name of the created policy. The alerting policy
         * that is returned will have a name that contains a normalized representation of this name
         * as a prefix but adds a suffix of the form /alertPolicies/[POLICY_ID], identifying the
         * policy in the container.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The project in which to create the alerting policy. The format is projects/[PROJECT_ID].Note that
       this field names the parent container in which the alerting policy will be written, not the name of
       the created policy. The alerting policy that is returned will have a name that contains a
       normalized representation of this name as a prefix but adds a suffix of the form
       /alertPolicies/[POLICY_ID], identifying the policy in the container.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The project in which to create the alerting policy. The format is
         * projects/[PROJECT_ID].Note that this field names the parent container in which the
         * alerting policy will be written, not the name of the created policy. The alerting policy
         * that is returned will have a name that contains a normalized representation of this name
         * as a prefix but adds a suffix of the form /alertPolicies/[POLICY_ID], identifying the
         * policy in the container.
         */
        public Create setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes an alerting policy.
       *
       * Create a request for the method "alertPolicies.delete".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name The alerting policy to delete. The format is:
      projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID]
       *        For more information, see AlertPolicy.
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends MonitoringRequest<com.google.api.services.monitoring.v3.model.Empty> {

        private static final String REST_PATH = "v3/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/alertPolicies/[^/]+$");

        /**
         * Deletes an alerting policy.
         *
         * Create a request for the method "alertPolicies.delete".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The alerting policy to delete. The format is:
      projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID]
       *        For more information, see AlertPolicy.
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(Monitoring.this, "DELETE", REST_PATH, null, com.google.api.services.monitoring.v3.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/alertPolicies/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The alerting policy to delete. The format is:
         * projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID] For more information, see
         * AlertPolicy.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The alerting policy to delete. The format is: projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID]
       For more information, see AlertPolicy.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The alerting policy to delete. The format is:
         * projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID] For more information, see
         * AlertPolicy.
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/alertPolicies/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets a single alerting policy.
       *
       * Create a request for the method "alertPolicies.get".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name The alerting policy to retrieve. The format is
      projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID]
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends MonitoringRequest<com.google.api.services.monitoring.v3.model.AlertPolicy> {

        private static final String REST_PATH = "v3/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/alertPolicies/[^/]+$");

        /**
         * Gets a single alerting policy.
         *
         * Create a request for the method "alertPolicies.get".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The alerting policy to retrieve. The format is
      projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID]
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Monitoring.this, "GET", REST_PATH, null, com.google.api.services.monitoring.v3.model.AlertPolicy.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/alertPolicies/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The alerting policy to retrieve. The format is
         * projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID]
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The alerting policy to retrieve. The format is
       projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID]
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The alerting policy to retrieve. The format is
         * projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID]
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/alertPolicies/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists the existing alerting policies for the project.
       *
       * Create a request for the method "alertPolicies.list".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param name The project whose alert policies are to be listed. The format is
      projects/[PROJECT_ID]
      Note that
       *        this field names the parent container in which the alerting policies to be listed are
       *        stored. To retrieve a single alerting policy by name, use the GetAlertPolicy operation,
       *        instead.
       * @return the request
       */
      public List list(java.lang.String name) throws java.io.IOException {
        List result = new List(name);
        initialize(result);
        return result;
      }

      public class List extends MonitoringRequest<com.google.api.services.monitoring.v3.model.ListAlertPoliciesResponse> {

        private static final String REST_PATH = "v3/{+name}/alertPolicies";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists the existing alerting policies for the project.
         *
         * Create a request for the method "alertPolicies.list".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The project whose alert policies are to be listed. The format is
      projects/[PROJECT_ID]
      Note that
       *        this field names the parent container in which the alerting policies to be listed are
       *        stored. To retrieve a single alerting policy by name, use the GetAlertPolicy operation,
       *        instead.
         * @since 1.13
         */
        protected List(java.lang.String name) {
          super(Monitoring.this, "GET", REST_PATH, null, com.google.api.services.monitoring.v3.model.ListAlertPoliciesResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The project whose alert policies are to be listed. The format is projects/[PROJECT_ID]
         * Note that this field names the parent container in which the alerting policies to be
         * listed are stored. To retrieve a single alerting policy by name, use the GetAlertPolicy
         * operation, instead.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The project whose alert policies are to be listed. The format is projects/[PROJECT_ID] Note that
       this field names the parent container in which the alerting policies to be listed are stored. To
       retrieve a single alerting policy by name, use the GetAlertPolicy operation, instead.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The project whose alert policies are to be listed. The format is projects/[PROJECT_ID]
         * Note that this field names the parent container in which the alerting policies to be
         * listed are stored. To retrieve a single alerting policy by name, use the GetAlertPolicy
         * operation, instead.
         */
        public List setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * If provided, this field specifies the criteria that must be met by alert policies to be
         * included in the response.For more details, see sorting and filtering.
         */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** If provided, this field specifies the criteria that must be met by alert policies to be included in
       the response.For more details, see sorting and filtering.
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /**
         * If provided, this field specifies the criteria that must be met by alert policies to be
         * included in the response.For more details, see sorting and filtering.
         */
        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        /**
         * A comma-separated list of fields by which to sort the result. Supports the same set of
         * field references as the filter field. Entries can be prefixed with a minus sign to sort
         * by the field in descending order.For more details, see sorting and filtering.
         */
        @com.google.api.client.util.Key
        private java.lang.String orderBy;

        /** A comma-separated list of fields by which to sort the result. Supports the same set of field
       references as the filter field. Entries can be prefixed with a minus sign to sort by the field in
       descending order.For more details, see sorting and filtering.
         */
        public java.lang.String getOrderBy() {
          return orderBy;
        }

        /**
         * A comma-separated list of fields by which to sort the result. Supports the same set of
         * field references as the filter field. Entries can be prefixed with a minus sign to sort
         * by the field in descending order.For more details, see sorting and filtering.
         */
        public List setOrderBy(java.lang.String orderBy) {
          this.orderBy = orderBy;
          return this;
        }

        /**
         * If this field is not empty then it must contain the nextPageToken value returned by a
         * previous call to this method. Using this field causes the method to return more results
         * from the previous method call.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** If this field is not empty then it must contain the nextPageToken value returned by a previous call
       to this method. Using this field causes the method to return more results from the previous method
       call.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * If this field is not empty then it must contain the nextPageToken value returned by a
         * previous call to this method. Using this field causes the method to return more results
         * from the previous method call.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /** The maximum number of results to return in a single response. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The maximum number of results to return in a single response.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** The maximum number of results to return in a single response. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates an alerting policy. You can either replace the entire policy with a new one or replace
       * only certain fields in the current alerting policy by specifying the fields to be updated via
       * updateMask. Returns the updated alerting policy.
       *
       * Create a request for the method "alertPolicies.patch".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name Required if the policy exists. The resource name for this policy. The syntax is:
       *        projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID]
      [ALERT_POLICY_ID] is assigned by
       *        Stackdriver Monitoring when the policy is created. When calling the alertPolicies.create
       *        method, do not include the name field in the alerting policy passed as part of the
       *        request.
       * @param content the {@link com.google.api.services.monitoring.v3.model.AlertPolicy}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.monitoring.v3.model.AlertPolicy content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends MonitoringRequest<com.google.api.services.monitoring.v3.model.AlertPolicy> {

        private static final String REST_PATH = "v3/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/alertPolicies/[^/]+$");

        /**
         * Updates an alerting policy. You can either replace the entire policy with a new one or replace
         * only certain fields in the current alerting policy by specifying the fields to be updated via
         * updateMask. Returns the updated alerting policy.
         *
         * Create a request for the method "alertPolicies.patch".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required if the policy exists. The resource name for this policy. The syntax is:
       *        projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID]
      [ALERT_POLICY_ID] is assigned by
       *        Stackdriver Monitoring when the policy is created. When calling the alertPolicies.create
       *        method, do not include the name field in the alerting policy passed as part of the
       *        request.
         * @param content the {@link com.google.api.services.monitoring.v3.model.AlertPolicy}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.monitoring.v3.model.AlertPolicy content) {
          super(Monitoring.this, "PATCH", REST_PATH, content, com.google.api.services.monitoring.v3.model.AlertPolicy.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/alertPolicies/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required if the policy exists. The resource name for this policy. The syntax is:
         * projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID] [ALERT_POLICY_ID] is assigned by
         * Stackdriver Monitoring when the policy is created. When calling the alertPolicies.create
         * method, do not include the name field in the alerting policy passed as part of the
         * request.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required if the policy exists. The resource name for this policy. The syntax is:
       projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID] [ALERT_POLICY_ID] is assigned by Stackdriver
       Monitoring when the policy is created. When calling the alertPolicies.create method, do not include
       the name field in the alerting policy passed as part of the request.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required if the policy exists. The resource name for this policy. The syntax is:
         * projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID] [ALERT_POLICY_ID] is assigned by
         * Stackdriver Monitoring when the policy is created. When calling the alertPolicies.create
         * method, do not include the name field in the alerting policy passed as part of the
         * request.
         */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/alertPolicies/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * Optional. A list of alerting policy field names. If this field is not empty, each listed
         * field in the existing alerting policy is set to the value of the corresponding field in
         * the supplied policy (alert_policy), or to the field's default value if the field is not
         * in the supplied alerting policy. Fields not listed retain their previous value.Examples
         * of valid field masks include display_name, documentation, documentation.content,
         * documentation.mime_type, user_labels, user_label.nameofkey, enabled, conditions,
         * combiner, etc.If this field is empty, then the supplied alerting policy replaces the
         * existing policy. It is the same as deleting the existing policy and adding the supplied
         * policy, except for the following: The new policy will have the same [ALERT_POLICY_ID] as
         * the former policy. This gives you continuity with the former policy in your notifications
         * and incidents. Conditions in the new policy will keep their former [CONDITION_ID] if the
         * supplied condition includes the name field with that [CONDITION_ID]. If the supplied
         * condition omits the name field, then a new [CONDITION_ID] is created.
         */
        @com.google.api.client.util.Key
        private String updateMask;

        /** Optional. A list of alerting policy field names. If this field is not empty, each listed field in
       the existing alerting policy is set to the value of the corresponding field in the supplied policy
       (alert_policy), or to the field's default value if the field is not in the supplied alerting
       policy. Fields not listed retain their previous value.Examples of valid field masks include
       display_name, documentation, documentation.content, documentation.mime_type, user_labels,
       user_label.nameofkey, enabled, conditions, combiner, etc.If this field is empty, then the supplied
       alerting policy replaces the existing policy. It is the same as deleting the existing policy and
       adding the supplied policy, except for the following: The new policy will have the same
       [ALERT_POLICY_ID] as the former policy. This gives you continuity with the former policy in your
       notifications and incidents. Conditions in the new policy will keep their former [CONDITION_ID] if
       the supplied condition includes the name field with that [CONDITION_ID]. If the supplied condition
       omits the name field, then a new [CONDITION_ID] is created.
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /**
         * Optional. A list of alerting policy field names. If this field is not empty, each listed
         * field in the existing alerting policy is set to the value of the corresponding field in
         * the supplied policy (alert_policy), or to the field's default value if the field is not
         * in the supplied alerting policy. Fields not listed retain their previous value.Examples
         * of valid field masks include display_name, documentation, documentation.content,
         * documentation.mime_type, user_labels, user_label.nameofkey, enabled, conditions,
         * combiner, etc.If this field is empty, then the supplied alerting policy replaces the
         * existing policy. It is the same as deleting the existing policy and adding the supplied
         * policy, except for the following: The new policy will have the same [ALERT_POLICY_ID] as
         * the former policy. This gives you continuity with the former policy in your notifications
         * and incidents. Conditions in the new policy will keep their former [CONDITION_ID] if the
         * supplied condition includes the name field with that [CONDITION_ID]. If the supplied
         * condition omits the name field, then a new [CONDITION_ID] is created.
         */
        public Patch setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the CollectdTimeSeries collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Monitoring monitoring = new Monitoring(...);}
     *   {@code Monitoring.CollectdTimeSeries.List request = monitoring.collectdTimeSeries().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public CollectdTimeSeries collectdTimeSeries() {
      return new CollectdTimeSeries();
    }

    /**
     * The "collectdTimeSeries" collection of methods.
     */
    public class CollectdTimeSeries {

      /**
       * Stackdriver Monitoring Agent only: Creates a new time series.This method is only for use by the
       * Stackdriver Monitoring Agent. Use projects.timeSeries.create instead.
       *
       * Create a request for the method "collectdTimeSeries.create".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param name The project in which to create the time series. The format is "projects/PROJECT_ID_OR_NUMBER".
       * @param content the {@link com.google.api.services.monitoring.v3.model.CreateCollectdTimeSeriesRequest}
       * @return the request
       */
      public Create create(java.lang.String name, com.google.api.services.monitoring.v3.model.CreateCollectdTimeSeriesRequest content) throws java.io.IOException {
        Create result = new Create(name, content);
        initialize(result);
        return result;
      }

      public class Create extends MonitoringRequest<com.google.api.services.monitoring.v3.model.CreateCollectdTimeSeriesResponse> {

        private static final String REST_PATH = "v3/{+name}/collectdTimeSeries";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Stackdriver Monitoring Agent only: Creates a new time series.This method is only for use by the
         * Stackdriver Monitoring Agent. Use projects.timeSeries.create instead.
         *
         * Create a request for the method "collectdTimeSeries.create".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The project in which to create the time series. The format is "projects/PROJECT_ID_OR_NUMBER".
         * @param content the {@link com.google.api.services.monitoring.v3.model.CreateCollectdTimeSeriesRequest}
         * @since 1.13
         */
        protected Create(java.lang.String name, com.google.api.services.monitoring.v3.model.CreateCollectdTimeSeriesRequest content) {
          super(Monitoring.this, "POST", REST_PATH, content, com.google.api.services.monitoring.v3.model.CreateCollectdTimeSeriesResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The project in which to create the time series. The format is
         * "projects/PROJECT_ID_OR_NUMBER".
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The project in which to create the time series. The format is "projects/PROJECT_ID_OR_NUMBER".
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The project in which to create the time series. The format is
         * "projects/PROJECT_ID_OR_NUMBER".
         */
        public Create setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Groups collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Monitoring monitoring = new Monitoring(...);}
     *   {@code Monitoring.Groups.List request = monitoring.groups().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Groups groups() {
      return new Groups();
    }

    /**
     * The "groups" collection of methods.
     */
    public class Groups {

      /**
       * Creates a new group.
       *
       * Create a request for the method "groups.create".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param name The project in which to create the group. The format is "projects/{project_id_or_number}".
       * @param content the {@link com.google.api.services.monitoring.v3.model.Group}
       * @return the request
       */
      public Create create(java.lang.String name, com.google.api.services.monitoring.v3.model.Group content) throws java.io.IOException {
        Create result = new Create(name, content);
        initialize(result);
        return result;
      }

      public class Create extends MonitoringRequest<com.google.api.services.monitoring.v3.model.Group> {

        private static final String REST_PATH = "v3/{+name}/groups";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Creates a new group.
         *
         * Create a request for the method "groups.create".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The project in which to create the group. The format is "projects/{project_id_or_number}".
         * @param content the {@link com.google.api.services.monitoring.v3.model.Group}
         * @since 1.13
         */
        protected Create(java.lang.String name, com.google.api.services.monitoring.v3.model.Group content) {
          super(Monitoring.this, "POST", REST_PATH, content, com.google.api.services.monitoring.v3.model.Group.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The project in which to create the group. The format is
         * "projects/{project_id_or_number}".
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The project in which to create the group. The format is "projects/{project_id_or_number}".
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The project in which to create the group. The format is
         * "projects/{project_id_or_number}".
         */
        public Create setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /** If true, validate this request but do not create the group. */
        @com.google.api.client.util.Key
        private java.lang.Boolean validateOnly;

        /** If true, validate this request but do not create the group.
         */
        public java.lang.Boolean getValidateOnly() {
          return validateOnly;
        }

        /** If true, validate this request but do not create the group. */
        public Create setValidateOnly(java.lang.Boolean validateOnly) {
          this.validateOnly = validateOnly;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes an existing group.
       *
       * Create a request for the method "groups.delete".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name The group to delete. The format is "projects/{project_id_or_number}/groups/{group_id}".
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends MonitoringRequest<com.google.api.services.monitoring.v3.model.Empty> {

        private static final String REST_PATH = "v3/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/groups/[^/]+$");

        /**
         * Deletes an existing group.
         *
         * Create a request for the method "groups.delete".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The group to delete. The format is "projects/{project_id_or_number}/groups/{group_id}".
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(Monitoring.this, "DELETE", REST_PATH, null, com.google.api.services.monitoring.v3.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/groups/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The group to delete. The format is "projects/{project_id_or_number}/groups/{group_id}".
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The group to delete. The format is "projects/{project_id_or_number}/groups/{group_id}".
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The group to delete. The format is "projects/{project_id_or_number}/groups/{group_id}".
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/groups/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets a single group.
       *
       * Create a request for the method "groups.get".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name The group to retrieve. The format is "projects/{project_id_or_number}/groups/{group_id}".
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends MonitoringRequest<com.google.api.services.monitoring.v3.model.Group> {

        private static final String REST_PATH = "v3/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/groups/[^/]+$");

        /**
         * Gets a single group.
         *
         * Create a request for the method "groups.get".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The group to retrieve. The format is "projects/{project_id_or_number}/groups/{group_id}".
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Monitoring.this, "GET", REST_PATH, null, com.google.api.services.monitoring.v3.model.Group.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/groups/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The group to retrieve. The format is "projects/{project_id_or_number}/groups/{group_id}".
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The group to retrieve. The format is "projects/{project_id_or_number}/groups/{group_id}".
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The group to retrieve. The format is "projects/{project_id_or_number}/groups/{group_id}".
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/groups/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists the existing groups.
       *
       * Create a request for the method "groups.list".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param name The project whose groups are to be listed. The format is "projects/{project_id_or_number}".
       * @return the request
       */
      public List list(java.lang.String name) throws java.io.IOException {
        List result = new List(name);
        initialize(result);
        return result;
      }

      public class List extends MonitoringRequest<com.google.api.services.monitoring.v3.model.ListGroupsResponse> {

        private static final String REST_PATH = "v3/{+name}/groups";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists the existing groups.
         *
         * Create a request for the method "groups.list".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The project whose groups are to be listed. The format is "projects/{project_id_or_number}".
         * @since 1.13
         */
        protected List(java.lang.String name) {
          super(Monitoring.this, "GET", REST_PATH, null, com.google.api.services.monitoring.v3.model.ListGroupsResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The project whose groups are to be listed. The format is
         * "projects/{project_id_or_number}".
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The project whose groups are to be listed. The format is "projects/{project_id_or_number}".
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The project whose groups are to be listed. The format is
         * "projects/{project_id_or_number}".
         */
        public List setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * A group name: "projects/{project_id_or_number}/groups/{group_id}". Returns groups whose
         * parentName field contains the group name. If no groups have this parent, the results are
         * empty.
         */
        @com.google.api.client.util.Key
        private java.lang.String childrenOfGroup;

        /** A group name: "projects/{project_id_or_number}/groups/{group_id}". Returns groups whose parentName
       field contains the group name. If no groups have this parent, the results are empty.
         */
        public java.lang.String getChildrenOfGroup() {
          return childrenOfGroup;
        }

        /**
         * A group name: "projects/{project_id_or_number}/groups/{group_id}". Returns groups whose
         * parentName field contains the group name. If no groups have this parent, the results are
         * empty.
         */
        public List setChildrenOfGroup(java.lang.String childrenOfGroup) {
          this.childrenOfGroup = childrenOfGroup;
          return this;
        }

        /**
         * A group name: "projects/{project_id_or_number}/groups/{group_id}". Returns the
         * descendants of the specified group. This is a superset of the results returned by the
         * childrenOfGroup filter, and includes children-of-children, and so forth.
         */
        @com.google.api.client.util.Key
        private java.lang.String descendantsOfGroup;

        /** A group name: "projects/{project_id_or_number}/groups/{group_id}". Returns the descendants of the
       specified group. This is a superset of the results returned by the childrenOfGroup filter, and
       includes children-of-children, and so forth.
         */
        public java.lang.String getDescendantsOfGroup() {
          return descendantsOfGroup;
        }

        /**
         * A group name: "projects/{project_id_or_number}/groups/{group_id}". Returns the
         * descendants of the specified group. This is a superset of the results returned by the
         * childrenOfGroup filter, and includes children-of-children, and so forth.
         */
        public List setDescendantsOfGroup(java.lang.String descendantsOfGroup) {
          this.descendantsOfGroup = descendantsOfGroup;
          return this;
        }

        /**
         * If this field is not empty then it must contain the nextPageToken value returned by a
         * previous call to this method. Using this field causes the method to return additional
         * results from the previous method call.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** If this field is not empty then it must contain the nextPageToken value returned by a previous call
       to this method. Using this field causes the method to return additional results from the previous
       method call.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * If this field is not empty then it must contain the nextPageToken value returned by a
         * previous call to this method. Using this field causes the method to return additional
         * results from the previous method call.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /** A positive number that is the maximum number of results to return. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** A positive number that is the maximum number of results to return.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** A positive number that is the maximum number of results to return. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * A group name: "projects/{project_id_or_number}/groups/{group_id}". Returns groups that
         * are ancestors of the specified group. The groups are returned in order, starting with the
         * immediate parent and ending with the most distant ancestor. If the specified group has no
         * immediate parent, the results are empty.
         */
        @com.google.api.client.util.Key
        private java.lang.String ancestorsOfGroup;

        /** A group name: "projects/{project_id_or_number}/groups/{group_id}". Returns groups that are
       ancestors of the specified group. The groups are returned in order, starting with the immediate
       parent and ending with the most distant ancestor. If the specified group has no immediate parent,
       the results are empty.
         */
        public java.lang.String getAncestorsOfGroup() {
          return ancestorsOfGroup;
        }

        /**
         * A group name: "projects/{project_id_or_number}/groups/{group_id}". Returns groups that
         * are ancestors of the specified group. The groups are returned in order, starting with the
         * immediate parent and ending with the most distant ancestor. If the specified group has no
         * immediate parent, the results are empty.
         */
        public List setAncestorsOfGroup(java.lang.String ancestorsOfGroup) {
          this.ancestorsOfGroup = ancestorsOfGroup;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates an existing group. You can change any group attributes except name.
       *
       * Create a request for the method "groups.update".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param name Output only. The name of this group. The format is
       *        "projects/{project_id_or_number}/groups/{group_id}". When creating a group, this field is
       *        ignored and a new name is created consisting of the project specified in the call to
       *        CreateGroup and a unique {group_id} that is generated automatically.
       * @param content the {@link com.google.api.services.monitoring.v3.model.Group}
       * @return the request
       */
      public Update update(java.lang.String name, com.google.api.services.monitoring.v3.model.Group content) throws java.io.IOException {
        Update result = new Update(name, content);
        initialize(result);
        return result;
      }

      public class Update extends MonitoringRequest<com.google.api.services.monitoring.v3.model.Group> {

        private static final String REST_PATH = "v3/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/groups/[^/]+$");

        /**
         * Updates an existing group. You can change any group attributes except name.
         *
         * Create a request for the method "groups.update".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
         * <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Output only. The name of this group. The format is
       *        "projects/{project_id_or_number}/groups/{group_id}". When creating a group, this field is
       *        ignored and a new name is created consisting of the project specified in the call to
       *        CreateGroup and a unique {group_id} that is generated automatically.
         * @param content the {@link com.google.api.services.monitoring.v3.model.Group}
         * @since 1.13
         */
        protected Update(java.lang.String name, com.google.api.services.monitoring.v3.model.Group content) {
          super(Monitoring.this, "PUT", REST_PATH, content, com.google.api.services.monitoring.v3.model.Group.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/groups/[^/]+$");
          }
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Output only. The name of this group. The format is
         * "projects/{project_id_or_number}/groups/{group_id}". When creating a group, this field is
         * ignored and a new name is created consisting of the project specified in the call to
         * CreateGroup and a unique {group_id} that is generated automatically.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Output only. The name of this group. The format is
       "projects/{project_id_or_number}/groups/{group_id}". When creating a group, this field is ignored
       and a new name is created consisting of the project specified in the call to CreateGroup and a
       unique {group_id} that is generated automatically.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Output only. The name of this group. The format is
         * "projects/{project_id_or_number}/groups/{group_id}". When creating a group, this field is
         * ignored and a new name is created consisting of the project specified in the call to
         * CreateGroup and a unique {group_id} that is generated automatically.
         */
        public Update setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/groups/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /** If true, validate this request but do not update the existing group. */
        @com.google.api.client.util.Key
        private java.lang.Boolean validateOnly;

        /** If true, validate this request but do not update the existing group.
         */
        public java.lang.Boolean getValidateOnly() {
          return validateOnly;
        }

        /** If true, validate this request but do not update the existing group. */
        public Update setValidateOnly(java.lang.Boolean validateOnly) {
          this.validateOnly = validateOnly;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the Members collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Monitoring monitoring = new Monitoring(...);}
       *   {@code Monitoring.Members.List request = monitoring.members().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Members members() {
        return new Members();
      }

      /**
       * The "members" collection of methods.
       */
      public class Members {

        /**
         * Lists the monitored resources that are members of a group.
         *
         * Create a request for the method "members.list".
         *
         * This request holds the parameters needed by the monitoring server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param name The group whose members are listed. The format is
         *        "projects/{project_id_or_number}/groups/{group_id}".
         * @return the request
         */
        public List list(java.lang.String name) throws java.io.IOException {
          List result = new List(name);
          initialize(result);
          return result;
        }

        public class List extends MonitoringRequest<com.google.api.services.monitoring.v3.model.ListGroupMembersResponse> {

          private static final String REST_PATH = "v3/{+name}/members";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/groups/[^/]+$");

          /**
           * Lists the monitored resources that are members of a group.
           *
           * Create a request for the method "members.list".
           *
           * This request holds the parameters needed by the the monitoring server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The group whose members are listed. The format is
         *        "projects/{project_id_or_number}/groups/{group_id}".
           * @since 1.13
           */
          protected List(java.lang.String name) {
            super(Monitoring.this, "GET", REST_PATH, null, com.google.api.services.monitoring.v3.model.ListGroupMembersResponse.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/groups/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The group whose members are listed. The format is
           * "projects/{project_id_or_number}/groups/{group_id}".
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The group whose members are listed. The format is
         "projects/{project_id_or_number}/groups/{group_id}".
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The group whose members are listed. The format is
           * "projects/{project_id_or_number}/groups/{group_id}".
           */
          public List setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/groups/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /**
           * If this field is not empty then it must contain the nextPageToken value returned by a
           * previous call to this method. Using this field causes the method to return additional
           * results from the previous method call.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** If this field is not empty then it must contain the nextPageToken value returned by a previous call
         to this method. Using this field causes the method to return additional results from the previous
         method call.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * If this field is not empty then it must contain the nextPageToken value returned by a
           * previous call to this method. Using this field causes the method to return additional
           * results from the previous method call.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          /**
           * Optional. The beginning of the time interval. The default value for the start time is
           * the end time. The start time must not be later than the end time.
           */
          @com.google.api.client.util.Key("interval.startTime")
          private String intervalStartTime;

          /** Optional. The beginning of the time interval. The default value for the start time is the end time.
         The start time must not be later than the end time.
           */
          public String getIntervalStartTime() {
            return intervalStartTime;
          }

          /**
           * Optional. The beginning of the time interval. The default value for the start time is
           * the end time. The start time must not be later than the end time.
           */
          public List setIntervalStartTime(String intervalStartTime) {
            this.intervalStartTime = intervalStartTime;
            return this;
          }

          /** A positive number that is the maximum number of results to return. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** A positive number that is the maximum number of results to return.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** A positive number that is the maximum number of results to return. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /** Required. The end of the time interval. */
          @com.google.api.client.util.Key("interval.endTime")
          private String intervalEndTime;

          /** Required. The end of the time interval.
           */
          public String getIntervalEndTime() {
            return intervalEndTime;
          }

          /** Required. The end of the time interval. */
          public List setIntervalEndTime(String intervalEndTime) {
            this.intervalEndTime = intervalEndTime;
            return this;
          }

          /**
           * An optional list filter describing the members to be returned. The filter may reference
           * the type, labels, and metadata of monitored resources that comprise the group. For
           * example, to return only resources representing Compute Engine VM instances, use this
           * filter: resource.type = "gce_instance"
           */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** An optional list filter describing the members to be returned. The filter may reference the type,
         labels, and metadata of monitored resources that comprise the group. For example, to return only
         resources representing Compute Engine VM instances, use this filter: resource.type = "gce_instance"
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /**
           * An optional list filter describing the members to be returned. The filter may reference
           * the type, labels, and metadata of monitored resources that comprise the group. For
           * example, to return only resources representing Compute Engine VM instances, use this
           * filter: resource.type = "gce_instance"
           */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
    }
    /**
     * An accessor for creating requests from the MetricDescriptors collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Monitoring monitoring = new Monitoring(...);}
     *   {@code Monitoring.MetricDescriptors.List request = monitoring.metricDescriptors().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public MetricDescriptors metricDescriptors() {
      return new MetricDescriptors();
    }

    /**
     * The "metricDescriptors" collection of methods.
     */
    public class MetricDescriptors {

      /**
       * Creates a new metric descriptor. User-created metric descriptors define custom metrics.
       *
       * Create a request for the method "metricDescriptors.create".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param name The project on which to execute the request. The format is "projects/{project_id_or_number}".
       * @param content the {@link com.google.api.services.monitoring.v3.model.MetricDescriptor}
       * @return the request
       */
      public Create create(java.lang.String name, com.google.api.services.monitoring.v3.model.MetricDescriptor content) throws java.io.IOException {
        Create result = new Create(name, content);
        initialize(result);
        return result;
      }

      public class Create extends MonitoringRequest<com.google.api.services.monitoring.v3.model.MetricDescriptor> {

        private static final String REST_PATH = "v3/{+name}/metricDescriptors";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Creates a new metric descriptor. User-created metric descriptors define custom metrics.
         *
         * Create a request for the method "metricDescriptors.create".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The project on which to execute the request. The format is "projects/{project_id_or_number}".
         * @param content the {@link com.google.api.services.monitoring.v3.model.MetricDescriptor}
         * @since 1.13
         */
        protected Create(java.lang.String name, com.google.api.services.monitoring.v3.model.MetricDescriptor content) {
          super(Monitoring.this, "POST", REST_PATH, content, com.google.api.services.monitoring.v3.model.MetricDescriptor.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The project on which to execute the request. The format is
         * "projects/{project_id_or_number}".
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The project on which to execute the request. The format is "projects/{project_id_or_number}".
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The project on which to execute the request. The format is
         * "projects/{project_id_or_number}".
         */
        public Create setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a metric descriptor. Only user-created custom metrics can be deleted.
       *
       * Create a request for the method "metricDescriptors.delete".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name The metric descriptor on which to execute the request. The format is
       *        "projects/{project_id_or_number}/metricDescriptors/{metric_id}". An example of {metric_id}
       *        is: "custom.googleapis.com/my_test_metric".
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends MonitoringRequest<com.google.api.services.monitoring.v3.model.Empty> {

        private static final String REST_PATH = "v3/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/metricDescriptors/.+$");

        /**
         * Deletes a metric descriptor. Only user-created custom metrics can be deleted.
         *
         * Create a request for the method "metricDescriptors.delete".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The metric descriptor on which to execute the request. The format is
       *        "projects/{project_id_or_number}/metricDescriptors/{metric_id}". An example of {metric_id}
       *        is: "custom.googleapis.com/my_test_metric".
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(Monitoring.this, "DELETE", REST_PATH, null, com.google.api.services.monitoring.v3.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/metricDescriptors/.+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The metric descriptor on which to execute the request. The format is
         * "projects/{project_id_or_number}/metricDescriptors/{metric_id}". An example of
         * {metric_id} is: "custom.googleapis.com/my_test_metric".
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The metric descriptor on which to execute the request. The format is
       "projects/{project_id_or_number}/metricDescriptors/{metric_id}". An example of {metric_id} is:
       "custom.googleapis.com/my_test_metric".
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The metric descriptor on which to execute the request. The format is
         * "projects/{project_id_or_number}/metricDescriptors/{metric_id}". An example of
         * {metric_id} is: "custom.googleapis.com/my_test_metric".
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/metricDescriptors/.+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets a single metric descriptor. This method does not require a Stackdriver account.
       *
       * Create a request for the method "metricDescriptors.get".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name The metric descriptor on which to execute the request. The format is
       *        "projects/{project_id_or_number}/metricDescriptors/{metric_id}". An example value of
       *        {metric_id} is "compute.googleapis.com/instance/disk/read_bytes_count".
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends MonitoringRequest<com.google.api.services.monitoring.v3.model.MetricDescriptor> {

        private static final String REST_PATH = "v3/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/metricDescriptors/.+$");

        /**
         * Gets a single metric descriptor. This method does not require a Stackdriver account.
         *
         * Create a request for the method "metricDescriptors.get".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The metric descriptor on which to execute the request. The format is
       *        "projects/{project_id_or_number}/metricDescriptors/{metric_id}". An example value of
       *        {metric_id} is "compute.googleapis.com/instance/disk/read_bytes_count".
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Monitoring.this, "GET", REST_PATH, null, com.google.api.services.monitoring.v3.model.MetricDescriptor.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/metricDescriptors/.+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The metric descriptor on which to execute the request. The format is
         * "projects/{project_id_or_number}/metricDescriptors/{metric_id}". An example value of
         * {metric_id} is "compute.googleapis.com/instance/disk/read_bytes_count".
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The metric descriptor on which to execute the request. The format is
       "projects/{project_id_or_number}/metricDescriptors/{metric_id}". An example value of {metric_id} is
       "compute.googleapis.com/instance/disk/read_bytes_count".
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The metric descriptor on which to execute the request. The format is
         * "projects/{project_id_or_number}/metricDescriptors/{metric_id}". An example value of
         * {metric_id} is "compute.googleapis.com/instance/disk/read_bytes_count".
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/metricDescriptors/.+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists metric descriptors that match a filter. This method does not require a Stackdriver account.
       *
       * Create a request for the method "metricDescriptors.list".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param name The project on which to execute the request. The format is "projects/{project_id_or_number}".
       * @return the request
       */
      public List list(java.lang.String name) throws java.io.IOException {
        List result = new List(name);
        initialize(result);
        return result;
      }

      public class List extends MonitoringRequest<com.google.api.services.monitoring.v3.model.ListMetricDescriptorsResponse> {

        private static final String REST_PATH = "v3/{+name}/metricDescriptors";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists metric descriptors that match a filter. This method does not require a Stackdriver
         * account.
         *
         * Create a request for the method "metricDescriptors.list".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The project on which to execute the request. The format is "projects/{project_id_or_number}".
         * @since 1.13
         */
        protected List(java.lang.String name) {
          super(Monitoring.this, "GET", REST_PATH, null, com.google.api.services.monitoring.v3.model.ListMetricDescriptorsResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The project on which to execute the request. The format is
         * "projects/{project_id_or_number}".
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The project on which to execute the request. The format is "projects/{project_id_or_number}".
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The project on which to execute the request. The format is
         * "projects/{project_id_or_number}".
         */
        public List setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * If this field is empty, all custom and system-defined metric descriptors are returned.
         * Otherwise, the filter specifies which metric descriptors are to be returned. For example,
         * the following filter matches all custom metrics: metric.type =
         * starts_with("custom.googleapis.com/")
         */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** If this field is empty, all custom and system-defined metric descriptors are returned. Otherwise,
       the filter specifies which metric descriptors are to be returned. For example, the following filter
       matches all custom metrics: metric.type = starts_with("custom.googleapis.com/")
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /**
         * If this field is empty, all custom and system-defined metric descriptors are returned.
         * Otherwise, the filter specifies which metric descriptors are to be returned. For example,
         * the following filter matches all custom metrics: metric.type =
         * starts_with("custom.googleapis.com/")
         */
        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        /**
         * If this field is not empty then it must contain the nextPageToken value returned by a
         * previous call to this method. Using this field causes the method to return additional
         * results from the previous method call.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** If this field is not empty then it must contain the nextPageToken value returned by a previous call
       to this method. Using this field causes the method to return additional results from the previous
       method call.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * If this field is not empty then it must contain the nextPageToken value returned by a
         * previous call to this method. Using this field causes the method to return additional
         * results from the previous method call.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /** A positive number that is the maximum number of results to return. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** A positive number that is the maximum number of results to return.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** A positive number that is the maximum number of results to return. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the MonitoredResourceDescriptors collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Monitoring monitoring = new Monitoring(...);}
     *   {@code Monitoring.MonitoredResourceDescriptors.List request = monitoring.monitoredResourceDescriptors().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public MonitoredResourceDescriptors monitoredResourceDescriptors() {
      return new MonitoredResourceDescriptors();
    }

    /**
     * The "monitoredResourceDescriptors" collection of methods.
     */
    public class MonitoredResourceDescriptors {

      /**
       * Gets a single monitored resource descriptor. This method does not require a Stackdriver account.
       *
       * Create a request for the method "monitoredResourceDescriptors.get".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name The monitored resource descriptor to get. The format is
       *        "projects/{project_id_or_number}/monitoredResourceDescriptors/{resource_type}". The
       *        {resource_type} is a predefined type, such as cloudsql_database.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends MonitoringRequest<com.google.api.services.monitoring.v3.model.MonitoredResourceDescriptor> {

        private static final String REST_PATH = "v3/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/monitoredResourceDescriptors/[^/]+$");

        /**
         * Gets a single monitored resource descriptor. This method does not require a Stackdriver
         * account.
         *
         * Create a request for the method "monitoredResourceDescriptors.get".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The monitored resource descriptor to get. The format is
       *        "projects/{project_id_or_number}/monitoredResourceDescriptors/{resource_type}". The
       *        {resource_type} is a predefined type, such as cloudsql_database.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Monitoring.this, "GET", REST_PATH, null, com.google.api.services.monitoring.v3.model.MonitoredResourceDescriptor.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/monitoredResourceDescriptors/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The monitored resource descriptor to get. The format is
         * "projects/{project_id_or_number}/monitoredResourceDescriptors/{resource_type}". The
         * {resource_type} is a predefined type, such as cloudsql_database.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The monitored resource descriptor to get. The format is
       "projects/{project_id_or_number}/monitoredResourceDescriptors/{resource_type}". The {resource_type}
       is a predefined type, such as cloudsql_database.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The monitored resource descriptor to get. The format is
         * "projects/{project_id_or_number}/monitoredResourceDescriptors/{resource_type}". The
         * {resource_type} is a predefined type, such as cloudsql_database.
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/monitoredResourceDescriptors/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists monitored resource descriptors that match a filter. This method does not require a
       * Stackdriver account.
       *
       * Create a request for the method "monitoredResourceDescriptors.list".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param name The project on which to execute the request. The format is "projects/{project_id_or_number}".
       * @return the request
       */
      public List list(java.lang.String name) throws java.io.IOException {
        List result = new List(name);
        initialize(result);
        return result;
      }

      public class List extends MonitoringRequest<com.google.api.services.monitoring.v3.model.ListMonitoredResourceDescriptorsResponse> {

        private static final String REST_PATH = "v3/{+name}/monitoredResourceDescriptors";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists monitored resource descriptors that match a filter. This method does not require a
         * Stackdriver account.
         *
         * Create a request for the method "monitoredResourceDescriptors.list".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The project on which to execute the request. The format is "projects/{project_id_or_number}".
         * @since 1.13
         */
        protected List(java.lang.String name) {
          super(Monitoring.this, "GET", REST_PATH, null, com.google.api.services.monitoring.v3.model.ListMonitoredResourceDescriptorsResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The project on which to execute the request. The format is
         * "projects/{project_id_or_number}".
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The project on which to execute the request. The format is "projects/{project_id_or_number}".
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The project on which to execute the request. The format is
         * "projects/{project_id_or_number}".
         */
        public List setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * An optional filter describing the descriptors to be returned. The filter can reference
         * the descriptor's type and labels. For example, the following filter returns only Google
         * Compute Engine descriptors that have an id label: resource.type = starts_with("gce_") AND
         * resource.label:id
         */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** An optional filter describing the descriptors to be returned. The filter can reference the
       descriptor's type and labels. For example, the following filter returns only Google Compute Engine
       descriptors that have an id label: resource.type = starts_with("gce_") AND resource.label:id
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /**
         * An optional filter describing the descriptors to be returned. The filter can reference
         * the descriptor's type and labels. For example, the following filter returns only Google
         * Compute Engine descriptors that have an id label: resource.type = starts_with("gce_") AND
         * resource.label:id
         */
        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        /**
         * If this field is not empty then it must contain the nextPageToken value returned by a
         * previous call to this method. Using this field causes the method to return additional
         * results from the previous method call.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** If this field is not empty then it must contain the nextPageToken value returned by a previous call
       to this method. Using this field causes the method to return additional results from the previous
       method call.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * If this field is not empty then it must contain the nextPageToken value returned by a
         * previous call to this method. Using this field causes the method to return additional
         * results from the previous method call.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /** A positive number that is the maximum number of results to return. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** A positive number that is the maximum number of results to return.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** A positive number that is the maximum number of results to return. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the NotificationChannelDescriptors collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Monitoring monitoring = new Monitoring(...);}
     *   {@code Monitoring.NotificationChannelDescriptors.List request = monitoring.notificationChannelDescriptors().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public NotificationChannelDescriptors notificationChannelDescriptors() {
      return new NotificationChannelDescriptors();
    }

    /**
     * The "notificationChannelDescriptors" collection of methods.
     */
    public class NotificationChannelDescriptors {

      /**
       * Gets a single channel descriptor. The descriptor indicates which fields are expected / permitted
       * for a notification channel of the given type.
       *
       * Create a request for the method "notificationChannelDescriptors.get".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name The channel type for which to execute the request. The format is
       *        projects/[PROJECT_ID]/notificationChannelDescriptors/{channel_type}.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends MonitoringRequest<com.google.api.services.monitoring.v3.model.NotificationChannelDescriptor> {

        private static final String REST_PATH = "v3/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/notificationChannelDescriptors/[^/]+$");

        /**
         * Gets a single channel descriptor. The descriptor indicates which fields are expected /
         * permitted for a notification channel of the given type.
         *
         * Create a request for the method "notificationChannelDescriptors.get".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The channel type for which to execute the request. The format is
       *        projects/[PROJECT_ID]/notificationChannelDescriptors/{channel_type}.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Monitoring.this, "GET", REST_PATH, null, com.google.api.services.monitoring.v3.model.NotificationChannelDescriptor.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/notificationChannelDescriptors/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The channel type for which to execute the request. The format is
         * projects/[PROJECT_ID]/notificationChannelDescriptors/{channel_type}.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The channel type for which to execute the request. The format is
       projects/[PROJECT_ID]/notificationChannelDescriptors/{channel_type}.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The channel type for which to execute the request. The format is
         * projects/[PROJECT_ID]/notificationChannelDescriptors/{channel_type}.
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/notificationChannelDescriptors/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists the descriptors for supported channel types. The use of descriptors makes it possible for
       * new channel types to be dynamically added.
       *
       * Create a request for the method "notificationChannelDescriptors.list".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param name The REST resource name of the parent from which to retrieve the notification channel descriptors.
       *        The expected syntax is:
      projects/[PROJECT_ID]
      Note that this names the parent container in
       *        which to look for the descriptors; to retrieve a single descriptor by name, use the
       *        GetNotificationChannelDescriptor operation, instead.
       * @return the request
       */
      public List list(java.lang.String name) throws java.io.IOException {
        List result = new List(name);
        initialize(result);
        return result;
      }

      public class List extends MonitoringRequest<com.google.api.services.monitoring.v3.model.ListNotificationChannelDescriptorsResponse> {

        private static final String REST_PATH = "v3/{+name}/notificationChannelDescriptors";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists the descriptors for supported channel types. The use of descriptors makes it possible for
         * new channel types to be dynamically added.
         *
         * Create a request for the method "notificationChannelDescriptors.list".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The REST resource name of the parent from which to retrieve the notification channel descriptors.
       *        The expected syntax is:
      projects/[PROJECT_ID]
      Note that this names the parent container in
       *        which to look for the descriptors; to retrieve a single descriptor by name, use the
       *        GetNotificationChannelDescriptor operation, instead.
         * @since 1.13
         */
        protected List(java.lang.String name) {
          super(Monitoring.this, "GET", REST_PATH, null, com.google.api.services.monitoring.v3.model.ListNotificationChannelDescriptorsResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The REST resource name of the parent from which to retrieve the notification channel
         * descriptors. The expected syntax is: projects/[PROJECT_ID] Note that this names the
         * parent container in which to look for the descriptors; to retrieve a single descriptor by
         * name, use the GetNotificationChannelDescriptor operation, instead.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The REST resource name of the parent from which to retrieve the notification channel descriptors.
       The expected syntax is: projects/[PROJECT_ID] Note that this names the parent container in which to
       look for the descriptors; to retrieve a single descriptor by name, use the
       GetNotificationChannelDescriptor operation, instead.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The REST resource name of the parent from which to retrieve the notification channel
         * descriptors. The expected syntax is: projects/[PROJECT_ID] Note that this names the
         * parent container in which to look for the descriptors; to retrieve a single descriptor by
         * name, use the GetNotificationChannelDescriptor operation, instead.
         */
        public List setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * If non-empty, page_token must contain a value returned as the next_page_token in a
         * previous response to request the next set of results.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** If non-empty, page_token must contain a value returned as the next_page_token in a previous
       response to request the next set of results.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * If non-empty, page_token must contain a value returned as the next_page_token in a
         * previous response to request the next set of results.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /**
         * The maximum number of results to return in a single response. If not set to a positive
         * number, a reasonable value will be chosen by the service.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The maximum number of results to return in a single response. If not set to a positive number, a
       reasonable value will be chosen by the service.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * The maximum number of results to return in a single response. If not set to a positive
         * number, a reasonable value will be chosen by the service.
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the NotificationChannels collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Monitoring monitoring = new Monitoring(...);}
     *   {@code Monitoring.NotificationChannels.List request = monitoring.notificationChannels().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public NotificationChannels notificationChannels() {
      return new NotificationChannels();
    }

    /**
     * The "notificationChannels" collection of methods.
     */
    public class NotificationChannels {

      /**
       * Creates a new notification channel, representing a single notification endpoint such as an email
       * address, SMS number, or pagerduty service.
       *
       * Create a request for the method "notificationChannels.create".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param name The project on which to execute the request. The format is:
      projects/[PROJECT_ID]
      Note that this
       *        names the container into which the channel will be written. This does not name the newly
       *        created channel. The resulting channel's name will have a normalized version of this field
       *        as a prefix, but will add /notificationChannels/[CHANNEL_ID] to identify the channel.
       * @param content the {@link com.google.api.services.monitoring.v3.model.NotificationChannel}
       * @return the request
       */
      public Create create(java.lang.String name, com.google.api.services.monitoring.v3.model.NotificationChannel content) throws java.io.IOException {
        Create result = new Create(name, content);
        initialize(result);
        return result;
      }

      public class Create extends MonitoringRequest<com.google.api.services.monitoring.v3.model.NotificationChannel> {

        private static final String REST_PATH = "v3/{+name}/notificationChannels";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Creates a new notification channel, representing a single notification endpoint such as an
         * email address, SMS number, or pagerduty service.
         *
         * Create a request for the method "notificationChannels.create".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The project on which to execute the request. The format is:
      projects/[PROJECT_ID]
      Note that this
       *        names the container into which the channel will be written. This does not name the newly
       *        created channel. The resulting channel's name will have a normalized version of this field
       *        as a prefix, but will add /notificationChannels/[CHANNEL_ID] to identify the channel.
         * @param content the {@link com.google.api.services.monitoring.v3.model.NotificationChannel}
         * @since 1.13
         */
        protected Create(java.lang.String name, com.google.api.services.monitoring.v3.model.NotificationChannel content) {
          super(Monitoring.this, "POST", REST_PATH, content, com.google.api.services.monitoring.v3.model.NotificationChannel.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The project on which to execute the request. The format is: projects/[PROJECT_ID] Note
         * that this names the container into which the channel will be written. This does not name
         * the newly created channel. The resulting channel's name will have a normalized version of
         * this field as a prefix, but will add /notificationChannels/[CHANNEL_ID] to identify the
         * channel.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The project on which to execute the request. The format is: projects/[PROJECT_ID] Note that this
       names the container into which the channel will be written. This does not name the newly created
       channel. The resulting channel's name will have a normalized version of this field as a prefix, but
       will add /notificationChannels/[CHANNEL_ID] to identify the channel.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The project on which to execute the request. The format is: projects/[PROJECT_ID] Note
         * that this names the container into which the channel will be written. This does not name
         * the newly created channel. The resulting channel's name will have a normalized version of
         * this field as a prefix, but will add /notificationChannels/[CHANNEL_ID] to identify the
         * channel.
         */
        public Create setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a notification channel.
       *
       * Create a request for the method "notificationChannels.delete".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name The channel for which to execute the request. The format is
       *        projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID].
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends MonitoringRequest<com.google.api.services.monitoring.v3.model.Empty> {

        private static final String REST_PATH = "v3/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/notificationChannels/[^/]+$");

        /**
         * Deletes a notification channel.
         *
         * Create a request for the method "notificationChannels.delete".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The channel for which to execute the request. The format is
       *        projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID].
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(Monitoring.this, "DELETE", REST_PATH, null, com.google.api.services.monitoring.v3.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/notificationChannels/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The channel for which to execute the request. The format is
         * projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID].
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The channel for which to execute the request. The format is
       projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID].
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The channel for which to execute the request. The format is
         * projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID].
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/notificationChannels/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * If true, the notification channel will be deleted regardless of its use in alert policies
         * (the policies will be updated to remove the channel). If false, channels that are still
         * referenced by an existing alerting policy will fail to be deleted in a delete operation.
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean force;

        /** If true, the notification channel will be deleted regardless of its use in alert policies (the
       policies will be updated to remove the channel). If false, channels that are still referenced by an
       existing alerting policy will fail to be deleted in a delete operation.
         */
        public java.lang.Boolean getForce() {
          return force;
        }

        /**
         * If true, the notification channel will be deleted regardless of its use in alert policies
         * (the policies will be updated to remove the channel). If false, channels that are still
         * referenced by an existing alerting policy will fail to be deleted in a delete operation.
         */
        public Delete setForce(java.lang.Boolean force) {
          this.force = force;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets a single notification channel. The channel includes the relevant configuration details with
       * which the channel was created. However, the response may truncate or omit passwords, API keys, or
       * other private key matter and thus the response may not be 100% identical to the information that
       * was supplied in the call to the create method.
       *
       * Create a request for the method "notificationChannels.get".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name The channel for which to execute the request. The format is
       *        projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID].
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends MonitoringRequest<com.google.api.services.monitoring.v3.model.NotificationChannel> {

        private static final String REST_PATH = "v3/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/notificationChannels/[^/]+$");

        /**
         * Gets a single notification channel. The channel includes the relevant configuration details
         * with which the channel was created. However, the response may truncate or omit passwords, API
         * keys, or other private key matter and thus the response may not be 100% identical to the
         * information that was supplied in the call to the create method.
         *
         * Create a request for the method "notificationChannels.get".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The channel for which to execute the request. The format is
       *        projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID].
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Monitoring.this, "GET", REST_PATH, null, com.google.api.services.monitoring.v3.model.NotificationChannel.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/notificationChannels/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The channel for which to execute the request. The format is
         * projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID].
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The channel for which to execute the request. The format is
       projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID].
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The channel for which to execute the request. The format is
         * projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID].
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/notificationChannels/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Requests a verification code for an already verified channel that can then be used in a call to
       * VerifyNotificationChannel() on a different channel with an equivalent identity in the same or in
       * a different project. This makes it possible to copy a channel between projects without requiring
       * manual reverification of the channel. If the channel is not in the verified state, this method
       * will fail (in other words, this may only be used if the SendNotificationChannelVerificationCode
       * and VerifyNotificationChannel paths have already been used to put the given channel into the
       * verified state).There is no guarantee that the verification codes returned by this method will be
       * of a similar structure or form as the ones that are delivered to the channel via
       * SendNotificationChannelVerificationCode; while VerifyNotificationChannel() will recognize both
       * the codes delivered via SendNotificationChannelVerificationCode() and returned from
       * GetNotificationChannelVerificationCode(), it is typically the case that the verification codes
       * delivered via SendNotificationChannelVerificationCode() will be shorter and also have a shorter
       * expiration (e.g. codes such as "G-123456") whereas GetVerificationCode() will typically return a
       * much longer, websafe base 64 encoded string that has a longer expiration time.
       *
       * Create a request for the method "notificationChannels.getVerificationCode".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link GetVerificationCode#execute()} method to invoke the remote operation.
       *
       * @param name The notification channel for which a verification code is to be generated and retrieved. This must
       *        name a channel that is already verified; if the specified channel is not verified, the
       *        request will fail.
       * @param content the {@link com.google.api.services.monitoring.v3.model.GetNotificationChannelVerificationCodeRequest}
       * @return the request
       */
      public GetVerificationCode getVerificationCode(java.lang.String name, com.google.api.services.monitoring.v3.model.GetNotificationChannelVerificationCodeRequest content) throws java.io.IOException {
        GetVerificationCode result = new GetVerificationCode(name, content);
        initialize(result);
        return result;
      }

      public class GetVerificationCode extends MonitoringRequest<com.google.api.services.monitoring.v3.model.GetNotificationChannelVerificationCodeResponse> {

        private static final String REST_PATH = "v3/{+name}:getVerificationCode";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/notificationChannels/[^/]+$");

        /**
         * Requests a verification code for an already verified channel that can then be used in a call to
         * VerifyNotificationChannel() on a different channel with an equivalent identity in the same or
         * in a different project. This makes it possible to copy a channel between projects without
         * requiring manual reverification of the channel. If the channel is not in the verified state,
         * this method will fail (in other words, this may only be used if the
         * SendNotificationChannelVerificationCode and VerifyNotificationChannel paths have already been
         * used to put the given channel into the verified state).There is no guarantee that the
         * verification codes returned by this method will be of a similar structure or form as the ones
         * that are delivered to the channel via SendNotificationChannelVerificationCode; while
         * VerifyNotificationChannel() will recognize both the codes delivered via
         * SendNotificationChannelVerificationCode() and returned from
         * GetNotificationChannelVerificationCode(), it is typically the case that the verification codes
         * delivered via SendNotificationChannelVerificationCode() will be shorter and also have a shorter
         * expiration (e.g. codes such as "G-123456") whereas GetVerificationCode() will typically return
         * a much longer, websafe base 64 encoded string that has a longer expiration time.
         *
         * Create a request for the method "notificationChannels.getVerificationCode".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link GetVerificationCode#execute()} method to invoke the remote
         * operation. <p> {@link GetVerificationCode#initialize(com.google.api.client.googleapis.services.
         * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param name The notification channel for which a verification code is to be generated and retrieved. This must
       *        name a channel that is already verified; if the specified channel is not verified, the
       *        request will fail.
         * @param content the {@link com.google.api.services.monitoring.v3.model.GetNotificationChannelVerificationCodeRequest}
         * @since 1.13
         */
        protected GetVerificationCode(java.lang.String name, com.google.api.services.monitoring.v3.model.GetNotificationChannelVerificationCodeRequest content) {
          super(Monitoring.this, "POST", REST_PATH, content, com.google.api.services.monitoring.v3.model.GetNotificationChannelVerificationCodeResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/notificationChannels/[^/]+$");
          }
        }

        @Override
        public GetVerificationCode set$Xgafv(java.lang.String $Xgafv) {
          return (GetVerificationCode) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetVerificationCode setAccessToken(java.lang.String accessToken) {
          return (GetVerificationCode) super.setAccessToken(accessToken);
        }

        @Override
        public GetVerificationCode setAlt(java.lang.String alt) {
          return (GetVerificationCode) super.setAlt(alt);
        }

        @Override
        public GetVerificationCode setCallback(java.lang.String callback) {
          return (GetVerificationCode) super.setCallback(callback);
        }

        @Override
        public GetVerificationCode setFields(java.lang.String fields) {
          return (GetVerificationCode) super.setFields(fields);
        }

        @Override
        public GetVerificationCode setKey(java.lang.String key) {
          return (GetVerificationCode) super.setKey(key);
        }

        @Override
        public GetVerificationCode setOauthToken(java.lang.String oauthToken) {
          return (GetVerificationCode) super.setOauthToken(oauthToken);
        }

        @Override
        public GetVerificationCode setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetVerificationCode) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetVerificationCode setQuotaUser(java.lang.String quotaUser) {
          return (GetVerificationCode) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetVerificationCode setUploadType(java.lang.String uploadType) {
          return (GetVerificationCode) super.setUploadType(uploadType);
        }

        @Override
        public GetVerificationCode setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetVerificationCode) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The notification channel for which a verification code is to be generated and retrieved.
         * This must name a channel that is already verified; if the specified channel is not
         * verified, the request will fail.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The notification channel for which a verification code is to be generated and retrieved. This must
       name a channel that is already verified; if the specified channel is not verified, the request will
       fail.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The notification channel for which a verification code is to be generated and retrieved.
         * This must name a channel that is already verified; if the specified channel is not
         * verified, the request will fail.
         */
        public GetVerificationCode setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/notificationChannels/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public GetVerificationCode set(String parameterName, Object value) {
          return (GetVerificationCode) super.set(parameterName, value);
        }
      }
      /**
       * Lists the notification channels that have been created for the project.
       *
       * Create a request for the method "notificationChannels.list".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param name The project on which to execute the request. The format is projects/[PROJECT_ID]. That is, this
       *        names the container in which to look for the notification channels; it does not name a
       *        specific channel. To query a specific channel by REST resource name, use the
       *        GetNotificationChannel operation.
       * @return the request
       */
      public List list(java.lang.String name) throws java.io.IOException {
        List result = new List(name);
        initialize(result);
        return result;
      }

      public class List extends MonitoringRequest<com.google.api.services.monitoring.v3.model.ListNotificationChannelsResponse> {

        private static final String REST_PATH = "v3/{+name}/notificationChannels";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists the notification channels that have been created for the project.
         *
         * Create a request for the method "notificationChannels.list".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The project on which to execute the request. The format is projects/[PROJECT_ID]. That is, this
       *        names the container in which to look for the notification channels; it does not name a
       *        specific channel. To query a specific channel by REST resource name, use the
       *        GetNotificationChannel operation.
         * @since 1.13
         */
        protected List(java.lang.String name) {
          super(Monitoring.this, "GET", REST_PATH, null, com.google.api.services.monitoring.v3.model.ListNotificationChannelsResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The project on which to execute the request. The format is projects/[PROJECT_ID]. That
         * is, this names the container in which to look for the notification channels; it does not
         * name a specific channel. To query a specific channel by REST resource name, use the
         * GetNotificationChannel operation.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The project on which to execute the request. The format is projects/[PROJECT_ID]. That is, this
       names the container in which to look for the notification channels; it does not name a specific
       channel. To query a specific channel by REST resource name, use the GetNotificationChannel
       operation.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The project on which to execute the request. The format is projects/[PROJECT_ID]. That
         * is, this names the container in which to look for the notification channels; it does not
         * name a specific channel. To query a specific channel by REST resource name, use the
         * GetNotificationChannel operation.
         */
        public List setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * A comma-separated list of fields by which to sort the result. Supports the same set of
         * fields as in filter. Entries can be prefixed with a minus sign to sort in descending
         * rather than ascending order.For more details, see sorting and filtering.
         */
        @com.google.api.client.util.Key
        private java.lang.String orderBy;

        /** A comma-separated list of fields by which to sort the result. Supports the same set of fields as in
       filter. Entries can be prefixed with a minus sign to sort in descending rather than ascending
       order.For more details, see sorting and filtering.
         */
        public java.lang.String getOrderBy() {
          return orderBy;
        }

        /**
         * A comma-separated list of fields by which to sort the result. Supports the same set of
         * fields as in filter. Entries can be prefixed with a minus sign to sort in descending
         * rather than ascending order.For more details, see sorting and filtering.
         */
        public List setOrderBy(java.lang.String orderBy) {
          this.orderBy = orderBy;
          return this;
        }

        /**
         * If non-empty, page_token must contain a value returned as the next_page_token in a
         * previous response to request the next set of results.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** If non-empty, page_token must contain a value returned as the next_page_token in a previous
       response to request the next set of results.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * If non-empty, page_token must contain a value returned as the next_page_token in a
         * previous response to request the next set of results.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /**
         * The maximum number of results to return in a single response. If not set to a positive
         * number, a reasonable value will be chosen by the service.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The maximum number of results to return in a single response. If not set to a positive number, a
       reasonable value will be chosen by the service.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * The maximum number of results to return in a single response. If not set to a positive
         * number, a reasonable value will be chosen by the service.
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * If provided, this field specifies the criteria that must be met by notification channels
         * to be included in the response.For more details, see sorting and filtering.
         */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** If provided, this field specifies the criteria that must be met by notification channels to be
       included in the response.For more details, see sorting and filtering.
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /**
         * If provided, this field specifies the criteria that must be met by notification channels
         * to be included in the response.For more details, see sorting and filtering.
         */
        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates a notification channel. Fields not specified in the field mask remain unchanged.
       *
       * Create a request for the method "notificationChannels.patch".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name The full REST resource name for this channel. The syntax is:
       *        projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
      The [CHANNEL_ID] is automatically
       *        assigned by the server on creation.
       * @param content the {@link com.google.api.services.monitoring.v3.model.NotificationChannel}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.monitoring.v3.model.NotificationChannel content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends MonitoringRequest<com.google.api.services.monitoring.v3.model.NotificationChannel> {

        private static final String REST_PATH = "v3/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/notificationChannels/[^/]+$");

        /**
         * Updates a notification channel. Fields not specified in the field mask remain unchanged.
         *
         * Create a request for the method "notificationChannels.patch".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The full REST resource name for this channel. The syntax is:
       *        projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
      The [CHANNEL_ID] is automatically
       *        assigned by the server on creation.
         * @param content the {@link com.google.api.services.monitoring.v3.model.NotificationChannel}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.monitoring.v3.model.NotificationChannel content) {
          super(Monitoring.this, "PATCH", REST_PATH, content, com.google.api.services.monitoring.v3.model.NotificationChannel.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/notificationChannels/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The full REST resource name for this channel. The syntax is:
         * projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID] The [CHANNEL_ID] is automatically
         * assigned by the server on creation.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The full REST resource name for this channel. The syntax is:
       projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID] The [CHANNEL_ID] is automatically assigned
       by the server on creation.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The full REST resource name for this channel. The syntax is:
         * projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID] The [CHANNEL_ID] is automatically
         * assigned by the server on creation.
         */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/notificationChannels/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /** The fields to update. */
        @com.google.api.client.util.Key
        private String updateMask;

        /** The fields to update.
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /** The fields to update. */
        public Patch setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Causes a verification code to be delivered to the channel. The code can then be supplied in
       * VerifyNotificationChannel to verify the channel.
       *
       * Create a request for the method "notificationChannels.sendVerificationCode".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link SendVerificationCode#execute()} method to invoke the remote
       * operation.
       *
       * @param name The notification channel to which to send a verification code.
       * @param content the {@link com.google.api.services.monitoring.v3.model.SendNotificationChannelVerificationCodeRequest}
       * @return the request
       */
      public SendVerificationCode sendVerificationCode(java.lang.String name, com.google.api.services.monitoring.v3.model.SendNotificationChannelVerificationCodeRequest content) throws java.io.IOException {
        SendVerificationCode result = new SendVerificationCode(name, content);
        initialize(result);
        return result;
      }

      public class SendVerificationCode extends MonitoringRequest<com.google.api.services.monitoring.v3.model.Empty> {

        private static final String REST_PATH = "v3/{+name}:sendVerificationCode";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/notificationChannels/[^/]+$");

        /**
         * Causes a verification code to be delivered to the channel. The code can then be supplied in
         * VerifyNotificationChannel to verify the channel.
         *
         * Create a request for the method "notificationChannels.sendVerificationCode".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link SendVerificationCode#execute()} method to invoke the
         * remote operation. <p> {@link SendVerificationCode#initialize(com.google.api.client.googleapis.s
         * ervices.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
         * after invoking the constructor. </p>
         *
         * @param name The notification channel to which to send a verification code.
         * @param content the {@link com.google.api.services.monitoring.v3.model.SendNotificationChannelVerificationCodeRequest}
         * @since 1.13
         */
        protected SendVerificationCode(java.lang.String name, com.google.api.services.monitoring.v3.model.SendNotificationChannelVerificationCodeRequest content) {
          super(Monitoring.this, "POST", REST_PATH, content, com.google.api.services.monitoring.v3.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/notificationChannels/[^/]+$");
          }
        }

        @Override
        public SendVerificationCode set$Xgafv(java.lang.String $Xgafv) {
          return (SendVerificationCode) super.set$Xgafv($Xgafv);
        }

        @Override
        public SendVerificationCode setAccessToken(java.lang.String accessToken) {
          return (SendVerificationCode) super.setAccessToken(accessToken);
        }

        @Override
        public SendVerificationCode setAlt(java.lang.String alt) {
          return (SendVerificationCode) super.setAlt(alt);
        }

        @Override
        public SendVerificationCode setCallback(java.lang.String callback) {
          return (SendVerificationCode) super.setCallback(callback);
        }

        @Override
        public SendVerificationCode setFields(java.lang.String fields) {
          return (SendVerificationCode) super.setFields(fields);
        }

        @Override
        public SendVerificationCode setKey(java.lang.String key) {
          return (SendVerificationCode) super.setKey(key);
        }

        @Override
        public SendVerificationCode setOauthToken(java.lang.String oauthToken) {
          return (SendVerificationCode) super.setOauthToken(oauthToken);
        }

        @Override
        public SendVerificationCode setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (SendVerificationCode) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public SendVerificationCode setQuotaUser(java.lang.String quotaUser) {
          return (SendVerificationCode) super.setQuotaUser(quotaUser);
        }

        @Override
        public SendVerificationCode setUploadType(java.lang.String uploadType) {
          return (SendVerificationCode) super.setUploadType(uploadType);
        }

        @Override
        public SendVerificationCode setUploadProtocol(java.lang.String uploadProtocol) {
          return (SendVerificationCode) super.setUploadProtocol(uploadProtocol);
        }

        /** The notification channel to which to send a verification code. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The notification channel to which to send a verification code.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The notification channel to which to send a verification code. */
        public SendVerificationCode setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/notificationChannels/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public SendVerificationCode set(String parameterName, Object value) {
          return (SendVerificationCode) super.set(parameterName, value);
        }
      }
      /**
       * Verifies a NotificationChannel by proving receipt of the code delivered to the channel as a
       * result of calling SendNotificationChannelVerificationCode.
       *
       * Create a request for the method "notificationChannels.verify".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Verify#execute()} method to invoke the remote operation.
       *
       * @param name The notification channel to verify.
       * @param content the {@link com.google.api.services.monitoring.v3.model.VerifyNotificationChannelRequest}
       * @return the request
       */
      public Verify verify(java.lang.String name, com.google.api.services.monitoring.v3.model.VerifyNotificationChannelRequest content) throws java.io.IOException {
        Verify result = new Verify(name, content);
        initialize(result);
        return result;
      }

      public class Verify extends MonitoringRequest<com.google.api.services.monitoring.v3.model.NotificationChannel> {

        private static final String REST_PATH = "v3/{+name}:verify";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/notificationChannels/[^/]+$");

        /**
         * Verifies a NotificationChannel by proving receipt of the code delivered to the channel as a
         * result of calling SendNotificationChannelVerificationCode.
         *
         * Create a request for the method "notificationChannels.verify".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Verify#execute()} method to invoke the remote operation.
         * <p> {@link
         * Verify#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The notification channel to verify.
         * @param content the {@link com.google.api.services.monitoring.v3.model.VerifyNotificationChannelRequest}
         * @since 1.13
         */
        protected Verify(java.lang.String name, com.google.api.services.monitoring.v3.model.VerifyNotificationChannelRequest content) {
          super(Monitoring.this, "POST", REST_PATH, content, com.google.api.services.monitoring.v3.model.NotificationChannel.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/notificationChannels/[^/]+$");
          }
        }

        @Override
        public Verify set$Xgafv(java.lang.String $Xgafv) {
          return (Verify) super.set$Xgafv($Xgafv);
        }

        @Override
        public Verify setAccessToken(java.lang.String accessToken) {
          return (Verify) super.setAccessToken(accessToken);
        }

        @Override
        public Verify setAlt(java.lang.String alt) {
          return (Verify) super.setAlt(alt);
        }

        @Override
        public Verify setCallback(java.lang.String callback) {
          return (Verify) super.setCallback(callback);
        }

        @Override
        public Verify setFields(java.lang.String fields) {
          return (Verify) super.setFields(fields);
        }

        @Override
        public Verify setKey(java.lang.String key) {
          return (Verify) super.setKey(key);
        }

        @Override
        public Verify setOauthToken(java.lang.String oauthToken) {
          return (Verify) super.setOauthToken(oauthToken);
        }

        @Override
        public Verify setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Verify) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Verify setQuotaUser(java.lang.String quotaUser) {
          return (Verify) super.setQuotaUser(quotaUser);
        }

        @Override
        public Verify setUploadType(java.lang.String uploadType) {
          return (Verify) super.setUploadType(uploadType);
        }

        @Override
        public Verify setUploadProtocol(java.lang.String uploadProtocol) {
          return (Verify) super.setUploadProtocol(uploadProtocol);
        }

        /** The notification channel to verify. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The notification channel to verify.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The notification channel to verify. */
        public Verify setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/notificationChannels/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Verify set(String parameterName, Object value) {
          return (Verify) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the TimeSeries collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Monitoring monitoring = new Monitoring(...);}
     *   {@code Monitoring.TimeSeries.List request = monitoring.timeSeries().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public TimeSeries timeSeries() {
      return new TimeSeries();
    }

    /**
     * The "timeSeries" collection of methods.
     */
    public class TimeSeries {

      /**
       * Creates or adds data to one or more time series. The response is empty if all time series in the
       * request were written. If any time series could not be written, a corresponding failure message is
       * included in the error response.
       *
       * Create a request for the method "timeSeries.create".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param name The project on which to execute the request. The format is "projects/{project_id_or_number}".
       * @param content the {@link com.google.api.services.monitoring.v3.model.CreateTimeSeriesRequest}
       * @return the request
       */
      public Create create(java.lang.String name, com.google.api.services.monitoring.v3.model.CreateTimeSeriesRequest content) throws java.io.IOException {
        Create result = new Create(name, content);
        initialize(result);
        return result;
      }

      public class Create extends MonitoringRequest<com.google.api.services.monitoring.v3.model.Empty> {

        private static final String REST_PATH = "v3/{+name}/timeSeries";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Creates or adds data to one or more time series. The response is empty if all time series in
         * the request were written. If any time series could not be written, a corresponding failure
         * message is included in the error response.
         *
         * Create a request for the method "timeSeries.create".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The project on which to execute the request. The format is "projects/{project_id_or_number}".
         * @param content the {@link com.google.api.services.monitoring.v3.model.CreateTimeSeriesRequest}
         * @since 1.13
         */
        protected Create(java.lang.String name, com.google.api.services.monitoring.v3.model.CreateTimeSeriesRequest content) {
          super(Monitoring.this, "POST", REST_PATH, content, com.google.api.services.monitoring.v3.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The project on which to execute the request. The format is
         * "projects/{project_id_or_number}".
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The project on which to execute the request. The format is "projects/{project_id_or_number}".
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The project on which to execute the request. The format is
         * "projects/{project_id_or_number}".
         */
        public Create setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Lists time series that match a filter. This method does not require a Stackdriver account.
       *
       * Create a request for the method "timeSeries.list".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param name The project on which to execute the request. The format is "projects/{project_id_or_number}".
       * @return the request
       */
      public List list(java.lang.String name) throws java.io.IOException {
        List result = new List(name);
        initialize(result);
        return result;
      }

      public class List extends MonitoringRequest<com.google.api.services.monitoring.v3.model.ListTimeSeriesResponse> {

        private static final String REST_PATH = "v3/{+name}/timeSeries";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists time series that match a filter. This method does not require a Stackdriver account.
         *
         * Create a request for the method "timeSeries.list".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The project on which to execute the request. The format is "projects/{project_id_or_number}".
         * @since 1.13
         */
        protected List(java.lang.String name) {
          super(Monitoring.this, "GET", REST_PATH, null, com.google.api.services.monitoring.v3.model.ListTimeSeriesResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The project on which to execute the request. The format is
         * "projects/{project_id_or_number}".
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The project on which to execute the request. The format is "projects/{project_id_or_number}".
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The project on which to execute the request. The format is
         * "projects/{project_id_or_number}".
         */
        public List setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /** Required. The end of the time interval. */
        @com.google.api.client.util.Key("interval.endTime")
        private String intervalEndTime;

        /** Required. The end of the time interval.
         */
        public String getIntervalEndTime() {
          return intervalEndTime;
        }

        /** Required. The end of the time interval. */
        public List setIntervalEndTime(String intervalEndTime) {
          this.intervalEndTime = intervalEndTime;
          return this;
        }

        /**
         * The alignment period for per-time series alignment. If present, alignmentPeriod must be
         * at least 60 seconds. After per-time series alignment, each time series will contain data
         * points only on the period boundaries. If perSeriesAligner is not specified or equals
         * ALIGN_NONE, then this field is ignored. If perSeriesAligner is specified and does not
         * equal ALIGN_NONE, then this field must be defined; otherwise an error is returned.
         */
        @com.google.api.client.util.Key("aggregation.alignmentPeriod")
        private String aggregationAlignmentPeriod;

        /** The alignment period for per-time series alignment. If present, alignmentPeriod must be at least 60
       seconds. After per-time series alignment, each time series will contain data points only on the
       period boundaries. If perSeriesAligner is not specified or equals ALIGN_NONE, then this field is
       ignored. If perSeriesAligner is specified and does not equal ALIGN_NONE, then this field must be
       defined; otherwise an error is returned.
         */
        public String getAggregationAlignmentPeriod() {
          return aggregationAlignmentPeriod;
        }

        /**
         * The alignment period for per-time series alignment. If present, alignmentPeriod must be
         * at least 60 seconds. After per-time series alignment, each time series will contain data
         * points only on the period boundaries. If perSeriesAligner is not specified or equals
         * ALIGN_NONE, then this field is ignored. If perSeriesAligner is specified and does not
         * equal ALIGN_NONE, then this field must be defined; otherwise an error is returned.
         */
        public List setAggregationAlignmentPeriod(String aggregationAlignmentPeriod) {
          this.aggregationAlignmentPeriod = aggregationAlignmentPeriod;
          return this;
        }

        /**
         * A positive number that is the maximum number of results to return. If page_size is empty
         * or more than 100,000 results, the effective page_size is 100,000 results. If view is set
         * to FULL, this is the maximum number of Points returned. If view is set to HEADERS, this
         * is the maximum number of TimeSeries returned.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** A positive number that is the maximum number of results to return. If page_size is empty or more
       than 100,000 results, the effective page_size is 100,000 results. If view is set to FULL, this is
       the maximum number of Points returned. If view is set to HEADERS, this is the maximum number of
       TimeSeries returned.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * A positive number that is the maximum number of results to return. If page_size is empty
         * or more than 100,000 results, the effective page_size is 100,000 results. If view is set
         * to FULL, this is the maximum number of Points returned. If view is set to HEADERS, this
         * is the maximum number of TimeSeries returned.
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * Unsupported: must be left blank. The points in each time series are returned in reverse
         * time order.
         */
        @com.google.api.client.util.Key
        private java.lang.String orderBy;

        /** Unsupported: must be left blank. The points in each time series are returned in reverse time order.
         */
        public java.lang.String getOrderBy() {
          return orderBy;
        }

        /**
         * Unsupported: must be left blank. The points in each time series are returned in reverse
         * time order.
         */
        public List setOrderBy(java.lang.String orderBy) {
          this.orderBy = orderBy;
          return this;
        }

        /**
         * The approach to be used to combine time series. Not all reducer functions may be applied
         * to all time series, depending on the metric type and the value type of the original time
         * series. Reduction may change the metric type of value type of the time series.Time series
         * data must be aligned in order to perform cross-time series reduction. If
         * crossSeriesReducer is specified, then perSeriesAligner must be specified and not equal
         * ALIGN_NONE and alignmentPeriod must be specified; otherwise, an error is returned.
         */
        @com.google.api.client.util.Key("aggregation.crossSeriesReducer")
        private java.lang.String aggregationCrossSeriesReducer;

        /** The approach to be used to combine time series. Not all reducer functions may be applied to all
       time series, depending on the metric type and the value type of the original time series. Reduction
       may change the metric type of value type of the time series.Time series data must be aligned in
       order to perform cross-time series reduction. If crossSeriesReducer is specified, then
       perSeriesAligner must be specified and not equal ALIGN_NONE and alignmentPeriod must be specified;
       otherwise, an error is returned.
         */
        public java.lang.String getAggregationCrossSeriesReducer() {
          return aggregationCrossSeriesReducer;
        }

        /**
         * The approach to be used to combine time series. Not all reducer functions may be applied
         * to all time series, depending on the metric type and the value type of the original time
         * series. Reduction may change the metric type of value type of the time series.Time series
         * data must be aligned in order to perform cross-time series reduction. If
         * crossSeriesReducer is specified, then perSeriesAligner must be specified and not equal
         * ALIGN_NONE and alignmentPeriod must be specified; otherwise, an error is returned.
         */
        public List setAggregationCrossSeriesReducer(java.lang.String aggregationCrossSeriesReducer) {
          this.aggregationCrossSeriesReducer = aggregationCrossSeriesReducer;
          return this;
        }

        /**
         * A monitoring filter that specifies which time series should be returned. The filter must
         * specify a single metric type, and can additionally specify metric labels and other
         * information. For example: metric.type = "compute.googleapis.com/instance/cpu/usage_time"
         * AND metric.label.instance_name = "my-instance-name"
         */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** A monitoring filter that specifies which time series should be returned. The filter must specify a
       single metric type, and can additionally specify metric labels and other information. For example:
       metric.type = "compute.googleapis.com/instance/cpu/usage_time" AND metric.label.instance_name =
       "my-instance-name"
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /**
         * A monitoring filter that specifies which time series should be returned. The filter must
         * specify a single metric type, and can additionally specify metric labels and other
         * information. For example: metric.type = "compute.googleapis.com/instance/cpu/usage_time"
         * AND metric.label.instance_name = "my-instance-name"
         */
        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        /**
         * The approach to be used to align individual time series. Not all alignment functions may
         * be applied to all time series, depending on the metric type and value type of the
         * original time series. Alignment may change the metric type or the value type of the time
         * series.Time series data must be aligned in order to perform cross-time series reduction.
         * If crossSeriesReducer is specified, then perSeriesAligner must be specified and not equal
         * ALIGN_NONE and alignmentPeriod must be specified; otherwise, an error is returned.
         */
        @com.google.api.client.util.Key("aggregation.perSeriesAligner")
        private java.lang.String aggregationPerSeriesAligner;

        /** The approach to be used to align individual time series. Not all alignment functions may be applied
       to all time series, depending on the metric type and value type of the original time series.
       Alignment may change the metric type or the value type of the time series.Time series data must be
       aligned in order to perform cross-time series reduction. If crossSeriesReducer is specified, then
       perSeriesAligner must be specified and not equal ALIGN_NONE and alignmentPeriod must be specified;
       otherwise, an error is returned.
         */
        public java.lang.String getAggregationPerSeriesAligner() {
          return aggregationPerSeriesAligner;
        }

        /**
         * The approach to be used to align individual time series. Not all alignment functions may
         * be applied to all time series, depending on the metric type and value type of the
         * original time series. Alignment may change the metric type or the value type of the time
         * series.Time series data must be aligned in order to perform cross-time series reduction.
         * If crossSeriesReducer is specified, then perSeriesAligner must be specified and not equal
         * ALIGN_NONE and alignmentPeriod must be specified; otherwise, an error is returned.
         */
        public List setAggregationPerSeriesAligner(java.lang.String aggregationPerSeriesAligner) {
          this.aggregationPerSeriesAligner = aggregationPerSeriesAligner;
          return this;
        }

        /**
         * If this field is not empty then it must contain the nextPageToken value returned by a
         * previous call to this method. Using this field causes the method to return additional
         * results from the previous method call.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** If this field is not empty then it must contain the nextPageToken value returned by a previous call
       to this method. Using this field causes the method to return additional results from the previous
       method call.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * If this field is not empty then it must contain the nextPageToken value returned by a
         * previous call to this method. Using this field causes the method to return additional
         * results from the previous method call.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /**
         * Optional. The beginning of the time interval. The default value for the start time is the
         * end time. The start time must not be later than the end time.
         */
        @com.google.api.client.util.Key("interval.startTime")
        private String intervalStartTime;

        /** Optional. The beginning of the time interval. The default value for the start time is the end time.
       The start time must not be later than the end time.
         */
        public String getIntervalStartTime() {
          return intervalStartTime;
        }

        /**
         * Optional. The beginning of the time interval. The default value for the start time is the
         * end time. The start time must not be later than the end time.
         */
        public List setIntervalStartTime(String intervalStartTime) {
          this.intervalStartTime = intervalStartTime;
          return this;
        }

        /** Specifies which information is returned about the time series. */
        @com.google.api.client.util.Key
        private java.lang.String view;

        /** Specifies which information is returned about the time series.
         */
        public java.lang.String getView() {
          return view;
        }

        /** Specifies which information is returned about the time series. */
        public List setView(java.lang.String view) {
          this.view = view;
          return this;
        }

        /**
         * The set of fields to preserve when crossSeriesReducer is specified. The groupByFields
         * determine how the time series are partitioned into subsets prior to applying the
         * aggregation function. Each subset contains time series that have the same value for each
         * of the grouping fields. Each individual time series is a member of exactly one subset.
         * The crossSeriesReducer is applied to each subset of time series. It is not possible to
         * reduce across different resource types, so this field implicitly contains resource.type.
         * Fields not specified in groupByFields are aggregated away. If groupByFields is not
         * specified and all the time series have the same resource type, then the time series are
         * aggregated into a single output time series. If crossSeriesReducer is not defined, this
         * field is ignored.
         */
        @com.google.api.client.util.Key("aggregation.groupByFields")
        private java.util.List<java.lang.String> aggregationGroupByFields;

        /** The set of fields to preserve when crossSeriesReducer is specified. The groupByFields determine how
       the time series are partitioned into subsets prior to applying the aggregation function. Each
       subset contains time series that have the same value for each of the grouping fields. Each
       individual time series is a member of exactly one subset. The crossSeriesReducer is applied to each
       subset of time series. It is not possible to reduce across different resource types, so this field
       implicitly contains resource.type. Fields not specified in groupByFields are aggregated away. If
       groupByFields is not specified and all the time series have the same resource type, then the time
       series are aggregated into a single output time series. If crossSeriesReducer is not defined, this
       field is ignored.
         */
        public java.util.List<java.lang.String> getAggregationGroupByFields() {
          return aggregationGroupByFields;
        }

        /**
         * The set of fields to preserve when crossSeriesReducer is specified. The groupByFields
         * determine how the time series are partitioned into subsets prior to applying the
         * aggregation function. Each subset contains time series that have the same value for each
         * of the grouping fields. Each individual time series is a member of exactly one subset.
         * The crossSeriesReducer is applied to each subset of time series. It is not possible to
         * reduce across different resource types, so this field implicitly contains resource.type.
         * Fields not specified in groupByFields are aggregated away. If groupByFields is not
         * specified and all the time series have the same resource type, then the time series are
         * aggregated into a single output time series. If crossSeriesReducer is not defined, this
         * field is ignored.
         */
        public List setAggregationGroupByFields(java.util.List<java.lang.String> aggregationGroupByFields) {
          this.aggregationGroupByFields = aggregationGroupByFields;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the UptimeCheckConfigs collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Monitoring monitoring = new Monitoring(...);}
     *   {@code Monitoring.UptimeCheckConfigs.List request = monitoring.uptimeCheckConfigs().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public UptimeCheckConfigs uptimeCheckConfigs() {
      return new UptimeCheckConfigs();
    }

    /**
     * The "uptimeCheckConfigs" collection of methods.
     */
    public class UptimeCheckConfigs {

      /**
       * Creates a new uptime check configuration.
       *
       * Create a request for the method "uptimeCheckConfigs.create".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent The project in which to create the uptime check. The format  is projects/[PROJECT_ID].
       * @param content the {@link com.google.api.services.monitoring.v3.model.UptimeCheckConfig}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.monitoring.v3.model.UptimeCheckConfig content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends MonitoringRequest<com.google.api.services.monitoring.v3.model.UptimeCheckConfig> {

        private static final String REST_PATH = "v3/{+parent}/uptimeCheckConfigs";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Creates a new uptime check configuration.
         *
         * Create a request for the method "uptimeCheckConfigs.create".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent The project in which to create the uptime check. The format  is projects/[PROJECT_ID].
         * @param content the {@link com.google.api.services.monitoring.v3.model.UptimeCheckConfig}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.monitoring.v3.model.UptimeCheckConfig content) {
          super(Monitoring.this, "POST", REST_PATH, content, com.google.api.services.monitoring.v3.model.UptimeCheckConfig.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The project in which to create the uptime check. The format  is projects/[PROJECT_ID].
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** The project in which to create the uptime check. The format  is projects/[PROJECT_ID].
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * The project in which to create the uptime check. The format  is projects/[PROJECT_ID].
         */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes an uptime check configuration. Note that this method will fail if the uptime check
       * configuration is referenced by an alert policy or other dependent configs that would be rendered
       * invalid by the deletion.
       *
       * Create a request for the method "uptimeCheckConfigs.delete".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name The uptime check configuration to delete. The format  is
       *        projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends MonitoringRequest<com.google.api.services.monitoring.v3.model.Empty> {

        private static final String REST_PATH = "v3/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/uptimeCheckConfigs/[^/]+$");

        /**
         * Deletes an uptime check configuration. Note that this method will fail if the uptime check
         * configuration is referenced by an alert policy or other dependent configs that would be
         * rendered invalid by the deletion.
         *
         * Create a request for the method "uptimeCheckConfigs.delete".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The uptime check configuration to delete. The format  is
       *        projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(Monitoring.this, "DELETE", REST_PATH, null, com.google.api.services.monitoring.v3.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/uptimeCheckConfigs/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The uptime check configuration to delete. The format  is
         * projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The uptime check configuration to delete. The format  is
       projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The uptime check configuration to delete. The format  is
         * projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/uptimeCheckConfigs/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets a single uptime check configuration.
       *
       * Create a request for the method "uptimeCheckConfigs.get".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name The uptime check configuration to retrieve. The format  is
       *        projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends MonitoringRequest<com.google.api.services.monitoring.v3.model.UptimeCheckConfig> {

        private static final String REST_PATH = "v3/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/uptimeCheckConfigs/[^/]+$");

        /**
         * Gets a single uptime check configuration.
         *
         * Create a request for the method "uptimeCheckConfigs.get".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The uptime check configuration to retrieve. The format  is
       *        projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Monitoring.this, "GET", REST_PATH, null, com.google.api.services.monitoring.v3.model.UptimeCheckConfig.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/uptimeCheckConfigs/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The uptime check configuration to retrieve. The format  is
         * projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The uptime check configuration to retrieve. The format  is
       projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The uptime check configuration to retrieve. The format  is
         * projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/uptimeCheckConfigs/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists the existing valid uptime check configurations for the project, leaving out any invalid
       * configurations.
       *
       * Create a request for the method "uptimeCheckConfigs.list".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param parent The project whose uptime check configurations are listed. The format  is projects/[PROJECT_ID].
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends MonitoringRequest<com.google.api.services.monitoring.v3.model.ListUptimeCheckConfigsResponse> {

        private static final String REST_PATH = "v3/{+parent}/uptimeCheckConfigs";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists the existing valid uptime check configurations for the project, leaving out any invalid
         * configurations.
         *
         * Create a request for the method "uptimeCheckConfigs.list".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent The project whose uptime check configurations are listed. The format  is projects/[PROJECT_ID].
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(Monitoring.this, "GET", REST_PATH, null, com.google.api.services.monitoring.v3.model.ListUptimeCheckConfigsResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The project whose uptime check configurations are listed. The format  is
         * projects/[PROJECT_ID].
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** The project whose uptime check configurations are listed. The format  is projects/[PROJECT_ID].
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * The project whose uptime check configurations are listed. The format  is
         * projects/[PROJECT_ID].
         */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * If this field is not empty then it must contain the nextPageToken value returned by a
         * previous call to this method. Using this field causes the method to return more results
         * from the previous method call.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** If this field is not empty then it must contain the nextPageToken value returned by a previous call
       to this method. Using this field causes the method to return more results from the previous method
       call.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * If this field is not empty then it must contain the nextPageToken value returned by a
         * previous call to this method. Using this field causes the method to return more results
         * from the previous method call.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /**
         * The maximum number of results to return in a single response. The server may further
         * constrain the maximum number of results returned in a single page. If the page_size is
         * <=0, the server will decide the number of results to be returned.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The maximum number of results to return in a single response. The server may further constrain the
       maximum number of results returned in a single page. If the page_size is <=0, the server will
       decide the number of results to be returned.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * The maximum number of results to return in a single response. The server may further
         * constrain the maximum number of results returned in a single page. If the page_size is
         * <=0, the server will decide the number of results to be returned.
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates an uptime check configuration. You can either replace the entire configuration with a new
       * one or replace only certain fields in the current configuration by specifying the fields to be
       * updated via "updateMask". Returns the updated configuration.
       *
       * Create a request for the method "uptimeCheckConfigs.patch".
       *
       * This request holds the parameters needed by the monitoring server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name A unique resource name for this UptimeCheckConfig. The format
       *        is:projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].This field should be omitted
       *        when creating the uptime check configuration; on create, the resource name is assigned by
       *        the server and included in the response.
       * @param content the {@link com.google.api.services.monitoring.v3.model.UptimeCheckConfig}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.monitoring.v3.model.UptimeCheckConfig content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends MonitoringRequest<com.google.api.services.monitoring.v3.model.UptimeCheckConfig> {

        private static final String REST_PATH = "v3/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/uptimeCheckConfigs/[^/]+$");

        /**
         * Updates an uptime check configuration. You can either replace the entire configuration with a
         * new one or replace only certain fields in the current configuration by specifying the fields to
         * be updated via "updateMask". Returns the updated configuration.
         *
         * Create a request for the method "uptimeCheckConfigs.patch".
         *
         * This request holds the parameters needed by the the monitoring server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name A unique resource name for this UptimeCheckConfig. The format
       *        is:projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].This field should be omitted
       *        when creating the uptime check configuration; on create, the resource name is assigned by
       *        the server and included in the response.
         * @param content the {@link com.google.api.services.monitoring.v3.model.UptimeCheckConfig}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.monitoring.v3.model.UptimeCheckConfig content) {
          super(Monitoring.this, "PATCH", REST_PATH, content, com.google.api.services.monitoring.v3.model.UptimeCheckConfig.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/uptimeCheckConfigs/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * A unique resource name for this UptimeCheckConfig. The format
         * is:projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].This field should be
         * omitted when creating the uptime check configuration; on create, the resource name is
         * assigned by the server and included in the response.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** A unique resource name for this UptimeCheckConfig. The format
       is:projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].This field should be omitted when
       creating the uptime check configuration; on create, the resource name is assigned by the server and
       included in the response.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * A unique resource name for this UptimeCheckConfig. The format
         * is:projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID].This field should be
         * omitted when creating the uptime check configuration; on create, the resource name is
         * assigned by the server and included in the response.
         */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/uptimeCheckConfigs/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * Optional. If present, only the listed fields in the current uptime check configuration
         * are updated with values from the new configuration. If this field is empty, then the
         * current configuration is completely replaced with the new configuration.
         */
        @com.google.api.client.util.Key
        private String updateMask;

        /** Optional. If present, only the listed fields in the current uptime check configuration are updated
       with values from the new configuration. If this field is empty, then the current configuration is
       completely replaced with the new configuration.
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /**
         * Optional. If present, only the listed fields in the current uptime check configuration
         * are updated with values from the new configuration. If this field is empty, then the
         * current configuration is completely replaced with the new configuration.
         */
        public Patch setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * An accessor for creating requests from the UptimeCheckIps collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Monitoring monitoring = new Monitoring(...);}
   *   {@code Monitoring.UptimeCheckIps.List request = monitoring.uptimeCheckIps().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public UptimeCheckIps uptimeCheckIps() {
    return new UptimeCheckIps();
  }

  /**
   * The "uptimeCheckIps" collection of methods.
   */
  public class UptimeCheckIps {

    /**
     * Returns the list of IPs that checkers run from
     *
     * Create a request for the method "uptimeCheckIps.list".
     *
     * This request holds the parameters needed by the monitoring server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends MonitoringRequest<com.google.api.services.monitoring.v3.model.ListUptimeCheckIpsResponse> {

      private static final String REST_PATH = "v3/uptimeCheckIps";

      /**
       * Returns the list of IPs that checkers run from
       *
       * Create a request for the method "uptimeCheckIps.list".
       *
       * This request holds the parameters needed by the the monitoring server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Monitoring.this, "GET", REST_PATH, null, com.google.api.services.monitoring.v3.model.ListUptimeCheckIpsResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * If this field is not empty then it must contain the nextPageToken value returned by a
       * previous call to this method. Using this field causes the method to return more results
       * from the previous method call. NOTE: this field is not yet implemented
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** If this field is not empty then it must contain the nextPageToken value returned by a previous call
     to this method. Using this field causes the method to return more results from the previous method
     call. NOTE: this field is not yet implemented
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * If this field is not empty then it must contain the nextPageToken value returned by a
       * previous call to this method. Using this field causes the method to return more results
       * from the previous method call. NOTE: this field is not yet implemented
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The maximum number of results to return in a single response. The server may further
       * constrain the maximum number of results returned in a single page. If the page_size is <=0,
       * the server will decide the number of results to be returned. NOTE: this field is not yet
       * implemented
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of results to return in a single response. The server may further constrain the
     maximum number of results returned in a single page. If the page_size is <=0, the server will
     decide the number of results to be returned. NOTE: this field is not yet implemented
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * The maximum number of results to return in a single response. The server may further
       * constrain the maximum number of results returned in a single page. If the page_size is <=0,
       * the server will decide the number of results to be returned. NOTE: this field is not yet
       * implemented
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Monitoring}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Monitoring}. */
    @Override
    public Monitoring build() {
      return new Monitoring(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link MonitoringRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setMonitoringRequestInitializer(
        MonitoringRequestInitializer monitoringRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(monitoringRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
