/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-12 at 20:40:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.monitoring.v3.model;

/**
 * A description of the conditions under which some aspect of your system is considered to be
 * "unhealthy" and the ways to notify people or services about this state. For an overview of alert
 * policies, see Introduction to Alerting.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Stackdriver Monitoring API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AlertPolicy extends com.google.api.client.json.GenericJson {

  /**
   * How to combine the results of multiple conditions to determine if an incident should be opened.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String combiner;

  /**
   * A list of conditions for the policy. The conditions are combined by AND or OR according to the
   * combiner field. If the combined conditions evaluate to true, then an incident is created. A
   * policy can have from one to six conditions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Condition> conditions;

  /**
   * A read-only record of the creation of the alerting policy. If provided in a call to create or
   * update, this field will be ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MutationRecord creationRecord;

  /**
   * A short name or phrase used to identify the policy in dashboards, notifications, and incidents.
   * To avoid confusion, don't use the same display name for multiple policies in the same project.
   * The name is limited to 512 Unicode characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Documentation that is included with notifications and incidents related to this policy. Best
   * practice is for the documentation to include information to help responders understand,
   * mitigate, escalate, and correct the underlying problems detected by the alerting policy.
   * Notification channels that have limited capacity might not show this documentation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Documentation documentation;

  /**
   * Whether or not the policy is enabled. On write, the default interpretation if unset is that the
   * policy is enabled. On read, clients should not make any assumption about the state if it has
   * not been populated. The field should always be populated on List and Get operations, unless a
   * field projection has been specified that strips it out.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enabled;

  /**
   * A read-only record of the most recent change to the alerting policy. If provided in a call to
   * create or update, this field will be ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MutationRecord mutationRecord;

  /**
   * Required if the policy exists. The resource name for this policy. The syntax is:
   * projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID] [ALERT_POLICY_ID] is assigned by
   * Stackdriver Monitoring when the policy is created. When calling the alertPolicies.create
   * method, do not include the name field in the alerting policy passed as part of the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Identifies the notification channels to which notifications should be sent when incidents are
   * opened or closed or when new violations occur on an already opened incident. Each element of
   * this array corresponds to the name field in each of the NotificationChannel objects that are
   * returned from the ListNotificationChannels method. The syntax of the entries in this field is:
   * projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> notificationChannels;

  /**
   * User-supplied key/value data to be used for organizing and identifying the AlertPolicy
   * objects.The field can contain up to 64 entries. Each key and value is limited to 63 Unicode
   * characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase
   * letters, numerals, underscores, and dashes. Keys must begin with a letter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> userLabels;

  /**
   * How to combine the results of multiple conditions to determine if an incident should be opened.
   * @return value or {@code null} for none
   */
  public java.lang.String getCombiner() {
    return combiner;
  }

  /**
   * How to combine the results of multiple conditions to determine if an incident should be opened.
   * @param combiner combiner or {@code null} for none
   */
  public AlertPolicy setCombiner(java.lang.String combiner) {
    this.combiner = combiner;
    return this;
  }

  /**
   * A list of conditions for the policy. The conditions are combined by AND or OR according to the
   * combiner field. If the combined conditions evaluate to true, then an incident is created. A
   * policy can have from one to six conditions.
   * @return value or {@code null} for none
   */
  public java.util.List<Condition> getConditions() {
    return conditions;
  }

  /**
   * A list of conditions for the policy. The conditions are combined by AND or OR according to the
   * combiner field. If the combined conditions evaluate to true, then an incident is created. A
   * policy can have from one to six conditions.
   * @param conditions conditions or {@code null} for none
   */
  public AlertPolicy setConditions(java.util.List<Condition> conditions) {
    this.conditions = conditions;
    return this;
  }

  /**
   * A read-only record of the creation of the alerting policy. If provided in a call to create or
   * update, this field will be ignored.
   * @return value or {@code null} for none
   */
  public MutationRecord getCreationRecord() {
    return creationRecord;
  }

  /**
   * A read-only record of the creation of the alerting policy. If provided in a call to create or
   * update, this field will be ignored.
   * @param creationRecord creationRecord or {@code null} for none
   */
  public AlertPolicy setCreationRecord(MutationRecord creationRecord) {
    this.creationRecord = creationRecord;
    return this;
  }

  /**
   * A short name or phrase used to identify the policy in dashboards, notifications, and incidents.
   * To avoid confusion, don't use the same display name for multiple policies in the same project.
   * The name is limited to 512 Unicode characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * A short name or phrase used to identify the policy in dashboards, notifications, and incidents.
   * To avoid confusion, don't use the same display name for multiple policies in the same project.
   * The name is limited to 512 Unicode characters.
   * @param displayName displayName or {@code null} for none
   */
  public AlertPolicy setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Documentation that is included with notifications and incidents related to this policy. Best
   * practice is for the documentation to include information to help responders understand,
   * mitigate, escalate, and correct the underlying problems detected by the alerting policy.
   * Notification channels that have limited capacity might not show this documentation.
   * @return value or {@code null} for none
   */
  public Documentation getDocumentation() {
    return documentation;
  }

  /**
   * Documentation that is included with notifications and incidents related to this policy. Best
   * practice is for the documentation to include information to help responders understand,
   * mitigate, escalate, and correct the underlying problems detected by the alerting policy.
   * Notification channels that have limited capacity might not show this documentation.
   * @param documentation documentation or {@code null} for none
   */
  public AlertPolicy setDocumentation(Documentation documentation) {
    this.documentation = documentation;
    return this;
  }

  /**
   * Whether or not the policy is enabled. On write, the default interpretation if unset is that the
   * policy is enabled. On read, clients should not make any assumption about the state if it has
   * not been populated. The field should always be populated on List and Get operations, unless a
   * field projection has been specified that strips it out.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnabled() {
    return enabled;
  }

  /**
   * Whether or not the policy is enabled. On write, the default interpretation if unset is that the
   * policy is enabled. On read, clients should not make any assumption about the state if it has
   * not been populated. The field should always be populated on List and Get operations, unless a
   * field projection has been specified that strips it out.
   * @param enabled enabled or {@code null} for none
   */
  public AlertPolicy setEnabled(java.lang.Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

  /**
   * A read-only record of the most recent change to the alerting policy. If provided in a call to
   * create or update, this field will be ignored.
   * @return value or {@code null} for none
   */
  public MutationRecord getMutationRecord() {
    return mutationRecord;
  }

  /**
   * A read-only record of the most recent change to the alerting policy. If provided in a call to
   * create or update, this field will be ignored.
   * @param mutationRecord mutationRecord or {@code null} for none
   */
  public AlertPolicy setMutationRecord(MutationRecord mutationRecord) {
    this.mutationRecord = mutationRecord;
    return this;
  }

  /**
   * Required if the policy exists. The resource name for this policy. The syntax is:
   * projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID] [ALERT_POLICY_ID] is assigned by
   * Stackdriver Monitoring when the policy is created. When calling the alertPolicies.create
   * method, do not include the name field in the alerting policy passed as part of the request.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required if the policy exists. The resource name for this policy. The syntax is:
   * projects/[PROJECT_ID]/alertPolicies/[ALERT_POLICY_ID] [ALERT_POLICY_ID] is assigned by
   * Stackdriver Monitoring when the policy is created. When calling the alertPolicies.create
   * method, do not include the name field in the alerting policy passed as part of the request.
   * @param name name or {@code null} for none
   */
  public AlertPolicy setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Identifies the notification channels to which notifications should be sent when incidents are
   * opened or closed or when new violations occur on an already opened incident. Each element of
   * this array corresponds to the name field in each of the NotificationChannel objects that are
   * returned from the ListNotificationChannels method. The syntax of the entries in this field is:
   * projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getNotificationChannels() {
    return notificationChannels;
  }

  /**
   * Identifies the notification channels to which notifications should be sent when incidents are
   * opened or closed or when new violations occur on an already opened incident. Each element of
   * this array corresponds to the name field in each of the NotificationChannel objects that are
   * returned from the ListNotificationChannels method. The syntax of the entries in this field is:
   * projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
   * @param notificationChannels notificationChannels or {@code null} for none
   */
  public AlertPolicy setNotificationChannels(java.util.List<java.lang.String> notificationChannels) {
    this.notificationChannels = notificationChannels;
    return this;
  }

  /**
   * User-supplied key/value data to be used for organizing and identifying the AlertPolicy
   * objects.The field can contain up to 64 entries. Each key and value is limited to 63 Unicode
   * characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase
   * letters, numerals, underscores, and dashes. Keys must begin with a letter.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getUserLabels() {
    return userLabels;
  }

  /**
   * User-supplied key/value data to be used for organizing and identifying the AlertPolicy
   * objects.The field can contain up to 64 entries. Each key and value is limited to 63 Unicode
   * characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase
   * letters, numerals, underscores, and dashes. Keys must begin with a letter.
   * @param userLabels userLabels or {@code null} for none
   */
  public AlertPolicy setUserLabels(java.util.Map<String, java.lang.String> userLabels) {
    this.userLabels = userLabels;
    return this;
  }

  @Override
  public AlertPolicy set(String fieldName, Object value) {
    return (AlertPolicy) super.set(fieldName, value);
  }

  @Override
  public AlertPolicy clone() {
    return (AlertPolicy) super.clone();
  }

}
