/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-12 at 20:40:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.monitoring.v3.model;

/**
 * BucketOptions describes the bucket boundaries used to create a histogram for the distribution.
 * The buckets can be in a linear sequence, an exponential sequence, or each bucket can be specified
 * explicitly. BucketOptions does not include the number of values in each bucket.A bucket has an
 * inclusive lower bound and exclusive upper bound for the values that are counted for that bucket.
 * The upper bound of a bucket must be strictly greater than the lower bound. The sequence of N
 * buckets for a distribution consists of an underflow bucket (number 0), zero or more finite
 * buckets (number 1 through N - 2) and an overflow bucket (number N - 1). The buckets are
 * contiguous: the lower bound of bucket i (i > 0) is the same as the upper bound of bucket i - 1.
 * The buckets span the whole range of finite values: lower bound of the underflow bucket is
 * -infinity and the upper bound of the overflow bucket is +infinity. The finite buckets are so-
 * called because both bounds are finite.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Stackdriver Monitoring API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BucketOptions extends com.google.api.client.json.GenericJson {

  /**
   * The explicit buckets.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Explicit explicitBuckets;

  /**
   * The exponential buckets.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Exponential exponentialBuckets;

  /**
   * The linear bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Linear linearBuckets;

  /**
   * The explicit buckets.
   * @return value or {@code null} for none
   */
  public Explicit getExplicitBuckets() {
    return explicitBuckets;
  }

  /**
   * The explicit buckets.
   * @param explicitBuckets explicitBuckets or {@code null} for none
   */
  public BucketOptions setExplicitBuckets(Explicit explicitBuckets) {
    this.explicitBuckets = explicitBuckets;
    return this;
  }

  /**
   * The exponential buckets.
   * @return value or {@code null} for none
   */
  public Exponential getExponentialBuckets() {
    return exponentialBuckets;
  }

  /**
   * The exponential buckets.
   * @param exponentialBuckets exponentialBuckets or {@code null} for none
   */
  public BucketOptions setExponentialBuckets(Exponential exponentialBuckets) {
    this.exponentialBuckets = exponentialBuckets;
    return this;
  }

  /**
   * The linear bucket.
   * @return value or {@code null} for none
   */
  public Linear getLinearBuckets() {
    return linearBuckets;
  }

  /**
   * The linear bucket.
   * @param linearBuckets linearBuckets or {@code null} for none
   */
  public BucketOptions setLinearBuckets(Linear linearBuckets) {
    this.linearBuckets = linearBuckets;
    return this;
  }

  @Override
  public BucketOptions set(String fieldName, Object value) {
    return (BucketOptions) super.set(fieldName, value);
  }

  @Override
  public BucketOptions clone() {
    return (BucketOptions) super.clone();
  }

}
