/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-12 at 20:40:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.monitoring.v3.model;

/**
 * A collection of data points sent from a collectd-based plugin. See the collectd documentation for
 * more information.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Stackdriver Monitoring API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CollectdPayload extends com.google.api.client.json.GenericJson {

  /**
   * The end time of the interval.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String endTime;

  /**
   * The measurement metadata. Example: "process_id" -> 12345
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, TypedValue> metadata;

  static {
    // hack to force ProGuard to consider TypedValue used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(TypedValue.class);
  }

  /**
   * The name of the plugin. Example: "disk".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String plugin;

  /**
   * The instance name of the plugin Example: "hdcl".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pluginInstance;

  /**
   * The start time of the interval.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String startTime;

  /**
   * The measurement type. Example: "memory".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The measurement type instance. Example: "used".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String typeInstance;

  /**
   * The measured values during this time interval. Each value must have a different dataSourceName.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CollectdValue> values;

  /**
   * The end time of the interval.
   * @return value or {@code null} for none
   */
  public String getEndTime() {
    return endTime;
  }

  /**
   * The end time of the interval.
   * @param endTime endTime or {@code null} for none
   */
  public CollectdPayload setEndTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * The measurement metadata. Example: "process_id" -> 12345
   * @return value or {@code null} for none
   */
  public java.util.Map<String, TypedValue> getMetadata() {
    return metadata;
  }

  /**
   * The measurement metadata. Example: "process_id" -> 12345
   * @param metadata metadata or {@code null} for none
   */
  public CollectdPayload setMetadata(java.util.Map<String, TypedValue> metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * The name of the plugin. Example: "disk".
   * @return value or {@code null} for none
   */
  public java.lang.String getPlugin() {
    return plugin;
  }

  /**
   * The name of the plugin. Example: "disk".
   * @param plugin plugin or {@code null} for none
   */
  public CollectdPayload setPlugin(java.lang.String plugin) {
    this.plugin = plugin;
    return this;
  }

  /**
   * The instance name of the plugin Example: "hdcl".
   * @return value or {@code null} for none
   */
  public java.lang.String getPluginInstance() {
    return pluginInstance;
  }

  /**
   * The instance name of the plugin Example: "hdcl".
   * @param pluginInstance pluginInstance or {@code null} for none
   */
  public CollectdPayload setPluginInstance(java.lang.String pluginInstance) {
    this.pluginInstance = pluginInstance;
    return this;
  }

  /**
   * The start time of the interval.
   * @return value or {@code null} for none
   */
  public String getStartTime() {
    return startTime;
  }

  /**
   * The start time of the interval.
   * @param startTime startTime or {@code null} for none
   */
  public CollectdPayload setStartTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * The measurement type. Example: "memory".
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The measurement type. Example: "memory".
   * @param type type or {@code null} for none
   */
  public CollectdPayload setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * The measurement type instance. Example: "used".
   * @return value or {@code null} for none
   */
  public java.lang.String getTypeInstance() {
    return typeInstance;
  }

  /**
   * The measurement type instance. Example: "used".
   * @param typeInstance typeInstance or {@code null} for none
   */
  public CollectdPayload setTypeInstance(java.lang.String typeInstance) {
    this.typeInstance = typeInstance;
    return this;
  }

  /**
   * The measured values during this time interval. Each value must have a different dataSourceName.
   * @return value or {@code null} for none
   */
  public java.util.List<CollectdValue> getValues() {
    return values;
  }

  /**
   * The measured values during this time interval. Each value must have a different dataSourceName.
   * @param values values or {@code null} for none
   */
  public CollectdPayload setValues(java.util.List<CollectdValue> values) {
    this.values = values;
    return this;
  }

  @Override
  public CollectdPayload set(String fieldName, Object value) {
    return (CollectdPayload) super.set(fieldName, value);
  }

  @Override
  public CollectdPayload clone() {
    return (CollectdPayload) super.clone();
  }

}
