/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-12 at 20:40:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.monitoring.v3.model;

/**
 * Describes the error status for values that were not written.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Stackdriver Monitoring API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CollectdValueError extends com.google.api.client.json.GenericJson {

  /**
   * Records the error status for the value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Status error;

  /**
   * The zero-based index in CollectdPayload.values within the parent
   * CreateCollectdTimeSeriesRequest.collectd_payloads.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer index;

  /**
   * Records the error status for the value.
   * @return value or {@code null} for none
   */
  public Status getError() {
    return error;
  }

  /**
   * Records the error status for the value.
   * @param error error or {@code null} for none
   */
  public CollectdValueError setError(Status error) {
    this.error = error;
    return this;
  }

  /**
   * The zero-based index in CollectdPayload.values within the parent
   * CreateCollectdTimeSeriesRequest.collectd_payloads.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getIndex() {
    return index;
  }

  /**
   * The zero-based index in CollectdPayload.values within the parent
   * CreateCollectdTimeSeriesRequest.collectd_payloads.
   * @param index index or {@code null} for none
   */
  public CollectdValueError setIndex(java.lang.Integer index) {
    this.index = index;
    return this;
  }

  @Override
  public CollectdValueError set(String fieldName, Object value) {
    return (CollectdValueError) super.set(fieldName, value);
  }

  @Override
  public CollectdValueError clone() {
    return (CollectdValueError) super.clone();
  }

}
